/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import b.a.lb;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.ui.AttachRootButtonDescriptor;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.libraries.ui.LibraryPropertiesEditor;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.libraries.ui.impl.RootDetectionUtil;
import com.intellij.openapi.roots.ui.configuration.ModificationOfImportedModelWarningComponent;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.DefaultLibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExcludedRootElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ItemElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryRootsTreeSpeedSearch;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableTreeBuilder;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableTreeContentElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTreeRenderer;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTreeStructure;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.OrderRootTypeElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.UrlComparator;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryRootsComponent
implements Disposable,
LibraryEditorComponent {
    static final UrlComparator ourUrlComparator;
    private JPanel b;
    private JPanel d;
    private MultiLineLabel o;
    private JPanel h;
    private JPanel j;
    private LibraryPropertiesEditor n;
    private Tree p;
    private LibraryTableTreeBuilder a;
    private final ModificationOfImportedModelWarningComponent m;
    private VirtualFile l;
    private final Collection<Runnable> g;
    @Nullable
    private final Project c;
    private final Computable<? extends LibraryEditor> k;
    private LibraryRootsComponentDescriptor e;
    private Module i;
    private AddExcludedRootActionButton f;
    private static final long q;

    public LibraryRootsComponent(@Nullable Project project2, @NotNull LibraryEditor libraryEditor) {
        if (libraryEditor == null) {
            LibraryRootsComponent.a(0);
        }
        this(project2, (Computable<? extends LibraryEditor>)new Computable.PredefinedValueComputable((Object)libraryEditor));
    }

    public LibraryRootsComponent(@Nullable Project project2, @NotNull Computable<? extends LibraryEditor> libraryEditorComputable) {
        long l2 = q ^ 0x23B0376D9586L;
        if (libraryEditorComputable == null) {
            LibraryRootsComponent.a(1);
        }
        this.e();
        this.g = ContainerUtil.createLockFreeCopyOnWriteList();
        this.c = project2;
        this.k = libraryEditorComputable;
        LibraryEditor libraryEditor = this.getLibraryEditor();
        LibraryType libraryType = libraryEditor.getType();
        if (libraryType != null) {
            this.e = libraryType.createLibraryRootsComponentDescriptor();
            this.n = libraryType.createPropertiesEditor((LibraryEditorComponent)this);
            if (this.n != null) {
                this.h.add((Component)this.n.createComponent(), "Center");
            }
        }
        if (this.e == null) {
            this.e = new DefaultLibraryRootsComponentDescriptor();
        }
        this.m = new ModificationOfImportedModelWarningComponent();
        this.j.add("Center", this.m.getLabel());
        this.a(new LibraryTreeStructure(this, this.e));
        this.updatePropertiesLabel();
        this.h();
    }

    private void h() {
        this.f.setEnabled(!this.d().isEmpty());
    }

    @NotNull
    public LibraryProperties getProperties() {
        LibraryProperties libraryProperties = this.getLibraryEditor().getProperties();
        if (libraryProperties == null) {
            LibraryRootsComponent.a(2);
        }
        return libraryProperties;
    }

    public boolean isNewLibrary() {
        return this.getLibraryEditor() instanceof NewLibraryEditor;
    }

    public void updatePropertiesLabel() {
        StringBuilder stringBuilder = new StringBuilder();
        LibraryType libraryType = this.getLibraryEditor().getType();
        Set<LibraryKind> set = libraryType != null ? Collections.singleton(libraryType.getKind()) : Collections.emptySet();
        for (String string : LibraryPresentationManager.getInstance().getDescriptions(this.getLibraryEditor().getFiles(OrderRootType.CLASSES), set)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(string);
        }
        this.o.setText(stringBuilder.toString());
    }

    private void a(AbstractTreeStructure abstractTreeStructure) {
        long l2 = q ^ 0x2279F5A9C881L;
        this.p = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.p.setRootVisible(false);
        this.p.setShowsRootHandles(true);
        new LibraryRootsTreeSpeedSearch(this.p);
        this.p.setCellRenderer((TreeCellRenderer)((Object)new LibraryTreeRenderer()));
        this.a = new LibraryTableTreeBuilder((JTree)this.p, (DefaultTreeModel)this.p.getModel(), abstractTreeStructure);
        this.d.setLayout(new BorderLayout());
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JTree)this.p).disableUpDownActions().setRemoveActionName(ProjectBundle.message((String)"library.remove.action", (Object[])new Object[0])).disableRemoveAction();
        toolbarDecorator.setPanelBorder((Border)new CustomLineBorder(1, 0, 0, 0));
        final ArrayList<AttachRootButtonDescriptor> arrayList = new ArrayList<AttachRootButtonDescriptor>();
        for (AttachRootButtonDescriptor attachRootButtonDescriptor : this.e.createAttachButtons()) {
            Icon icon = attachRootButtonDescriptor.getToolbarIcon();
            if (icon != null) {
                AttachItemAction attachItemAction = new AttachItemAction(attachRootButtonDescriptor, attachRootButtonDescriptor.getButtonText(), icon);
                toolbarDecorator.addExtraAction(AnActionButton.fromAction((AnAction)attachItemAction));
                continue;
            }
            arrayList.add(attachRootButtonDescriptor);
        }
        this.f = new AddExcludedRootActionButton(this);
        toolbarDecorator.addExtraAction((AnActionButton)this.f);
        toolbarDecorator.addExtraAction(new AnActionButton("Remove", IconUtil.getRemoveIcon()){
            private static final long a = lb.a(4799444088040609722L, 2010671518265182379L, MethodHandles.lookup().lookupClass()).a(151905463617930L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                List list2;
                if (e10 == null) {
                    1.a(0);
                }
                if ((list2 = LibraryRootsComponent.this.c()).isEmpty()) {
                    return;
                }
                ApplicationManager.getApplication().runWriteAction(() -> {
                    for (Object e10 : list2) {
                        ItemElement itemElement;
                        if (e10 instanceof ItemElement) {
                            itemElement = (ItemElement)((Object)((Object)e10));
                            LibraryRootsComponent.this.getLibraryEditor().removeRoot(itemElement.getUrl(), itemElement.getRootType());
                            continue;
                        }
                        if (e10 instanceof OrderRootTypeElement) {
                            String[] stringArray;
                            itemElement = ((OrderRootTypeElement)((Object)((Object)e10))).getOrderRootType();
                            for (String string : stringArray = LibraryRootsComponent.this.getLibraryEditor().getUrls((OrderRootType)itemElement)) {
                                LibraryRootsComponent.this.getLibraryEditor().removeRoot(string, (OrderRootType)itemElement);
                            }
                            continue;
                        }
                        if (!(e10 instanceof ExcludedRootElement)) continue;
                        LibraryRootsComponent.this.getLibraryEditor().removeExcludedRoot(((ExcludedRootElement)((Object)((Object)e10))).getUrl());
                    }
                });
                LibraryRootsComponent.this.a(true);
            }

            public void updateButton(@NotNull AnActionEvent e10) {
                long l2 = a ^ 0xC90FD508EFL;
                if (e10 == null) {
                    1.a(1);
                }
                super.updateButton(e10);
                Presentation presentation = e10.getPresentation();
                if (ContainerUtil.and((Iterable)LibraryRootsComponent.this.c(), (Condition)new FilteringIterator.InstanceOf(ExcludedRootElement.class))) {
                    presentation.setText("Cancel Exclusion");
                } else {
                    presentation.setText(this.getTemplatePresentation().getText());
                }
            }

            public ShortcutSet getShortcut() {
                return CommonShortcuts.getDelete();
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x2BCB9DA5EEABL;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryRootsComponent$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateButton";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        toolbarDecorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                if (arrayList.isEmpty()) {
                    new AttachFilesAction(LibraryRootsComponent.this.e.getAttachFilesActionName()).perform();
                    return;
                }
                ArrayList<AttachItemActionBase> arrayList2 = new ArrayList<AttachItemActionBase>();
                arrayList2.add(new AttachFilesAction(LibraryRootsComponent.this.e.getAttachFilesActionName()));
                for (AttachRootButtonDescriptor attachRootButtonDescriptor : arrayList) {
                    arrayList2.add(new AttachItemAction(attachRootButtonDescriptor, attachRootButtonDescriptor.getButtonText(), null));
                }
                DefaultActionGroup defaultActionGroup = new DefaultActionGroup(arrayList2);
                JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)defaultActionGroup, DataManager.getInstance().getDataContext((Component)button.getContextComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true).show(button.getPreferredPopupPoint());
            }
        });
        this.d.add((Component)toolbarDecorator.createPanel(), "Center");
        Disposer.register((Disposable)this, (Disposable)this.a);
    }

    public JComponent getComponent() {
        return this.b;
    }

    @Nullable
    public Project getProject() {
        return this.c;
    }

    public void setContextModule(Module module2) {
        this.i = module2;
    }

    @Nullable
    public VirtualFile getExistingRootDirectory() {
        for (PersistentOrderRootType persistentOrderRootType : OrderRootType.getAllPersistentTypes()) {
            VirtualFile[] virtualFileArray = this.getLibraryEditor().getFiles((OrderRootType)persistentOrderRootType);
            if (virtualFileArray.length <= 0) continue;
            VirtualFile virtualFile = virtualFileArray[0];
            if (virtualFile.getFileSystem() instanceof JarFileSystem) {
                virtualFile = JarFileSystem.getInstance().getVirtualFileForJar(virtualFile);
            }
            if (virtualFile == null) continue;
            if (virtualFile.isDirectory()) {
                return virtualFile;
            }
            return virtualFile.getParent();
        }
        return null;
    }

    @Nullable
    public VirtualFile getBaseDirectory() {
        if (this.c != null) {
            return this.c.getBaseDir();
        }
        return null;
    }

    public LibraryEditor getLibraryEditor() {
        return (LibraryEditor)this.k.compute();
    }

    public boolean hasChanges() {
        if (this.n != null && this.n.isModified()) {
            return true;
        }
        return this.getLibraryEditor().hasChanges();
    }

    @NotNull
    private List<Object> c() {
        if (this.a == null || this.a.isDisposed()) {
            List<Object> list2 = Collections.emptyList();
            if (list2 == null) {
                LibraryRootsComponent.a(3);
            }
            return list2;
        }
        TreePath[] treePathArray = this.a.getTree().getSelectionPaths();
        if (treePathArray == null) {
            List<Object> list3 = Collections.emptyList();
            if (list3 == null) {
                LibraryRootsComponent.a(4);
            }
            return list3;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (TreePath treePath : treePathArray) {
            Object object = LibraryRootsComponent.a(treePath);
            if (object == null) continue;
            arrayList.add(object);
        }
        ArrayList<Object> arrayList2 = arrayList;
        if (arrayList2 == null) {
            LibraryRootsComponent.a(5);
        }
        return arrayList2;
    }

    public void onLibraryRenamed() {
        this.b();
    }

    @Nullable
    private static Object a(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (!(object instanceof NodeDescriptor)) {
            return null;
        }
        Object object2 = ((NodeDescriptor)object).getElement();
        if (!(object2 instanceof LibraryTableTreeContentElement)) {
            return null;
        }
        return object2;
    }

    public void renameLibrary(String newName) {
        LibraryEditor libraryEditor = this.getLibraryEditor();
        libraryEditor.setName(newName);
        this.a(false);
    }

    public void dispose() {
        if (this.n != null) {
            this.n.disposeUIResources();
        }
        this.a = null;
    }

    public void resetProperties() {
        if (this.n != null) {
            this.n.reset();
        }
    }

    public void applyProperties() {
        if (this.n != null && this.n.isModified()) {
            this.n.apply();
        }
    }

    public void updateRootsTree() {
        if (this.a != null) {
            this.a.queueUpdate();
        }
    }

    @Nullable
    private VirtualFile a() {
        if (this.l != null) {
            return this.l;
        }
        VirtualFile virtualFile = this.getExistingRootDirectory();
        if (virtualFile != null) {
            return virtualFile;
        }
        return this.getBaseDirectory();
    }

    private List<OrderRoot> c(List<? extends OrderRoot> list2) {
        List<OrderRoot> list3 = this.b(list2);
        if (!list3.isEmpty()) {
            ApplicationManager.getApplication().runWriteAction(() -> this.getLibraryEditor().addRoots((Collection)list3));
            this.updatePropertiesLabel();
            this.h();
            this.a.queueUpdate();
        }
        return list3;
    }

    private List<OrderRoot> b(@NotNull List<? extends OrderRoot> list2) {
        if (list2 == null) {
            LibraryRootsComponent.a(6);
        }
        ArrayList<OrderRoot> arrayList = new ArrayList<OrderRoot>();
        for (OrderRoot orderRoot : list2) {
            Object[] objectArray = this.getLibraryEditor().getFiles(orderRoot.getType());
            if (ArrayUtil.contains((Object)orderRoot.getFile(), (Object[])objectArray)) continue;
            arrayList.add(orderRoot);
        }
        return arrayList;
    }

    private void a(boolean bl2) {
        this.h();
        this.updatePropertiesLabel();
        this.a.queueUpdate();
        if (bl2) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.p, true));
        }
        this.f();
    }

    private void f() {
        for (Runnable runnable : this.g) {
            runnable.run();
        }
        this.b();
    }

    private void b() {
        long l2 = q ^ 0x59C077D9F7E2L;
        LibraryEditor libraryEditor = this.getLibraryEditor();
        ProjectModelExternalSource projectModelExternalSource = libraryEditor.getExternalSource();
        if (projectModelExternalSource != null && this.hasChanges()) {
            String string = libraryEditor instanceof ExistingLibraryEditor ? ((ExistingLibraryEditor)libraryEditor).getLibrary().getName() : libraryEditor.getName();
            this.m.showWarning(string != null ? "Library '" + string + "'" : "Library", projectModelExternalSource);
        } else {
            this.m.hideWarning();
        }
    }

    public void addListener(Runnable listener) {
        this.g.add(listener);
    }

    public void removeListener(Runnable listener) {
        this.g.remove(listener);
    }

    private Set<VirtualFile> d() {
        LinkedHashSet<VirtualFile> linkedHashSet = new LinkedHashSet<VirtualFile>();
        String[] stringArray = this.getLibraryEditor().getExcludedRootUrls();
        HashSet hashSet = new HashSet();
        for (String string : stringArray) {
            ContainerUtil.addIfNotNull(hashSet, (Object)VirtualFileManager.getInstance().findFileByUrl(string));
        }
        for (String string : OrderRootType.getAllPersistentTypes()) {
            VirtualFile[] virtualFileArray;
            for (VirtualFile virtualFile : virtualFileArray = this.getLibraryEditor().getFiles((OrderRootType)string)) {
                if (VfsUtilCore.isUnder((VirtualFile)virtualFile, hashSet)) continue;
                linkedHashSet.add(VfsUtil.getLocalFile((VirtualFile)virtualFile));
            }
        }
        return linkedHashSet;
    }

    static {
        q = lb.a(1950901476834050160L, 5457888841525605265L, MethodHandles.lookup().lookupClass()).a(155544660514935L);
        ourUrlComparator = new UrlComparator();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = q ^ 0xA213C941E37L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryEditorComputable";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryRootsComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryRootsComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "filterAlreadyAdded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void e() {
        JPanel jPanel;
        JPanel jPanel2;
        MultiLineLabel multiLineLabel;
        JPanel jPanel3;
        JPanel jPanel4;
        this.b = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, 2, false, false));
        this.d = jPanel3 = new JPanel();
        jPanel4.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(300, -1), null));
        this.o = multiLineLabel = new MultiLineLabel();
        jPanel4.add((Component)multiLineLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.h = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.j = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.b;
    }

    private class AddExcludedRootActionButton
    extends AnActionButton {
        final /* synthetic */ LibraryRootsComponent this$0;
        private static final long a = lb.a(-3835613738326387502L, -342346227980329072L, MethodHandles.lookup().lookupClass()).a(30143050615697L);

        AddExcludedRootActionButton(LibraryRootsComponent libraryRootsComponent) {
            long l2 = a ^ 0xED344E6ED27L;
            this.this$0 = libraryRootsComponent;
            super("Exclude", null, AllIcons.Modules.AddExcludedRoot);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            long l2 = a ^ 0x5D3183AA19DAL;
            if (e10 == null) {
                AddExcludedRootActionButton.a(0);
            }
            FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createMultipleJavaPathDescriptor();
            fileChooserDescriptor.setTitle("Exclude from Library");
            fileChooserDescriptor.setDescription("Select directories which should be excluded from the library content. Content of excluded directories won't be processed by IDE.");
            Set set = this.this$0.d();
            fileChooserDescriptor.setRoots(set.toArray(VirtualFile.EMPTY_ARRAY));
            if (set.size() < 2) {
                fileChooserDescriptor.withTreeRootVisible(true);
            }
            VirtualFile virtualFile = null;
            VirtualFile[] virtualFileArray = this.this$0.c().iterator();
            while (virtualFileArray.hasNext()) {
                Object e11 = virtualFileArray.next();
                Object object = e11 instanceof ExcludedRootElement ? ((ExcludedRootElement)((Object)e11)).getParentDescriptor() : e11;
                if (!(object instanceof ItemElement)) continue;
                virtualFile = VirtualFileManager.getInstance().findFileByUrl(((ItemElement)((Object)object)).getUrl());
                break;
            }
            if ((virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor, (Component)this.this$0.b, (Project)this.this$0.c, virtualFile)).length > 0) {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    for (VirtualFile virtualFile : virtualFileArray) {
                        this.this$0.getLibraryEditor().addExcludedRoot(virtualFile.getUrl());
                    }
                });
                this.this$0.l = virtualFileArray[0];
                this.this$0.a(true);
            }
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x347C41F461E8L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryRootsComponent$AddExcludedRootActionButton", "actionPerformed"));
        }
    }

    private class AttachItemAction
    extends AttachItemActionBase {
        private final AttachRootButtonDescriptor a;

        protected AttachItemAction(AttachRootButtonDescriptor descriptor2, String title, Icon icon) {
            super(title);
            this.getTemplatePresentation().setIcon(icon);
            this.a = descriptor2;
        }

        @Override
        protected List<OrderRoot> selectRoots(@Nullable VirtualFile initialSelection) {
            VirtualFile[] virtualFileArray = this.a.selectFiles((JComponent)LibraryRootsComponent.this.b, initialSelection, LibraryRootsComponent.this.i, LibraryRootsComponent.this.getLibraryEditor());
            if (virtualFileArray.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<OrderRoot> arrayList = new ArrayList<OrderRoot>();
            for (VirtualFile virtualFile : this.a.scanForActualRoots(virtualFileArray, (JComponent)LibraryRootsComponent.this.b)) {
                arrayList.add(new OrderRoot(virtualFile, this.a.getRootType(), this.a.addAsJarDirectories()));
            }
            return arrayList;
        }
    }

    public abstract class AttachItemActionBase
    extends DumbAwareAction {
        private static final long b = lb.a(-3551180056434823322L, -2243949564156900481L, MethodHandles.lookup().lookupClass()).a(79505698449343L);

        protected AttachItemActionBase(String text2) {
            super(text2);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                AttachItemActionBase.a(0);
            }
            this.perform();
        }

        void perform() {
            VirtualFile virtualFile = LibraryRootsComponent.this.a();
            List<OrderRoot> list2 = this.selectRoots(virtualFile);
            if (list2.isEmpty()) {
                return;
            }
            List list3 = LibraryRootsComponent.this.c(list2);
            OrderRoot orderRoot = (OrderRoot)ContainerUtil.getFirstItem((List)list3);
            if (orderRoot != null) {
                LibraryRootsComponent.this.l = orderRoot.getFile();
            }
            LibraryRootsComponent.this.f();
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)LibraryRootsComponent.this.p, true));
        }

        protected abstract List<OrderRoot> selectRoots(@Nullable VirtualFile var1);

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x4816EA634265L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryRootsComponent$AttachItemActionBase", "actionPerformed"));
        }
    }

    private class AttachFilesAction
    extends AttachItemActionBase {
        AttachFilesAction(String title) {
            super(title);
        }

        @Override
        protected List<OrderRoot> selectRoots(@Nullable VirtualFile initialSelection) {
            VirtualFile[] virtualFileArray;
            String string = LibraryRootsComponent.this.getLibraryEditor().getName();
            FileChooserDescriptor fileChooserDescriptor = LibraryRootsComponent.this.e.createAttachFilesChooserDescriptor(string);
            if (LibraryRootsComponent.this.i != null) {
                fileChooserDescriptor.putUserData(LangDataKeys.MODULE_CONTEXT, (Object)LibraryRootsComponent.this.i);
            }
            if ((virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor, (Component)LibraryRootsComponent.this.b, (Project)LibraryRootsComponent.this.c, (VirtualFile)initialSelection)).length == 0) {
                return Collections.emptyList();
            }
            return RootDetectionUtil.detectRoots(Arrays.asList(virtualFileArray), (Component)LibraryRootsComponent.this.b, (Project)LibraryRootsComponent.this.c, (LibraryRootsComponentDescriptor)LibraryRootsComponent.this.e);
        }
    }
}

