/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import b.a.lb;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.ui.Util;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.NativeLibraryOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.AttachRootButtonDescriptor;
import com.intellij.openapi.roots.libraries.ui.DescendentBasedRootFilter;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRootTypePresentation;
import com.intellij.openapi.roots.libraries.ui.RootDetector;
import com.intellij.openapi.roots.ui.OrderRootTypeUIFactory;
import com.intellij.openapi.roots.ui.configuration.LibrarySourceRootDetectorUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.JavadocQuarantineStatusCleaner;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.a;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultLibraryRootsComponentDescriptor
extends LibraryRootsComponentDescriptor {
    private static final Set<String> a;
    public static final Condition<VirtualFile> LIBRARY_ROOT_CONDITION;
    private static final long b;

    public OrderRootTypePresentation getRootTypePresentation(@NotNull OrderRootType type) {
        if (type == null) {
            DefaultLibraryRootsComponentDescriptor.a(0);
        }
        return DefaultLibraryRootsComponentDescriptor.getDefaultPresentation(type);
    }

    @NotNull
    public List<? extends AttachRootButtonDescriptor> createAttachButtons() {
        List<AttachUrlJavadocDescriptor> list2 = Collections.singletonList(new AttachUrlJavadocDescriptor(null));
        if (list2 == null) {
            DefaultLibraryRootsComponentDescriptor.a(1);
        }
        return list2;
    }

    @NotNull
    public List<? extends RootDetector> getRootDetectors() {
        long l2 = b ^ 0x1C88252B2DD5L;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new DescendentBasedRootFilter(OrderRootType.CLASSES, false, "classes", virtualFile -> StdFileTypes.CLASS.equals(virtualFile.getFileType()) || virtualFile.getFileSystem() instanceof JarFileSystem && DefaultLibraryRootsComponentDescriptor.d(virtualFile)));
        arrayList.add(DescendentBasedRootFilter.createFileTypeBasedFilter((OrderRootType)OrderRootType.CLASSES, (boolean)true, (FileType)StdFileTypes.CLASS, (String)"jar directory"));
        ContainerUtil.addAll(arrayList, (Iterable)LibrarySourceRootDetectorUtil.JAVA_SOURCE_ROOT_DETECTOR.getExtensionList());
        arrayList.add(DescendentBasedRootFilter.createFileTypeBasedFilter((OrderRootType)OrderRootType.SOURCES, (boolean)true, (FileType)StdFileTypes.JAVA, (String)"source archive directory"));
        arrayList.add((Object)new JavadocRootDetector(null));
        arrayList.add(new DescendentBasedRootFilter(AnnotationOrderRootType.getInstance(), false, "external annotations", virtualFile -> {
            long l2 = b ^ 0x1B88F6E02C0FL;
            return "annotations.xml".equals(virtualFile.getName());
        }));
        arrayList.add((Object)new NativeLibraryRootFilter(null));
        ArrayList<Object> arrayList2 = arrayList;
        if (arrayList2 == null) {
            DefaultLibraryRootsComponentDescriptor.a(2);
        }
        return arrayList2;
    }

    private static boolean d(VirtualFile virtualFile) {
        String string = virtualFile.getExtension();
        return string != null && a.contains(string);
    }

    @NotNull
    public FileChooserDescriptor createAttachFilesChooserDescriptor(@Nullable String libraryName) {
        long l2 = b ^ 0x3BB2CCE40090L;
        FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, true, true, false, true, true).withFileFilter(LIBRARY_ROOT_CONDITION);
        fileChooserDescriptor.setTitle(StringUtil.isEmpty((String)libraryName) ? ProjectBundle.message((String)"library.attach.files.action", (Object[])new Object[0]) : ProjectBundle.message((String)"library.attach.files.to.library.action", (Object[])new Object[]{libraryName}));
        fileChooserDescriptor.setDescription(ProjectBundle.message((String)"library.java.attach.files.description", (Object[])new Object[0]));
        FileChooserDescriptor fileChooserDescriptor2 = fileChooserDescriptor;
        if (fileChooserDescriptor2 == null) {
            DefaultLibraryRootsComponentDescriptor.a(3);
        }
        return fileChooserDescriptor2;
    }

    public static OrderRootTypePresentation getDefaultPresentation(OrderRootType type) {
        OrderRootTypeUIFactory orderRootTypeUIFactory = (OrderRootTypeUIFactory)OrderRootTypeUIFactory.FACTORY.getByKey((Object)type);
        return new OrderRootTypePresentation(orderRootTypeUIFactory.getNodeText(), orderRootTypeUIFactory.getIcon());
    }

    static {
        b = lb.a(3057562679937771372L, 7931094091222195073L, MethodHandles.lookup().lookupClass()).a(239668092641247L);
        long l2 = b ^ 0x255743A501C5L;
        a = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY, (Object[])new String[]{"dll", "so", "dylib"});
        LIBRARY_ROOT_CONDITION = virtualFile -> FileElement.isArchive((VirtualFile)virtualFile) || DefaultLibraryRootsComponentDescriptor.d(virtualFile);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0xEBA59882285L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttachButtons";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootDetectors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttachFilesChooserDescriptor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootTypePresentation";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AttachUrlJavadocDescriptor
    extends AttachRootButtonDescriptor {
        private static final long a = lb.a(-6332091589811828309L, -5480875218584591355L, MethodHandles.lookup().lookupClass()).a(263565297651556L);

        private AttachUrlJavadocDescriptor() {
            long l2 = a ^ 0x1B85857C0E47L;
            super(JavadocOrderRootType.getInstance(), IconUtil.getAddLinkIcon(), ProjectBundle.message((String)"module.libraries.javadoc.url.button", (Object[])new Object[0]));
        }

        public VirtualFile[] selectFiles(@NotNull JComponent parent, @Nullable VirtualFile initialSelection, @Nullable Module contextModule, @NotNull LibraryEditor libraryEditor) {
            VirtualFile[] virtualFileArray;
            VirtualFile virtualFile;
            if (parent == null) {
                AttachUrlJavadocDescriptor.a(0);
            }
            if (libraryEditor == null) {
                AttachUrlJavadocDescriptor.a(1);
            }
            if ((virtualFile = Util.showSpecifyJavadocUrlDialog((JComponent)parent)) != null) {
                VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                virtualFileArray = virtualFileArray2;
                virtualFileArray2[0] = virtualFile;
            } else {
                virtualFileArray = VirtualFile.EMPTY_ARRAY;
            }
            return virtualFileArray;
        }

        /* synthetic */ AttachUrlJavadocDescriptor(a x0) {
            this();
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x88F1F7B4676L;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "libraryEditor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$AttachUrlJavadocDescriptor";
            objectArray[2] = "selectFiles";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NativeLibraryRootFilter
    extends RootDetector {
        private static final long a = lb.a(7236892478555462413L, 9004860616808865489L, MethodHandles.lookup().lookupClass()).a(96325942976346L);

        private NativeLibraryRootFilter() {
            long l2 = a ^ 0x55929C67BC74L;
            super(NativeLibraryOrderRootType.getInstance(), false, "native library location");
        }

        @NotNull
        public Collection<VirtualFile> detectRoots(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator) {
            if (rootCandidate == null) {
                NativeLibraryRootFilter.a(0);
            }
            if (progressIndicator == null) {
                NativeLibraryRootFilter.a(1);
            }
            if (rootCandidate.isInLocalFileSystem()) {
                if (rootCandidate.isDirectory()) {
                    for (VirtualFile virtualFile : rootCandidate.getChildren()) {
                        if (!DefaultLibraryRootsComponentDescriptor.d(virtualFile)) continue;
                        Set<VirtualFile> set = Collections.singleton(rootCandidate);
                        if (set == null) {
                            NativeLibraryRootFilter.a(2);
                        }
                        return set;
                    }
                } else if (DefaultLibraryRootsComponentDescriptor.d(rootCandidate)) {
                    Set<VirtualFile> set = Collections.singleton(rootCandidate.getParent());
                    if (set == null) {
                        NativeLibraryRootFilter.a(3);
                    }
                    return set;
                }
            }
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                NativeLibraryRootFilter.a(4);
            }
            return list2;
        }

        /* synthetic */ NativeLibraryRootFilter(a x0) {
            this();
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = a ^ 0x4C2B1D0D15D3L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootCandidate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressIndicator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$NativeLibraryRootFilter";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$NativeLibraryRootFilter";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "detectRoots";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "detectRoots";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class JavadocRootDetector
    extends RootDetector {
        private static final long a = lb.a(4739883814037163806L, -3931542676066364746L, MethodHandles.lookup().lookupClass()).a(203258343343821L);

        private JavadocRootDetector() {
            long l2 = a ^ 0x6F6D67A912C1L;
            super(JavadocOrderRootType.getInstance(), false, "JavaDocs");
        }

        @NotNull
        public Collection<VirtualFile> detectRoots(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator) {
            if (rootCandidate == null) {
                JavadocRootDetector.a(0);
            }
            if (progressIndicator == null) {
                JavadocRootDetector.a(1);
            }
            ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
            JavadocRootDetector.a(rootCandidate, arrayList, progressIndicator);
            JavadocQuarantineStatusCleaner.cleanIfNeeded(VfsUtilCore.toVirtualFileArray(arrayList));
            ArrayList<VirtualFile> arrayList2 = arrayList;
            if (arrayList2 == null) {
                JavadocRootDetector.a(2);
            }
            return arrayList2;
        }

        private static void a(VirtualFile virtualFile, final List<VirtualFile> list2, final ProgressIndicator progressIndicator) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)virtualFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){
                private static final long a = lb.a(2358433326286545665L, -7594531310938095594L, MethodHandles.lookup().lookupClass()).a(273585387084180L);

                public boolean visitFile(@NotNull VirtualFile file) {
                    long l2 = a ^ 0x2A50C94A4DCEL;
                    if (file == null) {
                        1.a(0);
                    }
                    progressIndicator.checkCanceled();
                    if (file.isDirectory() && file.findChild("allclasses-frame.html") != null && file.findChild("allclasses-noframe.html") != null) {
                        list2.add(file);
                        return false;
                    }
                    return true;
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x26AA62DFFAC6L;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$JavadocRootDetector$1", "visitFile"));
                }
            });
        }

        /* synthetic */ JavadocRootDetector(a x0) {
            this();
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = a ^ 0xDE8DDF67305L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootCandidate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressIndicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$JavadocRootDetector";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$JavadocRootDetector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "detectRoots";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "detectRoots";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

