/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraries;

import b.a.lb;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.ModuleLibraryTable;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureValidator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ParameterizedRunnable;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.Predicate;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryEditingUtil {
    private static final Logger a;
    private static final long b;

    private LibraryEditingUtil() {
    }

    public static boolean libraryAlreadyExists(LibraryTable.ModifiableModel table, String libraryName) {
        Iterator iterator = table.getLibraryIterator();
        while (iterator.hasNext()) {
            Library library = (Library)iterator.next();
            String string = table instanceof LibrariesModifiableModel ? ((LibrariesModifiableModel)table).getLibraryEditor(library).getName() : library.getName();
            if (!libraryName.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String suggestNewLibraryName(LibraryTable.ModifiableModel table, String baseName) {
        String string = baseName;
        int n2 = 1;
        while (LibraryEditingUtil.libraryAlreadyExists(table, string)) {
            string = baseName + n2++;
        }
        return string;
    }

    public static Predicate<Library> getNotAddedSuitableLibrariesCondition(ModuleRootModel rootModel, FacetsProvider facetsProvider) {
        OrderEntry[] orderEntryArray = rootModel.getOrderEntries();
        HashSet<Library> hashSet = new HashSet<Library>(orderEntryArray.length);
        for (OrderEntry orderEntry : orderEntryArray) {
            Library library2;
            if (!(orderEntry instanceof LibraryOrderEntry) || !orderEntry.isValid() || (library2 = ((LibraryOrderEntry)orderEntry).getLibrary()) == null) continue;
            if (library2 instanceof LibraryImpl) {
                Library library3 = ((LibraryImpl)library2).getSource();
                hashSet.add(library3 != null ? library3 : library2);
                continue;
            }
            hashSet.add(library2);
        }
        return library -> {
            LibraryType libraryType;
            Library library2;
            if (hashSet.contains(library)) {
                return false;
            }
            if (library instanceof LibraryImpl && (library2 = ((LibraryImpl)library).getSource()) != null && hashSet.contains(library2)) {
                return false;
            }
            library2 = ((LibraryEx)library).getKind();
            return library2 == null || (libraryType = LibraryType.findByKind((LibraryKind)library2)) == null || libraryType.isSuitableModule(rootModel.getModule(), facetsProvider);
        };
    }

    public static void copyLibrary(LibraryEx from, Map<String, String> rootMapping, LibraryEx.ModifiableModelEx target) {
        long l2 = b ^ 0x54019F0D6FF0L;
        target.setProperties(from.getProperties());
        for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
            String[] stringArray;
            for (String string : stringArray = from.getUrls(orderRootType)) {
                String string2;
                String string3;
                String string4;
                String string5 = VirtualFileManager.extractProtocol((String)string);
                if (string5 == null) continue;
                String string6 = VirtualFileManager.extractPath((String)string);
                int n2 = string6.indexOf("!/");
                if (n2 != -1) {
                    string4 = string6.substring(0, n2);
                    string3 = string6.substring(n2);
                } else {
                    string4 = string6;
                    string3 = "";
                }
                String string7 = rootMapping.get(string4);
                String string8 = string2 = string7 != null ? VirtualFileManager.constructUrl((String)string5, (String)(string7 + string3)) : string;
                if (from.isJarDirectory(string, orderRootType)) {
                    target.addJarDirectory(string2, false, orderRootType);
                    continue;
                }
                target.addRoot(string2, orderRootType);
            }
        }
    }

    public static LibraryTablePresentation getLibraryTablePresentation(@NotNull Project project2, @NotNull String level) {
        long l2 = b ^ 0x7F36A066454EL;
        if (project2 == null) {
            LibraryEditingUtil.a(0);
        }
        if (level == null) {
            LibraryEditingUtil.a(1);
        }
        if (level.equals("module")) {
            return ModuleLibraryTable.MODULE_LIBRARY_TABLE_PRESENTATION;
        }
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(level, project2);
        a.assertTrue(libraryTable != null, (Object)level);
        return libraryTable.getPresentation();
    }

    public static List<LibraryType> getSuitableTypes(ClasspathPanel classpathPanel) {
        ArrayList<LibraryType> arrayList = new ArrayList<LibraryType>();
        arrayList.add(null);
        Module module2 = classpathPanel.getRootModel().getModule();
        for (LibraryType libraryType : (LibraryType[])LibraryType.EP_NAME.getExtensions()) {
            if (libraryType.getCreateActionName() == null || !libraryType.isSuitableModule(module2, classpathPanel.getModuleConfigurationState().getFacetsProvider())) continue;
            arrayList.add(libraryType);
        }
        return arrayList;
    }

    public static boolean hasSuitableTypes(ClasspathPanel panel) {
        return LibraryEditingUtil.getSuitableTypes(panel).size() > 1;
    }

    public static BaseListPopupStep<LibraryType> createChooseTypeStep(ClasspathPanel classpathPanel, final ParameterizedRunnable<? super LibraryType> action) {
        long l2 = b ^ 0x54370BD9F10EL;
        return new BaseListPopupStep<LibraryType>(IdeBundle.message((String)"popup.title.select.library.type", (Object[])new Object[0]), LibraryEditingUtil.getSuitableTypes(classpathPanel)){
            private static final long a = lb.a(-9013991723932783622L, 7068346730153904528L, MethodHandles.lookup().lookupClass()).a(181056840694277L);

            @NotNull
            public String getTextFor(LibraryType value) {
                long l2 = a ^ 0x13032DBBF9L;
                String string = value != null ? value.getCreateActionName() : IdeBundle.message((String)"create.default.library.type.action.name", (Object[])new Object[0]);
                if (string == null) {
                    1.a(0);
                }
                return string;
            }

            public Icon getIconFor(LibraryType aValue) {
                return aValue != null ? aValue.getIcon(null) : PlatformIcons.LIBRARY_ICON;
            }

            public PopupStep onChosen(LibraryType selectedValue, boolean finalChoice) {
                return this.doFinalStep(() -> action.run((Object)selectedValue));
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x42E42B2872DFL;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/libraries/LibraryEditingUtil$1", "getTextFor"));
            }
        };
    }

    public static List<Module> getSuitableModules(@NotNull ModuleStructureConfigurable rootConfigurable, @Nullable LibraryKind kind, @Nullable Library library) {
        if (rootConfigurable == null) {
            LibraryEditingUtil.a(2);
        }
        ArrayList<Module> arrayList = new ArrayList<Module>();
        LibraryType libraryType = kind == null ? null : LibraryType.findByKind((LibraryKind)kind);
        for (Module module2 : rootConfigurable.getModules()) {
            ModuleRootModel moduleRootModel;
            if (libraryType != null && !libraryType.isSuitableModule(module2, (FacetsProvider)rootConfigurable.getFacetConfigurator()) || library != null && !LibraryEditingUtil.getNotAddedSuitableLibrariesCondition(moduleRootModel = rootConfigurable.getContext().getModulesConfigurator().getRootModel(module2), rootConfigurable.getFacetConfigurator()).apply((Object)library)) continue;
            arrayList.add(module2);
        }
        return arrayList;
    }

    public static void showDialogAndAddLibraryToDependencies(@NotNull Library library, @NotNull Project project2, boolean allowEmptySelection) {
        if (library == null) {
            LibraryEditingUtil.a(3);
        }
        if (project2 == null) {
            LibraryEditingUtil.a(4);
        }
        ProjectStructureValidator.showDialogAndAddLibraryToDependencies(library, project2, allowEmptySelection);
    }

    static {
        b = lb.a(-1813980993682332980L, 7136190039081717726L, MethodHandles.lookup().lookupClass()).a(16653398022641L);
        long l2 = b ^ 0x2C112FCEE94AL;
        a = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil");
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = b ^ 0x422761252957L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootConfigurable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraries/LibraryEditingUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLibraryTablePresentation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuitableModules";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showDialogAndAddLibraryToDependencies";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

