/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import b.a.lb;
import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.LibraryDependencyScopeSuggester;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.ui.configuration.classpath.AddItemPopupAction;
import com.intellij.openapi.roots.ui.configuration.classpath.AddNewLibraryDependencyAction;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathElementChooser;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathTableItem;
import com.intellij.openapi.roots.ui.configuration.classpath.ProjectStructureChooseLibrariesDialog;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.util.ParameterizedRunnable;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.Predicate;
import com.intellij.util.ui.classpath.ChooseLibrariesFromTablesDialog;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AddLibraryDependencyAction
extends AddItemPopupAction<Library> {
    private final StructureConfigurableContext d;
    private static final long e = lb.a(-1657922491376061163L, -7010164920256518810L, MethodHandles.lookup().lookupClass()).a(185308624539181L);

    AddLibraryDependencyAction(ClasspathPanel classpathPanel, int index, String title, StructureConfigurableContext context) {
        super(classpathPanel, index, title, PlatformIcons.LIBRARY_ICON);
        this.d = context;
    }

    @Override
    public boolean hasSubStep() {
        return !this.b() && LibraryEditingUtil.hasSuitableTypes(this.myClasspathPanel);
    }

    @Override
    public PopupStep createSubStep() {
        return LibraryEditingUtil.createChooseTypeStep(this.myClasspathPanel, (ParameterizedRunnable<? super LibraryType>)((ParameterizedRunnable)libraryType -> new AddNewLibraryDependencyAction(this.myClasspathPanel, this.d, (LibraryType)libraryType).execute()));
    }

    @Override
    public void run() {
        if (this.b()) {
            super.run();
        } else {
            new AddNewLibraryDependencyAction(this.myClasspathPanel, this.d, null).run();
        }
    }

    private boolean b() {
        Predicate<Library> predicate = this.a();
        for (LibraryTable libraryTable : ChooseLibrariesFromTablesDialog.getLibraryTables(this.myClasspathPanel.getProject(), true)) {
            LibrariesModifiableModel librariesModifiableModel = this.d.myLevel2Providers.get(libraryTable.getTableLevel());
            if (librariesModifiableModel == null) continue;
            for (Library library : librariesModifiableModel.getLibraries()) {
                if (!predicate.apply((Object)library)) continue;
                return true;
            }
        }
        return false;
    }

    private Predicate<Library> a() {
        ProjectFacetsConfigurator projectFacetsConfigurator = this.d.getModulesConfigurator().getFacetsConfigurator();
        return LibraryEditingUtil.getNotAddedSuitableLibrariesCondition((ModuleRootModel)this.myClasspathPanel.getRootModel(), projectFacetsConfigurator);
    }

    @Override
    @Nullable
    protected ClasspathTableItem<?> createTableItem(Library item) {
        LibraryOrderEntry libraryOrderEntry;
        long l2 = e ^ 0x2BE957C27DD2L;
        ModifiableRootModel modifiableRootModel = this.myClasspathPanel.getRootModel();
        for (OrderEntry orderEntry : libraryOrderEntry = modifiableRootModel.getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry)) continue;
            LibraryOrderEntry libraryOrderEntry2 = (LibraryOrderEntry)orderEntry;
            if (item.equals(libraryOrderEntry2.getLibrary())) {
                return ClasspathTableItem.createLibItem(libraryOrderEntry2, this.d);
            }
            String string = item.getName();
            if (string == null || !string.equals(libraryOrderEntry2.getLibraryName())) continue;
            if (orderEntry.isValid()) {
                Messages.showErrorDialog((String)ProjectBundle.message((String)"classpath.message.library.already.added", (Object[])new Object[]{item.getName()}), (String)ProjectBundle.message((String)"classpath.title.adding.dependency", (Object[])new Object[0]));
                return null;
            }
            modifiableRootModel.removeOrderEntry(orderEntry);
        }
        LibraryOrderEntry libraryOrderEntry3 = modifiableRootModel.addLibraryEntry(item);
        libraryOrderEntry3.setScope(LibraryDependencyScopeSuggester.getDefaultScope((Library)item));
        return ClasspathTableItem.createLibItem(libraryOrderEntry3, this.d);
    }

    @Override
    protected ClasspathElementChooser<Library> createChooser() {
        return new ExistingLibraryChooser();
    }

    class ExistingLibraryChooser
    implements ClasspathElementChooser<Library> {
        private static final long a = lb.a(-7795230495373550095L, -2656130468677548813L, MethodHandles.lookup().lookupClass()).a(163524608820303L);

        ExistingLibraryChooser() {
        }

        @Override
        @NotNull
        public List<Library> chooseElements() {
            ProjectStructureChooseLibrariesDialog projectStructureChooseLibrariesDialog = new ProjectStructureChooseLibrariesDialog(AddLibraryDependencyAction.this.myClasspathPanel, AddLibraryDependencyAction.this.d, (Predicate<? super Library>)AddLibraryDependencyAction.this.a());
            projectStructureChooseLibrariesDialog.show();
            List<Library> list2 = projectStructureChooseLibrariesDialog.getSelectedLibraries();
            if (list2 == null) {
                ExistingLibraryChooser.a(0);
            }
            return list2;
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x6B8C49E1AE0DL;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/classpath/AddLibraryDependencyAction$ExistingLibraryChooser", "chooseElements"));
        }
    }
}

