/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.ArtifactEditorFindUsagesActionBase;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ArtifactSourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.LibrarySourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleOutputSourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.SourceItemNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.SourceItemsTree;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.ui.treeStructure.Tree;
import java.util.List;

public class SourceItemFindUsagesAction
extends ArtifactEditorFindUsagesActionBase {
    private final SourceItemsTree d;

    public SourceItemFindUsagesAction(SourceItemsTree tree2, Project project2, ArtifactsStructureConfigurableContext artifactContext) {
        super((Tree)tree2, project2, artifactContext);
        this.d = tree2;
    }

    @Override
    protected ProjectStructureElement getSelectedElement() {
        List<SourceItemNode> list2 = this.d.getSelectedSourceItemNodes();
        if (list2.size() != 1) {
            return null;
        }
        SourceItemNode sourceItemNode = list2.get(0);
        if (sourceItemNode == null) {
            return null;
        }
        PackagingSourceItem packagingSourceItem = sourceItemNode.getSourceItem();
        if (packagingSourceItem == null) {
            return null;
        }
        StructureConfigurableContext structureConfigurableContext = this.getContext();
        if (packagingSourceItem instanceof ModuleOutputSourceItem) {
            return new ModuleProjectStructureElement(structureConfigurableContext, ((ModuleOutputSourceItem)packagingSourceItem).getModule());
        }
        if (packagingSourceItem instanceof LibrarySourceItem) {
            return new LibraryProjectStructureElement(structureConfigurableContext, ((LibrarySourceItem)packagingSourceItem).getLibrary());
        }
        if (packagingSourceItem instanceof ArtifactSourceItem) {
            return this.myArtifactContext.getOrCreateArtifactElement(((ArtifactSourceItem)packagingSourceItem).getArtifact());
        }
        return null;
    }
}

