/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.artifacts.PlaceInArtifact;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class UsageInArtifact
extends ProjectStructureElementUsage {
    private final Artifact b;
    private final ArtifactsStructureConfigurableContext c;
    private final ProjectStructureElement f;
    private final ProjectStructureElement a;
    private final String e;
    private final PackagingElement<?> d;

    public UsageInArtifact(Artifact originalArtifact, ArtifactsStructureConfigurableContext context, ProjectStructureElement sourceElement, ArtifactProjectStructureElement containingElement, String parentPath, PackagingElement<?> packagingElement) {
        this.b = originalArtifact;
        this.c = context;
        this.f = sourceElement;
        this.a = containingElement;
        this.e = parentPath;
        this.d = packagingElement;
    }

    @Override
    public ProjectStructureElement getSourceElement() {
        return this.f;
    }

    @Override
    public ProjectStructureElement getContainingElement() {
        return this.a;
    }

    public void removeElement() {
        this.a().removePackagingElement(this.e, this.d);
    }

    private ArtifactEditorEx a() {
        return (ArtifactEditorEx)this.c.getOrCreateEditor(this.b);
    }

    public void replaceElement(PackagingElement<?> replacement) {
        this.a().replacePackagingElement(this.e, this.d, replacement);
    }

    @Override
    public String getPresentableName() {
        return this.b.getName();
    }

    @Override
    public PlaceInProjectStructure getPlace() {
        return new PlaceInArtifact(this.b, this.c, this.e, this.d);
    }

    @Override
    public int hashCode() {
        return this.b.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof UsageInArtifact && ((UsageInArtifact)obj).b.equals(this.b);
    }

    @Override
    public Icon getIcon() {
        return this.b.getArtifactType().getIcon();
    }

    @Override
    @Nullable
    public String getPresentableLocationInElement() {
        return "[" + this.e + "]";
    }

    @Override
    public void removeSourceElement() {
        this.removeElement();
    }

    @Override
    public void replaceElement(ProjectStructureElement newElement) {
        Library library = ((LibraryProjectStructureElement)newElement).getLibrary();
        PackagingElement packagingElement = PackagingElementFactory.getInstance().createLibraryFiles(library.getName(), library.getTable().getTableLevel(), null);
        this.replaceElement(packagingElement);
    }
}

