/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import b.a.lb;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ComplexElementSubstitutionParameters;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTree;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeSelection;
import com.intellij.openapi.roots.ui.configuration.artifacts.PackagingElementDraggingObject;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.ArtifactRootNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.CompositePackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingNodeSource;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingTreeNodeFactory;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.DirectoryPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPropertiesPanel;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.WeightBasedComparator;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutTreeComponent
implements DnDTarget,
Disposable {
    @NonNls
    private static final String c = "<empty>";
    @NonNls
    private static final String k = "properties";
    private final ArtifactEditorImpl n;
    private final LayoutTree d;
    private final JPanel h;
    private final ComplexElementSubstitutionParameters e;
    private final ArtifactEditorContext g;
    private final Artifact j;
    private SelectedElementInfo<?> i;
    private JPanel b;
    private JPanel a;
    private final LayoutTreeBuilder f;
    private boolean l;
    private final LayoutTreeStructure m;
    private static final long o = lb.a(7276521497911009348L, -1163250834795920307L, MethodHandles.lookup().lookupClass()).a(276207011187030L);

    public LayoutTreeComponent(ArtifactEditorImpl artifactsEditor, ComplexElementSubstitutionParameters substitutionParameters, ArtifactEditorContext context, Artifact originalArtifact, boolean sortElements) {
        long l2 = o ^ 0x7C3C2AE2060EL;
        this.i = new SelectedElementInfo(this, null);
        this.n = artifactsEditor;
        this.e = substitutionParameters;
        this.g = context;
        this.j = originalArtifact;
        this.l = sortElements;
        this.d = new LayoutTree(this.n);
        this.m = new LayoutTreeStructure();
        this.f = new LayoutTreeBuilder();
        Disposer.register((Disposable)this, (Disposable)this.d);
        Disposer.register((Disposable)this, (Disposable)this.f);
        this.d.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e10) {
                LayoutTreeComponent.this.updatePropertiesPanel(false);
            }
        });
        this.b();
        this.h = new JPanel(new BorderLayout());
        this.h.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.d)), "Center");
        this.h.add((Component)this.b, "South");
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            DnDManager.getInstance().registerTarget((DnDTarget)this, (JComponent)((Object)this.d));
        }
    }

    @Nullable
    private WeightBasedComparator a() {
        return this.l ? new WeightBasedComparator(true) : null;
    }

    public void setSortElements(boolean sortElements) {
        this.l = sortElements;
        this.f.setNodeDescriptorComparator((Comparator)this.a());
        this.n.getContext().getParent().getDefaultSettings().setSortElements(sortElements);
    }

    @Nullable
    private static PackagingElementNode a(Object object) {
        if (!(object instanceof DefaultMutableTreeNode)) {
            return null;
        }
        Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
        return object2 instanceof PackagingElementNode ? (PackagingElementNode)((Object)object2) : null;
    }

    private void b() {
        long l2 = o ^ 0x3F557A0E4B99L;
        this.a = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setMinimumSize((Dimension)JBUI.emptySize());
        jPanel.setPreferredSize((Dimension)JBUI.emptySize());
        this.b = new JPanel(new CardLayout());
        this.a.setBorder((Border)new CustomLineBorder(1, 0, 0, 0));
        this.b.add(c, jPanel);
        this.b.add(k, this.a);
    }

    public Artifact getArtifact() {
        return this.n.getArtifact();
    }

    public LayoutTree getLayoutTree() {
        return this.d;
    }

    public void updatePropertiesPanel(boolean force) {
        PackagingElement<?> packagingElement = this.getSelection().getElementIfSingle();
        if (!force && Comparing.equal(packagingElement, (Object)((SelectedElementInfo)this.i).a)) {
            return;
        }
        this.i.save();
        this.i = new SelectedElementInfo(this, packagingElement);
        this.i.showPropertiesPanel();
    }

    public void saveElementProperties() {
        this.i.save();
    }

    public void rebuildTree() {
        this.f.updateFromRoot(true);
        this.updatePropertiesPanel(true);
        this.n.queueValidation();
    }

    public LayoutTreeSelection getSelection() {
        return this.d.getSelection();
    }

    public void addNewPackagingElement(@NotNull PackagingElementType<?> type) {
        CompositePackagingElement compositePackagingElement;
        PackagingElementNode<?> packagingElementNode;
        Object obj;
        if (type == null) {
            LayoutTreeComponent.a(0);
        }
        if ((obj = (packagingElementNode = this.a(this.d.getSelection())).getFirstElement()) instanceof CompositePackagingElement) {
            compositePackagingElement = (CompositePackagingElement)obj;
        } else {
            compositePackagingElement = this.getArtifact().getRootElement();
            packagingElementNode = this.d.getRootPackagingNode();
        }
        if (!this.checkCanAdd(compositePackagingElement, packagingElementNode)) {
            return;
        }
        List list2 = type.chooseAndCreate(this.g, this.getArtifact(), compositePackagingElement);
        PackagingElementNode<?> packagingElementNode2 = packagingElementNode;
        this.editLayout(() -> {
            CompositePackagingElement<?> compositePackagingElement2 = LayoutTreeComponent.a(compositePackagingElement, packagingElementNode2);
            for (PackagingElement packagingElement : list2) {
                compositePackagingElement2.addOrFindChild(packagingElement);
            }
        });
        this.updateAndSelect(packagingElementNode, list2);
    }

    private static CompositePackagingElement<?> a(CompositePackagingElement<?> compositePackagingElement, PackagingElementNode<?> compositePackagingElementNode) {
        Object obj;
        CompositePackagingElementNode compositePackagingElementNode2;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (compositePackagingElementNode2 = compositePackagingElementNode; compositePackagingElementNode2 != null && !(compositePackagingElementNode2 instanceof ArtifactRootNode); compositePackagingElementNode2 = compositePackagingElementNode2.getParentNode()) {
            obj = compositePackagingElementNode2.getFirstElement();
            if (!(obj instanceof DirectoryPackagingElement)) {
                return compositePackagingElement;
            }
            arrayList.add(((DirectoryPackagingElement)((Object)obj)).getDirectoryName());
        }
        if (compositePackagingElementNode2 == null) {
            return compositePackagingElement;
        }
        obj = compositePackagingElementNode2.getElementIfSingle();
        if (!(obj instanceof CompositePackagingElement)) {
            return compositePackagingElement;
        }
        Collections.reverse(arrayList);
        String string = StringUtil.join(arrayList, (String)"/");
        return PackagingElementFactory.getInstance().getOrCreateDirectory((CompositePackagingElement)obj, string);
    }

    public boolean checkCanModify(@NotNull PackagingElement<?> element, @NotNull PackagingElementNode<?> node) {
        if (element == null) {
            LayoutTreeComponent.a(1);
        }
        if (node == null) {
            LayoutTreeComponent.a(2);
        }
        return this.checkCanModify(node.getNodeSource(element));
    }

    public boolean checkCanModifyChildren(@NotNull PackagingElement<?> parentElement, @NotNull PackagingElementNode<?> parentNode, @NotNull Collection<? extends PackagingElementNode<?>> children2) {
        if (parentElement == null) {
            LayoutTreeComponent.a(3);
        }
        if (parentNode == null) {
            LayoutTreeComponent.a(4);
        }
        if (children2 == null) {
            LayoutTreeComponent.a(5);
        }
        ArrayList<PackagingNodeSource> arrayList = new ArrayList<PackagingNodeSource>(parentNode.getNodeSource(parentElement));
        for (PackagingElementNode<?> packagingElementNode : children2) {
            arrayList.addAll(packagingElementNode.getNodeSources());
        }
        return this.checkCanModify(arrayList);
    }

    public boolean checkCanModify(Collection<PackagingNodeSource> nodeSources) {
        long l2 = o ^ 0xA1896F1AC90L;
        if (nodeSources.isEmpty()) {
            return true;
        }
        if (nodeSources.size() > 1) {
            Messages.showErrorDialog((Component)this.n.getMainComponent(), (String)"The selected node consist of several elements so it cannot be edited.\nSwitch off 'Show content of elements' checkbox to edit the output layout.");
        } else {
            PackagingNodeSource packagingNodeSource = (PackagingNodeSource)ContainerUtil.getFirstItem(nodeSources, null);
            if (packagingNodeSource != null) {
                Messages.showErrorDialog((Component)this.n.getMainComponent(), (String)("The selected node belongs to '" + packagingNodeSource.getPresentableName() + "' element so it cannot be edited.\nSwitch off 'Show content of elements' checkbox to edit the output layout."));
            }
        }
        return false;
    }

    public boolean checkCanAdd(CompositePackagingElement<?> parentElement, PackagingElementNode<?> parentNode) {
        boolean bl2 = true;
        for (CompositePackagingElementNode compositePackagingElementNode = parentNode; compositePackagingElementNode != null && !(compositePackagingElementNode instanceof ArtifactRootNode); compositePackagingElementNode = compositePackagingElementNode.getParentNode()) {
            Object obj = compositePackagingElementNode.getFirstElement();
            if (obj instanceof DirectoryPackagingElement) continue;
            bl2 = false;
            break;
        }
        return bl2 || this.checkCanModify((PackagingElement<?>)parentElement, parentNode);
    }

    public boolean checkCanRemove(List<? extends PackagingElementNode<?>> nodes) {
        long l2 = o ^ 0x4E9F82DDDC3FL;
        HashSet<PackagingNodeSource> hashSet = new HashSet<PackagingNodeSource>();
        for (Object object2 : nodes) {
            hashSet.addAll(LayoutTreeComponent.a(object2.getNodeSources()));
        }
        if (!hashSet.isEmpty()) {
            Object object;
            if (hashSet.size() == 1) {
                Object object2;
                object2 = ((PackagingNodeSource)hashSet.iterator().next()).getPresentableName();
                object = "The selected node belongs to '" + object2 + "' element. Do you want to remove the whole '" + object2 + "' element from the artifact?";
            } else {
                object = "The selected node belongs to " + nodes.size() + " elements. Do you want to remove all these elements from the artifact?";
            }
            int n2 = Messages.showYesNoDialog((Component)this.n.getMainComponent(), (String)object, (String)"Remove Elements", null);
            if (n2 != 0) {
                return false;
            }
        }
        return true;
    }

    public void updateAndSelect(PackagingElementNode<?> node, List<? extends PackagingElement<?>> toSelect) {
        this.n.queueValidation();
        this.m.clearCaches();
        this.f.queueUpdateFrom(node, true).doWhenDone(() -> {
            List<PackagingElementNode<?>> list3 = this.d.findNodes(toSelect);
            this.f.select(ArrayUtil.toObjectArray(list3), null);
        });
    }

    public void selectNode(@NotNull String parentPath, @NotNull PackagingElement<?> element) {
        PackagingElementNode<?> packagingElementNode;
        if (parentPath == null) {
            LayoutTreeComponent.a(6);
        }
        if (element == null) {
            LayoutTreeComponent.a(7);
        }
        if ((packagingElementNode = this.d.findCompositeNodeByPath(parentPath)) == null) {
            return;
        }
        for (SimpleNode simpleNode : packagingElementNode.getChildren()) {
            if (!(simpleNode instanceof PackagingElementNode)) continue;
            List list2 = ((PackagingElementNode)simpleNode).getPackagingElements();
            for (PackagingElement packagingElement : list2) {
                if (!packagingElement.isEqualTo(element)) continue;
                this.f.select(simpleNode);
                return;
            }
        }
    }

    public void selectNode(@NotNull String parentPath, @NotNull String nodeName) {
        PackagingElementNode<?> packagingElementNode;
        if (parentPath == null) {
            LayoutTreeComponent.a(8);
        }
        if (nodeName == null) {
            LayoutTreeComponent.a(9);
        }
        if ((packagingElementNode = this.d.findCompositeNodeByPath(parentPath)) == null) {
            return;
        }
        for (SimpleNode simpleNode : packagingElementNode.getChildren()) {
            if (!(simpleNode instanceof PackagingElementNode) || !nodeName.equals(((PackagingElementNode)simpleNode).getElementPresentation().getSearchName())) continue;
            this.f.select(simpleNode);
            return;
        }
    }

    public void editLayout(Runnable action) {
        this.g.editLayout(this.j, action);
    }

    public void removeSelectedElements() {
        LayoutTreeSelection layoutTreeSelection = this.d.getSelection();
        if (!this.checkCanRemove(layoutTreeSelection.getNodes())) {
            return;
        }
        this.editLayout(() -> this.removeNodes(layoutTreeSelection.getNodes()));
        this.n.rebuildTries();
    }

    public void removeNodes(List<PackagingElementNode<?>> nodes) {
        Object object;
        HashSet<Collection<PackagingNodeSource>> hashSet = new HashSet<Collection<PackagingNodeSource>>();
        for (PackagingElementNode<?> object22 : nodes) {
            object = object22.getPackagingElements();
            for (PackagingElement packagingElement : object) {
                Collection<PackagingNodeSource> collection;
                Collection<PackagingNodeSource> collection2 = object22.getNodeSource(packagingElement);
                if (collection2.isEmpty()) {
                    collection = object22.getParentElement(packagingElement);
                    if (collection == null) continue;
                    hashSet.add(collection);
                    collection.removeChild(packagingElement);
                    continue;
                }
                collection = LayoutTreeComponent.a(collection2);
                for (PackagingNodeSource packagingNodeSource : collection) {
                    hashSet.add((Collection<PackagingNodeSource>)packagingNodeSource.getSourceParentElement());
                    packagingNodeSource.getSourceParentElement().removeChild(packagingNodeSource.getSourceElement());
                }
            }
        }
        List<PackagingElementNode<?>> list2 = this.d.findNodes(hashSet);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = (PackagingElementNode)((Object)iterator.next());
            this.d.addSubtreeToUpdate((PackagingElementNode)((Object)object));
        }
    }

    private static Collection<PackagingNodeSource> a(Collection<PackagingNodeSource> collection) {
        HashSet<PackagingNodeSource> hashSet = new HashSet<PackagingNodeSource>();
        LayoutTreeComponent.a(collection, hashSet);
        return hashSet;
    }

    private static void a(Collection<PackagingNodeSource> collection, Set<PackagingNodeSource> set) {
        for (PackagingNodeSource packagingNodeSource : collection) {
            Collection<PackagingNodeSource> collection2 = packagingNodeSource.getParentSources();
            if (collection2.isEmpty()) {
                set.add(packagingNodeSource);
                continue;
            }
            LayoutTreeComponent.a(collection2, set);
        }
    }

    private PackagingElementNode<?> a(LayoutTreeSelection layoutTreeSelection) {
        PackagingElementNode<?> packagingElementNode = layoutTreeSelection.getNodeIfSingle();
        if (packagingElementNode != null) {
            if (packagingElementNode.getFirstElement() instanceof CompositePackagingElement) {
                return packagingElementNode;
            }
            CompositePackagingElementNode compositePackagingElementNode = packagingElementNode.getParentNode();
            if (compositePackagingElementNode != null) {
                return compositePackagingElementNode;
            }
        }
        return this.d.getRootPackagingNode();
    }

    public JPanel getTreePanel() {
        return this.h;
    }

    public void dispose() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            DnDManager.getInstance().unregisterTarget((DnDTarget)this, (JComponent)((Object)this.d));
        }
    }

    public boolean update(DnDEvent aEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        aEvent.setDropPossible(false);
        aEvent.hideHighlighter();
        Object object = aEvent.getAttachedObject();
        if (object instanceof PackagingElementDraggingObject && (defaultMutableTreeNode = this.a(aEvent.getRelativePoint().getPoint((Component)((Object)this.d)))) != null) {
            Object e10;
            PackagingElementDraggingObject packagingElementDraggingObject = (PackagingElementDraggingObject)object;
            PackagingElementNode packagingElementNode = LayoutTreeComponent.a(defaultMutableTreeNode);
            if (packagingElementNode != null && packagingElementDraggingObject.canDropInto(packagingElementNode) && (e10 = packagingElementNode.getFirstElement()) instanceof CompositePackagingElement) {
                packagingElementDraggingObject.setTargetNode(packagingElementNode);
                packagingElementDraggingObject.setTargetElement((CompositePackagingElement)e10);
                Rectangle rectangle = this.d.getPathBounds(TreeUtil.getPathFromRoot((TreeNode)defaultMutableTreeNode));
                aEvent.setHighlighting(new RelativeRectangle((Component)((Object)this.d), rectangle), 1);
                aEvent.setDropPossible(true);
            }
        }
        return false;
    }

    public void drop(DnDEvent aEvent) {
        Object object = aEvent.getAttachedObject();
        if (object instanceof PackagingElementDraggingObject) {
            PackagingElementDraggingObject packagingElementDraggingObject = (PackagingElementDraggingObject)object;
            PackagingElementNode<?> packagingElementNode = packagingElementDraggingObject.getTargetNode();
            CompositePackagingElement<?> compositePackagingElement = packagingElementDraggingObject.getTargetElement();
            if (compositePackagingElement == null || packagingElementNode == null || !packagingElementDraggingObject.checkCanDrop()) {
                return;
            }
            if (!this.checkCanAdd(compositePackagingElement, packagingElementNode)) {
                return;
            }
            ArrayList arrayList = new ArrayList();
            this.editLayout(() -> {
                packagingElementDraggingObject.beforeDrop();
                CompositePackagingElement<?> compositePackagingElement2 = LayoutTreeComponent.a(compositePackagingElement, packagingElementNode);
                for (PackagingElement<?> packagingElement : packagingElementDraggingObject.createPackagingElements(this.g)) {
                    arrayList.add(packagingElement);
                    compositePackagingElement2.addOrFindChild(packagingElement);
                }
            });
            this.updateAndSelect(packagingElementNode, arrayList);
            this.n.getSourceItemsTree().rebuildTree();
        }
    }

    @Nullable
    private DefaultMutableTreeNode a(Point point) {
        for (TreePath treePath = this.d.getPathForLocation(point.x, point.y); treePath != null; treePath = treePath.getParentPath()) {
            PackagingElement<?> packagingElement = this.d.getElementByPath(treePath);
            if (!(packagingElement instanceof CompositePackagingElement)) continue;
            return (DefaultMutableTreeNode)treePath.getLastPathComponent();
        }
        return null;
    }

    public void cleanUpOnLeave() {
    }

    public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
    }

    public void startRenaming(TreePath path) {
        this.d.startEditingAtPath(path);
    }

    public boolean isEditing() {
        return this.d.isEditing();
    }

    public void setRootElement(CompositePackagingElement<?> rootElement) {
        this.g.getOrCreateModifiableArtifactModel().getOrCreateModifiableArtifact(this.j).setRootElement(rootElement);
        this.m.updateRootElement();
        DefaultMutableTreeNode defaultMutableTreeNode = this.d.getRootNode();
        defaultMutableTreeNode.setUserObject(this.m.getRootElement());
        this.f.updateNode(defaultMutableTreeNode);
        this.rebuildTree();
        this.n.getSourceItemsTree().rebuildTree();
    }

    public CompositePackagingElement<?> getRootElement() {
        return this.g.getRootElement(this.j);
    }

    public void updateTreeNodesPresentation() {
        this.f.updateFromRoot(false);
    }

    public void updateRootNode() {
        this.f.updateNode(this.d.getRootNode());
    }

    public void initTree() {
        this.f.initRootNode();
        this.i.showPropertiesPanel();
    }

    public void putIntoDefaultLocations(@NotNull List<? extends PackagingSourceItem> items) {
        if (items == null) {
            LayoutTreeComponent.a(10);
        }
        ArrayList arrayList = new ArrayList();
        this.editLayout(() -> {
            long l2 = o ^ 0x3A9FDD885C68L;
            if (items == null) {
                LayoutTreeComponent.a(17);
            }
            CompositePackagingElement compositePackagingElement = this.getArtifact().getRootElement();
            ArtifactType artifactType = this.getArtifact().getArtifactType();
            for (PackagingSourceItem packagingSourceItem : items) {
                String string = artifactType.getDefaultPathFor(packagingSourceItem);
                if (string == null) continue;
                CompositePackagingElement compositePackagingElement2 = string.endsWith("!/") ? PackagingElementFactory.getInstance().getOrCreateArchive(compositePackagingElement, StringUtil.trimEnd((String)string, (String)"!/")) : PackagingElementFactory.getInstance().getOrCreateDirectory(compositePackagingElement, string);
                List list4 = packagingSourceItem.createElements(this.g);
                arrayList.addAll(compositePackagingElement2.addOrFindChildren((Collection)list4));
            }
        });
        this.n.getSourceItemsTree().rebuildTree();
        this.updateAndSelect(this.d.getRootPackagingNode(), arrayList);
    }

    public void putElements(@NotNull String path, @NotNull List<? extends PackagingElement<?>> elements) {
        if (path == null) {
            LayoutTreeComponent.a(11);
        }
        if (elements == null) {
            LayoutTreeComponent.a(12);
        }
        ArrayList arrayList = new ArrayList();
        this.editLayout(() -> {
            if (path == null) {
                LayoutTreeComponent.a(15);
            }
            if (elements == null) {
                LayoutTreeComponent.a(16);
            }
            CompositePackagingElement compositePackagingElement = PackagingElementFactory.getInstance().getOrCreateDirectory(this.getArtifact().getRootElement(), path);
            arrayList.addAll(compositePackagingElement.addOrFindChildren((Collection)elements));
        });
        this.n.getSourceItemsTree().rebuildTree();
        this.updateAndSelect(this.d.getRootPackagingNode(), arrayList);
    }

    public void packInto(@NotNull List<? extends PackagingSourceItem> items, String pathToJar) {
        if (items == null) {
            LayoutTreeComponent.a(13);
        }
        ArrayList arrayList = new ArrayList();
        CompositePackagingElement compositePackagingElement = this.getArtifact().getRootElement();
        this.editLayout(() -> {
            if (items == null) {
                LayoutTreeComponent.a(14);
            }
            CompositePackagingElement compositePackagingElement2 = PackagingElementFactory.getInstance().getOrCreateArchive(compositePackagingElement, pathToJar);
            for (PackagingSourceItem packagingSourceItem : items) {
                List list4 = packagingSourceItem.createElements(this.g);
                compositePackagingElement2.addOrFindChildren((Collection)list4);
            }
            arrayList.add(compositePackagingElement2);
        });
        this.n.getSourceItemsTree().rebuildTree();
        this.updateAndSelect(this.d.getRootPackagingNode(), arrayList);
    }

    public boolean isPropertiesModified() {
        PackagingElementPropertiesPanel packagingElementPropertiesPanel = ((SelectedElementInfo)this.i).b;
        return packagingElementPropertiesPanel != null && packagingElementPropertiesPanel.isModified();
    }

    public void resetElementProperties() {
        PackagingElementPropertiesPanel packagingElementPropertiesPanel = ((SelectedElementInfo)this.i).b;
        if (packagingElementPropertiesPanel != null) {
            packagingElementPropertiesPanel.reset();
        }
    }

    public boolean isSortElements() {
        return this.l;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = o ^ 0x370540E2A2B8L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeName";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTreeComponent";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addNewPackagingElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCanModify";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCanModifyChildren";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "selectNode";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "putIntoDefaultLocations";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "putElements";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "packInto";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$packInto$6";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$putElements$5";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$putIntoDefaultLocations$4";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class LayoutTreeBuilder
    extends SimpleTreeBuilder {
        LayoutTreeBuilder() {
            super((JTree)((Object)LayoutTreeComponent.this.d), LayoutTreeComponent.this.d.getBuilderModel(), (AbstractTreeStructure)LayoutTreeComponent.this.m, (Comparator)LayoutTreeComponent.this.a());
        }

        public void updateNode(DefaultMutableTreeNode node) {
            super.updateNode(node);
        }
    }

    private class LayoutTreeStructure
    extends SimpleTreeStructure {
        private ArtifactRootNode a;
        private static final long b = lb.a(7965253956329669769L, 4840362615307481351L, MethodHandles.lookup().lookupClass()).a(41312077239350L);

        private LayoutTreeStructure() {
        }

        @NotNull
        public Object getRootElement() {
            if (this.a == null) {
                this.a = PackagingTreeNodeFactory.createRootNode(LayoutTreeComponent.this.n, LayoutTreeComponent.this.g, LayoutTreeComponent.this.e, LayoutTreeComponent.this.getArtifact().getArtifactType());
            }
            ArtifactRootNode artifactRootNode = this.a;
            if (artifactRootNode == null) {
                LayoutTreeStructure.a(0);
            }
            return artifactRootNode;
        }

        public void updateRootElement() {
            this.a = null;
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x19464847CF1CL;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTreeComponent$LayoutTreeStructure", "getRootElement"));
        }
    }

    private class SelectedElementInfo<E extends PackagingElement<?>> {
        private final E a;
        private PackagingElementPropertiesPanel b;
        final /* synthetic */ LayoutTreeComponent this$0;
        private static final long c = lb.a(2820771940245835733L, -6934233273366342969L, MethodHandles.lookup().lookupClass()).a(227065357040763L);

        private SelectedElementInfo(E element) {
            long l2 = c ^ 0x37453D5BE9EL;
            this.this$0 = var1_1;
            this.a = element;
            if (this.a != null) {
                this.b = element.getType().createElementPropertiesPanel(this.a, ((LayoutTreeComponent)var1_1).g);
                ((LayoutTreeComponent)var1_1).a.removeAll();
                if (this.b != null) {
                    ((LayoutTreeComponent)var1_1).a.add("Center", ScrollPaneFactory.createScrollPane((Component)this.b.createComponent(), (boolean)true));
                    this.b.reset();
                    ((LayoutTreeComponent)var1_1).a.revalidate();
                }
            }
        }

        public void save() {
            if (this.b != null && this.b.isModified()) {
                this.this$0.editLayout(() -> this.b.apply());
            }
        }

        public void showPropertiesPanel() {
            long l2 = c ^ 0x1C90531C6C14L;
            CardLayout cardLayout = (CardLayout)this.this$0.b.getLayout();
            if (this.b != null) {
                cardLayout.show(this.this$0.b, LayoutTreeComponent.k);
            } else {
                cardLayout.show(this.this$0.b, LayoutTreeComponent.c);
            }
            this.this$0.b.repaint();
        }
    }
}

