/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import b.a.lb;
import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactConfigurable;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactConfigurableBase;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorSettings;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactStructureConfigurableState;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContextImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.InvalidArtifactConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.GlobalLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.RemoveConfigurableHandler;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MasterDetailsState;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.NonEmptyInputValidator;
import com.intellij.openapi.util.Comparing;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactAdapter;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.InvalidArtifact;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.LibraryElementType;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactsStructureConfigurable
extends BaseStructureConfigurable {
    private ArtifactsStructureConfigurableContextImpl c;
    private final ArtifactEditorSettings b;
    private static final long d = lb.a(3962431524108483839L, 1922980534009046823L, MethodHandles.lookup().lookupClass()).a(137850910085397L);

    public ArtifactsStructureConfigurable(@NotNull Project project2) {
        if (project2 == null) {
            ArtifactsStructureConfigurable.b(0);
        }
        super(project2, new ArtifactStructureConfigurableState());
        this.b = new ArtifactEditorSettings();
    }

    protected String getComponentStateKey() {
        long l2 = d ^ 0x2304345B1D65L;
        return "ArtifactsStructureConfigurable.UI";
    }

    public void init(StructureConfigurableContext context, ModuleStructureConfigurable moduleStructureConfigurable, ProjectLibrariesConfigurable projectLibrariesConfig, GlobalLibrariesConfigurable globalLibrariesConfig) {
        super.init(context);
        this.c = new ArtifactsStructureConfigurableContextImpl(this.myContext, this.myProject, this.b, new ArtifactAdapter(){
            private static final long a = lb.a(-8368352507875781406L, 6292328383540900160L, MethodHandles.lookup().lookupClass()).a(158355498565764L);

            public void artifactAdded(@NotNull Artifact artifact) {
                if (artifact == null) {
                    1.a(0);
                }
                MasterDetailsComponent.MyNode myNode = ArtifactsStructureConfigurable.this.a(artifact);
                ArtifactsStructureConfigurable.this.selectNodeInTree((DefaultMutableTreeNode)myNode);
                ArtifactsStructureConfigurable.this.myContext.getDaemonAnalyzer().queueUpdate(ArtifactsStructureConfigurable.this.c.getOrCreateArtifactElement(artifact));
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x4290920E023L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$1", "artifactAdded"));
            }
        });
        context.getModulesConfigurator().addAllModuleChangeListener(new ModuleEditor.ChangeListener(){

            @Override
            public void moduleStateChanged(ModifiableRootModel moduleRootModel) {
                for (ProjectStructureElement projectStructureElement : ArtifactsStructureConfigurable.this.getProjectStructureElements()) {
                    ArtifactsStructureConfigurable.this.myContext.getDaemonAnalyzer().queueUpdate(projectStructureElement);
                }
            }
        });
        MasterDetailsComponent.ItemsChangeListener itemsChangeListener = new MasterDetailsComponent.ItemsChangeListener(){

            public void itemChanged(@Nullable Object deletedItem) {
                if (deletedItem instanceof Library || deletedItem instanceof Module) {
                    ArtifactsStructureConfigurable.this.c();
                }
            }
        };
        moduleStructureConfigurable.addItemsChangeListener(itemsChangeListener);
        projectLibrariesConfig.addItemsChangeListener(itemsChangeListener);
        globalLibrariesConfig.addItemsChangeListener(itemsChangeListener);
        context.addLibraryEditorListener(new LibraryEditorListener(){
            private static final long a = lb.a(-5595439622780044860L, 6052599312434016513L, MethodHandles.lookup().lookupClass()).a(221740646822093L);

            @Override
            public void libraryRenamed(@NotNull Library library, String oldName, String newName) {
                Artifact[] artifactArray;
                if (library == null) {
                    4.a(0);
                }
                for (Artifact artifact : artifactArray = ArtifactsStructureConfigurable.this.c.getArtifactModel().getArtifacts()) {
                    ArtifactsStructureConfigurable.this.a(artifact, library, oldName, newName);
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x4C5AF9A214F4L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$4", "libraryRenamed"));
            }
        });
    }

    private void a(Artifact artifact, final Library library, final String string, final String string2) {
        if (ArtifactUtil.processPackagingElements(this.c.getRootElement(artifact), LibraryElementType.LIBRARY_ELEMENT_TYPE, new PackagingElementProcessor<LibraryPackagingElement>(){
            private static final long a = lb.a(-7306856932819540902L, -2901398495497354203L, MethodHandles.lookup().lookupClass()).a(128750241552355L);

            @Override
            public boolean process(@NotNull LibraryPackagingElement element, @NotNull PackagingElementPath path) {
                if (element == null) {
                    5.a(0);
                }
                if (path == null) {
                    5.a(1);
                }
                return !ArtifactsStructureConfigurable.a(element, library, string);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x41A6CE9D27ACL;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$5";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this.c, false, artifact.getArtifactType())) {
            return;
        }
        this.c.editLayout(artifact, () -> {
            ModifiableArtifact modifiableArtifact = this.c.getOrCreateModifiableArtifactModel().getOrCreateModifiableArtifact(artifact);
            ArtifactUtil.processPackagingElements((Artifact)modifiableArtifact, LibraryElementType.LIBRARY_ELEMENT_TYPE, new PackagingElementProcessor<LibraryPackagingElement>(){
                private static final long a = lb.a(-924848990166135694L, -8061427329195791614L, MethodHandles.lookup().lookupClass()).a(46516623601027L);

                @Override
                public boolean process(@NotNull LibraryPackagingElement element, @NotNull PackagingElementPath path) {
                    if (element == null) {
                        6.a(0);
                    }
                    if (path == null) {
                        6.a(1);
                    }
                    if (ArtifactsStructureConfigurable.a(element, library, string)) {
                        element.setLibraryName(string2);
                    }
                    return true;
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    long l2 = a ^ 0x9659DCC8AEFL;
                    Object[] objectArray2 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "path";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$6";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, (PackagingElementResolvingContext)this.c, false);
        });
        ArtifactEditorImpl artifactEditorImpl = this.c.getArtifactEditor(artifact);
        if (artifactEditorImpl != null) {
            artifactEditorImpl.rebuildTries();
        }
    }

    private static boolean a(LibraryPackagingElement libraryPackagingElement, Library library, String string) {
        long l2 = d ^ 0x40C0D7DCA96AL;
        if (!libraryPackagingElement.getLibraryName().equals(string)) {
            return false;
        }
        LibraryTable libraryTable = library.getTable();
        if (libraryTable != null) {
            return libraryTable.getTableLevel().equals(libraryPackagingElement.getLevel());
        }
        return libraryPackagingElement.getLevel().equals("module");
    }

    private void c() {
        for (ArtifactEditorImpl artifactEditorImpl : this.c.getArtifactEditors()) {
            artifactEditorImpl.getSourceItemsTree().rebuildTree();
            artifactEditorImpl.queueValidation();
        }
    }

    protected MasterDetailsState getState() {
        ((ArtifactStructureConfigurableState)this.myState).setDefaultArtifactSettings(this.b.getState());
        return super.getState();
    }

    public void loadState(MasterDetailsState object) {
        super.loadState(object);
        this.b.loadState(((ArtifactStructureConfigurableState)this.myState).getDefaultArtifactSettings());
    }

    @Nls
    public String getDisplayName() {
        long l2 = d ^ 0x4E40CC737931L;
        return ProjectBundle.message((String)"display.name.artifacts", (Object[])new Object[0]);
    }

    @Override
    protected void loadTree() {
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(false);
        for (Artifact artifact : this.c.getArtifactModel().getAllArtifactsIncludingInvalid()) {
            this.a(artifact);
        }
    }

    @Override
    @NotNull
    protected Collection<? extends ProjectStructureElement> getProjectStructureElements() {
        ArrayList<ArtifactProjectStructureElement> arrayList = new ArrayList<ArtifactProjectStructureElement>();
        for (Artifact artifact : this.c.getArtifactModel().getAllArtifactsIncludingInvalid()) {
            arrayList.add(this.c.getOrCreateArtifactElement(artifact));
        }
        ArrayList<ArtifactProjectStructureElement> arrayList2 = arrayList;
        if (arrayList2 == null) {
            ArtifactsStructureConfigurable.b(1);
        }
        return arrayList2;
    }

    private MasterDetailsComponent.MyNode a(Artifact artifact) {
        ArtifactConfigurableBase artifactConfigurableBase = artifact instanceof InvalidArtifact ? new InvalidArtifactConfigurable((InvalidArtifact)artifact, this.c, this.TREE_UPDATER) : new ArtifactConfigurable(artifact, this.c, this.TREE_UPDATER);
        MasterDetailsComponent.MyNode myNode = new MasterDetailsComponent.MyNode((NamedConfigurable)artifactConfigurableBase);
        this.addNode(myNode, this.myRoot);
        return myNode;
    }

    @Override
    public void reset() {
        this.loadComponentState();
        this.c.resetModifiableModel();
        super.reset();
    }

    public boolean isModified() {
        ModifiableArtifactModel modifiableArtifactModel = this.c.getActualModifiableModel();
        if (modifiableArtifactModel != null && modifiableArtifactModel.isModified()) {
            return true;
        }
        return this.c.getManifestFilesInfo().isManifestFilesModified() || super.isModified();
    }

    public ArtifactsStructureConfigurableContext getArtifactsStructureContext() {
        return this.c;
    }

    public ModifiableArtifactModel getModifiableArtifactModel() {
        return this.c.getOrCreateModifiableArtifactModel();
    }

    @Override
    protected BaseStructureConfigurable.AbstractAddGroup createAddAction() {
        long l2 = d ^ 0x38F74A3C3784L;
        return new BaseStructureConfigurable.AbstractAddGroup(ProjectBundle.message((String)"add.new.header.text", (Object[])new Object[0])){
            private static final long a = lb.a(-7873018160227800087L, -2602444027270251244L, MethodHandles.lookup().lookupClass()).a(170821076864423L);

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e10) {
                ArtifactType[] artifactTypeArray = ArtifactType.getAllTypes();
                AnAction[] anActionArray = new AnAction[artifactTypeArray.length];
                for (int i10 = 0; i10 < artifactTypeArray.length; ++i10) {
                    anActionArray[i10] = ArtifactsStructureConfigurable.this.a(artifactTypeArray[i10]);
                }
                if (anActionArray == null) {
                    7.a(0);
                }
                return anActionArray;
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x1A9EA757C9E6L;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$7", "getChildren"));
            }
        };
    }

    private AnAction a(final @NotNull ArtifactType artifactType) {
        if (artifactType == null) {
            ArtifactsStructureConfigurable.b(2);
        }
        List list2 = artifactType.getNewArtifactTemplates((PackagingElementResolvingContext)this.c);
        ArtifactTemplate artifactTemplate = new ArtifactTemplate(){
            private static final long a = lb.a(-4797491403414233950L, -6345181240234212391L, MethodHandles.lookup().lookupClass()).a(168394143115660L);

            public String getPresentableName() {
                long l2 = a ^ 0x139DD922BC3L;
                return "Empty";
            }

            public ArtifactTemplate.NewArtifactConfiguration createArtifact() {
                long l2 = a ^ 0x2C33DAE29488L;
                String string = "unnamed";
                return new ArtifactTemplate.NewArtifactConfiguration(artifactType.createRootElement("unnamed"), "unnamed", artifactType);
            }
        };
        if (list2.isEmpty()) {
            return new AddArtifactAction(artifactType, artifactTemplate, artifactType.getPresentableName(), artifactType.getIcon());
        }
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(artifactType.getPresentableName(), true);
        defaultActionGroup.getTemplatePresentation().setIcon(artifactType.getIcon());
        defaultActionGroup.add((AnAction)new AddArtifactAction(artifactType, artifactTemplate, artifactTemplate.getPresentableName(), null));
        defaultActionGroup.addSeparator();
        for (ArtifactTemplate artifactTemplate2 : list2) {
            defaultActionGroup.add((AnAction)new AddArtifactAction(artifactType, artifactTemplate2, artifactTemplate2.getPresentableName(), null));
        }
        return defaultActionGroup;
    }

    private void a(@NotNull ArtifactType artifactType, @NotNull ArtifactTemplate artifactTemplate) {
        if (artifactType == null) {
            ArtifactsStructureConfigurable.b(3);
        }
        if (artifactTemplate == null) {
            ArtifactsStructureConfigurable.b(4);
        }
        Artifact artifact = ArtifactUtil.addArtifact(this.c.getOrCreateModifiableArtifactModel(), artifactType, artifactTemplate);
        this.selectNodeInTree((DefaultMutableTreeNode)ArtifactsStructureConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)artifact));
    }

    @Override
    @NotNull
    protected List<? extends AnAction> createCopyActions(boolean fromPopup) {
        ArrayList<CopyArtifactAction> arrayList = new ArrayList<CopyArtifactAction>();
        arrayList.add(new CopyArtifactAction(this));
        ArrayList<CopyArtifactAction> arrayList2 = arrayList;
        if (arrayList2 == null) {
            ArtifactsStructureConfigurable.b(5);
        }
        return arrayList2;
    }

    public void apply() throws ConfigurationException {
        long l2 = d ^ 0x22CFEDEBC971L;
        this.c.saveEditorSettings();
        this.checkForEmptyAndDuplicatedNames("Artifact", CommonBundle.getErrorTitle(), ArtifactConfigurableBase.class);
        super.apply();
        this.c.getManifestFilesInfo().saveManifestFiles();
        ModifiableArtifactModel modifiableArtifactModel = this.c.getActualModifiableModel();
        if (modifiableArtifactModel != null) {
            WriteAction.run(() -> modifiableArtifactModel.commit());
        }
        this.c.resetModifiableModel();
        this.reloadTreeNodes();
        this.restoreLastSelection();
    }

    @Override
    public void disposeUIResources() {
        this.c.saveEditorSettings();
        super.disposeUIResources();
        this.c.disposeUIResources();
    }

    protected void updateSelection(@Nullable NamedConfigurable configurable) {
        ArtifactEditorImpl artifactEditorImpl;
        boolean bl2;
        boolean bl3 = bl2 = !Comparing.equal((Object)this.myCurrentConfigurable, (Object)configurable);
        if (bl2 && this.myCurrentConfigurable instanceof ArtifactConfigurable && (artifactEditorImpl = this.c.getArtifactEditor(((ArtifactConfigurable)this.myCurrentConfigurable).getArtifact())) != null) {
            artifactEditorImpl.getLayoutTreeComponent().saveElementProperties();
        }
        super.updateSelection(configurable);
        if (bl2 && configurable instanceof ArtifactConfigurable && (artifactEditorImpl = this.c.getArtifactEditor(((ArtifactConfigurable)configurable).getArtifact())) != null) {
            artifactEditorImpl.getLayoutTreeComponent().resetElementProperties();
        }
    }

    public String getHelpTopic() {
        long l2 = d ^ 0x71275E79320BL;
        String string = super.getHelpTopic();
        return string != null ? string : "reference.settingsdialog.project.structure.artifacts";
    }

    @Override
    protected List<? extends RemoveConfigurableHandler<?>> getRemoveHandlers() {
        return Collections.singletonList(new ArtifactRemoveHandler());
    }

    @NotNull
    public String getId() {
        long l2 = d ^ 0x76CF35A7BD5DL;
        if ("project.artifacts" == null) {
            ArtifactsStructureConfigurable.b(6);
        }
        return "project.artifacts";
    }

    public void dispose() {
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = d ^ 0xBABCB6EE823L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactTemplate";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectStructureElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopyActions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createAddArtifactAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addArtifact";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CopyArtifactAction
    extends AnAction {
        final /* synthetic */ ArtifactsStructureConfigurable this$0;
        private static final long a = lb.a(8156762609151262557L, -5681144534841222459L, MethodHandles.lookup().lookupClass()).a(52309583482211L);

        private CopyArtifactAction(ArtifactsStructureConfigurable artifactsStructureConfigurable) {
            long l2 = a ^ 0x2AC2D6A64F02L;
            this.this$0 = artifactsStructureConfigurable;
            super(CommonBundle.message((String)"button.copy", (Object[])new Object[0]), CommonBundle.message((String)"button.copy", (Object[])new Object[0]), COPY_ICON);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            Object object;
            long l2 = a ^ 0x8436BCC50D1L;
            if (e10 == null) {
                CopyArtifactAction.a(0);
            }
            if ((object = this.this$0.getSelectedObject()) instanceof Artifact) {
                Artifact artifact = (Artifact)object;
                ModifiableArtifactModel modifiableArtifactModel = this.this$0.c.getOrCreateModifiableArtifactModel();
                String string = ArtifactUtil.generateUniqueArtifactName(artifact.getName(), modifiableArtifactModel);
                String string2 = Messages.showInputDialog((String)"Enter artifact name:", (String)"Copy Artifact", (Icon)COPY_ICON, (String)string, (InputValidator)new NonEmptyInputValidator());
                if (string2 == null) {
                    return;
                }
                CompositePackagingElement<?> compositePackagingElement = ArtifactUtil.copyFromRoot(artifact.getRootElement(), this.this$0.myProject);
                modifiableArtifactModel.addArtifact(string2, artifact.getArtifactType(), compositePackagingElement);
            }
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                CopyArtifactAction.a(1);
            }
            if (this.this$0.myTree.getSelectionPaths() == null || this.this$0.myTree.getSelectionPaths().length != 1) {
                e10.getPresentation().setEnabled(false);
            } else {
                e10.getPresentation().setEnabled(this.this$0.getSelectedObject() instanceof Artifact);
            }
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x37EE798D6285L;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$CopyArtifactAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class AddArtifactAction
    extends DumbAwareAction {
        private final ArtifactType a;
        private final ArtifactTemplate b;
        private static final long c = lb.a(-8078033787576081199L, 4752283792678655877L, MethodHandles.lookup().lookupClass()).a(19818795617991L);

        AddArtifactAction(@NotNull ArtifactType type, @NotNull ArtifactTemplate artifactTemplate, String actionText, Icon icon) {
            if (type == null) {
                AddArtifactAction.a(0);
            }
            if (artifactTemplate == null) {
                AddArtifactAction.a(1);
            }
            if (actionText == null) {
                AddArtifactAction.a(2);
            }
            super(actionText, null, icon);
            this.a = type;
            this.b = artifactTemplate;
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                AddArtifactAction.a(3);
            }
            ArtifactsStructureConfigurable.this.a(this.a, this.b);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = c ^ 0x5E34C75687E6L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifactTemplate";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionText";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$AddArtifactAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ArtifactRemoveHandler
    extends RemoveConfigurableHandler<Artifact> {
        private static final long b = lb.a(-1499194969126265392L, -3697345683568088254L, MethodHandles.lookup().lookupClass()).a(226577470974053L);

        ArtifactRemoveHandler() {
            super(ArtifactConfigurableBase.class);
        }

        @Override
        public boolean remove(@NotNull Collection<? extends Artifact> artifacts) {
            if (artifacts == null) {
                ArtifactRemoveHandler.b(0);
            }
            for (Artifact artifact : artifacts) {
                ArtifactsStructureConfigurable.this.c.getOrCreateModifiableArtifactModel().removeArtifact(artifact);
                ArtifactsStructureConfigurable.this.myContext.getDaemonAnalyzer().removeElement(ArtifactsStructureConfigurable.this.c.getOrCreateArtifactElement(artifact));
            }
            return true;
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = b ^ 0x2C656EC5BB6L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$ArtifactRemoveHandler", "remove"));
        }
    }
}

