/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import b.a.lb;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.JdkListConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkComboBox
extends ComboBoxWithWidePopup<JdkComboBoxItem> {
    private static final Icon b;
    @Nullable
    private final Condition<? super Sdk> d;
    @Nullable
    private final Condition<SdkTypeId> e;
    private JButton a;
    private final Condition<? super SdkTypeId> c;
    private static final long f;

    public JdkComboBox(@NotNull ProjectSdksModel jdkModel) {
        if (jdkModel == null) {
            JdkComboBox.a(0);
        }
        this(jdkModel, null);
    }

    public JdkComboBox(@NotNull ProjectSdksModel jdkModel, @Nullable Condition<? super SdkTypeId> filter) {
        if (jdkModel == null) {
            JdkComboBox.a(1);
        }
        this(jdkModel, filter, JdkComboBox.getSdkFilter(filter), filter, false);
    }

    public JdkComboBox(final @NotNull ProjectSdksModel jdkModel, @Nullable Condition<? super SdkTypeId> sdkTypeFilter, @Nullable Condition<? super Sdk> filter, @Nullable Condition<? super SdkTypeId> creationFilter, boolean addSuggestedItems) {
        if (jdkModel == null) {
            JdkComboBox.a(2);
        }
        super((ComboBoxModel)new JdkComboBoxModel(jdkModel, sdkTypeFilter, filter, addSuggestedItems));
        this.d = filter;
        this.c = sdkTypeFilter;
        this.e = JdkComboBox.a(creationFilter);
        this.setRenderer((ListCellRenderer)new ColoredListCellRenderer<JdkComboBoxItem>(){
            private static final long a = lb.a(1176154315532563490L, -7483208101174571603L, MethodHandles.lookup().lookupClass()).a(237068407360755L);

            protected void customizeCellRenderer(@NotNull JList<? extends JdkComboBoxItem> list2, JdkComboBoxItem value, int index, boolean selected, boolean hasFocus) {
                long l2 = a ^ 0x56DDBD8A0C71L;
                if (list2 == null) {
                    1.a(0);
                }
                if (JdkComboBox.this.isEnabled()) {
                    this.setIcon(b);
                    if (value instanceof InvalidJdkComboBoxItem) {
                        String string = value.toString();
                        this.append(string, SimpleTextAttributes.ERROR_ATTRIBUTES);
                    } else if (value instanceof ProjectJdkComboBoxItem) {
                        Sdk sdk = jdkModel.getProjectSdk();
                        if (sdk != null) {
                            this.setIcon(((SdkType)sdk.getSdkType()).getIcon());
                            this.append(ProjectBundle.message((String)"project.roots.project.jdk.inherited", (Object[])new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                            this.append(" (" + sdk.getName() + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        } else {
                            String string = value.toString();
                            this.append(string, SimpleTextAttributes.ERROR_ATTRIBUTES);
                        }
                    } else if (value instanceof SuggestedJdkItem) {
                        SdkType sdkType = ((SuggestedJdkItem)value).getSdkType();
                        String string = ((SuggestedJdkItem)value).getPath();
                        this.setIcon(sdkType.getIconForAddAction());
                        String string2 = sdkType.getVersionString(string);
                        this.append(string2 == null ? sdkType.getPresentableName() : string2);
                        this.append(" (" + string + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    } else if (value != null) {
                        OrderEntryAppearanceService.getInstance().forJdk(value.getJdk(), false, selected, true).customize((SimpleColoredComponent)this);
                    } else {
                        this.customizeCellRenderer(list2, new NoneJdkComboBoxItem(), index, selected, hasFocus);
                    }
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x4F2009BD77B0L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/roots/ui/configuration/JdkComboBox$1", "customizeCellRenderer"));
            }
        });
    }

    @NotNull
    private static Condition<SdkTypeId> a(@Nullable Condition<? super SdkTypeId> condition) {
        Condition condition2 = SimpleJavaSdkType.notSimpleJavaSdkType(condition);
        if (condition2 == null) {
            JdkComboBox.a(3);
        }
        return condition2;
    }

    public Dimension getPreferredSize() {
        Rectangle rectangle = ScreenUtil.getScreenRectangle((int)0, (int)0);
        Dimension dimension = super.getPreferredSize();
        int n2 = rectangle.width / 4;
        if (dimension.width > n2) {
            dimension.width = n2;
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        Dimension dimension2 = this.getPreferredSize();
        if (dimension.width > dimension2.width) {
            dimension.width = dimension2.width;
        }
        return dimension;
    }

    public void setSetupButton(JButton setUpButton, @Nullable Project project2, ProjectSdksModel jdksModel, JdkComboBoxItem firstItem, @Nullable Condition<Sdk> additionalSetup, boolean moduleJdkSetup) {
        long l2 = f ^ 0x371D1E26875DL;
        this.setSetupButton(setUpButton, project2, jdksModel, firstItem, additionalSetup, ProjectBundle.message((String)"project.roots.set.up.jdk.title", (Object[])new Object[]{moduleJdkSetup ? 1 : 2}));
    }

    public void setSetupButton(JButton setUpButton, @Nullable Project project2, ProjectSdksModel jdksModel, JdkComboBoxItem firstItem, @Nullable Condition<? super Sdk> additionalSetup, String actionGroupTitle) {
        this.a = setUpButton;
        this.a.addActionListener(actionEvent -> {
            long l2 = f ^ 0x3F57DF6420C8L;
            DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
            jdksModel.createAddActions(defaultActionGroup, (JComponent)((Object)this), this.getSelectedJdk(), sdk -> {
                if (project2 != null) {
                    JdkListConfigurable jdkListConfigurable = JdkListConfigurable.getInstance(project2);
                    jdkListConfigurable.addJdkNode((Sdk)sdk, false);
                }
                this.reloadModel(new ActualJdkComboBoxItem((Sdk)sdk), project2);
                this.setSelectedJdk((Sdk)sdk);
                if (additionalSetup != null && additionalSetup.value(sdk)) {
                    this.setSelectedJdk(firstItem.getJdk());
                }
            }, this.e);
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this));
            if (defaultActionGroup.getChildrenCount() > 1) {
                JBPopupFactory.getInstance().createActionGroupPopup(actionGroupTitle, (ActionGroup)defaultActionGroup, dataContext, JBPopupFactory.ActionSelectionAid.MNEMONICS, false).showUnderneathOf((Component)setUpButton);
            } else {
                AnActionEvent anActionEvent = new AnActionEvent(null, dataContext, "unknown", new Presentation(""), ActionManager.getInstance(), 0);
                defaultActionGroup.getChildren(anActionEvent)[0].actionPerformed(anActionEvent);
            }
        });
    }

    public void setEditButton(JButton editButton, Project project2, Computable<? extends Sdk> retrieveJDK) {
        editButton.addActionListener(actionEvent -> {
            Sdk sdk = (Sdk)retrieveJDK.compute();
            if (sdk != null) {
                ProjectStructureConfigurable.getInstance(project2).select(sdk, true);
            }
        });
        this.addActionListener(actionEvent -> {
            JdkComboBoxItem jdkComboBoxItem = this.getSelectedItem();
            if (jdkComboBoxItem instanceof ProjectJdkComboBoxItem) {
                editButton.setEnabled(ProjectStructureConfigurable.getInstance(project2).getProjectJdksModel().getProjectSdk() != null);
            } else {
                editButton.setEnabled(!(jdkComboBoxItem instanceof InvalidJdkComboBoxItem) && jdkComboBoxItem != null && jdkComboBoxItem.getJdk() != null);
            }
        });
    }

    public JButton getSetUpButton() {
        return this.a;
    }

    public JdkComboBoxItem getSelectedItem() {
        return (JdkComboBoxItem)super.getSelectedItem();
    }

    @Nullable
    public Sdk getSelectedJdk() {
        JdkComboBoxItem jdkComboBoxItem = this.getSelectedItem();
        return jdkComboBoxItem != null ? jdkComboBoxItem.getJdk() : null;
    }

    public void setSelectedJdk(Sdk jdk) {
        int n2 = this.a(jdk);
        if (n2 >= 0) {
            this.setSelectedIndex(n2);
        }
    }

    public void setInvalidJdk(String name2) {
        this.a();
        this.addItem(new InvalidJdkComboBoxItem(name2));
        this.setSelectedIndex(this.getModel().getSize() - 1);
    }

    private int a(Sdk sdk) {
        JdkComboBoxModel jdkComboBoxModel = (JdkComboBoxModel)this.getModel();
        int n2 = jdkComboBoxModel.getSize();
        for (int i10 = 0; i10 < n2; ++i10) {
            Sdk sdk2;
            JdkComboBoxItem jdkComboBoxItem = (JdkComboBoxItem)jdkComboBoxModel.getElementAt(i10);
            if (!(sdk == null ? jdkComboBoxItem instanceof NoneJdkComboBoxItem || jdkComboBoxItem instanceof ProjectJdkComboBoxItem : (sdk2 = jdkComboBoxItem.getJdk()) != null && sdk.getName().equals(sdk2.getName()))) continue;
            return i10;
        }
        return -1;
    }

    private void a() {
        JdkComboBoxModel jdkComboBoxModel = (JdkComboBoxModel)this.getModel();
        int n2 = jdkComboBoxModel.getSize();
        for (int i10 = 0; i10 < n2; ++i10) {
            JdkComboBoxItem jdkComboBoxItem = (JdkComboBoxItem)jdkComboBoxModel.getElementAt(i10);
            if (!(jdkComboBoxItem instanceof InvalidJdkComboBoxItem)) continue;
            this.removeItemAt(i10);
            break;
        }
    }

    public void reloadModel(JdkComboBoxItem firstItem, @Nullable Project project2) {
        JdkComboBoxModel jdkComboBoxModel = (JdkComboBoxModel)this.getModel();
        if (project2 == null) {
            jdkComboBoxModel.addElement(firstItem);
            return;
        }
        jdkComboBoxModel.reload(firstItem, ProjectStructureConfigurable.getInstance(project2).getProjectJdksModel(), this.c, this.d, false);
    }

    public static Condition<Sdk> getSdkFilter(@Nullable Condition<? super SdkTypeId> filter) {
        return filter == null ? Conditions.alwaysTrue() : sdk -> filter.value((Object)sdk.getSdkType());
    }

    static {
        f = lb.a(1622372449839299338L, -4832060749702482673L, MethodHandles.lookup().lookupClass()).a(92383056144705L);
        b = JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)1, (int)16));
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = f ^ 0x6C929EB00E10L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/JdkComboBox";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/JdkComboBox";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreationFilter";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SuggestedJdkItem
    extends JdkComboBoxItem {
        private final SdkType a;
        private final String b;
        private static final long c = lb.a(7986155943933689544L, -4293507141022859930L, MethodHandles.lookup().lookupClass()).a(235975745204944L);

        SuggestedJdkItem(@NotNull SdkType sdkType, @NotNull String path) {
            if (sdkType == null) {
                SuggestedJdkItem.a(0);
            }
            if (path == null) {
                SuggestedJdkItem.a(1);
            }
            this.a = sdkType;
            this.b = path;
        }

        @NotNull
        public SdkType getSdkType() {
            SdkType sdkType = this.a;
            if (sdkType == null) {
                SuggestedJdkItem.a(2);
            }
            return sdkType;
        }

        @NotNull
        public String getPath() {
            String string = this.b;
            if (string == null) {
                SuggestedJdkItem.a(3);
            }
            return string;
        }

        public String toString() {
            return this.b;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = c ^ 0x4FEA3B95B8F5L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdkType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/JdkComboBox$SuggestedJdkItem";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/JdkComboBox$SuggestedJdkItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSdkType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class InvalidJdkComboBoxItem
    extends JdkComboBoxItem {
        private final String a;
        private static final long b = lb.a(-4974941756059997285L, -5515851313297507934L, MethodHandles.lookup().lookupClass()).a(14127887948717L);

        InvalidJdkComboBoxItem(String name2) {
            this.a = name2;
        }

        @Override
        public String getSdkName() {
            return this.a;
        }

        public String toString() {
            long l2 = b ^ 0x5951D812E931L;
            return ProjectBundle.message((String)"jdk.combo.box.invalid.item", (Object[])new Object[]{this.a});
        }
    }

    public static class NoneJdkComboBoxItem
    extends JdkComboBoxItem {
        private static final long a = lb.a(-6037958953647504054L, -3608390458007445724L, MethodHandles.lookup().lookupClass()).a(169613070196715L);

        public String toString() {
            long l2 = a ^ 0x6B707D647767L;
            return ProjectBundle.message((String)"jdk.combo.box.none.item", (Object[])new Object[0]);
        }
    }

    public static class ProjectJdkComboBoxItem
    extends JdkComboBoxItem {
        private static final long a = lb.a(8232658758234847376L, 4252489878186602872L, MethodHandles.lookup().lookupClass()).a(207201266419391L);

        public String toString() {
            long l2 = a ^ 0x5D064F8B7CAAL;
            return ProjectBundle.message((String)"jdk.combo.box.project.item", (Object[])new Object[0]);
        }
    }

    public static class ActualJdkComboBoxItem
    extends JdkComboBoxItem {
        private final Sdk a;
        private static final long b = lb.a(4675794308893316825L, -1339463489922267096L, MethodHandles.lookup().lookupClass()).a(272282351787194L);

        public ActualJdkComboBoxItem(@NotNull Sdk jdk) {
            if (jdk == null) {
                ActualJdkComboBoxItem.a(0);
            }
            this.a = jdk;
        }

        public String toString() {
            return this.a.getName();
        }

        @Override
        @Nullable
        public Sdk getJdk() {
            return this.a;
        }

        @Override
        @Nullable
        public String getSdkName() {
            return this.a.getName();
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x74F89DC2F3EDL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/intellij/openapi/roots/ui/configuration/JdkComboBox$ActualJdkComboBoxItem", "<init>"));
        }
    }

    public static abstract class JdkComboBoxItem {
        @Nullable
        public Sdk getJdk() {
            return null;
        }

        @Nullable
        public String getSdkName() {
            return null;
        }
    }

    private static class JdkComboBoxModel
    extends DefaultComboBoxModel<JdkComboBoxItem> {
        private static final long a = lb.a(-901079562169707281L, 6184734506762779677L, MethodHandles.lookup().lookupClass()).a(214771760778971L);

        JdkComboBoxModel(@NotNull ProjectSdksModel jdksModel, @Nullable Condition<? super SdkTypeId> sdkTypeFilter, @Nullable Condition<? super Sdk> sdkFilter, boolean addSuggested) {
            if (jdksModel == null) {
                JdkComboBoxModel.a(0);
            }
            this.reload(null, jdksModel, sdkTypeFilter, sdkFilter, addSuggested);
        }

        void reload(@Nullable JdkComboBoxItem firstItem, @NotNull ProjectSdksModel jdksModel, @Nullable Condition<? super SdkTypeId> sdkTypeFilter, @Nullable Condition<? super Sdk> sdkFilter, boolean addSuggested) {
            Sdk[] sdkArray;
            if (jdksModel == null) {
                JdkComboBoxModel.a(1);
            }
            this.removeAllElements();
            if (firstItem != null) {
                this.addElement(firstItem);
            }
            for (Sdk sdk : sdkArray = JdkComboBoxModel.a(jdksModel.getSdks())) {
                if (sdkFilter != null && !sdkFilter.value((Object)sdk)) continue;
                this.addElement(new ActualJdkComboBoxItem(sdk));
            }
            if (addSuggested) {
                this.addSuggestedItems(sdkTypeFilter, sdkArray);
            }
        }

        @NotNull
        private static Sdk[] a(@NotNull Sdk[] sdkArray) {
            if (sdkArray == null) {
                JdkComboBoxModel.a(2);
            }
            Sdk[] sdkArray2 = (Sdk[])sdkArray.clone();
            Arrays.sort(sdkArray2, (sdk, sdk2) -> {
                SdkType sdkType = (SdkType)sdk.getSdkType();
                SdkType sdkType2 = (SdkType)sdk2.getSdkType();
                if (!sdkType.getComparator().equals(sdkType2.getComparator())) {
                    return StringUtil.compare((String)sdkType.getPresentableName(), (String)sdkType2.getPresentableName(), (boolean)true);
                }
                return sdkType.getComparator().compare(sdk, sdk2);
            });
            if (sdkArray2 == null) {
                JdkComboBoxModel.a(3);
            }
            return sdkArray2;
        }

        void addSuggestedItems(@Nullable Condition<? super SdkTypeId> sdkTypeFilter, Sdk[] jdks) {
            SdkType[] sdkTypeArray;
            for (SdkType sdkType : sdkTypeArray = SdkType.getAllTypes()) {
                if (sdkTypeFilter != null && (!sdkTypeFilter.value((Object)sdkType) || ContainerUtil.find((Object[])jdks, sdk -> sdk.getSdkType() == sdkType) != null)) continue;
                Collection collection = sdkType.suggestHomePaths();
                for (String string : collection) {
                    if (string == null || !sdkType.isValidSdkHome(string)) continue;
                    this.addElement(new SuggestedJdkItem(sdkType, string));
                }
            }
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = a ^ 0x1BBB9C8C3418L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 3: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jdksModel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdks";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/JdkComboBox$JdkComboBoxModel";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/JdkComboBox$JdkComboBoxModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sortSdks";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "reload";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "sortSdks";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

