/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import b.a.lb;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.roots.impl.storage.ClasspathStorageProvider;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleJdkConfigurable;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanelImpl;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ClasspathEditor
extends ModuleElementsEditor
implements ModuleRootListener {
    public static final String NAME;
    private ClasspathPanelImpl b;
    private ClasspathFormatPanel a;
    private static final long c;

    public ClasspathEditor(ModuleConfigurationState state) {
        super(state);
        Disposable disposable = Disposer.newDisposable();
        state.getProject().getMessageBus().connect(disposable).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)this);
        this.registerDisposable(disposable);
    }

    public boolean isModified() {
        return super.isModified() || this.a != null && this.a.b();
    }

    public String getHelpTopic() {
        long l2 = c ^ 0x2F011F83A8FEL;
        return "projectStructure.modules.dependencies";
    }

    public String getDisplayName() {
        return NAME;
    }

    public void saveData() {
        this.b.stopEditing();
    }

    public void apply() throws ConfigurationException {
        if (this.a != null) {
            this.a.c();
        }
    }

    public void canApply() throws ConfigurationException {
        super.canApply();
        if (this.a != null) {
            this.a.canApply();
        }
    }

    public JComponent createComponentImpl() {
        long l2 = c ^ 0x79B0EF7DC92DL;
        this.b = new ClasspathPanelImpl(this.getState());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        jPanel.add((Component)this.b, "Center");
        ModuleJdkConfigurable moduleJdkConfigurable = new ModuleJdkConfigurable(this, ProjectStructureConfigurable.getInstance(this.myProject).getProjectJdksModel()){

            @Override
            protected ModifiableRootModel getRootModel() {
                return ClasspathEditor.this.getState().getRootModel();
            }
        };
        jPanel.add((Component)moduleJdkConfigurable.createComponent(), "North");
        moduleJdkConfigurable.reset();
        this.registerDisposable(moduleJdkConfigurable);
        ClasspathStorageProvider[] classpathStorageProviderArray = (ClasspathStorageProvider[])ClasspathStorageProvider.EXTENSION_POINT_NAME.getExtensions();
        if (classpathStorageProviderArray.length > 0) {
            this.a = new ClasspathFormatPanel(classpathStorageProviderArray, this.getModel());
            jPanel.add((Component)this.a, "South");
        }
        return jPanel;
    }

    public void selectOrderEntry(@NotNull OrderEntry entry) {
        if (entry == null) {
            ClasspathEditor.a(0);
        }
        this.b.selectOrderEntry(entry);
    }

    public void moduleStateChanged() {
        if (this.b != null) {
            this.b.initFromModel();
        }
    }

    public void rootsChanged(@NotNull ModuleRootEvent event) {
        if (event == null) {
            ClasspathEditor.a(1);
        }
        if (this.b != null) {
            this.b.rootsChanged();
        }
    }

    public void setSdk(Sdk newJDK) {
        ModifiableRootModel modifiableRootModel = this.getModel();
        if (newJDK != null) {
            modifiableRootModel.setSdk(newJDK);
        } else {
            modifiableRootModel.inheritSdk();
        }
        if (this.b != null) {
            this.b.forceInitFromModel();
        }
    }

    static {
        c = lb.a(7908470256390013648L, 2245542989797071374L, MethodHandles.lookup().lookupClass()).a(44141744482425L);
        long l2 = c ^ 0x2BAFD8D9BBBFL;
        NAME = ProjectBundle.message((String)"modules.classpath.title", (Object[])new Object[0]);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = c ^ 0x3C245ADAE13AL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ClasspathEditor";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "selectOrderEntry";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "rootsChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ClasspathFormatPanel
    extends JPanel {
        private final ModifiableRootModel a;
        private final JComboBox<String> b;
        private static final long c = lb.a(-8760994882708893316L, 1038315817473638832L, MethodHandles.lookup().lookupClass()).a(35246041194345L);

        private ClasspathFormatPanel(ClasspathStorageProvider[] providers, ModifiableRootModel model) {
            long l2 = c ^ 0x6ABC449DCAADL;
            super(new GridBagLayout());
            this.a = model;
            this.add((Component)new JLabel(ProjectBundle.message((String)"project.roots.classpath.format.label", (Object[])new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insets((int)10, (int)6, (int)6, (int)0), 0, 0));
            final LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put("default", ProjectBundle.message((String)"project.roots.classpath.format.default.descr", (Object[])new Object[0]));
            for (ClasspathStorageProvider classpathStorageProvider : providers) {
                linkedHashMap.put(classpathStorageProvider.getID(), classpathStorageProvider.getDescription());
            }
            this.b = new ComboBox((Object[])ArrayUtil.toStringArray(linkedHashMap.keySet()));
            this.b.setRenderer((ListCellRenderer<String>)new ListCellRendererWrapper<String>(){

                public void customize(JList list2, String value, int index, boolean selected, boolean hasFocus) {
                    this.setText((String)linkedHashMap.get(value));
                }
            });
            this.b.setSelectedItem(this.d());
            this.add(this.b, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)6, (int)6, (int)6, (int)0), 0, 0));
        }

        private String a() {
            return (String)this.b.getSelectedItem();
        }

        private String d() {
            return ClassPathStorageUtil.getStorageType((Module)this.a.getModule());
        }

        private boolean b() {
            return !this.a().equals(this.d());
        }

        public void canApply() throws ConfigurationException {
            ClasspathStorageProvider classpathStorageProvider = ClasspathStorage.getProvider((String)this.a());
            if (classpathStorageProvider != null) {
                classpathStorageProvider.assertCompatible((ModuleRootModel)this.a);
            }
        }

        private void c() throws ConfigurationException {
            this.canApply();
            ClasspathStorage.setStorageType((ModuleRootModel)this.a, (String)this.a());
        }
    }
}

