/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import b.a.lb;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractDependencyDataService;
import com.intellij.openapi.externalSystem.service.project.manage.LibraryDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483618)
public class LibraryDependencyDataService
extends AbstractDependencyDataService<LibraryDependencyData, LibraryOrderEntry> {
    private static final Logger c;
    @NotNull
    private final LibraryDataService b;
    private static final long e;

    public LibraryDependencyDataService(@NotNull LibraryDataService libraryManager) {
        if (libraryManager == null) {
            LibraryDependencyDataService.b(0);
        }
        this.b = libraryManager;
    }

    @NotNull
    public Key<LibraryDependencyData> getTargetDataKey() {
        Key key = ProjectKeys.LIBRARY_DEPENDENCY;
        if (key == null) {
            LibraryDependencyDataService.b(1);
        }
        return key;
    }

    @Override
    @NotNull
    public Class<LibraryOrderEntry> getOrderEntryType() {
        if (LibraryOrderEntry.class == null) {
            LibraryDependencyDataService.b(2);
        }
        return LibraryOrderEntry.class;
    }

    @Override
    protected Map<OrderEntry, OrderAware> importData(@NotNull Collection<DataNode<LibraryDependencyData>> nodesToImport, @NotNull Module module2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        LibraryDependencyData libraryDependencyData;
        if (nodesToImport == null) {
            LibraryDependencyDataService.b(3);
        }
        if (module2 == null) {
            LibraryDependencyDataService.b(4);
        }
        if (modelsProvider == null) {
            LibraryDependencyDataService.b(5);
        }
        HashMap hashMap = ContainerUtilRt.newHashMap();
        HashMap hashMap2 = ContainerUtilRt.newHashMap();
        LinkedHashSet linkedHashSet = ContainerUtilRt.newLinkedHashSet();
        LinkedHashMap linkedHashMap = ContainerUtil.newLinkedHashMap();
        boolean bl2 = false;
        for (DataNode<LibraryDependencyData> modifiableRootModel2 : nodesToImport) {
            libraryDependencyData = (LibraryDependencyData)modifiableRootModel2.getData();
            LibraryData libraryData = (LibraryData)libraryDependencyData.getTarget();
            bl2 |= libraryData.isUnresolved();
            switch (libraryDependencyData.getLevel()) {
                case MODULE: {
                    HashSet hashSet = ContainerUtilRt.newHashSet();
                    for (String string : libraryData.getPaths(LibraryPathType.BINARY)) {
                        hashSet.add(ExternalSystemApiUtil.toCanonicalPath((String)string) + libraryDependencyData.getScope().name());
                    }
                    hashMap.put(hashSet, libraryDependencyData);
                    linkedHashSet.add(libraryDependencyData);
                    break;
                }
                case PROJECT: {
                    hashMap2.put(libraryData.getInternalName() + libraryDependencyData.getScope().name(), libraryDependencyData);
                    linkedHashSet.add(libraryDependencyData);
                }
            }
        }
        boolean bl3 = bl2;
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module2);
        libraryDependencyData = modifiableRootModel.getModuleLibraryTable();
        this.a(modelsProvider, hashMap, hashMap2, linkedHashSet, linkedHashMap, modifiableRootModel, bl3);
        if (!linkedHashSet.isEmpty()) {
            this.a(modelsProvider, linkedHashSet, linkedHashMap, modifiableRootModel, (LibraryTable)libraryDependencyData, module2);
        }
        return linkedHashMap;
    }

    private void a(@NotNull IdeModifiableModelsProvider ideModifiableModelsProvider, @NotNull Set<LibraryDependencyData> set, @NotNull Map<OrderEntry, OrderAware> map2, @NotNull ModifiableRootModel modifiableRootModel, @NotNull LibraryTable libraryTable, @NotNull Module module2) {
        if (ideModifiableModelsProvider == null) {
            LibraryDependencyDataService.b(6);
        }
        if (set == null) {
            LibraryDependencyDataService.b(7);
        }
        if (map2 == null) {
            LibraryDependencyDataService.b(8);
        }
        if (modifiableRootModel == null) {
            LibraryDependencyDataService.b(9);
        }
        if (libraryTable == null) {
            LibraryDependencyDataService.b(10);
        }
        if (module2 == null) {
            LibraryDependencyDataService.b(11);
        }
        for (LibraryDependencyData libraryDependencyData : set) {
            LibraryData libraryData = (LibraryData)libraryDependencyData.getTarget();
            String string = libraryData.getInternalName();
            switch (libraryDependencyData.getLevel()) {
                case MODULE: {
                    Library library = string.isEmpty() ? libraryTable.createLibrary() : libraryTable.createLibrary(string);
                    LibraryOrderEntry libraryOrderEntry = this.a(ideModifiableModelsProvider, libraryDependencyData, library, modifiableRootModel, module2);
                    map2.put((OrderEntry)libraryOrderEntry, (OrderAware)libraryDependencyData);
                    break;
                }
                case PROJECT: {
                    LibraryOrderEntry libraryOrderEntry;
                    Library library = ideModifiableModelsProvider.getLibraryByName(string);
                    if (library == null) {
                        libraryOrderEntry = this.a(ideModifiableModelsProvider, libraryDependencyData, libraryTable.createLibrary(string), modifiableRootModel, module2);
                        map2.put((OrderEntry)libraryOrderEntry, (OrderAware)libraryDependencyData);
                        break;
                    }
                    libraryOrderEntry = modifiableRootModel.addLibraryEntry(library);
                    LibraryDependencyDataService.a(libraryOrderEntry, library, module2, libraryDependencyData);
                    ModuleOrderEntry moduleOrderEntry = ideModifiableModelsProvider.trySubstitute(module2, libraryOrderEntry, (ProjectCoordinate)libraryData);
                    if (moduleOrderEntry != null) {
                        map2.put((OrderEntry)moduleOrderEntry, (OrderAware)libraryDependencyData);
                        break;
                    }
                    map2.put((OrderEntry)libraryOrderEntry, (OrderAware)libraryDependencyData);
                }
            }
        }
    }

    private static void a(@NotNull LibraryOrderEntry libraryOrderEntry, @NotNull Library library, @NotNull Module module2, @NotNull LibraryDependencyData libraryDependencyData) {
        long l2 = e ^ 0x4DDE9CDDAF8EL;
        if (libraryOrderEntry == null) {
            LibraryDependencyDataService.b(12);
        }
        if (library == null) {
            LibraryDependencyDataService.b(13);
        }
        if (module2 == null) {
            LibraryDependencyDataService.b(14);
        }
        if (libraryDependencyData == null) {
            LibraryDependencyDataService.b(15);
        }
        libraryOrderEntry.setExported(libraryDependencyData.isExported());
        libraryOrderEntry.setScope(libraryDependencyData.getScope());
        if (c.isDebugEnabled()) {
            c.debug(String.format("Configuring library '%s' of module '%s' to be%s exported and have scope %s", library, module2.getName(), libraryDependencyData.isExported() ? " not" : "", libraryDependencyData.getScope()));
        }
    }

    private void a(@NotNull IdeModifiableModelsProvider ideModifiableModelsProvider, @NotNull Map<Set<String>, LibraryDependencyData> map2, @NotNull Map<String, LibraryDependencyData> map3, @NotNull Set<LibraryDependencyData> set, @NotNull Map<OrderEntry, OrderAware> map4, @NotNull ModifiableRootModel modifiableRootModel, boolean bl2) {
        long l2 = e ^ 0x5C0EC25E7956L;
        if (ideModifiableModelsProvider == null) {
            LibraryDependencyDataService.b(16);
        }
        if (map2 == null) {
            LibraryDependencyDataService.b(17);
        }
        if (map3 == null) {
            LibraryDependencyDataService.b(18);
        }
        if (set == null) {
            LibraryDependencyDataService.b(19);
        }
        if (map4 == null) {
            LibraryDependencyDataService.b(20);
        }
        if (modifiableRootModel == null) {
            LibraryDependencyDataService.b(21);
        }
        for (OrderEntry orderEntry : modifiableRootModel.getOrderEntries()) {
            Object object;
            LibraryDependencyData libraryDependencyData;
            Object object2;
            ModuleLibraryOrderEntryImpl moduleLibraryOrderEntryImpl;
            if (orderEntry instanceof ModuleLibraryOrderEntryImpl) {
                moduleLibraryOrderEntryImpl = (ModuleLibraryOrderEntryImpl)orderEntry;
                object2 = moduleLibraryOrderEntryImpl.getLibrary();
                if (object2 == null) {
                    c.warn("Skipping module-level library entry because it doesn't have backing Library object. Entry: " + orderEntry);
                    continue;
                }
                libraryDependencyData = object2.getFiles(OrderRootType.CLASSES);
                object = ContainerUtilRt.newHashSet((int)((VirtualFile[])libraryDependencyData).length);
                for (LibraryDependencyData libraryDependencyData2 : libraryDependencyData) {
                    object.add(ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)libraryDependencyData2) + moduleLibraryOrderEntryImpl.getScope().name());
                }
                LibraryDependencyData libraryDependencyData3 = map2.remove(object);
                if (libraryDependencyData3 == null || !StringUtil.equals((CharSequence)StringUtil.nullize((String)libraryDependencyData3.getInternalName()), (CharSequence)object2.getName())) {
                    modifiableRootModel.removeOrderEntry(orderEntry);
                    continue;
                }
                map4.put(orderEntry, (OrderAware)libraryDependencyData3);
                this.a(ideModifiableModelsProvider, libraryDependencyData3, (Library)object2, modifiableRootModel, moduleLibraryOrderEntryImpl.getOwnerModule());
                set.remove(libraryDependencyData3);
                continue;
            }
            if (!(orderEntry instanceof LibraryOrderEntry)) continue;
            moduleLibraryOrderEntryImpl = (LibraryOrderEntry)orderEntry;
            object2 = moduleLibraryOrderEntryImpl.getLibraryName();
            libraryDependencyData = map3.remove((String)object2 + moduleLibraryOrderEntryImpl.getScope().name());
            if (libraryDependencyData != null) {
                object = ideModifiableModelsProvider.findModuleByPublication((ProjectCoordinate)libraryDependencyData.getTarget());
                if (object == null) {
                    set.remove(libraryDependencyData);
                    map4.put(orderEntry, (OrderAware)libraryDependencyData);
                    moduleLibraryOrderEntryImpl.setExported(libraryDependencyData.isExported());
                    moduleLibraryOrderEntryImpl.setScope(libraryDependencyData.getScope());
                    continue;
                }
                modifiableRootModel.removeOrderEntry(orderEntry);
                continue;
            }
            if (bl2) continue;
            modifiableRootModel.removeOrderEntry(orderEntry);
        }
    }

    private LibraryOrderEntry a(@NotNull IdeModifiableModelsProvider ideModifiableModelsProvider, @NotNull LibraryDependencyData libraryDependencyData, @NotNull Library library, @NotNull ModifiableRootModel modifiableRootModel, @NotNull Module module2) {
        if (ideModifiableModelsProvider == null) {
            LibraryDependencyDataService.b(22);
        }
        if (libraryDependencyData == null) {
            LibraryDependencyDataService.b(23);
        }
        if (library == null) {
            LibraryDependencyDataService.b(24);
        }
        if (modifiableRootModel == null) {
            LibraryDependencyDataService.b(25);
        }
        if (module2 == null) {
            LibraryDependencyDataService.b(26);
        }
        Library.ModifiableModel modifiableModel = ideModifiableModelsProvider.getModifiableLibraryModel(library);
        String string = libraryDependencyData.getInternalName();
        LibraryData libraryData = (LibraryData)libraryDependencyData.getTarget();
        Map<OrderRootType, Collection<File>> map2 = this.b.prepareLibraryFiles(libraryData);
        LibraryDataService.registerPaths(libraryData.isUnresolved(), map2, modifiableModel, string);
        LibraryOrderEntry libraryOrderEntry = LibraryDependencyDataService.a(modifiableRootModel, library, libraryDependencyData.getScope());
        assert (libraryOrderEntry != null);
        LibraryDependencyDataService.a(libraryOrderEntry, library, module2, libraryDependencyData);
        return libraryOrderEntry;
    }

    @Nullable
    private static LibraryOrderEntry a(@NotNull ModifiableRootModel modifiableRootModel, @NotNull Library library, @NotNull DependencyScope dependencyScope) {
        if (modifiableRootModel == null) {
            LibraryDependencyDataService.b(27);
        }
        if (library == null) {
            LibraryDependencyDataService.b(28);
        }
        if (dependencyScope == null) {
            LibraryDependencyDataService.b(29);
        }
        LibraryOrderEntry libraryOrderEntry = null;
        for (OrderEntry orderEntry : modifiableRootModel.getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry)) continue;
            LibraryOrderEntry libraryOrderEntry2 = (LibraryOrderEntry)orderEntry;
            if (library == libraryOrderEntry2.getLibrary()) {
                return libraryOrderEntry2;
            }
            if (!library.equals(libraryOrderEntry2.getLibrary())) continue;
            if (libraryOrderEntry2.getScope() == dependencyScope) {
                return libraryOrderEntry2;
            }
            libraryOrderEntry = libraryOrderEntry2;
        }
        return libraryOrderEntry;
    }

    static {
        e = lb.a(-3974174037920828390L, 5063594161589489707L, MethodHandles.lookup().lookupClass()).a(80172923703615L);
        c = Logger.getInstance(LibraryDependencyDataService.class);
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = e ^ 0x311AB39BF6ECL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesToImport";
                break;
            }
            case 4: 
            case 11: 
            case 14: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 6: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 8: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntryDataMap";
                break;
            }
            case 9: 
            case 21: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRootModel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleLibraryTable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lib";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyData";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleLibrariesToImport";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectLibrariesToImport";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryDependencyData";
                break;
            }
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntryType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "importMissing";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setLibraryScope";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "syncExistingAndRemoveObsolete";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "syncExistingLibraryDependency";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryOrderEntry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

