/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import b.a.lb;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.service.project.AbstractIdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectsWorkspaceImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class ModifiableWorkspace {
    private final Map<ProjectCoordinate, String> a = ContainerUtil.newTroveMap((TObjectHashingStrategy)new TObjectHashingStrategy<ProjectCoordinate>(){

        public int computeHashCode(ProjectCoordinate object) {
            String string = object.getGroupId();
            String string2 = object.getArtifactId();
            String string3 = object.getVersion();
            int n2 = string != null ? string.hashCode() : 0;
            n2 = 31 * n2 + (string2 != null ? string2.hashCode() : 0);
            n2 = 31 * n2 + (string3 != null ? string3.hashCode() : 0);
            return n2;
        }

        public boolean equals(ProjectCoordinate o1, ProjectCoordinate o2) {
            if (o1.getGroupId() != null ? !o1.getGroupId().equals(o2.getGroupId()) : o2.getGroupId() != null) {
                return false;
            }
            if (o1.getArtifactId() != null ? !o1.getArtifactId().equals(o2.getArtifactId()) : o2.getArtifactId() != null) {
                return false;
            }
            return !(o1.getVersion() != null ? !o1.getVersion().equals(o2.getVersion()) : o2.getVersion() != null);
        }
    });
    private final AbstractIdeModifiableModelsProvider d;
    private final ExternalProjectsWorkspaceImpl.State b;
    private final MultiMap<String, String> c = MultiMap.createSet();
    private final Map<String, String> e = ContainerUtil.newHashMap();
    private static final long f = lb.a(8811676225282064263L, -2545498241040601285L, MethodHandles.lookup().lookupClass()).a(203354911154516L);

    public ModifiableWorkspace(ExternalProjectsWorkspaceImpl.State state, AbstractIdeModifiableModelsProvider modelsProvider) {
        this.d = modelsProvider;
        HashSet hashSet = ContainerUtil.newHashSet();
        for (Module module2 : modelsProvider.getModules()) {
            this.a(module2, modelsProvider);
            hashSet.add(module2.getName());
        }
        this.b = state;
        if (this.b.names != null) {
            for (Map.Entry entry : this.b.names.entrySet()) {
                if (!hashSet.contains(entry.getKey())) continue;
                this.e.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.b.substitutions != null) {
            for (Map.Entry entry : this.b.substitutions.entrySet()) {
                if (!hashSet.contains(entry.getKey())) continue;
                this.c.put(entry.getKey(), (Collection)entry.getValue());
            }
        }
    }

    public void commit() {
        HashSet hashSet = ContainerUtil.newHashSet();
        Arrays.stream(this.d.getModules()).map(Module::getName).forEach(hashSet::add);
        this.b.names = new HashMap<String, String>();
        this.e.forEach((string, string2) -> {
            if (hashSet.contains(string)) {
                this.b.names.put((String)string, (String)string2);
            }
        });
        this.b.substitutions = new HashMap<String, Set<String>>();
        for (Map.Entry entry : this.c.entrySet()) {
            Collection collection;
            if (!hashSet.contains(entry.getKey()) || (collection = (Collection)entry.getValue()) == null || collection.isEmpty()) continue;
            this.b.substitutions.put((String)entry.getKey(), new TreeSet(collection));
        }
    }

    public void addSubstitution(String ownerModuleName, String moduleName, String libraryName, DependencyScope scope) {
        this.e.put(moduleName, libraryName);
        this.c.putValue((Object)ownerModuleName, (Object)(moduleName + '_' + scope.getDisplayName()));
    }

    public void removeSubstitution(String ownerModuleName, String moduleName, String libraryName, DependencyScope scope) {
        this.c.remove((Object)ownerModuleName, (Object)(moduleName + '_' + scope.getDisplayName()));
        Collection collection = this.c.values();
        for (DependencyScope dependencyScope : DependencyScope.values()) {
            if (!collection.contains(moduleName + '_' + dependencyScope.getDisplayName())) continue;
            return;
        }
        this.e.remove(moduleName, libraryName);
    }

    public boolean isSubstitution(String moduleOwner, String substitutionModule, DependencyScope scope) {
        return this.c.get((Object)moduleOwner).contains(substitutionModule + '_' + scope.getDisplayName());
    }

    public boolean isSubstituted(String libraryName) {
        return this.e.values().contains(libraryName);
    }

    public String getSubstitutedLibrary(String moduleName) {
        return this.e.get(moduleName);
    }

    @Nullable
    public String findModule(@NotNull ProjectCoordinate id2) {
        if (id2 == null) {
            ModifiableWorkspace.a(0);
        }
        if (StringUtil.isEmpty((String)id2.getArtifactId())) {
            return null;
        }
        String string = this.a.get(id2);
        return string == null && id2.getVersion() != null ? this.a.get(new ProjectId(id2.getGroupId(), id2.getArtifactId(), null)) : string;
    }

    public void register(@NotNull ProjectCoordinate id2, @NotNull Module module2) {
        if (id2 == null) {
            ModifiableWorkspace.a(1);
        }
        if (module2 == null) {
            ModifiableWorkspace.a(2);
        }
        this.a.put(id2, module2.getName());
        this.a.put((ProjectCoordinate)new ProjectId(id2.getGroupId(), id2.getArtifactId(), null), module2.getName());
    }

    private void a(@NotNull Module module2, AbstractIdeModifiableModelsProvider abstractIdeModifiableModelsProvider) {
        if (module2 == null) {
            ModifiableWorkspace.a(3);
        }
        Arrays.stream(ExternalProjectsWorkspaceImpl.EP_NAME.getExtensions()).map(contributor -> {
            if (module2 == null) {
                ModifiableWorkspace.a(5);
            }
            return contributor.findProjectId(module2, abstractIdeModifiableModelsProvider);
        }).filter(Objects::nonNull).findFirst().ifPresent(projectCoordinate -> {
            if (module2 == null) {
                ModifiableWorkspace.a(4);
            }
            this.register((ProjectCoordinate)projectCoordinate, module2);
        });
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = f ^ 0x466EBCD7031DL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/ModifiableWorkspace";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findModule";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$register$2";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$register$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

