/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.internal;

import b.a.lb;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.ExternalSystemFacadeManager;
import com.intellij.openapi.externalSystem.service.internal.AbstractExternalSystemTask;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemProcessingManager
implements ExternalSystemTaskNotificationListener,
Disposable {
    private static final long d;
    @NotNull
    private final ConcurrentMap<ExternalSystemTaskId, Long> f;
    @NotNull
    private final ConcurrentMap<ExternalSystemTaskId, ExternalSystemTask> e;
    @NotNull
    private final Alarm a;
    @NotNull
    private final ExternalSystemFacadeManager c;
    @NotNull
    private final ExternalSystemProgressNotificationManager b;
    private static final long g;

    public ExternalSystemProcessingManager(@NotNull ExternalSystemFacadeManager facadeManager, @NotNull ExternalSystemProgressNotificationManager notificationManager) {
        if (facadeManager == null) {
            ExternalSystemProcessingManager.a(0);
        }
        if (notificationManager == null) {
            ExternalSystemProcessingManager.a(1);
        }
        this.f = ContainerUtil.newConcurrentMap();
        this.e = ContainerUtil.newConcurrentMap();
        this.a = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.c = facadeManager;
        this.b = notificationManager;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        notificationManager.addNotificationListener(this);
    }

    public void dispose() {
        this.b.removeNotificationListener(this);
        this.a.cancelAllRequests();
    }

    public boolean hasTaskOfTypeInProgress(@NotNull ExternalSystemTaskType type, @NotNull Project project2) {
        if (type == null) {
            ExternalSystemProcessingManager.a(2);
        }
        if (project2 == null) {
            ExternalSystemProcessingManager.a(3);
        }
        String string = ExternalSystemTaskId.getProjectId((Project)project2);
        for (ExternalSystemTaskId externalSystemTaskId : this.f.keySet()) {
            if (!type.equals((Object)externalSystemTaskId.getType()) || !string.equals(externalSystemTaskId.getIdeProjectId())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public ExternalSystemTask findTask(@NotNull ExternalSystemTaskType type, @NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        if (type == null) {
            ExternalSystemProcessingManager.a(4);
        }
        if (projectSystemId == null) {
            ExternalSystemProcessingManager.a(5);
        }
        if (externalProjectPath == null) {
            ExternalSystemProcessingManager.a(6);
        }
        for (ExternalSystemTask externalSystemTask : this.e.values()) {
            AbstractExternalSystemTask abstractExternalSystemTask;
            if (!(externalSystemTask instanceof AbstractExternalSystemTask) || (abstractExternalSystemTask = (AbstractExternalSystemTask)externalSystemTask).getId().getType() != type || !abstractExternalSystemTask.getExternalSystemId().getId().equals(projectSystemId.getId()) || !abstractExternalSystemTask.getExternalProjectPath().equals(externalProjectPath)) continue;
            return externalSystemTask;
        }
        return null;
    }

    @NotNull
    public List<ExternalSystemTask> findTasksOfState(@NotNull ProjectSystemId projectSystemId, ExternalSystemTaskState ... taskStates) {
        if (projectSystemId == null) {
            ExternalSystemProcessingManager.a(7);
        }
        if (taskStates == null) {
            ExternalSystemProcessingManager.a(8);
        }
        SmartList smartList = new SmartList();
        for (ExternalSystemTask externalSystemTask : this.e.values()) {
            AbstractExternalSystemTask abstractExternalSystemTask;
            if (!(externalSystemTask instanceof AbstractExternalSystemTask) || !(abstractExternalSystemTask = (AbstractExternalSystemTask)externalSystemTask).getExternalSystemId().getId().equals(projectSystemId.getId()) || !ArrayUtil.contains((Object)abstractExternalSystemTask.getState(), (Object[])taskStates)) continue;
            smartList.add(externalSystemTask);
        }
        SmartList smartList2 = smartList;
        if (smartList2 == null) {
            ExternalSystemProcessingManager.a(9);
        }
        return smartList2;
    }

    public void add(@NotNull ExternalSystemTask task) {
        if (task == null) {
            ExternalSystemProcessingManager.a(10);
        }
        this.e.put(task.getId(), task);
    }

    public void release(@NotNull ExternalSystemTaskId id2) {
        if (id2 == null) {
            ExternalSystemProcessingManager.a(11);
        }
        this.e.remove(id2);
    }

    public void onQueued(@NotNull ExternalSystemTaskId id2, String workingDir) {
        if (id2 == null) {
            ExternalSystemProcessingManager.a(12);
        }
        this.onStart(id2, workingDir);
    }

    public void onStart(@NotNull ExternalSystemTaskId id2, String workingDir) {
        if (id2 == null) {
            ExternalSystemProcessingManager.a(13);
        }
        this.f.put(id2, System.currentTimeMillis() + d);
        if (this.a.getActiveRequestCount() <= 0) {
            this.a.addRequest(() -> this.update(), d);
        }
    }

    public void onStart(@NotNull ExternalSystemTaskId id2) {
        if (id2 == null) {
            ExternalSystemProcessingManager.a(14);
        }
        this.f.put(id2, System.currentTimeMillis() + d);
    }

    public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
        if (event == null) {
            ExternalSystemProcessingManager.a(15);
        }
        this.f.put(event.getId(), System.currentTimeMillis() + d);
    }

    public void onTaskOutput(@NotNull ExternalSystemTaskId id2, @NotNull String text2, boolean stdOut) {
        if (id2 == null) {
            ExternalSystemProcessingManager.a(16);
        }
        if (text2 == null) {
            ExternalSystemProcessingManager.a(17);
        }
        this.f.put(id2, System.currentTimeMillis() + d);
    }

    public void onEnd(@NotNull ExternalSystemTaskId id2) {
        if (id2 == null) {
            ExternalSystemProcessingManager.a(18);
        }
        this.f.remove(id2);
        if (this.f.isEmpty()) {
            this.a.cancelAllRequests();
        }
    }

    public void onSuccess(@NotNull ExternalSystemTaskId id2) {
        if (id2 == null) {
            ExternalSystemProcessingManager.a(19);
        }
    }

    public void onFailure(@NotNull ExternalSystemTaskId id2, @NotNull Exception e10) {
        if (id2 == null) {
            ExternalSystemProcessingManager.a(20);
        }
        if (e10 == null) {
            ExternalSystemProcessingManager.a(21);
        }
    }

    public void beforeCancel(@NotNull ExternalSystemTaskId id2) {
        if (id2 == null) {
            ExternalSystemProcessingManager.a(22);
        }
    }

    public void onCancel(@NotNull ExternalSystemTaskId id2) {
        if (id2 == null) {
            ExternalSystemProcessingManager.a(23);
        }
    }

    public void update() {
        long l2 = d;
        HashMap hashMap = ContainerUtilRt.newHashMap();
        HashMap hashMap2 = ContainerUtilRt.newHashMap(this.f);
        if (hashMap2.isEmpty()) {
            return;
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            long l3 = System.currentTimeMillis() - (Long)entry.getValue();
            if (l3 > 0L) {
                l2 = Math.min(l2, l3);
                hashMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!this.c.isTaskActive((ExternalSystemTaskId)entry.getKey())) continue;
            hashMap.put(entry.getKey(), System.currentTimeMillis() + d);
        }
        this.f.clear();
        this.f.putAll(hashMap);
        if (!hashMap.isEmpty()) {
            this.a.cancelAllRequests();
            this.a.addRequest(() -> this.update(), l2);
        }
    }

    static {
        g = lb.a(8294444556830288795L, -5412333733680381625L, MethodHandles.lookup().lookupClass()).a(76000068604154L);
        d = TimeUnit.SECONDS.toMillis(10L);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = g ^ 0x14566AA7D87L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 9: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facadeManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationManager";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskStates";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/internal/ExternalSystemProcessingManager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/internal/ExternalSystemProcessingManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findTasksOfState";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasTaskOfTypeInProgress";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findTask";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findTasksOfState";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "release";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "onQueued";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "onStart";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "onStatusChange";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "onTaskOutput";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "onEnd";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "onSuccess";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "onFailure";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "beforeCancel";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "onCancel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

