/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import b.a.lb;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJavaUtil;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkException;
import com.intellij.openapi.externalSystem.service.execution.InvalidJavaHomeException;
import com.intellij.openapi.externalSystem.service.execution.InvalidSdkException;
import com.intellij.openapi.externalSystem.service.execution.ProjectJdkNotFoundException;
import com.intellij.openapi.externalSystem.service.execution.UndefinedJavaHomeException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemJdkUtil {
    public static final String USE_INTERNAL_JAVA = "#JAVA_INTERNAL";
    public static final String USE_PROJECT_JDK = "#USE_PROJECT_JDK";
    public static final String USE_JAVA_HOME = "#JAVA_HOME";
    private static final long a = lb.a(3211924763055230814L, -3037580245400550078L, MethodHandles.lookup().lookupClass()).a(159918884021645L);

    @Nullable
    public static Sdk getJdk(@Nullable Project project2, @Nullable String jdkName) throws ExternalSystemJdkException {
        long l2 = a ^ 0x74045B8CC9A7L;
        if (jdkName == null) {
            return null;
        }
        if (USE_INTERNAL_JAVA.equals(jdkName)) {
            return ExternalSystemJdkUtil.b();
        }
        if (USE_PROJECT_JDK.equals(jdkName)) {
            Sdk sdk;
            Sdk sdk2;
            if (project2 != null) {
                sdk2 = ProjectRootManager.getInstance((Project)project2).getProjectSdk();
                if (sdk2 != null) {
                    return sdk2;
                }
                for (Sdk sdk3 : sdk = ModuleManager.getInstance((Project)project2).getModules()) {
                    Sdk sdk4 = ModuleRootManager.getInstance((Module)sdk3).getSdk();
                    if (sdk4 == null || !(sdk4.getSdkType() instanceof JavaSdkType)) continue;
                    return sdk4;
                }
            }
            if (project2 == null || project2.isDefault()) {
                sdk2 = ExternalSystemJdkUtil.c();
                sdk = sdk2 == null ? null : ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)sdk2);
                return sdk != null ? sdk : ExternalSystemJdkUtil.b();
            }
            throw new ProjectJdkNotFoundException();
        }
        if (USE_JAVA_HOME.equals(jdkName)) {
            String string = (String)EnvironmentUtil.getEnvironmentMap().get("JAVA_HOME");
            if (StringUtil.isEmptyOrSpaces((String)string)) {
                throw new UndefinedJavaHomeException();
            }
            if (!ExternalSystemJdkUtil.isValidJdk(string)) {
                throw new InvalidJavaHomeException(string);
            }
            SimpleJavaSdkType simpleJavaSdkType = SimpleJavaSdkType.getInstance();
            String string2 = simpleJavaSdkType.suggestSdkName(null, string);
            return simpleJavaSdkType.createJdk(string2, string);
        }
        Sdk sdk = ProjectJdkTable.getInstance().findJdk(jdkName);
        if (sdk != null) {
            String string = sdk.getHomePath();
            if (!ExternalSystemJdkUtil.isValidJdk(string)) {
                throw new InvalidSdkException(string);
            }
            return sdk;
        }
        return null;
    }

    @NotNull
    public static Pair<String, Sdk> getAvailableJdk(@Nullable Project project2) throws ExternalSystemJdkException {
        String string;
        Object object;
        Sdk sdk2;
        long l2 = a ^ 0x53FED3E2053BL;
        SdkType sdkType = ExternalSystemJdkUtil.getJavaSdkType();
        if (project2 != null && (sdk2 = (Sdk)(object = Stream.concat(Stream.of(ProjectRootManager.getInstance((Project)project2).getProjectSdk()), Stream.of(ModuleManager.getInstance((Project)project2).getModules()).map(module2 -> ModuleRootManager.getInstance((Module)module2).getSdk()))).filter(sdk -> sdk != null && sdk.getSdkType() == sdkType && ExternalSystemJdkUtil.isValidJdk(sdk.getHomePath())).findFirst().orElse(null)) != null) {
            Pair pair2 = Pair.pair((Object)USE_PROJECT_JDK, (Object)sdk2);
            if (pair2 == null) {
                ExternalSystemJdkUtil.a(0);
            }
            return pair2;
        }
        object = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)sdkType);
        sdk2 = object.stream().filter(sdk -> ExternalSystemJdkUtil.isValidJdk(sdk.getHomePath())).max(sdkType.versionComparator()).orElse(null);
        if (sdk2 != null) {
            Pair pair3 = Pair.pair((Object)sdk2.getName(), (Object)sdk2);
            if (pair3 == null) {
                ExternalSystemJdkUtil.a(1);
            }
            return pair3;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && ExternalSystemJdkUtil.isValidJdk(string = (String)EnvironmentUtil.getEnvironmentMap().get("JAVA_HOME"))) {
            SimpleJavaSdkType simpleJavaSdkType = SimpleJavaSdkType.getInstance();
            String string2 = simpleJavaSdkType.suggestSdkName(null, string);
            Pair pair4 = Pair.pair((Object)USE_JAVA_HOME, (Object)simpleJavaSdkType.createJdk(string2, string));
            if (pair4 == null) {
                ExternalSystemJdkUtil.a(2);
            }
            return pair4;
        }
        Pair pair5 = Pair.pair((Object)USE_INTERNAL_JAVA, (Object)ExternalSystemJdkUtil.b());
        if (pair5 == null) {
            ExternalSystemJdkUtil.a(3);
        }
        return pair5;
    }

    @NotNull
    public static Collection<String> suggestJdkHomePaths() {
        Collection collection = ExternalSystemJdkUtil.getJavaSdkType().suggestHomePaths();
        if (collection == null) {
            ExternalSystemJdkUtil.a(4);
        }
        return collection;
    }

    @NotNull
    public static SdkType getJavaSdkType() {
        SdkType sdkType = ExternalSystemJdkUtil.c();
        Object object = sdkType == null ? SimpleJavaSdkType.getInstance() : sdkType;
        if (object == null) {
            ExternalSystemJdkUtil.a(5);
        }
        return object;
    }

    @Deprecated
    public static boolean checkForJdk(@NotNull Project project2, @Nullable String jdkName) {
        if (project2 == null) {
            ExternalSystemJdkUtil.a(6);
        }
        try {
            Sdk sdk = ExternalSystemJdkUtil.getJdk(project2, jdkName);
            return sdk != null && sdk.getHomePath() != null && JdkUtil.checkForJdk((String)sdk.getHomePath());
        }
        catch (ExternalSystemJdkException externalSystemJdkException) {
            return false;
        }
    }

    public static boolean isValidJdk(@Nullable String homePath) {
        return !StringUtil.isEmptyOrSpaces((String)homePath) && JdkUtil.checkForJdk((String)homePath) && JdkUtil.checkForJre((String)homePath);
    }

    @NotNull
    public static Sdk addJdk(String homePath) {
        Sdk sdk;
        if (ExternalSystemJdkUtil.a() && (sdk = ExternalSystemJavaUtil.tryAddJdk(homePath)) != null) {
            Sdk sdk2 = sdk;
            if (sdk2 == null) {
                ExternalSystemJdkUtil.a(7);
            }
            return sdk2;
        }
        SimpleJavaSdkType simpleJavaSdkType = SimpleJavaSdkType.getInstance();
        sdk = simpleJavaSdkType.createJdk(simpleJavaSdkType.suggestSdkName(null, homePath), homePath);
        SdkConfigurationUtil.addSdk((Sdk)sdk);
        Sdk sdk3 = sdk;
        if (sdk3 == null) {
            ExternalSystemJdkUtil.a(8);
        }
        return sdk3;
    }

    @Nullable
    private static SdkType c() {
        if (ExternalSystemJdkUtil.a()) {
            return ExternalSystemJavaUtil.getJavaSdk();
        }
        return null;
    }

    @NotNull
    private static Sdk b() {
        Object object;
        if (ExternalSystemJdkUtil.a() && (object = ExternalSystemJavaUtil.getInternalJdk()) != null) {
            Object object2 = object;
            if (object2 == null) {
                ExternalSystemJdkUtil.a(9);
            }
            return object2;
        }
        object = SystemProperties.getJavaHome();
        SimpleJavaSdkType simpleJavaSdkType = SimpleJavaSdkType.getInstance();
        Sdk sdk = simpleJavaSdkType.createJdk(simpleJavaSdkType.suggestSdkName(null, (String)object), (String)object);
        if (sdk == null) {
            ExternalSystemJdkUtil.a(10);
        }
        return sdk;
    }

    private static boolean a() {
        long l2 = a ^ 0x284ACD902635L;
        try {
            Class.forName("com.intellij.openapi.projectRoots.impl.JavaSdkImpl");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x510D885A658DL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 6: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemJdkUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableJdk";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestJdkHomePaths";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaSdkType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemJdkUtil";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "addJdk";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalJdk";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkForJdk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

