/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import b.a.lb;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.module.Module;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemActionUtil {
    private static final long a = lb.a(8826390980654379360L, 6774079783905069851L, MethodHandles.lookup().lookupClass()).a(113555489696497L);

    public static void executeAction(String actionId, InputEvent e10) {
        ExternalSystemActionUtil.executeAction(actionId, "", e10);
    }

    public static void executeAction(String actionId, @NotNull String place, InputEvent e10) {
        ActionManager actionManager;
        AnAction anAction;
        if (place == null) {
            ExternalSystemActionUtil.a(0);
        }
        if ((anAction = (actionManager = ActionManager.getInstance()).getAction(actionId)) != null) {
            Presentation presentation = new Presentation();
            AnActionEvent anActionEvent = new AnActionEvent(e10, DataManager.getInstance().getDataContext(e10.getComponent()), place, presentation, actionManager, 0);
            anAction.update(anActionEvent);
            if (presentation.isEnabled()) {
                anAction.actionPerformed(anActionEvent);
            }
        }
    }

    @Nullable
    public static Module getModule(DataContext context) {
        Module module2 = (Module)LangDataKeys.MODULE.getData(context);
        return module2 != null ? module2 : (Module)LangDataKeys.MODULE_CONTEXT.getData(context);
    }

    public static <E> void setElements(ElementsChooser<E> chooser, Collection<? extends E> all, Collection<E> selected, Comparator<? super E> comparator2) {
        List list2 = chooser.getSelectedElements();
        chooser.clear();
        TreeSet<? extends E> treeSet = new TreeSet<E>(comparator2);
        treeSet.addAll(all);
        for (Object e10 : treeSet) {
            chooser.addElement(e10, selected.contains(e10));
        }
        chooser.selectElements((Collection)list2);
    }

    public static void installCheckboxRenderer(final SimpleTree tree2, final CheckboxHandler handler) {
        long l2 = a ^ 0x1EAB6AEE47B1L;
        final JCheckBox jCheckBox = new JCheckBox();
        final JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jCheckBox, "West");
        final TreeCellRenderer treeCellRenderer = tree2.getCellRenderer();
        tree2.setCellRenderer(new TreeCellRenderer(){
            private static final long a = lb.a(550064950241326619L, 7140279671254559814L, MethodHandles.lookup().lookupClass()).a(224592718565123L);

            @Override
            public Component getTreeCellRendererComponent(JTree tree2, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                long l2 = a ^ 0x388C5891FA14L;
                Component component = treeCellRenderer.getTreeCellRendererComponent(tree2, value, selected, expanded, leaf, row, hasFocus);
                Object object = ((DefaultMutableTreeNode)value).getUserObject();
                if (!handler.isVisible(object)) {
                    return component;
                }
                Color color = UIUtil.getTreeForeground((boolean)selected, (boolean)hasFocus);
                Color color2 = UIUtil.getTreeBackground((boolean)selected, (boolean)hasFocus);
                jPanel.add(component, "Center");
                jPanel.setBackground(color2);
                jPanel.setForeground(color);
                CheckBoxState checkBoxState = handler.getState(object);
                jCheckBox.setSelected(checkBoxState != CheckBoxState.UNCHECKED);
                jCheckBox.setEnabled(checkBoxState != CheckBoxState.PARTIAL);
                jCheckBox.setBackground(color2);
                jCheckBox.setForeground(color);
                return jPanel;
            }
        });
        tree2.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e10) {
                int n2 = tree2.getRowForLocation(e10.getX(), e10.getY());
                if (n2 >= 0) {
                    TreePath treePath = tree2.getPathForRow(n2);
                    if (!ExternalSystemActionUtil.a(treePath, handler)) {
                        return;
                    }
                    Rectangle rectangle = jCheckBox.getBounds();
                    rectangle.setLocation(tree2.getRowBounds(n2).getLocation());
                    if (rectangle.contains(e10.getPoint())) {
                        handler.toggle(treePath, e10);
                        e10.consume();
                        tree2.setSelectionRow(n2);
                    }
                }
            }
        });
        tree2.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e10) {
                TreePath[] treePathArray;
                if (e10.getKeyCode() == 32 && (treePathArray = tree2.getSelectionPaths()) != null) {
                    for (TreePath treePath : treePathArray) {
                        if (!ExternalSystemActionUtil.a(treePath, handler)) continue;
                        handler.toggle(treePath, e10);
                    }
                    e10.consume();
                }
            }
        });
    }

    private static boolean a(TreePath treePath, CheckboxHandler checkboxHandler) {
        Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
        return checkboxHandler.isVisible(object);
    }

    @NotNull
    public static ExternalTaskExecutionInfo buildTaskInfo(@NotNull TaskData task) {
        if (task == null) {
            ExternalSystemActionUtil.a(1);
        }
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = new ExternalSystemTaskExecutionSettings();
        externalSystemTaskExecutionSettings.setExternalProjectPath(task.getLinkedExternalProjectPath());
        externalSystemTaskExecutionSettings.setTaskNames(Collections.singletonList(task.getName()));
        externalSystemTaskExecutionSettings.setTaskDescriptions(Collections.singletonList(task.getDescription()));
        externalSystemTaskExecutionSettings.setExternalSystemIdString(task.getOwner().toString());
        ExternalTaskExecutionInfo externalTaskExecutionInfo = new ExternalTaskExecutionInfo(externalSystemTaskExecutionSettings, DefaultRunExecutor.EXECUTOR_ID);
        if (externalTaskExecutionInfo == null) {
            ExternalSystemActionUtil.a(2);
        }
        return externalTaskExecutionInfo;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x235643A7E63AL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/action/ExternalSystemActionUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/action/ExternalSystemActionUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTaskInfo";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeAction";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildTaskInfo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class CheckBoxState
    extends Enum<CheckBoxState> {
        public static final /* enum */ CheckBoxState CHECKED;
        public static final /* enum */ CheckBoxState UNCHECKED;
        public static final /* enum */ CheckBoxState PARTIAL;
        private static final /* synthetic */ CheckBoxState[] a;

        public static CheckBoxState[] values() {
            return (CheckBoxState[])a.clone();
        }

        public static CheckBoxState valueOf(String name2) {
            return Enum.valueOf(CheckBoxState.class, name2);
        }

        static {
            long l2 = lb.a(-7010811474535837431L, 7102033433105808853L, MethodHandles.lookup().lookupClass()).a(63091142247518L) ^ 0x55A5D516B211L;
            CHECKED = new CheckBoxState();
            UNCHECKED = new CheckBoxState();
            PARTIAL = new CheckBoxState();
            a = new CheckBoxState[]{CHECKED, UNCHECKED, PARTIAL};
        }
    }

    public static interface CheckboxHandler {
        public void toggle(TreePath var1, InputEvent var2);

        public boolean isVisible(Object var1);

        public CheckBoxState getState(Object var1);
    }
}

