/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import b.a.lb;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.module.impl.ModulePath;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.Parameterized;
import com.intellij.testFramework.TestFrameworkUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import junit.framework.TestCase;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

public class PathManagerEx {
    private static final ConcurrentMap<Class, TestDataLookupStrategy> a;
    private static final ConcurrentMap<String, Class> b;
    private static Set<String> d;
    private static final Map<TestDataLookupStrategy, List<String>> c;
    private static final long e;

    private PathManagerEx() {
    }

    @NonNls
    public static String getTestDataPath() throws IllegalStateException {
        TestDataLookupStrategy testDataLookupStrategy = PathManagerEx.guessTestDataLookupStrategy();
        return PathManagerEx.getTestDataPath(testDataLookupStrategy);
    }

    public static String getTestDataPath(String path) throws IllegalStateException {
        return PathManagerEx.getTestDataPath() + path.replace('/', File.separatorChar);
    }

    public static String getTestDataPath(Class<?> testClass) throws IllegalStateException {
        TestDataLookupStrategy testDataLookupStrategy = PathManagerEx.a() ? TestDataLookupStrategy.COMMUNITY : PathManagerEx.a(testClass);
        return PathManagerEx.getTestDataPath(testDataLookupStrategy);
    }

    @NotNull
    public static String getCommunityHomePath() {
        String string = PathManager.getCommunityHomePath();
        if (string == null) {
            PathManagerEx.a(0);
        }
        return string;
    }

    public static String getHomePath(Class<?> testClass) {
        TestDataLookupStrategy testDataLookupStrategy = PathManagerEx.a() ? TestDataLookupStrategy.COMMUNITY : PathManagerEx.a(testClass);
        return testDataLookupStrategy == TestDataLookupStrategy.COMMUNITY_FROM_ULTIMATE ? PathManager.getCommunityHomePath() : PathManager.getHomePath();
    }

    public static File findFileUnderCommunityHome(String relativePath) {
        long l2 = e ^ 0x27E88206AA44L;
        File file = new File(PathManager.getCommunityHomePath(), FileUtil.toSystemDependentName((String)relativePath));
        if (!file.exists()) {
            throw new IllegalArgumentException("Cannot find file '" + relativePath + "' under '" + PathManager.getCommunityHomePath() + "' directory");
        }
        return file;
    }

    public static File findFileUnderProjectHome(String relativePath, Class<? extends TestCase> testClass) {
        long l2 = e ^ 0x71A39B6714C5L;
        String string = PathManagerEx.getHomePath(testClass);
        File file = new File(string, FileUtil.toSystemDependentName((String)relativePath));
        if (!file.exists()) {
            throw new IllegalArgumentException("Cannot find file '" + relativePath + "' under '" + string + "' directory");
        }
        return file;
    }

    private static boolean a() {
        FileSystemLocation fileSystemLocation = PathManagerEx.b();
        return fileSystemLocation == FileSystemLocation.COMMUNITY;
    }

    @NonNls
    public static String getTestDataPath(TestDataLookupStrategy strategy) throws IllegalStateException {
        long l2 = e ^ 0x74BCDFF4E476L;
        String string = PathManager.getHomePath();
        List<String> list2 = c.get((Object)strategy);
        if (list2.isEmpty()) {
            throw new IllegalStateException(String.format("Can't determine test data path. Reason: no predefined relative paths are configured for test data lookup strategy %s. Configured mappings: %s", new Object[]{strategy, c}));
        }
        File file = null;
        for (String string2 : list2) {
            file = new File(string, string2);
            if (!file.isDirectory()) continue;
            return file.getPath();
        }
        if (file == null) {
            throw new IllegalStateException("Can't determine test data path. Looks like programming error - reached 'if' block that was never expected to be executed");
        }
        return file.getPath();
    }

    public static TestDataLookupStrategy guessTestDataLookupStrategy() {
        TestDataLookupStrategy testDataLookupStrategy = PathManagerEx.c();
        if (testDataLookupStrategy == null) {
            testDataLookupStrategy = PathManagerEx.d();
        }
        return testDataLookupStrategy;
    }

    @Nullable
    private static TestDataLookupStrategy c() {
        StackTraceElement[] stackTraceElementArray;
        if (PathManagerEx.a()) {
            return TestDataLookupStrategy.COMMUNITY;
        }
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        for (StackTraceElement stackTraceElement : stackTraceElementArray = new Exception().getStackTrace()) {
            String string = stackTraceElement.getClassName();
            Class<?> clazz3 = PathManagerEx.a(string);
            if (clazz3 == null || TestCase.class == clazz3 || !PathManagerEx.b(clazz3)) continue;
            if (PathManagerEx.a(clazz3) == TestDataLookupStrategy.ULTIMATE) {
                return TestDataLookupStrategy.ULTIMATE;
            }
            if ((clazz3.getModifiers() & 0x400) == 0) {
                clazz = clazz3;
                continue;
            }
            clazz2 = clazz3;
        }
        StackTraceElement[] stackTraceElementArray2 = clazz == null ? clazz2 : clazz;
        return stackTraceElementArray2 == null ? null : PathManagerEx.a(stackTraceElementArray2);
    }

    @Nullable
    private static Class<?> a(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = (Class<?>)b.get(string);
        if (clazz != null) {
            return clazz;
        }
        ClassLoader classLoader2 = PathManagerEx.class.getClassLoader();
        ClassLoader classLoader3 = ClassLoader.getSystemClassLoader();
        for (ClassLoader classLoader4 : Arrays.asList(classLoader, classLoader2, classLoader3)) {
            clazz = PathManagerEx.a(string, classLoader4);
            if (clazz == null) continue;
            b.put(string, clazz);
            return clazz;
        }
        b.put(string, TestCase.class);
        return null;
    }

    @Nullable
    private static Class<?> a(String string, ClassLoader classLoader) {
        try {
            return Class.forName(string, true, classLoader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            return null;
        }
    }

    private static boolean b(Class<?> clazz) {
        return TestCase.class.isAssignableFrom(clazz) || TestFrameworkUtil.isJUnit4TestClass(clazz) || Parameterized.class.isAssignableFrom(clazz);
    }

    @Nullable
    private static TestDataLookupStrategy a(Class<?> clazz) {
        TestDataLookupStrategy testDataLookupStrategy = (TestDataLookupStrategy)((Object)a.get(clazz));
        if (testDataLookupStrategy != null) {
            return testDataLookupStrategy;
        }
        FileSystemLocation fileSystemLocation = PathManagerEx.c(clazz);
        testDataLookupStrategy = fileSystemLocation == FileSystemLocation.COMMUNITY ? TestDataLookupStrategy.COMMUNITY_FROM_ULTIMATE : TestDataLookupStrategy.ULTIMATE;
        a.put(clazz, testDataLookupStrategy);
        return testDataLookupStrategy;
    }

    public static void replaceLookupStrategy(Class<?> substitutor, Class<?> ... initial) {
        a.clear();
        for (Class<?> clazz : initial) {
            a.put(clazz, PathManagerEx.a(substitutor));
        }
    }

    private static FileSystemLocation c(Class<?> clazz) {
        String string;
        long l2 = e ^ 0x300178947F85L;
        String string2 = PathManager.getJarPathForClass(clazz);
        if (string2 == null) {
            throw new IllegalStateException("Cannot find root directory for " + clazz);
        }
        File file = new File(string2);
        if (!file.exists()) {
            throw new IllegalStateException("Classes root " + file + " doesn't exist");
        }
        if (!file.isDirectory()) {
            return FileSystemLocation.ULTIMATE;
        }
        String string3 = file.getName();
        if (string3.startsWith(string = "ModuleChunk(")) {
            string3 = StringUtil.trimStart((String)string3, (String)string);
            string3 = string3.substring(0, string3.indexOf(44));
        }
        return PathManagerEx.e().contains(string3) ? FileSystemLocation.COMMUNITY : FileSystemLocation.ULTIMATE;
    }

    private static synchronized Set<String> e() {
        long l2 = e ^ 0x3F24F28E8C4CL;
        if (d != null) {
            return d;
        }
        d = new THashSet();
        File file = PathManagerEx.findFileUnderCommunityHome(".idea/modules.xml");
        if (!file.exists()) {
            throw new IllegalStateException("Cannot obtain test data path: " + file.getAbsolutePath() + " not found");
        }
        try {
            Element element = JDomSerializationUtil.findComponent((Element)JDOMUtil.load((File)file), (String)"ProjectModuleManager");
            assert (element != null);
            for (ModulePath modulePath : ModuleManagerImpl.getPathsToModuleFiles((Element)element)) {
                d.add(modulePath.getModuleName());
            }
            return d;
        }
        catch (IOException | JDOMException throwable) {
            throw new RuntimeException("Cannot read modules from " + file.getAbsolutePath(), throwable);
        }
    }

    private static FileSystemLocation b() {
        long l2 = e ^ 0x4ABAFEAF9254L;
        return new File(PathManager.getHomePath(), "community/.idea").isDirectory() ? FileSystemLocation.ULTIMATE : FileSystemLocation.COMMUNITY;
    }

    private static TestDataLookupStrategy d() {
        String string = PathManager.getHomePath();
        for (Map.Entry<TestDataLookupStrategy, List<String>> entry : c.entrySet()) {
            for (String string2 : entry.getValue()) {
                if (!new File(string, string2).isDirectory()) continue;
                return entry.getKey();
            }
        }
        return TestDataLookupStrategy.ULTIMATE;
    }

    static {
        e = lb.a(8759575753323810292L, -6701651620203515506L, MethodHandles.lookup().lookupClass()).a(33316762661404L);
        long l2 = e ^ 0x6C8050B57D51L;
        a = ContainerUtil.newConcurrentMap();
        b = ContainerUtil.newConcurrentMap();
        c = new EnumMap<TestDataLookupStrategy, List<String>>(TestDataLookupStrategy.class);
        c.put(TestDataLookupStrategy.ULTIMATE, Collections.singletonList(FileUtil.toSystemDependentName((String)"testData")));
        c.put(TestDataLookupStrategy.COMMUNITY, Collections.singletonList(FileUtil.toSystemDependentName((String)"java/java-tests/testData")));
        c.put(TestDataLookupStrategy.COMMUNITY_FROM_ULTIMATE, Collections.singletonList(FileUtil.toSystemDependentName((String)"community/java/java-tests/testData")));
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = e ^ 0x340C2221C5B2L;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/ex/PathManagerEx", "getCommunityHomePath"));
    }

    public static final class TestDataLookupStrategy
    extends Enum<TestDataLookupStrategy> {
        public static final /* enum */ TestDataLookupStrategy ULTIMATE;
        public static final /* enum */ TestDataLookupStrategy COMMUNITY;
        public static final /* enum */ TestDataLookupStrategy COMMUNITY_FROM_ULTIMATE;
        private static final /* synthetic */ TestDataLookupStrategy[] a;

        public static TestDataLookupStrategy[] values() {
            return (TestDataLookupStrategy[])a.clone();
        }

        public static TestDataLookupStrategy valueOf(String name2) {
            return Enum.valueOf(TestDataLookupStrategy.class, name2);
        }

        static {
            long l2 = lb.a(1638731444088084444L, -3256677199533136901L, MethodHandles.lookup().lookupClass()).a(203127236379513L) ^ 0x1DC7B7156660L;
            ULTIMATE = new TestDataLookupStrategy();
            COMMUNITY = new TestDataLookupStrategy();
            COMMUNITY_FROM_ULTIMATE = new TestDataLookupStrategy();
            a = new TestDataLookupStrategy[]{ULTIMATE, COMMUNITY, COMMUNITY_FROM_ULTIMATE};
        }
    }

    private static final class FileSystemLocation
    extends Enum<FileSystemLocation> {
        public static final /* enum */ FileSystemLocation ULTIMATE;
        public static final /* enum */ FileSystemLocation COMMUNITY;
        private static final /* synthetic */ FileSystemLocation[] a;

        public static FileSystemLocation[] values() {
            return (FileSystemLocation[])a.clone();
        }

        public static FileSystemLocation valueOf(String name2) {
            return Enum.valueOf(FileSystemLocation.class, name2);
        }

        static {
            long l2 = lb.a(6051517430577706040L, -7340880519598261111L, MethodHandles.lookup().lookupClass()).a(114217910335394L) ^ 0x65A8D5A1CE2DL;
            ULTIMATE = new FileSystemLocation();
            COMMUNITY = new FileSystemLocation();
            a = new FileSystemLocation[]{ULTIMATE, COMMUNITY};
        }
    }
}

