/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import b.a.lb;
import com.google.common.base.Predicate;
import com.intellij.ProjectTopics;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryTableImplUtil;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryUtils;

public class RepositoryLibrarySynchronizer
implements StartupActivity,
DumbAware {
    private static final long a = lb.a(2584132532788051111L, -7666915103614992149L, MethodHandles.lookup().lookupClass()).a(163546352671127L);

    private static boolean a(LibraryEx libraryEx, RepositoryLibraryProperties repositoryLibraryProperties) {
        long l2 = a ^ 0x449021AF5CAEL;
        String string = repositoryLibraryProperties.getVersion();
        if (string == null) {
            return false;
        }
        if (string.equals("LATEST") || string.equals("RELEASE") || string.endsWith("-SNAPSHOT")) {
            return true;
        }
        for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
            if (libraryEx.getFiles(orderRootType).length == libraryEx.getUrls(orderRootType).length) continue;
            return true;
        }
        return false;
    }

    public static Set<Library> collectLibraries(@NotNull Project project2, @NotNull Predicate<? super Library> predicate) {
        if (project2 == null) {
            RepositoryLibrarySynchronizer.a(0);
        }
        if (predicate == null) {
            RepositoryLibrarySynchronizer.a(1);
        }
        LinkedHashSet<Library> linkedHashSet = new LinkedHashSet<Library>();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project2 == null) {
                RepositoryLibrarySynchronizer.a(8);
            }
            if (predicate == null) {
                RepositoryLibrarySynchronizer.a(9);
            }
            if (project2.isDisposed()) {
                return;
            }
            for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
                OrderEnumerator.orderEntries((Module)module2).withoutSdk().forEachLibrary(library -> {
                    if (predicate == null) {
                        RepositoryLibrarySynchronizer.a(10);
                    }
                    if (predicate.apply(library)) {
                        linkedHashSet.add((Library)library);
                    }
                    return true;
                });
            }
            for (Module module2 : ProjectLibraryTable.getInstance((Project)project2).getLibraries()) {
                if (!predicate.apply((Object)module2)) continue;
                linkedHashSet.add((Library)module2);
            }
        });
        return linkedHashSet;
    }

    private static void b(@NotNull Project project2) {
        Set<Library> set;
        if (project2 == null) {
            RepositoryLibrarySynchronizer.a(2);
        }
        if (!(set = RepositoryLibrarySynchronizer.collectLibraries(project2, (Predicate<? super Library>)((Predicate)library -> library instanceof LibraryEx && ((LibraryEx)library).getProperties() instanceof RepositoryLibraryProperties && RepositoryLibrarySynchronizer.a(library)))).isEmpty()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                List list2;
                long l2 = a ^ 0x534167F5F892L;
                if (project2 == null) {
                    RepositoryLibrarySynchronizer.a(7);
                }
                if ((list2 = ContainerUtil.filter((Collection)set, LibraryTableImplUtil::isValidLibrary)).isEmpty()) {
                    return;
                }
                WriteAction.run(() -> {
                    for (Library library : list2) {
                        Library.ModifiableModel modifiableModel = library.getModifiableModel();
                        for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
                            String[] stringArray = modifiableModel.getUrls(orderRootType);
                            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(stringArray));
                            if (linkedHashSet.size() == stringArray.length) continue;
                            for (String string : stringArray) {
                                modifiableModel.removeRoot(string, orderRootType);
                            }
                            for (String string : linkedHashSet) {
                                modifiableModel.addRoot(string, orderRootType);
                            }
                        }
                        modifiableModel.commit();
                    }
                });
                String string = list2.size() == 1 ? "'" + LibraryUtil.getPresentableName((Library)((Library)list2.iterator().next())) + "' library" : list2.size() + " libraries";
                Notifications.Bus.notify((Notification)new Notification("Repository", "Repository libraries cleanup", "Duplicated URLs were removed from " + string + ". These duplicated URLs were produced due to a bug in a previous " + ApplicationNamesInfo.getInstance().getFullProductName() + " version and might cause performance issues.", NotificationType.INFORMATION), (Project)project2);
            }, project2.getDisposed());
        }
    }

    private static boolean a(Library library) {
        for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
            Object[] objectArray = library.getUrls(orderRootType);
            if (objectArray.length == ContainerUtil.set((Object[])objectArray).size()) continue;
            return true;
        }
        return false;
    }

    public void runActivity(final @NotNull Project project2) {
        if (project2 == null) {
            RepositoryLibrarySynchronizer.a(3);
        }
        final Runnable runnable = () -> {
            if (project2 == null) {
                RepositoryLibrarySynchronizer.a(5);
            }
            Set<Library> set = RepositoryLibrarySynchronizer.collectLibraries(project2, (Predicate<? super Library>)((Predicate)library -> {
                if (library instanceof LibraryEx) {
                    LibraryEx libraryEx = (LibraryEx)library;
                    return libraryEx.getProperties() instanceof RepositoryLibraryProperties && RepositoryLibrarySynchronizer.a(libraryEx, (RepositoryLibraryProperties)libraryEx.getProperties());
                }
                return false;
            }));
            ApplicationManager.getApplication().invokeLater((Runnable)((DumbAwareRunnable)() -> {
                if (project2 == null) {
                    RepositoryLibrarySynchronizer.a(6);
                }
                for (Library library : set) {
                    if (!LibraryTableImplUtil.isValidLibrary((Library)library)) continue;
                    RepositoryUtils.reloadDependencies(project2, (LibraryEx)library);
                }
            }), project2.getDisposed());
        };
        project2.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){
            private final Alarm a;
            private static final long b = lb.a(1231509590702103016L, 8276403114793897724L, MethodHandles.lookup().lookupClass()).a(58974603213441L);
            {
                this.a = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project2);
            }

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.a(0);
                }
                if (!this.a.isDisposed() && event.getSource() instanceof Project) {
                    this.a.cancelAllRequests();
                    this.a.addRequest(runnable, 300L);
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = b ^ 0x7DD34846833BL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/jarRepository/RepositoryLibrarySynchronizer$1", "rootsChanged"));
            }
        });
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (project2 == null) {
                    RepositoryLibrarySynchronizer.a(4);
                }
                RepositoryLibrarySynchronizer.b(project2);
                runnable.run();
            });
        }
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x4AD66EF58928L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jarRepository/RepositoryLibrarySynchronizer";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectLibraries";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeDuplicatedUrlsFromRepositoryLibraries";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$runActivity$8";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$runActivity$7";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$6";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$removeDuplicatedUrlsFromRepositoryLibraries$4";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$collectLibraries$1";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

