/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import b.a.lb;
import com.intellij.CommonBundle;
import com.intellij.jarRepository.RemoteRepositoriesConfiguration;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.jarRepository.RepositoryAttachDialog;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.jarRepository.services.MavenRepositoryServicesManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.transfer.RepositoryOfflineException;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.version.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.aether.ArtifactDependencyNode;
import org.jetbrains.idea.maven.aether.ArtifactKind;
import org.jetbrains.idea.maven.aether.ArtifactRepositoryManager;
import org.jetbrains.idea.maven.aether.ProgressConsumer;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

public class JarRepositoryManager {
    private static final Logger e;
    private static final String b = "$MAVEN_REPOSITORY$";
    private static final String f = ".m2/repository";
    private static final AtomicInteger a;
    private static final Map<String, OrderRootType> c;
    private static volatile File d;
    private static final long g;

    public static boolean hasRunningTasks() {
        return a.get() > 0;
    }

    @Nullable
    public static NewLibraryConfiguration chooseLibraryAndDownload(@NotNull Project project2, @Nullable String initialFilter, JComponent parentComponent) {
        NewLibraryConfiguration newLibraryConfiguration;
        RepositoryAttachDialog repositoryAttachDialog;
        long l2 = g ^ 0x5A2D404821FBL;
        if (project2 == null) {
            JarRepositoryManager.a(0);
        }
        if (!(repositoryAttachDialog = new RepositoryAttachDialog(project2, initialFilter, RepositoryAttachDialog.Mode.DOWNLOAD)).showAndGet()) {
            return null;
        }
        String string = repositoryAttachDialog.getCoordinateText();
        boolean bl2 = repositoryAttachDialog.getAttachSources();
        boolean bl3 = repositoryAttachDialog.getAttachJavaDoc();
        boolean bl4 = repositoryAttachDialog.getAttachExternalAnnotations();
        boolean bl5 = repositoryAttachDialog.getIncludeTransitiveDependencies();
        String string2 = repositoryAttachDialog.getDirectoryPath();
        EnumSet<ArtifactKind> enumSet = JarRepositoryManager.kindsOf(bl2, bl3, new String[0]);
        if (bl4) {
            enumSet.add(ArtifactKind.ANNOTATIONS);
        }
        if ((newLibraryConfiguration = JarRepositoryManager.a(project2, string, enumSet, bl5, string2, RemoteRepositoriesConfiguration.getInstance((Project)project2).getRepositories())) == null) {
            Messages.showErrorDialog((Component)parentComponent, (String)("No files were downloaded for " + string), (String)CommonBundle.getErrorTitle());
        }
        return newLibraryConfiguration;
    }

    private static NewLibraryConfiguration a(Project project2, String string, EnumSet<ArtifactKind> enumSet, boolean bl2, String string2, Collection<RemoteRepositoryDescription> collection) {
        ArtifactKind artifactKind2;
        long l2 = g ^ 0x1E4C36829E7EL;
        String string3 = "jar";
        for (ArtifactKind artifactKind2 : enumSet) {
            if (!artifactKind2.getClassifier().isEmpty()) continue;
            string3 = artifactKind2.getExtension();
            break;
        }
        RepositoryLibraryProperties repositoryLibraryProperties = new RepositoryLibraryProperties(string, string3, bl2);
        artifactKind2 = repositoryLibraryProperties.getRepositoryLibraryDescriptor();
        ArrayList arrayList = ContainerUtil.newArrayList();
        if (artifactKind2.getMavenId() != null) {
            arrayList.addAll(JarRepositoryManager.loadDependenciesModal(project2, (JpsMavenRepositoryLibraryDescriptor)artifactKind2, enumSet, collection, string2));
        }
        if (!arrayList.isEmpty()) {
            JarRepositoryManager.a(project2, (Collection<OrderRoot>)arrayList);
            return JarRepositoryManager.createNewLibraryConfiguration(repositoryLibraryProperties, arrayList);
        }
        return null;
    }

    @Nullable
    public static NewLibraryConfiguration resolveAndDownload(@NotNull Project project2, String coord, boolean attachSources, boolean attachJavaDoc, boolean includeTransitiveDependencies, String copyTo, Collection<RemoteRepositoryDescription> repositories) {
        long l2 = g ^ 0x621ED13CD806L;
        if (project2 == null) {
            JarRepositoryManager.a(1);
        }
        return JarRepositoryManager.resolveAndDownload(project2, coord, attachSources, attachJavaDoc, "jar", includeTransitiveDependencies, copyTo, repositories);
    }

    @Nullable
    public static NewLibraryConfiguration resolveAndDownload(@NotNull Project project2, String coord, boolean attachSources, boolean attachJavaDoc, String packaging, boolean includeTransitiveDependencies, String copyTo, Collection<RemoteRepositoryDescription> repositories) {
        if (project2 == null) {
            JarRepositoryManager.a(2);
        }
        return JarRepositoryManager.a(project2, coord, JarRepositoryManager.kindsOf(attachSources, attachJavaDoc, packaging), includeTransitiveDependencies, copyTo, repositories);
    }

    @NotNull
    protected static NewLibraryConfiguration createNewLibraryConfiguration(RepositoryLibraryProperties props, final Collection<? extends OrderRoot> roots) {
        NewLibraryConfiguration newLibraryConfiguration = new NewLibraryConfiguration(RepositoryLibraryDescription.findDescription((RepositoryLibraryProperties)props).getDisplayName(props.getVersion()), RepositoryLibraryType.getInstance(), (LibraryProperties)props){
            private static final long a = lb.a(-8958062509810554408L, -8438892914622429820L, MethodHandles.lookup().lookupClass()).a(254535373788908L);

            public void addRoots(@NotNull LibraryEditor editor) {
                if (editor == null) {
                    1.a(0);
                }
                editor.addRoots(roots);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x3D8F781EE012L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/jarRepository/JarRepositoryManager$1", "addRoots"));
            }
        };
        if (newLibraryConfiguration == null) {
            JarRepositoryManager.a(3);
        }
        return newLibraryConfiguration;
    }

    @NotNull
    public static File getLocalRepositoryPath() {
        long l2 = g ^ 0x3E3554D99059L;
        File file = d;
        if (file != null) {
            File file2 = file;
            if (file2 == null) {
                JarRepositoryManager.a(4);
            }
            return file2;
        }
        String string = PathMacroManager.getInstance((ComponentManager)ApplicationManager.getApplication()).expandPath(b);
        if (!b.equals(string) && (file = new File(string)).exists()) {
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            d = file;
            File file3 = file;
            if (file3 == null) {
                JarRepositoryManager.a(5);
            }
            return file3;
        }
        String string2 = System.getProperty("user.home", null);
        d = file = string2 != null ? new File(string2, f) : new File(f);
        File file4 = file;
        if (file4 == null) {
            JarRepositoryManager.a(6);
        }
        return file4;
    }

    static void setLocalRepositoryPath(File localRepo) {
        d = localRepo;
    }

    public static Collection<OrderRoot> loadDependenciesModal(@NotNull Project project2, @NotNull RepositoryLibraryProperties libraryProps, boolean loadSources, boolean loadJavadoc, @Nullable String copyTo, @Nullable Collection<RemoteRepositoryDescription> repositories) {
        JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor;
        if (project2 == null) {
            JarRepositoryManager.a(7);
        }
        if (libraryProps == null) {
            JarRepositoryManager.a(8);
        }
        if ((jpsMavenRepositoryLibraryDescriptor = libraryProps.getRepositoryLibraryDescriptor()).getMavenId() != null) {
            EnumSet<ArtifactKind> enumSet = JarRepositoryManager.kindsOf(loadSources, loadJavadoc, libraryProps.getPackaging());
            return JarRepositoryManager.loadDependenciesModal(project2, jpsMavenRepositoryLibraryDescriptor, enumSet, repositories, copyTo);
        }
        return Collections.emptyList();
    }

    public static Collection<OrderRoot> loadDependenciesModal(@NotNull Project project2, @NotNull JpsMavenRepositoryLibraryDescriptor desc, Set<ArtifactKind> artifactKinds, @Nullable Collection<RemoteRepositoryDescription> repositories, @Nullable String copyTo) {
        long l2 = g ^ 0x47E51F58BDD1L;
        if (project2 == null) {
            JarRepositoryManager.a(9);
        }
        if (desc == null) {
            JarRepositoryManager.a(10);
        }
        Collection<RemoteRepositoryDescription> collection = JarRepositoryManager.addDefaultsIfEmpty(project2, repositories);
        return JarRepositoryManager.a(project2, "Resolving Maven dependencies...", JarRepositoryManager.a(desc, artifactKinds, collection, copyTo));
    }

    public static Promise<List<OrderRoot>> loadDependenciesAsync(@NotNull Project project2, RepositoryLibraryProperties libraryProps, boolean loadSources, boolean loadJavadoc, @Nullable List<RemoteRepositoryDescription> repos, @Nullable String copyTo) {
        if (project2 == null) {
            JarRepositoryManager.a(11);
        }
        EnumSet<ArtifactKind> enumSet = JarRepositoryManager.kindsOf(loadSources, loadJavadoc, libraryProps.getPackaging());
        return JarRepositoryManager.loadDependenciesAsync(project2, libraryProps.getRepositoryLibraryDescriptor(), enumSet, repos, copyTo);
    }

    public static Promise<List<OrderRoot>> loadDependenciesAsync(@NotNull Project project2, JpsMavenRepositoryLibraryDescriptor desc, Set<ArtifactKind> artifactKinds, @Nullable List<RemoteRepositoryDescription> repos, @Nullable String copyTo) {
        long l2 = g ^ 0xC6434FD1330L;
        if (project2 == null) {
            JarRepositoryManager.a(12);
        }
        Collection<RemoteRepositoryDescription> collection = JarRepositoryManager.addDefaultsIfEmpty(project2, repos);
        return JarRepositoryManager.b(project2, "Resolving Maven dependencies...", JarRepositoryManager.a(desc, artifactKinds, collection, copyTo));
    }

    @Nullable
    public static List<OrderRoot> loadDependenciesSync(@NotNull Project project2, JpsMavenRepositoryLibraryDescriptor desc, Set<ArtifactKind> artifactKinds, @Nullable List<RemoteRepositoryDescription> repos, @Nullable String copyTo) {
        long l2 = g ^ 0x1985F5E766F5L;
        if (project2 == null) {
            JarRepositoryManager.a(13);
        }
        Collection<RemoteRepositoryDescription> collection = JarRepositoryManager.addDefaultsIfEmpty(project2, repos);
        return JarRepositoryManager.c(project2, "Resolving Maven dependencies...", JarRepositoryManager.a(desc, artifactKinds, collection, copyTo));
    }

    @NotNull
    protected static Collection<RemoteRepositoryDescription> addDefaultsIfEmpty(@NotNull Project project2, @Nullable Collection<RemoteRepositoryDescription> repositories) {
        if (project2 == null) {
            JarRepositoryManager.a(14);
        }
        if (repositories == null || repositories.isEmpty()) {
            repositories = RemoteRepositoriesConfiguration.getInstance((Project)project2).getRepositories();
        }
        List list2 = repositories;
        if (list2 == null) {
            JarRepositoryManager.a(15);
        }
        return list2;
    }

    protected static EnumSet<ArtifactKind> kindsOf(boolean loadSources, boolean loadJavadoc, String ... artifactPackaging) {
        EnumSet enumSet = ArtifactKind.kindsOf((boolean)loadSources, (boolean)loadJavadoc);
        if (artifactPackaging.length == 0) {
            enumSet.add(ArtifactKind.ARTIFACT);
        } else {
            for (String string : artifactPackaging) {
                ArtifactKind artifactKind = ArtifactKind.find((String)ArtifactKind.ARTIFACT.getClassifier(), (String)string);
                if (artifactKind == null) continue;
                enumSet.add(artifactKind);
            }
        }
        return enumSet;
    }

    @NotNull
    public static Promise<Collection<String>> getAvailableVersions(Project project2, RepositoryLibraryDescription libraryDescription) {
        long l2 = g ^ 0x71150638EE11L;
        List list2 = RemoteRepositoriesConfiguration.getInstance((Project)project2).getRepositories();
        Promise<Collection<String>> promise = JarRepositoryManager.b(project2, "Looking up available versions for " + libraryDescription.getDisplayName(), new VersionResolveJob(libraryDescription, list2));
        if (promise == null) {
            JarRepositoryManager.a(16);
        }
        return promise;
    }

    @Nullable
    public static ArtifactDependencyNode loadDependenciesTree(final @NotNull RepositoryLibraryDescription description, final @NotNull String version, Project project2) {
        long l2 = g ^ 0x27D65131B7C8L;
        if (description == null) {
            JarRepositoryManager.a(17);
        }
        if (version == null) {
            JarRepositoryManager.a(18);
        }
        List list2 = RemoteRepositoriesConfiguration.getInstance((Project)project2).getRepositories();
        return JarRepositoryManager.a(project2, "Resolving Maven Dependencies", new AetherJob<ArtifactDependencyNode>((Collection)list2){
            private static final long b = lb.a(-3733929710452669995L, -2549646037251250282L, MethodHandles.lookup().lookupClass()).a(82268651338250L);

            @Override
            protected String getProgressText() {
                long l2 = b ^ 0x9BD8CE96B4DL;
                return "Loading dependencies of " + description.getMavenCoordinates(version);
            }

            @Override
            protected ArtifactDependencyNode perform(ProgressIndicator progress, ArtifactRepositoryManager manager) throws Exception {
                return manager.collectDependencies(description.getGroupId(), description.getArtifactId(), version);
            }

            @Override
            protected ArtifactDependencyNode getDefaultResult() {
                return null;
            }
        });
    }

    private static void a(Project project2, Collection<OrderRoot> collection) {
        long l2 = g ^ 0x5860793E1673L;
        StringBuilder stringBuilder = new StringBuilder();
        String string = "The following files were downloaded:";
        stringBuilder.append("<ol>");
        for (OrderRoot orderRoot : collection) {
            stringBuilder.append("<li>");
            stringBuilder.append(orderRoot.getFile().getName());
            stringBuilder.append("</li>");
        }
        stringBuilder.append("</ol>");
        Notifications.Bus.notify((Notification)new Notification("Repository", "The following files were downloaded:", stringBuilder.toString(), NotificationType.INFORMATION), (Project)project2);
    }

    public static void searchArtifacts(Project project2, String coord, Consumer<? super Collection<Pair<RepositoryArtifactDescription, RemoteRepositoryDescription>>> resultProcessor) {
        long l2 = g ^ 0x5D9561DE062BL;
        JarRepositoryManager.searchArtifacts(project2, coord, "jar", resultProcessor);
    }

    public static void searchArtifacts(final Project project2, String coord, String packaging, final Consumer<? super Collection<Pair<RepositoryArtifactDescription, RemoteRepositoryDescription>>> resultProcessor) {
        long l2 = g ^ 0x4B2C15DB96A8L;
        if (coord == null || coord.length() == 0) {
            return;
        }
        final RepositoryArtifactDescription repositoryArtifactDescription = coord.indexOf(58) == -1 && Character.isUpperCase(coord.charAt(0)) ? new RepositoryArtifactDescription(null, null, null, packaging, null, coord, null) : new RepositoryArtifactDescription(new RepositoryLibraryProperties(coord, packaging, true), null);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, "Maven", false){
            private static final long a = lb.a(-4475095377502242373L, -7085176686569244654L, MethodHandles.lookup().lookupClass()).a(121888841785324L);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.a(0);
                }
                ArrayList<Pair> arrayList = new ArrayList<Pair>();
                try {
                    for (String string : MavenRepositoryServicesManager.getServiceUrls((Project)project2)) {
                        try {
                            List list2 = MavenRepositoryServicesManager.findArtifacts((RepositoryArtifactDescription)repositoryArtifactDescription, (String)string);
                            if (list2.isEmpty()) continue;
                            List list3 = MavenRepositoryServicesManager.getRepositories((String)string);
                            THashMap tHashMap = new THashMap();
                            for (RemoteRepositoryDescription remoteRepositoryDescription : list3) {
                                tHashMap.put(remoteRepositoryDescription.getId(), remoteRepositoryDescription);
                            }
                            for (RemoteRepositoryDescription remoteRepositoryDescription : list2) {
                                RemoteRepositoryDescription remoteRepositoryDescription2 = (RemoteRepositoryDescription)tHashMap.get(remoteRepositoryDescription.getRepositoryId());
                                if (remoteRepositoryDescription2 == null) continue;
                                arrayList.add(Pair.create((Object)remoteRepositoryDescription, (Object)remoteRepositoryDescription2));
                            }
                        }
                        catch (Exception exception) {
                            e.error((Throwable)exception);
                        }
                    }
                }
                finally {
                    ApplicationManager.getApplication().invokeLater(() -> resultProcessor.accept(arrayList));
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x73390932C01BL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarRepository/JarRepositoryManager$3", "run"));
            }
        });
    }

    public static void searchRepositories(Project project2, final Collection<String> serviceUrls, final Processor<? super Collection<RemoteRepositoryDescription>> resultProcessor) {
        long l2 = g ^ 0x72548E4E468AL;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, "Maven", false){
            private static final long a = lb.a(8592645342221861996L, 6388422456921012879L, MethodHandles.lookup().lookupClass()).a(64040644593399L);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                long l2 = a ^ 0x42D03389CFF6L;
                if (indicator == null) {
                    4.a(0);
                }
                Ref ref = Ref.create(Collections.emptyList());
                try {
                    ArrayList arrayList = new ArrayList();
                    for (String string : serviceUrls) {
                        List list2;
                        try {
                            list2 = MavenRepositoryServicesManager.getRepositories((String)string);
                        }
                        catch (Exception exception) {
                            e.warn("Accessing Service at: " + string, (Throwable)exception);
                            continue;
                        }
                        arrayList.addAll(list2);
                    }
                    ref.set(arrayList);
                }
                catch (Exception exception) {
                    e.error((Throwable)exception);
                }
                finally {
                    ApplicationManager.getApplication().invokeLater(() -> resultProcessor.process(ref.get()));
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x3E5BE68747D0L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarRepository/JarRepositoryManager$4", "run"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static <T> T c(@Nullable Project project2, String string, Function<? super ProgressIndicator, ? extends T> function) {
        try {
            a.incrementAndGet();
            EmptyProgressIndicator emptyProgressIndicator = new EmptyProgressIndicator(ModalityState.defaultModalityState());
            Object object = ProgressManager.getInstance().runProcess(() -> JarRepositoryManager.b(function, (ProgressIndicator)emptyProgressIndicator), (ProgressIndicator)emptyProgressIndicator);
            return (T)object;
        }
        finally {
            a.decrementAndGet();
        }
    }

    @Nullable
    private static <T> T a(@Nullable Project project2, String string, final Function<? super ProgressIndicator, ? extends T> function) {
        final Ref ref = Ref.create(null);
        new Task.Modal(project2, string, true){
            private static final long a = lb.a(6087715421543073763L, 883828321929772070L, MethodHandles.lookup().lookupClass()).a(206312076477859L);

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.a(0);
                }
                try {
                    a.incrementAndGet();
                    ref.set(function.apply(indicator));
                }
                finally {
                    a.decrementAndGet();
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x2BBFF63CDE96L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarRepository/JarRepositoryManager$5", "run"));
            }
        }.queue();
        return (T)ref.get();
    }

    private static <T> Promise<T> b(@Nullable Project project2, String string, Function<? super ProgressIndicator, ? extends T> function) {
        ModalityState modalityState = ModalityState.defaultModalityState();
        AsyncPromise asyncPromise = new AsyncPromise();
        JobExecutor.INSTANCE.submit(() -> {
            try {
                a.incrementAndGet();
                EmptyProgressIndicator emptyProgressIndicator = new EmptyProgressIndicator(modalityState);
                Object object = ProgressManager.getInstance().runProcess(() -> JarRepositoryManager.a(function, (ProgressIndicator)emptyProgressIndicator), (ProgressIndicator)emptyProgressIndicator);
                asyncPromise.setResult(object);
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable throwable) {
                e.info(throwable);
                asyncPromise.setError(throwable);
            }
            finally {
                a.decrementAndGet();
            }
        });
        return asyncPromise;
    }

    private static Collection<String> a(String string, String string2, ArtifactRepositoryManager artifactRepositoryManager) throws Exception {
        long l2 = g ^ 0x5697685EAABDL;
        try {
            List list2 = artifactRepositoryManager.getAvailableVersions(string, string2, "[0,)", ArtifactKind.ARTIFACT);
            return list2.stream().sorted(Comparator.reverseOrder()).map(Version::toString).collect(Collectors.toCollection(() -> new ArrayList(list2.size())));
        }
        catch (TransferCancelledException transferCancelledException) {
            throw new ProcessCanceledException((Throwable)transferCancelledException);
        }
    }

    private static Function<ProgressIndicator, List<OrderRoot>> a(@NotNull JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor, @NotNull Set<ArtifactKind> set, @NotNull Collection<RemoteRepositoryDescription> collection2, @Nullable String string) {
        if (jpsMavenRepositoryLibraryDescriptor == null) {
            JarRepositoryManager.a(19);
        }
        if (set == null) {
            JarRepositoryManager.a(20);
        }
        if (collection2 == null) {
            JarRepositoryManager.a(21);
        }
        return new LibraryResolveJob(jpsMavenRepositoryLibraryDescriptor, set, collection2).andThen(collection -> collection.isEmpty() ? Collections.emptyList() : (List)WriteAction.computeAndWait(() -> JarRepositoryManager.a(collection, string)));
    }

    private static List<OrderRoot> a(@NotNull Collection<? extends Artifact> collection, @Nullable String string) {
        if (collection == null) {
            JarRepositoryManager.a(22);
        }
        ArrayList<OrderRoot> arrayList = new ArrayList<OrderRoot>();
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        for (Artifact artifact : collection) {
            try {
                File file;
                File file2 = file = artifact.getFile();
                if (string != null) {
                    file2 = new File(string, file.getName());
                    if (file.exists()) {
                        FileUtil.copy((File)file, (File)file2);
                    }
                }
                virtualFileManager.refreshAndFindFileByUrl(VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)file2.getPath())));
                String string2 = VfsUtil.getUrlForLibraryRoot((File)file2);
                VirtualFile virtualFile = virtualFileManager.refreshAndFindFileByUrl(string2);
                if (virtualFile == null) continue;
                OrderRootType orderRootType = c.getOrDefault(artifact.getClassifier(), OrderRootType.CLASSES);
                arrayList.add(new OrderRoot(virtualFile, orderRootType));
            }
            catch (IOException iOException) {
                e.warn((Throwable)iOException);
            }
        }
        return arrayList;
    }

    private static /* synthetic */ Object a(Function function, ProgressIndicator progressIndicator) {
        return function.apply(progressIndicator);
    }

    private static /* synthetic */ Object b(Function function, ProgressIndicator progressIndicator) {
        return function.apply(progressIndicator);
    }

    static {
        g = lb.a(-1008263484321553492L, -2177991844875435132L, MethodHandles.lookup().lookupClass()).a(237533993041493L);
        long l2 = g ^ 0x4D7024E11B49L;
        e = Logger.getInstance((String)"#org.jetbrains.idea.maven.utils.library.RepositoryAttachHandler");
        a = new AtomicInteger();
        c = new HashMap<String, OrderRootType>();
        c.put(ArtifactKind.ARTIFACT.getClassifier(), OrderRootType.CLASSES);
        c.put(ArtifactKind.JAVADOC.getClassifier(), JavadocOrderRootType.getInstance());
        c.put(ArtifactKind.SOURCES.getClassifier(), OrderRootType.SOURCES);
        c.put(ArtifactKind.ANNOTATIONS.getClassifier(), AnnotationOrderRootType.getInstance());
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = g ^ 0x536147967C5L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 16: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarRepository/JarRepositoryManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryProps";
                break;
            }
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarRepository/JarRepositoryManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewLibraryConfiguration";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalRepositoryPath";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "addDefaultsIfEmpty";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableVersions";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "chooseLibraryAndDownload";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveAndDownload";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 16: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadDependenciesModal";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadDependenciesAsync";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadDependenciesSync";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addDefaultsIfEmpty";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadDependenciesTree";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "newOrderRootResolveJob";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class VersionResolveJob
    extends AetherJob<Collection<String>> {
        @NotNull
        private final RepositoryLibraryDescription b;
        private static final long c = lb.a(-1525970351173699750L, 6938993523649553821L, MethodHandles.lookup().lookupClass()).a(91635009576514L);

        VersionResolveJob(@NotNull RepositoryLibraryDescription repositoryLibraryDescription, @NotNull List<RemoteRepositoryDescription> repositories) {
            if (repositoryLibraryDescription == null) {
                VersionResolveJob.b(0);
            }
            if (repositories == null) {
                VersionResolveJob.b(1);
            }
            super(repositories);
            this.b = repositoryLibraryDescription;
        }

        @Override
        protected String getProgressText() {
            long l2 = c ^ 0x29E86A7E64A2L;
            return "Loading " + this.b.getDisplayName() + " versions";
        }

        @Override
        protected Collection<String> perform(ProgressIndicator progress, ArtifactRepositoryManager manager) throws Exception {
            return JarRepositoryManager.a(this.b.getGroupId(), this.b.getArtifactId(), manager);
        }

        @Override
        protected Collection<String> getDefaultResult() {
            return Collections.emptyList();
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            long l2 = c ^ 0x5549B0E378EDL;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repositoryLibraryDescription";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repositories";
                    break;
                }
            }
            objectArray[1] = "com/intellij/jarRepository/JarRepositoryManager$VersionResolveJob";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LibraryResolveJob
    extends AetherJob<Collection<Artifact>> {
        @NotNull
        private final JpsMavenRepositoryLibraryDescriptor b;
        @NotNull
        private final Set<ArtifactKind> c;
        private static final long e = lb.a(-3044027741835162650L, -2440270751716930588L, MethodHandles.lookup().lookupClass()).a(251998417465483L);

        LibraryResolveJob(@NotNull JpsMavenRepositoryLibraryDescriptor desc, @NotNull Set<ArtifactKind> kinds, @NotNull Collection<RemoteRepositoryDescription> repositories) {
            if (desc == null) {
                LibraryResolveJob.b(0);
            }
            if (kinds == null) {
                LibraryResolveJob.b(1);
            }
            if (repositories == null) {
                LibraryResolveJob.b(2);
            }
            super(repositories);
            this.b = desc;
            this.c = kinds;
        }

        @Override
        protected boolean canStart() {
            return super.canStart() && this.b.getMavenId() != null;
        }

        @Override
        protected String getProgressText() {
            long l2 = e ^ 0x2500BA42C0AFL;
            return "Loading " + RepositoryLibraryDescription.findDescription((JpsMavenRepositoryLibraryDescriptor)this.b).getDisplayName();
        }

        @Override
        protected Collection<Artifact> getDefaultResult() {
            return Collections.emptyList();
        }

        @Override
        protected Collection<Artifact> perform(ProgressIndicator progress, ArtifactRepositoryManager manager) throws Exception {
            String string = this.b.getVersion();
            try {
                return manager.resolveDependencyAsArtifact(this.b.getGroupId(), this.b.getArtifactId(), string, this.c, this.b.isIncludeTransitiveDependencies(), this.b.getExcludedDependencies());
            }
            catch (TransferCancelledException transferCancelledException) {
                throw new ProcessCanceledException((Throwable)transferCancelledException);
            }
            catch (RepositoryOfflineException repositoryOfflineException) {
                throw repositoryOfflineException;
            }
            catch (Exception exception) {
                String string2 = this.a(manager, string);
                if (Comparing.equal((String)string, (String)string2)) {
                    throw exception;
                }
                try {
                    return manager.resolveDependencyAsArtifact(this.b.getGroupId(), this.b.getArtifactId(), string2, this.c, this.b.isIncludeTransitiveDependencies(), this.b.getExcludedDependencies());
                }
                catch (TransferCancelledException transferCancelledException) {
                    throw new ProcessCanceledException((Throwable)transferCancelledException);
                }
            }
        }

        @Nullable
        private String a(ArtifactRepositoryManager artifactRepositoryManager, String string) throws Exception {
            long l2 = e ^ 0x6D755289ED40L;
            boolean bl2 = "LATEST".equals(string);
            boolean bl3 = "RELEASE".equals(string);
            if (bl2 || bl3) {
                try {
                    for (String string2 : JarRepositoryManager.a(this.b.getGroupId(), this.b.getArtifactId(), artifactRepositoryManager)) {
                        if (bl3 && string2.endsWith("-SNAPSHOT")) continue;
                        return string2;
                    }
                }
                catch (InterruptedException | ExecutionException exception) {
                    e.error("Got unexpected exception while resolving artifact versions", (Throwable)exception);
                }
            }
            return string;
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            long l2 = e ^ 0x72D49CCCCAA8L;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "desc";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kinds";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repositories";
                    break;
                }
            }
            objectArray[1] = "com/intellij/jarRepository/JarRepositoryManager$LibraryResolveJob";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class AetherJob<T>
    implements Function<ProgressIndicator, T> {
        @NotNull
        private final Collection<? extends RemoteRepositoryDescription> a;
        private static final long d = lb.a(6912420897367234679L, -4408416635701741672L, MethodHandles.lookup().lookupClass()).a(232899660328667L);

        AetherJob(@NotNull Collection<? extends RemoteRepositoryDescription> repositories) {
            if (repositories == null) {
                AetherJob.a(0);
            }
            this.a = repositories;
        }

        protected boolean canStart() {
            return !this.a.isEmpty();
        }

        @Override
        public final T apply(final ProgressIndicator indicator) {
            if (this.canStart()) {
                indicator.setText(this.getProgressText());
                indicator.setIndeterminate(true);
                ArrayList<RemoteRepository> arrayList = new ArrayList<RemoteRepository>();
                for (RemoteRepositoryDescription remoteRepositoryDescription : this.a) {
                    arrayList.add(ArtifactRepositoryManager.createRemoteRepository((String)remoteRepositoryDescription.getId(), (String)remoteRepositoryDescription.getUrl()));
                }
                try {
                    return this.perform(indicator, new ArtifactRepositoryManager(JarRepositoryManager.getLocalRepositoryPath(), arrayList, new ProgressConsumer(){

                        public void consume(String message) {
                            indicator.setText(message);
                        }

                        public boolean isCanceled() {
                            return indicator.isCanceled();
                        }
                    }));
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw processCanceledException;
                }
                catch (Exception exception) {
                    e.info((Throwable)exception);
                }
            }
            return this.getDefaultResult();
        }

        protected abstract String getProgressText();

        protected abstract T perform(ProgressIndicator var1, ArtifactRepositoryManager var2) throws Exception;

        protected abstract T getDefaultResult();

        private static /* synthetic */ void a(int n2) {
            long l2 = d ^ 0x1836BA2F8F73L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "com/intellij/jarRepository/JarRepositoryManager$AetherJob", "<init>"));
        }
    }

    private static class JobExecutor {
        static final ExecutorService INSTANCE;

        private JobExecutor() {
        }

        static {
            long l2 = lb.a(2844367258782278372L, -3525286812480030217L, MethodHandles.lookup().lookupClass()).a(236062293707269L) ^ 0x3100F50EBEF6L;
            INSTANCE = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"RemoteLibraryDownloader");
        }
    }
}

