/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarFinder;

import b.a.lb;
import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAttachSourceProvider
implements AttachSourcesProvider {
    private static final Logger a;
    private static final long d;

    @Nullable
    protected static VirtualFile getJarByPsiFile(@Nullable PsiFile psiFile) {
        VirtualFileSystem virtualFileSystem;
        VirtualFile virtualFile;
        if (psiFile != null && (virtualFile = psiFile.getVirtualFile()) != null && (virtualFileSystem = virtualFile.getFileSystem()) instanceof JarFileSystem) {
            return ((JarFileSystem)virtualFileSystem).getLocalByEntry(virtualFile);
        }
        return null;
    }

    @Nullable
    protected static Library getLibraryFromOrderEntriesList(List<? extends LibraryOrderEntry> orderEntries) {
        if (orderEntries.isEmpty()) {
            return null;
        }
        Library library = orderEntries.get(0).getLibrary();
        if (library == null) {
            return null;
        }
        for (int i10 = 1; i10 < orderEntries.size(); ++i10) {
            if (library.equals(orderEntries.get(i10).getLibrary())) continue;
            return null;
        }
        return library;
    }

    protected void addSourceFile(@Nullable VirtualFile jarRoot, @NotNull Library library) {
        if (library == null) {
            AbstractAttachSourceProvider.a(0);
        }
        if (jarRoot != null && !Arrays.asList(library.getFiles(OrderRootType.SOURCES)).contains(jarRoot)) {
            Library.ModifiableModel modifiableModel = library.getModifiableModel();
            modifiableModel.addRoot(jarRoot, OrderRootType.SOURCES);
            modifiableModel.commit();
        }
    }

    static {
        d = lb.a(-825934903417003160L, -3112087549967548741L, MethodHandles.lookup().lookupClass()).a(139968276413848L);
        a = Logger.getInstance(AbstractAttachSourceProvider.class);
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = d ^ 0x6AB579E410FDL;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/jarFinder/AbstractAttachSourceProvider", "addSourceFile"));
    }

    protected static abstract class DownloadSourcesAction
    implements AttachSourcesProvider.AttachSourcesAction {
        protected final Project myProject;
        protected final String myUrl;
        protected final String myMessageGroupId;
        private static final long a = lb.a(-5462345331003947151L, -9000261021851931619L, MethodHandles.lookup().lookupClass()).a(27197922868764L);

        public DownloadSourcesAction(Project project2, String messageGroupId, String url) {
            this.myProject = project2;
            this.myUrl = url;
            this.myMessageGroupId = messageGroupId;
        }

        public String getName() {
            long l2 = a ^ 0x37C6EEEC60C3L;
            return "Download Sources";
        }

        public String getBusyText() {
            long l2 = a ^ 0xBB3F8194A9EL;
            return "Downloading Sources...";
        }

        protected abstract void storeFile(byte[] var1);

        public ActionCallback perform(List<LibraryOrderEntry> orderEntriesContainingFile) {
            long l2 = a ^ 0x4F2CF617F890L;
            final ActionCallback actionCallback = new ActionCallback();
            Task.Backgroundable backgroundable = new Task.Backgroundable(this.myProject, "Downloading Sources", true){
                private static final long a = lb.a(8229436203247834974L, -1827333635037978038L, MethodHandles.lookup().lookupClass()).a(131005134774716L);

                public void run(@NotNull ProgressIndicator indicator) {
                    byte[] byArray;
                    long l2 = a ^ 0x626FAB48DBE6L;
                    if (indicator == null) {
                        1.a(0);
                    }
                    try {
                        a.info("Downloading sources JAR: " + myUrl);
                        indicator.checkCanceled();
                        byArray = HttpRequests.request((String)myUrl).readBytes(indicator);
                    }
                    catch (IOException iOException) {
                        a.warn((Throwable)iOException);
                        ApplicationManager.getApplication().invokeLater(() -> {
                            long l2 = a ^ 0x140BCD77762BL;
                            String string = "Failed to download sources: " + myUrl;
                            new Notification(myMessageGroupId, "Downloading failed", string, NotificationType.ERROR).notify(this.getProject());
                            actionCallback.setDone();
                        });
                        return;
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        try {
                            WriteAction.run(() -> this.storeFile(byArray));
                        }
                        finally {
                            actionCallback.setDone();
                        }
                    });
                }

                public void onCancel() {
                    actionCallback.setRejected();
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x121FE1809650L;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarFinder/AbstractAttachSourceProvider$DownloadSourcesAction$1", "run"));
                }
            };
            backgroundable.queue();
            return actionCallback;
        }
    }

    protected class AttachExistingSourceAction
    implements AttachSourcesProvider.AttachSourcesAction {
        private final String c;
        private final VirtualFile b;
        private final Library a;

        public AttachExistingSourceAction(VirtualFile srcFile, Library library, String actionName) {
            this.b = srcFile;
            this.a = library;
            this.c = actionName;
        }

        public String getName() {
            return this.c;
        }

        public String getBusyText() {
            return this.getName();
        }

        public ActionCallback perform(List<LibraryOrderEntry> orderEntriesContainingFile) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            ActionCallback actionCallback = new ActionCallback();
            actionCallback.setDone();
            if (!this.b.isValid()) {
                return actionCallback;
            }
            if (this.a != AbstractAttachSourceProvider.getLibraryFromOrderEntriesList(orderEntriesContainingFile)) {
                return actionCallback;
            }
            WriteAction.run(() -> AbstractAttachSourceProvider.this.addSourceFile(this.b, this.a));
            return actionCallback;
        }
    }
}

