/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import b.a.lb;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.ide.util.projectWizard.JdkChooserPanel;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.JdkListConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.invoke.MethodHandles;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ProjectJdkForModuleStep
extends ModuleWizardStep {
    private final JdkChooserPanel a;
    private final JPanel f;
    private final WizardContext b;
    private final SdkType d;
    private final String e;
    private boolean g;
    private final JButton c;
    private static final long h = lb.a(-6593216554396435006L, 2020254902447211804L, MethodHandles.lookup().lookupClass()).a(220080081964740L);

    public ProjectJdkForModuleStep(WizardContext context, SdkType type) {
        this(context, type, null);
    }

    public ProjectJdkForModuleStep(final WizardContext context, final SdkType type, @Nullable @NonNls String helpId) {
        long l2 = h ^ 0x47431377E8DCL;
        this.g = false;
        this.b = context;
        this.d = type;
        this.e = helpId;
        this.a = new JdkChooserPanel(ProjectJdkForModuleStep.a(context, type));
        this.f = new JPanel(new GridBagLayout());
        this.f.setBorder(BorderFactory.createEtchedBorder());
        JLabel jLabel = new JLabel(IdeBundle.message((String)"prompt.please.select.module.jdk", (Object[])new Object[]{type.getPresentableName()}));
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        this.f.add((Component)jLabel, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)8, (int)10), 0, 0));
        JLabel jLabel2 = new JLabel(IdeBundle.message((String)"label.project.jdk", (Object[])new Object[0]));
        jLabel2.setFont(UIUtil.getLabelFont().deriveFont(1));
        this.f.add((Component)jLabel2, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        this.f.add((Component)this.a, new GridBagConstraints(0, -1, 1, 2, 1.0, 1.0, 18, 1, (Insets)JBUI.insets((int)2, (int)10, (int)10, (int)5), 0, 0));
        JButton jButton = new JButton(IdeBundle.message((String)"button.configure", (Object[])new Object[0]));
        this.f.add((Component)jButton, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insets((int)2, (int)0, (int)5, (int)5), 0, 0));
        this.c = new JButton("Set Default");
        this.c.setMnemonic('D');
        this.f.add((Component)this.c, new GridBagConstraints(1, -1, 1, 1, 0.0, 1.0, 18, 0, (Insets)JBUI.insets((int)2, (int)0, (int)10, (int)5), 0, 0));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                Project project2 = ProjectJdkForModuleStep.a(context, type);
                ProjectStructureConfigurable projectStructureConfigurable = ProjectStructureConfigurable.getInstance(project2);
                JdkListConfigurable jdkListConfigurable = JdkListConfigurable.getInstance(project2);
                ProjectSdksModel projectSdksModel = projectStructureConfigurable.getProjectJdksModel();
                boolean[] blArray = new boolean[1];
                projectSdksModel.reset(project2);
                projectSdksModel.doAdd((JComponent)ProjectJdkForModuleStep.this.f, type, sdk -> {
                    blArray[0] = jdkListConfigurable.addJdkNode((Sdk)sdk, false);
                    ProjectJdkForModuleStep.this.a.updateList((Sdk)sdk, type, projectSdksModel.getSdks());
                    if (!blArray[0]) {
                        try {
                            projectSdksModel.apply((MasterDetailsComponent)jdkListConfigurable);
                        }
                        catch (ConfigurationException configurationException) {
                            // empty catch block
                        }
                    }
                });
            }
        });
        final Project project2 = ProjectManagerEx.getInstanceEx().getDefaultProject();
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                Sdk sdk = ProjectJdkForModuleStep.this.getJdk();
                Runnable runnable = () -> ProjectRootManagerEx.getInstanceEx((Project)project2).setProjectSdk(sdk);
                ApplicationManager.getApplication().runWriteAction(runnable);
                ProjectJdkForModuleStep.this.c.setEnabled(false);
            }
        });
        this.a.addSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e10) {
                ProjectJdkForModuleStep.this.c.setEnabled(ProjectJdkForModuleStep.this.getJdk() != ProjectRootManagerEx.getInstanceEx((Project)project2).getProjectSdk());
            }
        });
    }

    @Nullable
    private static Project a(WizardContext wizardContext, SdkType sdkType) {
        Project project2 = wizardContext.getProject();
        if (sdkType != null && project2 == null) {
            project2 = ProjectManager.getInstance().getDefaultProject();
        }
        return project2;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.a.getPreferredFocusedComponent();
    }

    public String getHelpId() {
        return this.e;
    }

    public JComponent getComponent() {
        return this.f;
    }

    public void updateDataModel() {
        this.b.setProjectJdk(this.getJdk());
    }

    public void updateStep() {
        if (!this.g) {
            this.a.fillList(this.d, null);
            Sdk sdk = ProjectJdkForModuleStep.a(this.b);
            if (sdk != null) {
                this.a.selectJdk(sdk);
            }
            this.c.setEnabled(sdk != null);
            this.g = true;
        }
    }

    public Sdk getJdk() {
        return this.a.getChosenJdk();
    }

    public Object[] getAllJdks() {
        return this.a.getAllJdks();
    }

    public Icon getIcon() {
        return this.b.getStepIcon();
    }

    @Nullable
    private static Sdk a(WizardContext wizardContext) {
        Project project2 = ProjectManagerEx.getInstanceEx().getDefaultProject();
        Sdk sdk = ProjectRootManagerEx.getInstanceEx((Project)project2).getProjectSdk();
        if (sdk == null) {
            sdk = AddModuleWizard.getMostRecentSuitableSdk(wizardContext);
        }
        return sdk;
    }

    public boolean validate() {
        int n2;
        long l2 = h ^ 0x69B460A01976L;
        Sdk sdk = this.a.getChosenJdk();
        return sdk != null || (n2 = Messages.showOkCancelDialog((String)IdeBundle.message((String)"prompt.confirm.project.no.jdk", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.no.jdk.specified", (Object[])new Object[0]), (Icon)Messages.getWarningIcon())) == 0;
    }
}

