/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import b.a.lb;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.invoke.MethodHandles;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NotNull;

public class NamePathComponent
extends JPanel {
    private static final Logger h;
    private final JTextField i = new JTextField();
    private final JTextField g;
    private final JLabel b;
    private final FieldPanel d;
    private boolean c = false;
    private boolean e = false;
    private boolean a = true;
    private boolean f = true;
    private boolean j;
    private static final long k;

    public NamePathComponent(String nameLabelText, String pathLabelText, String pathChooserTitle, String pathChooserDescription) {
        this(nameLabelText, pathLabelText, pathChooserTitle, pathChooserDescription, true);
    }

    public NamePathComponent(String nameLabelText, String pathLabelText, String pathChooserTitle, String pathChooserDescription, boolean hideIgnored) {
        this(nameLabelText, pathLabelText, pathChooserTitle, pathChooserDescription, hideIgnored, true);
    }

    public NamePathComponent(String nameLabelText, String pathLabelText, String pathChooserTitle, String pathChooserDescription, boolean hideIgnored, boolean bold) {
        super(new GridBagLayout());
        this.i.setDocument(new NameFieldDocument());
        this.i.setPreferredSize(new Dimension(200, this.i.getPreferredSize().height));
        this.g = new JTextField();
        this.g.setDocument(new PathFieldDocument());
        this.g.setPreferredSize(new Dimension(200, this.g.getPreferredSize().height));
        this.b = new JLabel(nameLabelText);
        if (bold) {
            this.b.setFont(UIUtil.getLabelFont().deriveFont(1));
        }
        this.b.setLabelFor(this.i);
        FileChooserDescriptor fileChooserDescriptor = (FileChooserDescriptor)BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR.clone();
        fileChooserDescriptor.setHideIgnored(hideIgnored);
        BrowseFilesListener browseFilesListener = new BrowseFilesListener(this.g, pathChooserTitle, pathChooserDescription, fileChooserDescriptor){

            public void actionPerformed(ActionEvent e10) {
                super.actionPerformed(e10);
                NamePathComponent.this.e = true;
            }
        };
        this.d = new FieldPanel(this.g, null, null, (ActionListener)browseFilesListener, null);
        JLabel jLabel = new JLabel(pathLabelText);
        if (bold) {
            jLabel.setFont(UIUtil.getLabelFont().deriveFont(1));
        }
        jLabel.setLabelFor(this.g);
        this.add((Component)this.b, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insets((int)0, (int)0, (int)5, (int)4), 0, 0));
        this.add((Component)this.i, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insetsBottom((int)5), 0, 0));
        this.add((Component)jLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insets((int)0, (int)0, (int)5, (int)4), 0, 0));
        this.add((Component)this.d, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insetsBottom((int)5), 0, 0));
    }

    public static NamePathComponent initNamePathComponent(WizardContext context) {
        long l2 = k ^ 0x483FF759662L;
        NamePathComponent namePathComponent = new NamePathComponent(IdeBundle.message((String)"label.project.name", (Object[])new Object[0]), IdeBundle.message((String)"label.project.files.location", (Object[])new Object[0]), IdeBundle.message((String)"title.select.project.file.directory", (Object[])new Object[]{IdeBundle.message((String)"project.new.wizard.project.identification", (Object[])new Object[0])}), IdeBundle.message((String)"description.select.project.file.directory", (Object[])new Object[]{StringUtil.capitalize((String)IdeBundle.message((String)"project.new.wizard.project.identification", (Object[])new Object[0]))}), true, false);
        String string = context.getProjectFileDirectory();
        String string2 = context.getProjectName();
        String string3 = string2 != null ? string2 : ProjectWizardUtil.findNonExistingFileName(string, "untitled", "");
        namePathComponent.setPath(string2 == null ? string + File.separator + string3 : string);
        namePathComponent.setNameValue(string3);
        namePathComponent.getNameComponent().select(0, string3.length());
        return namePathComponent;
    }

    public boolean validateNameAndPath(WizardContext context, boolean defaultFormat) throws ConfigurationException {
        long l2 = k ^ 0x1BD2E4494BC4L;
        String string = this.getNameValue();
        if (StringUtil.isEmptyOrSpaces((String)string)) {
            ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
            throw new ConfigurationException(IdeBundle.message((String)"prompt.new.project.file.name", (Object[])new Object[]{applicationNamesInfo.getFullProductName(), context.getPresentationName()}));
        }
        String string2 = this.getPath();
        if (StringUtil.isEmptyOrSpaces((String)string2)) {
            throw new ConfigurationException(IdeBundle.message((String)"prompt.enter.project.file.location", (Object[])new Object[]{context.getPresentationName()}));
        }
        if (this.j && !new File(string2).isAbsolute()) {
            throw new ConfigurationException(StringUtil.capitalize((String)IdeBundle.message((String)"file.location.should.be.absolute", (Object[])new Object[]{context.getPresentationName()})));
        }
        boolean bl2 = this.isPathChangedByUser();
        String string3 = IdeBundle.message((String)"directory.project.file.directory", (Object[])new Object[]{context.getPresentationName()});
        if (!ProjectWizardUtil.createDirectoryIfNotExists(string3, string2, bl2)) {
            return false;
        }
        File file = new File(string2);
        if (file.exists() && !file.canWrite()) {
            throw new ConfigurationException(String.format("Directory '%s' is not seem to be writable. Please consider another location.", string2));
        }
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            if (!ProjectUtil.isSameProject((String)string2, (Project)project2)) continue;
            throw new ConfigurationException(String.format("Directory '%s' is already taken by the project '%s'. Please consider another location.", string2, project2.getName()));
        }
        boolean bl3 = true;
        String string4 = defaultFormat ? string + ".ipr" : ".idea";
        File file2 = new File(file, string4);
        if (file2.exists()) {
            string3 = IdeBundle.message((String)"prompt.overwrite.project.file", (Object[])new Object[]{file2.getAbsolutePath(), context.getPresentationName()});
            int n2 = Messages.showYesNoDialog((String)string3, (String)IdeBundle.message((String)"title.file.already.exists", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            bl3 = n2 == 0;
        }
        return bl3;
    }

    public String getNameValue() {
        return this.i.getText().trim();
    }

    public void setNameValue(String name2) {
        boolean bl2 = this.c;
        this.f = false;
        try {
            this.i.setText(name2);
        }
        finally {
            this.c = bl2;
            this.f = true;
        }
    }

    public String getPath() {
        String string = this.g.getText().trim();
        return FileUtil.toCanonicalPath((String)FileUtil.expandUserHome((String)string));
    }

    public void setPath(String path) {
        boolean bl2 = this.e;
        this.a = false;
        try {
            this.g.setText(FileUtil.getLocationRelativeToUserHome((String)FileUtil.toSystemDependentName((String)path)));
        }
        finally {
            this.e = bl2;
            this.a = true;
        }
    }

    @NotNull
    public JTextField getNameComponent() {
        JTextField jTextField = this.i;
        if (jTextField == null) {
            NamePathComponent.a(0);
        }
        return jTextField;
    }

    public void setNameComponentVisible(boolean visible) {
        this.i.setVisible(visible);
        this.b.setVisible(visible);
    }

    @NotNull
    public JTextField getPathComponent() {
        JTextField jTextField = this.g;
        if (jTextField == null) {
            NamePathComponent.a(1);
        }
        return jTextField;
    }

    @NotNull
    public FieldPanel getPathPanel() {
        FieldPanel fieldPanel = this.d;
        if (fieldPanel == null) {
            NamePathComponent.a(2);
        }
        return fieldPanel;
    }

    public boolean isNameChangedByUser() {
        return this.c;
    }

    public boolean isPathChangedByUser() {
        return this.e;
    }

    public void addChangeListener(final Runnable callback) {
        DocumentAdapter documentAdapter = new DocumentAdapter(){
            private static final long a = lb.a(-496649177468566380L, 2261667837761097603L, MethodHandles.lookup().lookupClass()).a(202628079740228L);

            protected void textChanged(@NotNull DocumentEvent e10) {
                if (e10 == null) {
                    2.a(0);
                }
                callback.run();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x4A4B26BA3595L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/projectWizard/NamePathComponent$2", "textChanged"));
            }
        };
        this.i.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.g.getDocument().addDocumentListener((DocumentListener)documentAdapter);
    }

    public void setShouldBeAbsolute(boolean shouldBeAbsolute) {
        this.j = shouldBeAbsolute;
    }

    static {
        k = lb.a(-6475126883205378139L, 2310830254079383042L, MethodHandles.lookup().lookupClass()).a(191575322580526L);
        h = Logger.getInstance(NamePathComponent.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = k ^ 0x7BAE0AB99F57L;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/util/projectWizard/NamePathComponent";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathPanel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class PathFieldDocument
    extends PlainDocument {
        PathFieldDocument() {
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){
                private static final long a = lb.a(6917572600765973577L, 4503548195361556085L, MethodHandles.lookup().lookupClass()).a(110127689415867L);

                public void textChanged(@NotNull DocumentEvent event) {
                    if (event == null) {
                        1.a(0);
                    }
                    NamePathComponent.this.e = true;
                    PathFieldDocument.this.a();
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x25B2CF0885A4L;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/util/projectWizard/NamePathComponent$PathFieldDocument$1", "textChanged"));
                }
            });
        }

        private void a() {
            if (NamePathComponent.this.a && !NamePathComponent.this.isNameChangedByUser()) {
                try {
                    NamePathComponent.this.f = false;
                    String string = this.getText(0, this.getLength());
                    int n2 = string.lastIndexOf(File.separator);
                    if (n2 >= 0 && n2 + 1 < string.length()) {
                        NamePathComponent.this.setNameValue(string.substring(n2 + 1));
                    }
                }
                catch (BadLocationException badLocationException) {
                    h.error((Throwable)badLocationException);
                }
                finally {
                    NamePathComponent.this.f = true;
                }
            }
        }
    }

    private class NameFieldDocument
    extends PlainDocument {
        NameFieldDocument() {
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){
                private static final long a = lb.a(-6307500388551119163L, 8064870717598471990L, MethodHandles.lookup().lookupClass()).a(239525027549370L);

                public void textChanged(@NotNull DocumentEvent event) {
                    if (event == null) {
                        1.a(0);
                    }
                    NamePathComponent.this.c = true;
                    NameFieldDocument.this.a();
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x441B353307D7L;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/util/projectWizard/NamePathComponent$NameFieldDocument$1", "textChanged"));
                }
            });
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a10) throws BadLocationException {
            boolean bl2 = true;
            for (int i10 = 0; i10 < str.length() && bl2; ++i10) {
                char c10 = str.charAt(i10);
                bl2 = c10 != File.separatorChar && c10 != '\\' && c10 != '/' && c10 != '|' && c10 != ':';
            }
            if (bl2) {
                super.insertString(offs, str, a10);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void a() {
            if (NamePathComponent.this.f && !NamePathComponent.this.isPathChangedByUser()) {
                try {
                    NamePathComponent.this.a = false;
                    String string = this.getText(0, this.getLength());
                    String string2 = NamePathComponent.this.g.getText().trim();
                    int n2 = string2.lastIndexOf(File.separator);
                    if (n2 >= 0) {
                        NamePathComponent.this.setPath(string2.substring(0, n2 + 1) + string);
                    } else if (!string2.isEmpty()) {
                        NamePathComponent.this.setPath(string2 + File.separatorChar + string);
                    }
                }
                catch (BadLocationException badLocationException) {
                    h.error((Throwable)badLocationException);
                }
                finally {
                    NamePathComponent.this.a = true;
                }
            }
        }
    }
}

