/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import b.a.lb;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinder;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.projectRoots.ui.ProjectJdksEditor;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.ui.StatusText;
import gnu.trove.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkChooserPanel
extends JPanel {
    @Nullable
    private final Project b;
    private final DefaultListModel<Sdk> f;
    private final JBList<Sdk> c;
    private final LoadingDecorator d;
    private Sdk a;
    private SdkType[] e;
    private static final long g = lb.a(5248545059016715045L, -2734744686356981466L, MethodHandles.lookup().lookupClass()).a(123106308473635L);

    public JdkChooserPanel(@Nullable Project project2) {
        long l2 = g ^ 0x67DE6A22220AL;
        super(new BorderLayout());
        this.e = null;
        this.b = project2;
        this.f = new DefaultListModel();
        this.c = new JBList(this.f);
        this.c.setSelectionMode(0);
        this.c.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<Sdk>(){
            private static final long a = lb.a(7419496325986413949L, -1032326920127666434L, MethodHandles.lookup().lookupClass()).a(203981052154238L);

            protected void customizeCellRenderer(@NotNull JList<? extends Sdk> list2, Sdk value, int index, boolean selected, boolean hasFocus) {
                if (list2 == null) {
                    1.a(0);
                }
                OrderEntryAppearanceService.getInstance().forJdk(value, false, selected, true).customize((SimpleColoredComponent)this);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x46D31082E78FL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/util/projectWizard/JdkChooserPanel$1", "customizeCellRenderer"));
            }
        });
        this.c.addListSelectionListener(listSelectionEvent -> {
            this.a = (Sdk)this.c.getSelectedValue();
        });
        new ClickListener(){
            private static final long a = lb.a(-3679891053292576586L, 1737013291448373283L, MethodHandles.lookup().lookupClass()).a(9446043579079L);

            public boolean onClick(@NotNull MouseEvent e10, int clickCount) {
                if (e10 == null) {
                    2.a(0);
                }
                if (JdkChooserPanel.this.b == null) {
                    JdkChooserPanel.this.editJdkTable();
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x49F09ED814E8L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/projectWizard/JdkChooserPanel$2", "onClick"));
            }
        }.installOn(this.c);
        JPanel jPanel = new JPanel(new BorderLayout()){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height = Math.max(dimension.height, JdkChooserPanel.this.c.getVisibleRowCount() * JdkChooserPanel.this.c.getFixedCellHeight());
                return dimension;
            }
        };
        jPanel.add((Component)ScrollPaneFactory.createScrollPane(this.c), "Center");
        this.d = new LoadingDecorator((JComponent)jPanel, (Disposable)project2, 0, true);
        this.d.setLoadingText("Looking for JDKs...");
        this.add((Component)this.d.getComponent(), "Center");
        if (this.f.getSize() > 0) {
            this.c.setSelectedIndex(0);
        }
    }

    public void setAllowedJdkTypes(@Nullable SdkType[] allowedJdkTypes) {
        this.e = allowedJdkTypes;
    }

    public Sdk getChosenJdk() {
        return this.a;
    }

    public Object[] getAllJdks() {
        return this.f.toArray();
    }

    public void editJdkTable() {
        ProjectJdksEditor projectJdksEditor = new ProjectJdksEditor((Sdk)this.c.getSelectedValue(), this.b != null ? this.b : ProjectManager.getInstance().getDefaultProject(), (Component)this.c);
        if (projectJdksEditor.showAndGet()) {
            Sdk sdk = projectJdksEditor.getSelectedJdk();
            this.updateList(sdk, null);
        }
    }

    public void updateList(Sdk selectedJdk, @Nullable SdkType type) {
        this.updateList(selectedJdk, type, null);
    }

    public void updateList(Sdk selectedJdk, @Nullable SdkType type, @Nullable Sdk[] globalSdks) {
        int[] nArray = this.c.getSelectedIndices();
        this.fillList(type, globalSdks);
        if (selectedJdk != null) {
            TIntArrayList tIntArrayList = new TIntArrayList();
            for (int i10 = 0; i10 < this.f.size(); ++i10) {
                Sdk sdk = this.f.getElementAt(i10);
                if (!Comparing.strEqual((String)sdk.getName(), (String)selectedJdk.getName())) continue;
                tIntArrayList.add(i10);
            }
            int[] nArray2 = tIntArrayList.toNativeArray();
            if (nArray2.length > 0) {
                this.c.setSelectedIndices(nArray2);
            } else if (this.c.getModel().getSize() > 0) {
                this.c.setSelectedIndex(0);
            }
        } else if (nArray.length > 0) {
            this.c.setSelectedIndices(nArray);
        } else {
            this.c.setSelectedIndex(0);
        }
        this.a = (Sdk)this.c.getSelectedValue();
    }

    public JList getPreferredFocusedComponent() {
        return this.c;
    }

    public void fillList(@Nullable SdkType type, @Nullable Sdk[] globalSdks) {
        Object object;
        long l2 = g ^ 0x45F82D425441L;
        ArrayList<Sdk> arrayList = new ArrayList<Sdk>();
        if (this.b == null || this.b.isDefault()) {
            object = globalSdks != null ? globalSdks : ProjectJdkTable.getInstance().getAllJdks();
            arrayList.addAll(this.a(type, Arrays.asList(object)));
        } else {
            object = ProjectStructureConfigurable.getInstance(this.b).getProjectJdksModel();
            if (!object.isInitialized()) {
                object.reset(this.b);
            }
            Collection<Sdk> collection = object.getProjectSdks().values();
            arrayList.addAll(this.a(type, collection));
        }
        object = new ArrayList(arrayList);
        if (Registry.is((String)"autodetect.all.jdks") && (type == null || type instanceof JavaSdkType)) {
            this.c.getEmptyText().setText("");
            this.d.startLoading(false);
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.a(arrayList, (ArrayList)object));
        } else {
            this.b((ArrayList<Sdk>)object, arrayList);
        }
    }

    private void b(ArrayList<Sdk> arrayList, ArrayList<Sdk> arrayList2) {
        Sdk sdk3 = (Sdk)this.c.getSelectedValue();
        this.f.clear();
        Collections.sort(arrayList, (sdk, sdk2) -> {
            String string;
            boolean bl2;
            boolean bl3 = !arrayList2.contains(sdk);
            boolean bl4 = bl2 = !arrayList2.contains(sdk2);
            if (bl3 != bl2) {
                return bl3 ? 1 : -1;
            }
            String string2 = sdk.getVersionString();
            if (string2 != null & (string = sdk2.getVersionString()) != null) {
                try {
                    return -JavaVersion.parse((String)string2).compareTo(JavaVersion.parse((String)string));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return -sdk.getName().compareToIgnoreCase(sdk2.getName());
        });
        for (Sdk sdk4 : arrayList) {
            this.f.addElement(sdk4);
        }
        if (sdk3 != null) {
            ScrollingUtil.selectItem(this.c, (Object)sdk3);
        }
    }

    private List<Sdk> a(@Nullable SdkType sdkType, Collection<Sdk> collection) {
        HashSet<Sdk> hashSet = new HashSet<Sdk>();
        for (Sdk sdk : collection) {
            if (!this.a(sdk, sdkType)) continue;
            hashSet.add(sdk);
        }
        return new ArrayList<Sdk>(hashSet);
    }

    private boolean a(Sdk sdk, @Nullable SdkType sdkType) {
        if (sdkType != null) {
            return sdk.getSdkType() == sdkType;
        }
        if (this.e != null) {
            return ArrayUtil.indexOf((Object[])this.e, (Object)sdk.getSdkType()) >= 0;
        }
        return true;
    }

    public JComponent getDefaultFocusedComponent() {
        return this.c;
    }

    public void selectJdk(@Nullable Sdk defaultJdk) {
        if (defaultJdk != null) {
            ScrollingUtil.selectItem(this.c, (Object)defaultJdk);
        }
    }

    public void addSelectionListener(ListSelectionListener listener) {
        this.c.addListSelectionListener(listener);
    }

    private static Sdk a(Project project2, String string, Component component, Sdk sdk) {
        JdkChooserPanel jdkChooserPanel = new JdkChooserPanel(project2);
        jdkChooserPanel.fillList(null, null);
        JdkChooserPanel jdkChooserPanel2 = jdkChooserPanel;
        jdkChooserPanel2.getClass();
        final MyDialog myDialog = new MyDialog(jdkChooserPanel2, component);
        if (string != null) {
            myDialog.setTitle(string);
        }
        if (sdk != null) {
            jdkChooserPanel.selectJdk(sdk);
        } else {
            ScrollingUtil.ensureSelectionExists(jdkChooserPanel.c);
        }
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e10) {
                myDialog.clickDefaultButton();
                return true;
            }
        }.installOn(jdkChooserPanel.c);
        return myDialog.showAndGet() ? jdkChooserPanel.getChosenJdk() : null;
    }

    public static Sdk chooseAndSetJDK(Project project2) {
        String string;
        long l2 = g ^ 0x28733FCFAE74L;
        Sdk sdk = ProjectRootManager.getInstance((Project)project2).getProjectSdk();
        Sdk sdk2 = JdkChooserPanel.a(project2, ProjectBundle.message((String)"module.libraries.target.jdk.select.title", (Object[])new Object[0]), (Component)WindowManagerEx.getInstanceEx().getFrame(project2), sdk);
        String string2 = string = sdk2 != null ? sdk2.getHomePath() : null;
        if (string == null) {
            return null;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
            List list2 = projectJdkTable.getSdksOfType(sdk2.getSdkType());
            if (ContainerUtil.find((Iterable)list2, sdk -> string.equals(sdk.getHomePath())) == null) {
                projectJdkTable.addJdk(sdk2);
            }
            ProjectRootManager.getInstance((Project)project2).setProjectSdk(sdk2);
        });
        return sdk2;
    }

    private /* synthetic */ void a(ArrayList arrayList, ArrayList arrayList2) {
        List list2 = JavaHomeFinder.suggestHomePaths();
        list2.removeAll(ContainerUtil.map((Collection)arrayList, sdk -> sdk.getHomePath()));
        ApplicationManager.getApplication().invokeLater(() -> {
            for (String string : list2) {
                JavaSdk javaSdk;
                VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(string);
                if (virtualFile == null) continue;
                JavaVersion javaVersion = JavaVersion.tryParse((String)(javaSdk = JavaSdk.getInstance()).getVersionString(string));
                String string2 = javaVersion != null ? javaVersion.toString() : SimpleJavaSdkType.suggestJavaSdkName((JavaSdkType)javaSdk, (String)"", (String)string);
                Sdk sdk = javaSdk.createJdk(string2, string, false);
                if (sdk instanceof ProjectJdkImpl) {
                    ProjectJdkImpl projectJdkImpl = SdkConfigurationUtil.createSdk((Sdk[])arrayList2.toArray(new Sdk[0]), (VirtualFile)virtualFile, (SdkType)javaSdk, null, (String)string2);
                    String string3 = projectJdkImpl.getName();
                    ((ProjectJdkImpl)sdk).setName(string3);
                }
                arrayList2.add(sdk);
            }
            this.b(arrayList2, arrayList);
            this.d.stopLoading();
            this.c.getEmptyText().setText(StatusText.DEFAULT_EMPTY_TEXT);
        }, ModalityState.any());
    }

    public class MyDialog
    extends DialogWrapper
    implements ListSelectionListener {
        final /* synthetic */ JdkChooserPanel this$0;
        private static final long a = lb.a(-1273216417817788152L, -5852336300798272702L, MethodHandles.lookup().lookupClass()).a(252477610382936L);

        public MyDialog(JdkChooserPanel this$0, Component parent) {
            long l2 = a ^ 0x4CE3CACD2393L;
            this.this$0 = this$0;
            super(parent, true);
            this.setTitle(IdeBundle.message((String)"title.select.jdk", (Object[])new Object[0]));
            this.init();
            this$0.c.addListSelectionListener((ListSelectionListener)this);
            this.a();
        }

        protected String getDimensionServiceKey() {
            long l2 = a ^ 0x68C6461A2D59L;
            return "#com.intellij.ide.util.projectWizard.JdkChooserPanel.MyDialog";
        }

        @Override
        public void valueChanged(ListSelectionEvent e10) {
            this.a();
        }

        private void a() {
            this.setOKActionEnabled(this.this$0.c.getSelectedValue() != null);
        }

        public void dispose() {
            this.this$0.c.removeListSelectionListener((ListSelectionListener)this);
            super.dispose();
        }

        protected JComponent createCenterPanel() {
            return this.this$0;
        }

        @NotNull
        protected Action[] createActions() {
            Action[] actionArray = new Action[]{new ConfigureAction(this), this.getOKAction(), this.getCancelAction()};
            if (actionArray == null) {
                MyDialog.a(0);
            }
            return actionArray;
        }

        public JComponent getPreferredFocusedComponent() {
            return this.this$0.c;
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x4C2EAEB48B02L;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/JdkChooserPanel$MyDialog", "createActions"));
        }

        private final class ConfigureAction
        extends AbstractAction {
            final /* synthetic */ MyDialog this$1;
            private static final long a = lb.a(-2324842367871993461L, 4138746538312434466L, MethodHandles.lookup().lookupClass()).a(219851415439873L);

            ConfigureAction(MyDialog myDialog) {
                long l2 = a ^ 0x550C9F907FFAL;
                this.this$1 = myDialog;
                super(IdeBundle.message((String)"button.configure.e", (Object[])new Object[0]));
                this.putValue("MnemonicKey", new Integer(69));
            }

            @Override
            public void actionPerformed(ActionEvent e10) {
                this.this$1.this$0.editJdkTable();
            }
        }
    }
}

