/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import b.a.lb;
import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.importProject.ProjectLayoutPanel;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ModulesLayoutPanel
extends ProjectLayoutPanel<ModuleDescriptor> {
    private final LibraryFilter e;
    private static final long f = lb.a(2941388275834341003L, -3211973420919216985L, MethodHandles.lookup().lookupClass()).a(61116173383239L);

    public ModulesLayoutPanel(ModuleInsight insight, LibraryFilter libFilter) {
        super(insight);
        this.e = libFilter;
    }

    @Override
    protected String getElementName(ModuleDescriptor entry) {
        return entry.getName();
    }

    @Override
    protected void setElementName(ModuleDescriptor entry, String name2) {
        entry.setName(name2);
    }

    @Override
    protected List<ModuleDescriptor> getEntries() {
        List<ModuleDescriptor> list2 = this.getInsight().getSuggestedModules();
        return list2 != null ? list2 : Collections.emptyList();
    }

    @Override
    protected Collection getDependencies(ModuleDescriptor entry) {
        ArrayList<ModuleDescriptor> arrayList = new ArrayList<ModuleDescriptor>(entry.getDependencies());
        Collection<LibraryDescriptor> collection = this.getInsight().getLibraryDependencies(entry);
        for (LibraryDescriptor libraryDescriptor : collection) {
            if (!this.e.isLibraryChosen(libraryDescriptor)) continue;
            arrayList.add((ModuleDescriptor)((Object)libraryDescriptor));
        }
        return arrayList;
    }

    @Override
    @Nullable
    protected ModuleDescriptor merge(List<ModuleDescriptor> entries) {
        ModuleInsight moduleInsight = this.getInsight();
        ModuleDescriptor moduleDescriptor = null;
        for (ModuleDescriptor moduleDescriptor2 : entries) {
            if (moduleDescriptor == null) {
                moduleDescriptor = moduleDescriptor2;
                continue;
            }
            moduleInsight.merge(moduleDescriptor, moduleDescriptor2);
        }
        return moduleDescriptor;
    }

    @Override
    protected ModuleDescriptor split(ModuleDescriptor entry, String newEntryName, Collection<File> extractedData) {
        return this.getInsight().splitModule(entry, newEntryName, extractedData);
    }

    @Override
    protected Collection<File> getContent(ModuleDescriptor entry) {
        return entry.getContentRoots();
    }

    @Override
    protected String getEntriesChooserTitle() {
        long l2 = f ^ 0x50AB9A79F22CL;
        return "Modules";
    }

    @Override
    protected String getDependenciesTitle() {
        long l2 = f ^ 0x125E98CBD4FBL;
        return "Module dependencies";
    }

    @Override
    protected String getElementTypeName() {
        long l2 = f ^ 0x4F37C4C88C77L;
        return "module";
    }

    @Override
    protected String getSplitDialogChooseFilesPrompt() {
        long l2 = f ^ 0x7C76E745E853L;
        return "&Select content roots to extract to the new module:";
    }

    @Override
    protected String getNameAlreadyUsedMessage(String name2) {
        long l2 = f ^ 0xBC0B494732L;
        return "Module with name " + name2 + " already exists";
    }

    @Override
    protected String getStepDescriptionText() {
        long l2 = f ^ 0x7F3EE7B29F9L;
        return "Please review suggested module structure for the project. At this stage you can set module names,\nexclude particular modules from the project, merge or split individual modules.\nAll dependencies between the modules as well as dependencies on the libraries will be automatically updated.";
    }

    public static interface LibraryFilter {
        public boolean isLibraryChosen(LibraryDescriptor var1);
    }
}

