/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import b.a.lb;
import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ProgressIndicatorWrapper;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.impl.ProjectFromSourcesBuilderImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.text.StringFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleInsight {
    private static final Logger b;
    @NotNull
    protected final ProgressIndicatorWrapper myProgress;
    private final Set<File> i = new HashSet<File>();
    private final List<DetectedSourceRoot> j = new ArrayList<DetectedSourceRoot>();
    private final Set<String> g = new HashSet<String>();
    private final Map<File, Set<String>> l = new HashMap<File, Set<String>>();
    private final Map<File, Set<String>> e = new HashMap<File, Set<String>>();
    private final Map<File, Set<String>> k = new HashMap<File, Set<String>>();
    private final StringInterner d = new StringInterner();
    private List<ModuleDescriptor> c;
    private List<LibraryDescriptor> a;
    private final Set<String> h;
    private final Set<String> f;
    private static final long p;

    public ModuleInsight(@Nullable ProgressIndicator progress, Set<String> existingModuleNames, Set<String> existingProjectLibraryNames) {
        this.h = existingModuleNames;
        this.f = existingProjectLibraryNames;
        this.myProgress = new ProgressIndicatorWrapper(progress);
        this.setRoots(Collections.emptyList(), Collections.emptyList(), Collections.emptySet());
    }

    public final void setRoots(List<? extends File> contentRoots, List<? extends DetectedSourceRoot> sourceRoots, Set<String> ignoredNames) {
        this.c = null;
        this.a = null;
        this.i.clear();
        this.i.addAll(contentRoots);
        this.j.clear();
        this.j.addAll(sourceRoots);
        this.g.clear();
        this.g.addAll(ignoredNames);
        this.k.clear();
        this.d.clear();
    }

    @Nullable
    public List<LibraryDescriptor> getSuggestedLibraries() {
        return this.a;
    }

    @Nullable
    public List<ModuleDescriptor> getSuggestedModules() {
        return this.c;
    }

    public void scanModules() {
        long l2 = p ^ 0x76079BFD6AB7L;
        this.myProgress.setIndeterminate(true);
        HashMap<File, ModuleDescriptor> hashMap = new HashMap<File, ModuleDescriptor>();
        try {
            Object object;
            Serializable serializable;
            File file;
            this.myProgress.pushState();
            ArrayList<DetectedSourceRoot> arrayList = new ArrayList<DetectedSourceRoot>();
            for (DetectedSourceRoot detectedSourceRoot : this.getSourceRootsToScan()) {
                file = detectedSourceRoot.getDirectory();
                if (this.isIgnoredName(file)) continue;
                this.myProgress.setText("Scanning " + file.getPath());
                serializable = new HashSet();
                this.l.put(file, (Set<String>)((Object)serializable));
                object = new HashSet();
                this.addExportedPackages(file, (Set<String>)object);
                this.a(file, ProjectFromSourcesBuilderImpl.getPackagePrefix(detectedSourceRoot), (Set<String>)((Object)serializable), (Set<String>)object);
                serializable.removeAll((Collection<?>)object);
                arrayList.add(detectedSourceRoot);
            }
            this.myProgress.popState();
            this.myProgress.pushState();
            this.myProgress.setText("Building modules layout...");
            for (DetectedSourceRoot detectedSourceRoot : arrayList) {
                file = detectedSourceRoot.getDirectory();
                serializable = this.isEntryPointRoot(file) ? file : file.getParentFile();
                object = (ModuleDescriptor)hashMap.get(serializable);
                if (object != null) {
                    ((ModuleDescriptor)object).addSourceRoot((File)serializable, detectedSourceRoot);
                    continue;
                }
                object = this.createModuleDescriptor((File)serializable, (Collection<DetectedSourceRoot>)Collections.singletonList(detectedSourceRoot));
                hashMap.put((File)serializable, (ModuleDescriptor)object);
            }
            this.a(hashMap);
            this.myProgress.popState();
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        this.addModules(hashMap.values());
    }

    protected void addExportedPackages(File sourceRoot, Set<String> packages) {
        this.e.put(sourceRoot, packages);
    }

    protected boolean isIgnoredName(File sourceRoot) {
        return this.g.contains(sourceRoot.getName());
    }

    protected void addModules(Collection<ModuleDescriptor> newModules) {
        if (this.c == null) {
            this.c = new ArrayList<ModuleDescriptor>(newModules);
        } else {
            this.c.addAll(newModules);
        }
        HashSet<String> hashSet = new HashSet<String>(this.h);
        for (ModuleDescriptor moduleDescriptor : newModules) {
            String string = ModuleInsight.b(hashSet, moduleDescriptor.getName());
            moduleDescriptor.setName(string);
            hashSet.add(string);
        }
    }

    @NotNull
    protected List<DetectedSourceRoot> getSourceRootsToScan() {
        List<DetectedSourceRoot> list2 = Collections.unmodifiableList(this.j);
        if (list2 == null) {
            ModuleInsight.a(0);
        }
        return list2;
    }

    protected boolean isEntryPointRoot(File srcRoot) {
        return this.i.contains(srcRoot);
    }

    protected abstract ModuleDescriptor createModuleDescriptor(File var1, Collection<DetectedSourceRoot> var2);

    private void a(Map<File, ModuleDescriptor> map2) {
        long l2 = p ^ 0x5B1C0EA92319L;
        Set<File> set = map2.keySet();
        for (File file : set) {
            ModuleDescriptor moduleDescriptor = map2.get(file);
            this.myProgress.setText2("Building library dependencies for module " + moduleDescriptor.getName());
            this.a(moduleDescriptor);
            this.myProgress.setText2("Building module dependencies for module " + moduleDescriptor.getName());
            block1: for (File file2 : set) {
                ModuleDescriptor moduleDescriptor2 = map2.get(file2);
                if (moduleDescriptor.equals(moduleDescriptor2)) continue;
                Collection<? extends DetectedProjectRoot> collection = moduleDescriptor2.getSourceRoots();
                for (DetectedProjectRoot detectedProjectRoot : moduleDescriptor.getSourceRoots()) {
                    Set<String> set2 = this.l.get(detectedProjectRoot.getDirectory());
                    for (DetectedProjectRoot detectedProjectRoot2 : collection) {
                        if (!ContainerUtil.intersects(set2, (Collection)this.e.get(detectedProjectRoot2.getDirectory()))) continue;
                        moduleDescriptor.addDependencyOn(moduleDescriptor2);
                        continue block1;
                    }
                }
            }
        }
    }

    private void a(ModuleDescriptor moduleDescriptor) {
        block0: for (File file : this.k.keySet()) {
            Set<String> set = this.k.get(file);
            for (DetectedProjectRoot detectedProjectRoot : moduleDescriptor.getSourceRoots()) {
                if (!ContainerUtil.intersects((Collection)this.l.get(detectedProjectRoot.getDirectory()), set)) continue;
                moduleDescriptor.addLibraryFile(file);
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanLibraries() {
        long l2 = p ^ 0x3C227919D1EDL;
        this.myProgress.setIndeterminate(true);
        this.myProgress.pushState();
        try {
            try {
                for (File serializable2 : this.i) {
                    this.myProgress.setText("Scanning for libraries " + serializable2.getPath());
                    this.a(serializable2);
                }
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
            this.myProgress.setText("Building initial libraries layout...");
            List<LibraryDescriptor> list2 = ModuleInsight.a(this.k.keySet());
            HashSet<String> hashSet = new HashSet<String>(this.f);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                LibraryDescriptor libraryDescriptor = (LibraryDescriptor)iterator.next();
                Collection<File> collection = libraryDescriptor.getJars();
                String string = ModuleInsight.b(hashSet, collection.size() == 1 ? FileUtil.getNameWithoutExtension((File)collection.iterator().next()) : libraryDescriptor.getName());
                libraryDescriptor.setName(string);
                hashSet.add(string);
            }
            this.a = list2;
        }
        finally {
            this.myProgress.popState();
        }
    }

    public abstract boolean isApplicableRoot(DetectedProjectRoot var1);

    private static String b(Set<String> set, String string) {
        String string2 = string;
        int n2 = 1;
        while (set.contains(string2)) {
            string2 = string + n2++;
        }
        return string2;
    }

    public void merge(ModuleDescriptor mainModule, ModuleDescriptor module2) {
        for (File object : module2.getContentRoots()) {
            File file = ModuleInsight.a(mainModule, object);
            Collection<DetectedSourceRoot> collection = module2.getSourceRoots(object);
            for (DetectedSourceRoot detectedSourceRoot : collection) {
                mainModule.addSourceRoot(file, detectedSourceRoot);
            }
        }
        for (File file : module2.getLibraryFiles()) {
            mainModule.addLibraryFile(file);
        }
        for (ModuleDescriptor moduleDescriptor : module2.getDependencies()) {
            if (mainModule.equals(moduleDescriptor)) continue;
            mainModule.addDependencyOn(moduleDescriptor);
        }
        this.c.remove(module2);
        for (ModuleDescriptor moduleDescriptor : this.c) {
            if (!moduleDescriptor.getDependencies().contains(module2)) continue;
            moduleDescriptor.removeDependencyOn(module2);
            if (moduleDescriptor.equals(mainModule)) continue;
            moduleDescriptor.addDependencyOn(mainModule);
        }
    }

    public LibraryDescriptor splitLibrary(LibraryDescriptor library, String newLibraryName, Collection<File> jarsToExtract) {
        LibraryDescriptor libraryDescriptor = new LibraryDescriptor(newLibraryName, jarsToExtract);
        this.a.add(libraryDescriptor);
        library.removeJars(jarsToExtract);
        if (library.getJars().size() == 0) {
            this.removeLibrary(library);
        }
        return libraryDescriptor;
    }

    @Nullable
    public ModuleDescriptor splitModule(ModuleDescriptor descriptor2, String newModuleName, Collection<File> contentsToExtract) {
        ModuleDescriptor moduleDescriptor = null;
        for (File object3 : contentsToExtract) {
            HashSet hashSet = descriptor2.removeContentRoot(object3);
            if (moduleDescriptor == null) {
                moduleDescriptor = this.createModuleDescriptor(object3, hashSet != null ? hashSet : new HashSet());
                continue;
            }
            if (hashSet != null && hashSet.size() > 0) {
                for (Object object : hashSet) {
                    moduleDescriptor.addSourceRoot(object3, (DetectedSourceRoot)object);
                }
                continue;
            }
            moduleDescriptor.addContentRoot(object3);
        }
        if (moduleDescriptor == null) {
            return null;
        }
        moduleDescriptor.setName(newModuleName);
        this.c.add(moduleDescriptor);
        HashMap hashMap = new HashMap();
        for (ModuleDescriptor moduleDescriptor2 : this.c) {
            Object object;
            Set<File> set = moduleDescriptor2.getContentRoots();
            object = set.iterator();
            while (object.hasNext()) {
                File file = (File)object.next();
                hashMap.put(file, moduleDescriptor2);
            }
            moduleDescriptor2.clearModuleDependencies();
            moduleDescriptor2.clearLibraryFiles();
        }
        this.a(hashMap);
        return moduleDescriptor;
    }

    public void removeLibrary(LibraryDescriptor lib) {
        this.a.remove(lib);
    }

    public void moveJarsToLibrary(LibraryDescriptor from, Collection<File> files, LibraryDescriptor to) {
        to.addJars(files);
        from.removeJars(files);
        if (from.getJars().size() == 0) {
            this.removeLibrary(from);
        }
    }

    public Collection<LibraryDescriptor> getLibraryDependencies(ModuleDescriptor module2) {
        return ModuleInsight.getLibraryDependencies(module2, this.a);
    }

    public static Collection<LibraryDescriptor> getLibraryDependencies(ModuleDescriptor module2, @Nullable List<? extends LibraryDescriptor> allLibraries) {
        HashSet<LibraryDescriptor> hashSet = new HashSet<LibraryDescriptor>();
        if (allLibraries != null) {
            for (LibraryDescriptor libraryDescriptor : allLibraries) {
                if (!ContainerUtil.intersects(libraryDescriptor.getJars(), module2.getLibraryFiles())) continue;
                hashSet.add(libraryDescriptor);
            }
        }
        return hashSet;
    }

    private static File a(ModuleDescriptor moduleDescriptor, File file) {
        Set<File> set = moduleDescriptor.getContentRoots();
        for (File file2 : set) {
            if (FileUtil.isAncestor((File)file2, (File)file, (boolean)false)) {
                return file2;
            }
            if (!FileUtil.isAncestor((File)file, (File)file2, (boolean)true)) continue;
            Collection<DetectedSourceRoot> collection = moduleDescriptor.getSourceRoots(file2);
            moduleDescriptor.removeContentRoot(file2);
            moduleDescriptor.addContentRoot(file);
            for (DetectedSourceRoot detectedSourceRoot : collection) {
                moduleDescriptor.addSourceRoot(file, detectedSourceRoot);
            }
            return file;
        }
        moduleDescriptor.addContentRoot(file);
        return file;
    }

    private static List<LibraryDescriptor> a(Set<? extends File> set) {
        HashMap<File, LibraryDescriptor> hashMap = new HashMap<File, LibraryDescriptor>();
        for (File file : set) {
            File file2 = file.getParentFile();
            LibraryDescriptor libraryDescriptor = (LibraryDescriptor)hashMap.get(file2);
            if (libraryDescriptor == null) {
                libraryDescriptor = new LibraryDescriptor(file2.getName(), new HashSet<File>());
                hashMap.put(file2, libraryDescriptor);
            }
            libraryDescriptor.addJars(Collections.singleton(file));
        }
        return new ArrayList<LibraryDescriptor>(hashMap.values());
    }

    private void a(File file, String string, Set<String> set, Set<String> set2) {
        if (this.isIgnoredName(file)) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            this.myProgress.checkCanceled();
            boolean bl2 = false;
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    String string2 = string + (string.isEmpty() ? "" : ".") + file2.getName();
                    this.a(file2, string2, set, set2);
                    continue;
                }
                if (!this.isSourceFile(file2)) continue;
                bl2 = true;
                this.a(file2, set);
            }
            if (bl2) {
                set2.add((String)this.d.intern((Object)string));
            }
        }
    }

    protected abstract boolean isSourceFile(File var1);

    private void a(File file, Set<String> set) {
        this.myProgress.setText2(file.getName());
        try {
            char[] cArray = FileUtil.loadFileText((File)file);
            this.scanSourceFileForImportedPackages(StringFactory.createShared((char[])cArray), (Consumer<String>)((Consumer)string -> set.add((String)this.d.intern(string))));
        }
        catch (IOException iOException) {
            b.info((Throwable)iOException);
        }
    }

    protected abstract void scanSourceFileForImportedPackages(CharSequence var1, Consumer<String> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(File file) {
        if (this.isIgnoredName(file)) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            this.myProgress.checkCanceled();
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    this.a(file2);
                    continue;
                }
                String string2 = file2.getName();
                if (!this.isLibraryFile(string2) || this.k.containsKey(file2)) continue;
                HashSet hashSet = new HashSet();
                this.k.put(file2, hashSet);
                this.myProgress.pushState();
                this.myProgress.setText2(file2.getName());
                try {
                    this.scanLibraryForDeclaredPackages(file2, (Consumer<String>)((Consumer)string -> {
                        if (!hashSet.contains(string)) {
                            hashSet.add(this.d.intern(string));
                        }
                    }));
                }
                catch (IOException iOException) {
                    b.info((Throwable)iOException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    b.info((Throwable)illegalArgumentException);
                }
                catch (InternalError internalError) {
                    b.info((Throwable)internalError);
                }
                finally {
                    this.myProgress.popState();
                }
            }
        }
    }

    protected abstract boolean isLibraryFile(String var1);

    protected abstract void scanLibraryForDeclaredPackages(File var1, Consumer<String> var2) throws IOException;

    static {
        p = lb.a(6567896230044178215L, -2137190273306943782L, MethodHandles.lookup().lookupClass()).a(527315118841L);
        long l2 = p ^ 0x1B493557BC24L;
        b = Logger.getInstance((String)"#com.intellij.ide.util.importProject.ModuleInsight");
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = p ^ 0x220F8FF36168L;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/importProject/ModuleInsight", "getSourceRootsToScan"));
    }
}

