/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import b.a.lb;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JreComboboxEditor;
import com.intellij.execution.ui.JreProvider;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JrePathEditor
extends LabeledComponent<ComboboxWithBrowseButton>
implements PanelWithAnchor {
    private static final String a = "Default";
    private final JreComboboxEditor e;
    private final DefaultJreItem b;
    private DefaultJreSelector d;
    private final SortedComboBoxModel<JreComboBoxItem> f;
    private String c;
    private static final long g = lb.a(-8253835093584660448L, -7237496614517571207L, MethodHandles.lookup().lookupClass()).a(272152855001454L);

    public JrePathEditor(DefaultJreSelector defaultJreSelector) {
        this();
        this.setDefaultJreSelector(defaultJreSelector);
    }

    public JrePathEditor() {
        String string;
        long l2 = g ^ 0x1353D9F410CBL;
        this.f = new SortedComboBoxModel((jreComboBoxItem, jreComboBoxItem2) -> {
            int n2 = Comparing.compare((int)jreComboBoxItem.getOrder(), (int)jreComboBoxItem2.getOrder());
            if (n2 != 0) {
                return n2;
            }
            return jreComboBoxItem.getPresentableText().compareToIgnoreCase(jreComboBoxItem2.getPresentableText());
        });
        this.b = new DefaultJreItem();
        this.f.add((Object)this.b);
        Sdk[] sdkArray = ProjectJdkTable.getInstance().getAllJdks();
        for (Sdk sdk : sdkArray) {
            this.f.add((Object)new SdkAsJreItem(sdk));
        }
        HashSet hashSet = new HashSet();
        for (JreProvider jreProvider : (ComboBox)JreProvider.EP_NAME.getExtensions()) {
            string = jreProvider.getJrePath();
            if (StringUtil.isEmpty((String)string)) continue;
            hashSet.add(string);
            this.f.add((Object)new CustomJreItem(string));
        }
        for (JreProvider jreProvider : sdkArray) {
            File file;
            string = jreProvider.getHomePath();
            if (!SystemInfo.isMac && (file = new File(jreProvider.getHomePath(), "jre")).isDirectory()) {
                string = file.getPath();
            }
            if (!hashSet.add(string)) continue;
            this.f.add((Object)new CustomJreItem(string));
        }
        ComboBox comboBox = new ComboBox(this.f, 100);
        comboBox.setEditable(true);
        comboBox.setRenderer((ListCellRenderer)new ColoredListCellRenderer<JreComboBoxItem>(){
            private static final long a = lb.a(8321460465651280995L, -2991024187208980003L, MethodHandles.lookup().lookupClass()).a(257099541958977L);
            {
                this.setIpad((Insets)JBUI.insets((int)1, (int)0));
                this.setMyBorder(null);
            }

            protected void customizeCellRenderer(@NotNull JList<? extends JreComboBoxItem> list2, JreComboBoxItem value, int index, boolean selected, boolean hasFocus) {
                if (list2 == null) {
                    1.a(0);
                }
                if (value != null) {
                    value.render((SimpleColoredComponent)this, selected);
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x78C79ED9C9B4L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/execution/ui/JrePathEditor$1", "customizeCellRenderer"));
            }
        });
        this.e = new JreComboboxEditor(this.f);
        this.e.getEditorComponent().setTextToTriggerEmptyTextStatus(a);
        comboBox.setEditor((ComboBoxEditor)this.e);
        InsertPathAction.addTo((JTextComponent)this.e.getEditorComponent());
        ComboboxWithBrowseButton comboboxWithBrowseButton = new ComboboxWithBrowseButton((JComboBox)comboBox);
        comboboxWithBrowseButton.addBrowseFolderListener(ExecutionBundle.message((String)"run.configuration.select.alternate.jre.label", (Object[])new Object[0]), ExecutionBundle.message((String)"run.configuration.select.jre.dir.label", (Object[])new Object[0]), null, BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR, JreComboboxEditor.TEXT_COMPONENT_ACCESSOR);
        this.setLabelLocation("West");
        this.setText(ExecutionBundle.message((String)"run.configuration.jre.label", (Object[])new Object[0]));
        this.setComponent((JComponent)comboboxWithBrowseButton);
        this.updateUI();
    }

    @Nullable
    public String getJrePathOrName() {
        JreComboBoxItem jreComboBoxItem = this.a();
        if (jreComboBoxItem instanceof DefaultJreItem) {
            return this.c;
        }
        return jreComboBoxItem.getPathOrName();
    }

    public boolean isAlternativeJreSelected() {
        return !(this.a() instanceof DefaultJreItem);
    }

    private JreComboBoxItem a() {
        return (JreComboBoxItem)((ComboboxWithBrowseButton)this.getComponent()).getComboBox().getEditor().getItem();
    }

    public void setDefaultJreSelector(DefaultJreSelector defaultJreSelector) {
        this.d = defaultJreSelector;
        this.d.addChangeListener(() -> this.c());
    }

    public void setPathOrName(@Nullable String pathOrName, boolean useAlternativeJre) {
        JreComboBoxItem jreComboBoxItem = this.b;
        if (!StringUtil.isEmpty((String)pathOrName)) {
            this.c = pathOrName;
            JreComboBoxItem jreComboBoxItem2 = this.a(pathOrName);
            if (useAlternativeJre) {
                jreComboBoxItem = jreComboBoxItem2;
            }
        }
        ((JComboBox)((ComboboxWithBrowseButton)this.getComponent()).getChildComponent()).setSelectedItem(jreComboBoxItem);
        this.c();
    }

    private void c() {
        long l2 = g ^ 0x7FAA198B243EL;
        StatusText statusText = this.e.getEmptyText();
        statusText.clear();
        statusText.appendText(a, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        statusText.appendText(this.d.getDescriptionString(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    private JreComboBoxItem a(@NotNull String string) {
        if (string == null) {
            JrePathEditor.a(0);
        }
        for (JreComboBoxItem jreComboBoxItem : this.f.getItems()) {
            if ((!(jreComboBoxItem instanceof CustomJreItem) || !FileUtil.pathsEqual((String)string, (String)((CustomJreItem)jreComboBoxItem).a)) && !string.equals(jreComboBoxItem.getPathOrName())) continue;
            return jreComboBoxItem;
        }
        CustomJreItem customJreItem = new CustomJreItem(string);
        this.f.add((Object)customJreItem);
        return customJreItem;
    }

    public void addActionListener(ActionListener listener) {
        ((ComboboxWithBrowseButton)this.getComponent()).getComboBox().addActionListener(listener);
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = g ^ 0xA2E9BD872ACL;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathOrName", "com/intellij/execution/ui/JrePathEditor", "findOrAddCustomJre"));
    }

    private class DefaultJreItem
    implements JreComboBoxItem {
        private static final long a = lb.a(1200722852079018592L, -2892355433299179453L, MethodHandles.lookup().lookupClass()).a(213041510236112L);

        private DefaultJreItem() {
        }

        @Override
        public void render(SimpleColoredComponent component, boolean selected) {
            long l2 = a ^ 0x62E76F937A4FL;
            component.append(JrePathEditor.a);
            if (JrePathEditor.this.d != null) {
                component.append(JrePathEditor.this.d.getDescriptionString(), SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }

        @Override
        public String getPresentableText() {
            long l2 = a ^ 0xCFA785779BL;
            return JrePathEditor.a;
        }

        @Override
        public String getPathOrName() {
            return null;
        }

        @Override
        public int getOrder() {
            return 0;
        }
    }

    static class CustomJreItem
    implements JreComboBoxItem {
        private final String a;

        CustomJreItem(String path) {
            this.a = path;
        }

        @Override
        public void render(SimpleColoredComponent component, boolean selected) {
            component.append(this.getPresentableText());
            component.setIcon(AllIcons.Nodes.Folder);
        }

        @Override
        public String getPresentableText() {
            return FileUtil.toSystemDependentName((String)this.a);
        }

        @Override
        public String getPathOrName() {
            return this.a;
        }

        @Override
        public int getOrder() {
            return 2;
        }
    }

    private static class SdkAsJreItem
    implements JreComboBoxItem {
        private final Sdk a;

        SdkAsJreItem(Sdk sdk) {
            this.a = sdk;
        }

        @Override
        public void render(SimpleColoredComponent component, boolean selected) {
            OrderEntryAppearanceService.getInstance().forJdk(this.a, false, selected, true).customize(component);
        }

        @Override
        public String getPresentableText() {
            return this.a.getName();
        }

        @Override
        public String getPathOrName() {
            return this.a.getName();
        }

        @Override
        public int getOrder() {
            return 1;
        }
    }

    static interface JreComboBoxItem {
        public void render(SimpleColoredComponent var1, boolean var2);

        public String getPresentableText();

        @Nullable
        public String getPathOrName();

        public int getOrder();
    }
}

