/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.testframework.AbstractJavaTestConfigurationProducer;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class AbstractPatternBasedConfigurationProducer<T extends JavaTestConfigurationBase>
extends AbstractJavaTestConfigurationProducer<T>
implements Cloneable {
    public AbstractPatternBasedConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    public boolean isConfiguredFromContext(ConfigurationContext context, Set<String> patterns) {
        int n2;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        DataContext dataContext = context.getDataContext();
        if (TestsUIUtil.isMultipleSelectionImpossible((DataContext)dataContext)) {
            return false;
        }
        PsiElement[] psiElementArray = this.collectLocationElements(linkedHashSet, dataContext);
        if (psiElementArray == null) {
            this.collectContextElements(dataContext, true, false, linkedHashSet, (PsiElementProcessor.CollectElements<PsiElement>)new PsiElementProcessor.CollectElements());
        }
        if ((n2 = patterns.size()) == linkedHashSet.size()) {
            String string;
            Iterator<String> iterator = patterns.iterator();
            Iterator iterator2 = linkedHashSet.iterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                if (Comparing.equal((String)iterator.next(), (String)((String)iterator2.next()))) continue;
                return false;
            }
            if (n2 == 1 && !(string = patterns.iterator().next()).contains(",")) {
                PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)), PsiMethod.class);
                return psiMethod != null && this.isTestMethod(false, psiMethod);
            }
            return true;
        }
        return false;
    }

    public PsiElement checkPatterns(ConfigurationContext context, LinkedHashSet<String> classes) {
        PsiElement[] psiElementArray;
        DataContext dataContext = context.getDataContext();
        if (TestsUIUtil.isMultipleSelectionImpossible((DataContext)dataContext)) {
            return null;
        }
        PsiElement[] psiElementArray2 = this.collectLocationElements(classes, dataContext);
        PsiElementProcessor.CollectElements collectElements = new PsiElementProcessor.CollectElements();
        if (psiElementArray2 != null) {
            this.collectTestMembers(psiElementArray2, false, true, (PsiElementProcessor.CollectElements<PsiElement>)collectElements);
            psiElementArray = collectElements.toArray();
        } else if (this.collectContextElements(dataContext, true, true, classes, (PsiElementProcessor.CollectElements<PsiElement>)collectElements)) {
            psiElementArray = collectElements.toArray();
        } else {
            return null;
        }
        if (psiElementArray.length <= 1) {
            return null;
        }
        return psiElementArray[0];
    }
}

