/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import b.a.lb;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.Location;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;

public abstract class AbstractJavaTestConfigurationProducer<T extends JavaTestConfigurationBase>
extends JavaRunConfigurationProducerBase<T> {
    private static final long d = lb.a(-2488967542321939928L, 330947715592334504L, MethodHandles.lookup().lookupClass()).a(160709603926322L);

    protected AbstractJavaTestConfigurationProducer(ConfigurationFactory configurationFactory) {
        super(configurationFactory);
    }

    protected AbstractJavaTestConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    @Contract(value="null->false")
    protected boolean isTestClass(PsiClass psiClass) {
        if (psiClass != null) {
            JavaTestFramework javaTestFramework = this.getCurrentFramework(psiClass);
            return javaTestFramework != null && javaTestFramework.isTestClass((PsiElement)psiClass);
        }
        return false;
    }

    protected boolean isTestMethod(boolean checkAbstract, PsiMethod method) {
        JavaTestFramework javaTestFramework = this.getCurrentFramework(method.getContainingClass());
        return javaTestFramework != null && javaTestFramework.isTestMethod((PsiElement)method, checkAbstract);
    }

    protected JavaTestFramework getCurrentFramework(PsiClass psiClass) {
        if (psiClass != null) {
            ConfigurationType configurationType = this.getConfigurationType();
            Set set = TestFrameworks.detectApplicableFrameworks((PsiClass)psiClass);
            return set.stream().filter(testFramework -> testFramework instanceof JavaTestFramework && ((JavaTestFramework)testFramework).isMyConfigurationType(configurationType)).map(testFramework -> (JavaTestFramework)testFramework).findFirst().orElse(null);
        }
        return null;
    }

    protected boolean isApplicableTestType(String type, ConfigurationContext context) {
        return true;
    }

    public boolean isConfigurationFromContext(T configuration, ConfigurationContext context) {
        String string;
        if (this.isMultipleElementsSelected(context)) {
            return false;
        }
        RunConfiguration runConfiguration = context.getOriginalConfiguration(this.getConfigurationType());
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        Location location2 = JavaExecutionUtil.stepIntoSingleClass((Location)location);
        if (location2 == null) {
            return false;
        }
        PsiElement psiElement = location2.getPsiElement();
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = context.getRunManager().getConfigurationTemplate(this.getConfigurationFactory());
        Module module2 = ((JavaRunConfigurationModule)((JavaTestConfigurationBase)runnerAndConfigurationSettings.getConfiguration()).getConfigurationModule()).getModule();
        String string2 = string = runConfiguration instanceof CommonJavaRunConfigurationParameters ? ((CommonJavaRunConfigurationParameters)runConfiguration).getVMParameters() : null;
        if (string != null && !Comparing.strEqual((String)string, (String)configuration.getVMParameters())) {
            return false;
        }
        if (this.differentParamSet(configuration, location)) {
            return false;
        }
        if (!this.isApplicableTestType(((JavaTestConfigurationBase)configuration).getTestType(), context)) {
            return false;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class);
        if (psiClass != null && this.getCurrentFramework(psiClass) == null) {
            return false;
        }
        if (((JavaTestConfigurationBase)configuration).isConfiguredByElement(psiElement)) {
            Module module3 = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
            if (Comparing.equal((Object)location2.getModule(), (Object)module3)) {
                return true;
            }
            if (Comparing.equal((Object)module2, (Object)module3)) {
                return true;
            }
        }
        return false;
    }

    protected boolean differentParamSet(T configuration, Location contextLocation) {
        String string;
        String string2 = string = contextLocation instanceof PsiMemberParameterizedLocation ? ((JavaTestConfigurationBase)configuration).prepareParameterizedParameter(((PsiMemberParameterizedLocation)contextLocation).getParamSetName()) : null;
        return string != null && !Comparing.strEqual((String)string, (String)configuration.getProgramParameters());
    }

    public Module findModule(ModuleBasedConfiguration configuration, Module contextModule, Set<String> patterns) {
        return JavaExecutionUtil.findModule((Module)contextModule, patterns, (Project)configuration.getProject(), psiClass -> this.isTestClass((PsiClass)psiClass));
    }

    public void collectTestMembers(PsiElement[] psiElements, boolean checkAbstract, boolean checkIsTest, PsiElementProcessor.CollectElements<PsiElement> collectingProcessor) {
        for (PsiElement psiElement : psiElements) {
            PsiClass psiClass;
            if ((psiElement = PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMember.class, (boolean)false)) instanceof PsiClassOwner) {
                for (PsiClass psiClass2 : psiClass = ((PsiClassOwner)psiElement).getClasses()) {
                    if ((checkIsTest || !this.isRequiredVisibility((PsiMember)psiClass2)) && (!checkIsTest || !this.isTestClass(psiClass2)) || collectingProcessor.execute((PsiElement)psiClass2)) continue;
                    return;
                }
                continue;
            }
            if (psiElement instanceof PsiClass) {
                if ((checkIsTest || !this.isRequiredVisibility((PsiMember)((PsiClass)psiElement))) && (!checkIsTest || !this.isTestClass((PsiClass)psiElement)) || collectingProcessor.execute(psiElement)) continue;
                return;
            }
            if (psiElement instanceof PsiMethod) {
                if (checkIsTest && this.isTestMethod(checkAbstract, (PsiMethod)psiElement) && !collectingProcessor.execute(psiElement)) {
                    return;
                }
                if (checkIsTest || (psiClass = ((PsiMethod)psiElement).getContainingClass()) == null || !this.isRequiredVisibility((PsiMember)psiClass) || collectingProcessor.execute(psiElement)) continue;
                return;
            }
            if (!(psiElement instanceof PsiDirectory) || (psiClass = JavaDirectoryService.getInstance().getPackage((PsiDirectory)psiElement)) == null || collectingProcessor.execute((PsiElement)psiClass)) continue;
            return;
        }
    }

    protected boolean isRequiredVisibility(PsiMember psiElement) {
        long l2 = d ^ 0x3115025B290L;
        return psiElement.hasModifierProperty("public");
    }

    protected boolean collectContextElements(DataContext dataContext, boolean checkAbstract, boolean checkIsTest, LinkedHashSet<String> classes, PsiElementProcessor.CollectElements<PsiElement> processor) {
        PsiManager psiManager;
        List list2;
        VirtualFile[] virtualFileArray;
        PsiElement[] psiElementArray = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        if (psiElementArray != null) {
            return this.a(psiElementArray, checkAbstract, checkIsTest, processor, classes);
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiElement psiElement = null;
        if (editor != null) {
            virtualFileArray = (VirtualFile[])CommonDataKeys.PSI_FILE.getData(dataContext);
            list2 = editor.getCaretModel().getAllCarets();
            if (virtualFileArray != null) {
                if (list2.size() > 1) {
                    psiManager = new LinkedHashSet();
                    for (Caret caret : list2) {
                        ContainerUtil.addIfNotNull((Collection)psiManager, (Object)PsiTreeUtil.getParentOfType((PsiElement)virtualFileArray.findElementAt(caret.getOffset()), PsiMethod.class));
                    }
                    if (!psiManager.isEmpty()) {
                        return this.a(psiManager.toArray(PsiElement.EMPTY_ARRAY), checkAbstract, checkIsTest, processor, classes);
                    }
                } else {
                    int n2;
                    Caret caret;
                    psiElement = virtualFileArray.findElementAt(editor.getCaretModel().getOffset());
                    psiManager = editor.getSelectionModel();
                    if (psiManager.hasSelection() && (caret = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)virtualFileArray.findElementAt(n2 = psiManager.getSelectionStart()), PsiClass.class)) != null) {
                        TextRange textRange = new TextRange(n2, psiManager.getSelectionEnd());
                        PsiMethod[] psiMethodArray = (PsiMethod[])Arrays.stream(caret.getMethods()).filter(psiMethod -> {
                            TextRange textRange2 = psiMethod.getTextRange();
                            return textRange2 != null && textRange.contains(textRange2);
                        }).toArray(PsiMethod[]::new);
                        if (psiMethodArray.length > 0) {
                            return this.a((PsiElement[])psiMethodArray, checkAbstract, checkIsTest, processor, classes);
                        }
                    }
                }
            }
        }
        if (psiElement == null) {
            psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        }
        if ((virtualFileArray = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext)) != null && (list2 = (Project)CommonDataKeys.PROJECT.getData(dataContext)) != null) {
            psiManager = PsiManager.getInstance((Project)list2);
            for (VirtualFile virtualFile : virtualFileArray) {
                PsiFile psiFile = psiManager.findFile(virtualFile);
                if (!(psiFile instanceof PsiClassOwner)) continue;
                PsiClass[] psiClassArray = ((PsiClassOwner)psiFile).getClasses();
                if (psiElement != null && psiClassArray.length > 0) {
                    for (PsiClass psiClass : psiClassArray) {
                        if (!PsiTreeUtil.isAncestor((PsiElement)psiClass, (PsiElement)psiElement, (boolean)false)) continue;
                        psiClassArray = new PsiClass[]{psiClass};
                        break;
                    }
                }
                this.collectTestMembers((PsiElement[])psiClassArray, checkAbstract, checkIsTest, processor);
                for (PsiElement psiElement2 : processor.getCollection()) {
                    classes.add(((PsiClass)psiElement2).getQualifiedName());
                }
            }
            return true;
        }
        return false;
    }

    private boolean a(PsiElement[] psiElementArray, boolean bl2, boolean bl3, PsiElementProcessor.CollectElements<PsiElement> collectElements, LinkedHashSet<String> linkedHashSet) {
        this.collectTestMembers(psiElementArray, bl2, bl3, collectElements);
        for (PsiElement psiElement : collectElements.getCollection()) {
            linkedHashSet.add(this.getQName(psiElement));
        }
        return linkedHashSet.size() > 1;
    }

    protected PsiElement[] collectLocationElements(LinkedHashSet<String> classes, DataContext dataContext) {
        Location[] locationArray = (Location[])Location.DATA_KEYS.getData(dataContext);
        if (locationArray != null) {
            ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
            for (Location location : locationArray) {
                String string;
                PsiElement psiElement = location.getPsiElement();
                if (!(psiElement instanceof PsiNamedElement) || (string = this.getQName(psiElement, location)) == null) continue;
                classes.add(string);
                arrayList.add(psiElement);
            }
            return arrayList.toArray(PsiElement.EMPTY_ARRAY);
        }
        return null;
    }

    public String getQName(PsiElement psiMember) {
        return this.getQName(psiMember, null);
    }

    public String getQName(PsiElement psiMember, Location location) {
        long l2 = d ^ 0x295C1DAB7BF1L;
        if (psiMember instanceof PsiClass) {
            return ClassUtil.getJVMClassName((PsiClass)((PsiClass)psiMember));
        }
        if (psiMember instanceof PsiMember) {
            PsiClass psiClass;
            PsiClass psiClass2 = location instanceof MethodLocation ? ((MethodLocation)location).getContainingClass() : (psiClass = location instanceof PsiMemberParameterizedLocation ? ((PsiMemberParameterizedLocation)location).getContainingClass() : ((PsiMember)psiMember).getContainingClass());
            assert (psiClass != null);
            return ClassUtil.getJVMClassName((PsiClass)psiClass) + "," + this.getMethodPresentation((PsiMember)psiMember);
        }
        if (psiMember instanceof PsiPackage) {
            return ((PsiPackage)psiMember).getQualifiedName() + ".*";
        }
        return null;
    }

    protected String getMethodPresentation(PsiMember psiMember) {
        return psiMember.getName();
    }

    public boolean isMultipleElementsSelected(ConfigurationContext context) {
        if (!context.containsMultipleSelection()) {
            return false;
        }
        DataContext dataContext = context.getDataContext();
        if (TestsUIUtil.isMultipleSelectionImpossible((DataContext)dataContext)) {
            return false;
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        PsiElementProcessor.CollectElementsWithLimit collectElementsWithLimit = new PsiElementProcessor.CollectElementsWithLimit(2);
        PsiElement[] psiElementArray = this.collectLocationElements(linkedHashSet, dataContext);
        if (psiElementArray != null) {
            this.collectTestMembers(psiElementArray, false, false, (PsiElementProcessor.CollectElements<PsiElement>)collectElementsWithLimit);
        } else {
            this.collectContextElements(dataContext, false, false, linkedHashSet, (PsiElementProcessor.CollectElements<PsiElement>)collectElementsWithLimit);
        }
        return collectElementsWithLimit.getCollection().size() > 1;
    }

    public void setupConfigurationParamName(T configuration, Location contextLocation) {
        String string;
        if (contextLocation instanceof PsiMemberParameterizedLocation && (string = ((PsiMemberParameterizedLocation)contextLocation).getParamSetName()) != null) {
            configuration.setProgramParameters(((JavaTestConfigurationBase)configuration).prepareParameterizedParameter(string));
        }
    }
}

