/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.indices;

import b.a.lb;
import com.intellij.execution.testDiscovery.indices.DiscoveredTestsIndex;
import com.intellij.execution.testDiscovery.indices.PersistentObjectSeq;
import com.intellij.execution.testDiscovery.indices.TestFilesIndex;
import com.intellij.execution.testDiscovery.indices.TestId;
import com.intellij.execution.testDiscovery.indices.TestModuleIndex;
import com.intellij.execution.testDiscovery.indices.UsedSources;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.PersistentEnumeratorDelegate;
import com.intellij.util.io.PersistentStringEnumerator;
import gnu.trove.TIntArrayList;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DiscoveredTestDataHolder {
    private static final Logger k;
    private final DiscoveredTestsIndex i;
    private final TestFilesIndex f;
    private final TestModuleIndex e;
    private final PersistentStringEnumerator d;
    private final PersistentStringEnumerator j;
    private final PersistentStringEnumerator g;
    private final PersistentEnumeratorDelegate<TestId> b;
    private final PersistentObjectSeq c;
    private boolean a;
    private final Disposable h;
    static final int VERSION = 10;
    private static final long l;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DiscoveredTestDataHolder(@NotNull Path basePath) {
        long l2 = l ^ 0xED0632B84F2L;
        if (basePath == null) {
            DiscoveredTestDataHolder.a(0);
        }
        this.c = new PersistentObjectSeq();
        this.h = Disposer.newDisposable();
        Path path = DiscoveredTestDataHolder.getVersionFile(basePath);
        PathKt.createDirectories((Path)basePath);
        File file = basePath.resolve("discoveredTests.index").toFile();
        File file2 = basePath.resolve("testFiles.index").toFile();
        File file3 = basePath.resolve("className.enum").toFile();
        File file4 = basePath.resolve("methodName.enum").toFile();
        File file5 = basePath.resolve("path.enum").toFile();
        File file6 = basePath.resolve("testName.enum").toFile();
        try {
            PersistentEnumeratorDelegate persistentEnumeratorDelegate;
            PersistentStringEnumerator persistentStringEnumerator;
            PersistentStringEnumerator persistentStringEnumerator2;
            PersistentStringEnumerator persistentStringEnumerator3;
            TestModuleIndex testModuleIndex;
            TestFilesIndex testFilesIndex;
            DiscoveredTestsIndex discoveredTestsIndex;
            int n2 = DiscoveredTestDataHolder.b(path);
            if (n2 != 10) {
                k.info(n2 != -1 ? "TestDiscoveryIndex was rewritten due to version change" : "TestDiscoveryIndex is not exist. Empty index is created");
                PathKt.delete((Path)basePath);
                DiscoveredTestDataHolder.a(path);
            }
            int n3 = 0;
            while (true) {
                ++n3;
                try {
                    discoveredTestsIndex = new DiscoveredTestsIndex(file);
                    this.c.add((InvertedIndex<?, ?, ?>)discoveredTestsIndex);
                    testFilesIndex = new TestFilesIndex(file2);
                    this.c.add((InvertedIndex<?, ?, ?>)testFilesIndex);
                    testModuleIndex = new TestModuleIndex(basePath, this.c);
                    persistentStringEnumerator3 = new PersistentStringEnumerator(file3, true);
                    this.c.add((PersistentEnumeratorDelegate<?>)persistentStringEnumerator3);
                    persistentStringEnumerator2 = new PersistentStringEnumerator(file4, true);
                    this.c.add((PersistentEnumeratorDelegate<?>)persistentStringEnumerator2);
                    persistentStringEnumerator = new PersistentStringEnumerator(file5, true);
                    this.c.add((PersistentEnumeratorDelegate<?>)persistentStringEnumerator);
                    persistentEnumeratorDelegate = new PersistentEnumeratorDelegate(file6, TestId.DESCRIPTOR, 4096);
                    this.c.add(persistentEnumeratorDelegate);
                }
                catch (Throwable throwable) {
                    k.info("TestDiscoveryIndex problem", throwable);
                    this.c.close(true);
                    this.c.clear();
                    PathKt.delete((Path)basePath);
                    if (n3 < 3) continue;
                    k.error("Unexpected circular initialization problem");
                    assert (false);
                    continue;
                }
                break;
            }
            this.i = discoveredTestsIndex;
            this.f = testFilesIndex;
            this.e = testModuleIndex;
            this.d = persistentStringEnumerator3;
            this.j = persistentStringEnumerator2;
            this.g = persistentStringEnumerator;
            this.b = persistentEnumeratorDelegate;
            LowMemoryWatcher.register(() -> this.c.flush(), (Disposable)this.h);
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static void a(@NotNull Path path) throws IOException {
        if (path == null) {
            DiscoveredTestDataHolder.a(1);
        }
        try (DataOutputStream dataOutputStream = new DataOutputStream(PathKt.outputStream((Path)path));){
            DataInputOutputUtil.writeINT((DataOutput)dataOutputStream, (int)10);
        }
    }

    private static int b(@NotNull Path path) throws IOException {
        InputStream inputStream;
        if (path == null) {
            DiscoveredTestDataHolder.a(2);
        }
        if ((inputStream = PathKt.inputStreamIfExists((Path)path)) == null) {
            return -1;
        }
        try (DataInputStream dataInputStream = new DataInputStream(inputStream);){
            int n2 = DataInputOutputUtil.readINT((DataInput)dataInputStream);
            return n2;
        }
    }

    public void flush() {
        this.c.flush();
    }

    public void dispose() {
        try {
            Disposer.dispose((Disposable)this.h);
            this.c.close(false);
        }
        finally {
            this.a = true;
        }
    }

    public boolean hasTestTrace(@NotNull String testClassName, @NotNull String testMethodName, byte frameworkId) throws IOException {
        int n2;
        if (testClassName == null) {
            DiscoveredTestDataHolder.a(3);
        }
        if (testMethodName == null) {
            DiscoveredTestDataHolder.a(4);
        }
        return (n2 = this.b.tryEnumerate((Object)this.a(testClassName, testMethodName, frameworkId))) != 0 && this.i.containsDataFrom(n2);
    }

    public void removeTestTrace(@NotNull String testClassName, @NotNull String testMethodName, byte frameworkId) throws IOException {
        int n2;
        if (testClassName == null) {
            DiscoveredTestDataHolder.a(5);
        }
        if (testMethodName == null) {
            DiscoveredTestDataHolder.a(6);
        }
        if ((n2 = this.b.tryEnumerate((Object)this.a(testClassName, testMethodName, frameworkId))) != 0) {
            this.i.update(n2, null).compute();
            this.e.removeTest(n2);
        }
    }

    @NotNull
    public Collection<String> getTestModulesByMethodName(@NotNull String testClassName, @NotNull String testMethodName, byte frameworkId) throws IOException {
        int n2;
        if (testClassName == null) {
            DiscoveredTestDataHolder.a(7);
        }
        if (testMethodName == null) {
            DiscoveredTestDataHolder.a(8);
        }
        if ((n2 = this.b.tryEnumerate((Object)this.a(testClassName, testMethodName, frameworkId))) != 0) {
            Collection<String> collection = this.e.getTestRunModules(n2);
            if (collection == null) {
                DiscoveredTestDataHolder.a(9);
            }
            return collection;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            DiscoveredTestDataHolder.a(10);
        }
        return set;
    }

    public void updateTestData(@NotNull String testClassName, @NotNull String testMethodName, @NotNull MultiMap<String, String> usedMethods, @NotNull String[] usedFiles, @Nullable String moduleName, byte frameworkId) throws IOException {
        Object object2;
        if (testClassName == null) {
            DiscoveredTestDataHolder.a(11);
        }
        if (testMethodName == null) {
            DiscoveredTestDataHolder.a(12);
        }
        if (usedMethods == null) {
            DiscoveredTestDataHolder.a(13);
        }
        if (usedFiles == null) {
            DiscoveredTestDataHolder.a(14);
        }
        int n2 = this.b.enumerate((Object)this.a(testClassName, testMethodName, frameworkId));
        HashMap<Integer, TIntArrayList> hashMap = new HashMap<Integer, TIntArrayList>();
        for (Object object2 : usedMethods.entrySet()) {
            TIntArrayList tIntArrayList = new TIntArrayList(((Collection)object2.getValue()).size());
            hashMap.put(this.d.enumerate((String)object2.getKey()), tIntArrayList);
            for (String string : (Collection)object2.getValue()) {
                tIntArrayList.add(this.j.enumerate(string));
            }
        }
        HashMap hashMap2 = new HashMap();
        for (String string : usedFiles) {
            int n3 = this.g.enumerate(string);
            hashMap2.put(n3, null);
        }
        object2 = new UsedSources(hashMap, hashMap2);
        this.i.update(n2, object2).compute();
        this.f.update(n2, object2).compute();
        this.e.appendModuleData(n2, moduleName);
    }

    @NotNull
    public MultiMap<String, String> getTestsByFile(@NotNull String relativePath, byte frameworkId) throws IOException {
        MultiMap multiMap;
        int n3;
        if (relativePath == null) {
            DiscoveredTestDataHolder.a(15);
        }
        if ((n3 = this.g.tryEnumerate((Object)relativePath)) == 0) {
            MultiMap multiMap2 = MultiMap.empty();
            if (multiMap2 == null) {
                DiscoveredTestDataHolder.a(16);
            }
            return multiMap2;
        }
        try {
            MultiMap multiMap3 = new MultiMap();
            IOException[] iOExceptionArray = new IOException[]{null};
            this.f.getData(n3).forEach((n2, void_) -> this.a(n2, frameworkId, (MultiMap<String, String>)multiMap3, iOExceptionArray));
            if (iOExceptionArray[0] != null) {
                throw iOExceptionArray[0];
            }
            multiMap = multiMap3;
        }
        catch (StorageException storageException) {
            throw new IOException(storageException);
        }
        if (multiMap == null) {
            DiscoveredTestDataHolder.a(17);
        }
        return multiMap;
    }

    @NotNull
    public MultiMap<String, String> getTestsByClassName(@NotNull String classFQName, byte frameworkId) throws IOException {
        MultiMap multiMap;
        int n3;
        if (classFQName == null) {
            DiscoveredTestDataHolder.a(18);
        }
        if ((n3 = this.d.tryEnumerate((Object)classFQName)) == 0) {
            MultiMap multiMap2 = MultiMap.empty();
            if (multiMap2 == null) {
                DiscoveredTestDataHolder.a(19);
            }
            return multiMap2;
        }
        try {
            MultiMap multiMap3 = new MultiMap();
            IOException[] iOExceptionArray = new IOException[]{null};
            this.i.getData(n3).forEach((n2, tIntArrayList) -> this.a(n2, frameworkId, (MultiMap<String, String>)multiMap3, iOExceptionArray));
            if (iOExceptionArray[0] != null) {
                throw iOExceptionArray[0];
            }
            multiMap = multiMap3;
        }
        catch (StorageException storageException) {
            throw new IOException(storageException);
        }
        if (multiMap == null) {
            DiscoveredTestDataHolder.a(20);
        }
        return multiMap;
    }

    @NotNull
    public MultiMap<String, String> getTestsByMethodName(@NotNull String classFQName, @NotNull String methodName, byte frameworkId) throws IOException {
        MultiMap multiMap;
        int n2;
        if (classFQName == null) {
            DiscoveredTestDataHolder.a(21);
        }
        if (methodName == null) {
            DiscoveredTestDataHolder.a(22);
        }
        if ((n2 = this.j.tryEnumerate((Object)methodName)) == 0) {
            MultiMap multiMap2 = MultiMap.empty();
            if (multiMap2 == null) {
                DiscoveredTestDataHolder.a(23);
            }
            return multiMap2;
        }
        int n4 = this.d.tryEnumerate((Object)classFQName);
        if (n4 == 0) {
            MultiMap multiMap3 = MultiMap.empty();
            if (multiMap3 == null) {
                DiscoveredTestDataHolder.a(24);
            }
            return multiMap3;
        }
        try {
            MultiMap multiMap4 = new MultiMap();
            IOException[] iOExceptionArray = new IOException[]{null};
            this.i.getData(n4).forEach((n3, tIntArrayList) -> !tIntArrayList.contains(n2) || this.a(n3, frameworkId, (MultiMap<String, String>)multiMap4, iOExceptionArray));
            if (iOExceptionArray[0] != null) {
                throw iOExceptionArray[0];
            }
            multiMap = multiMap4;
        }
        catch (StorageException storageException) {
            throw new IOException(storageException);
        }
        if (multiMap == null) {
            DiscoveredTestDataHolder.a(25);
        }
        return multiMap;
    }

    public boolean isDisposed() {
        return this.a;
    }

    @NotNull
    static Path getVersionFile(Path path) {
        long l2 = l ^ 0x59DF1CB53825L;
        Path path2 = path.resolve("index.version");
        if (path2 == null) {
            DiscoveredTestDataHolder.a(26);
        }
        return path2;
    }

    @NotNull
    private TestId a(String string, String string2, byte by2) throws IOException {
        TestId testId = new TestId(this.d.enumerate(string), this.j.enumerate(string2), by2);
        if (testId == null) {
            DiscoveredTestDataHolder.a(27);
        }
        return testId;
    }

    private boolean a(int n2, byte by2, @NotNull MultiMap<String, String> multiMap, @NotNull IOException[] iOExceptionArray) {
        if (multiMap == null) {
            DiscoveredTestDataHolder.a(28);
        }
        if (iOExceptionArray == null) {
            DiscoveredTestDataHolder.a(29);
        }
        try {
            TestId testId = (TestId)this.b.valueOf(n2);
            if (testId.getFrameworkId() == by2) {
                String string = this.d.valueOf(testId.getClassId());
                String string2 = this.j.valueOf(testId.getMethodId());
                multiMap.putValue((Object)string, (Object)string2);
            }
        }
        catch (IOException iOException) {
            iOExceptionArray[0] = iOException;
            return false;
        }
        return true;
    }

    static {
        l = lb.a(-4565468911700038858L, 197147843053555865L, MethodHandles.lookup().lookupClass()).a(72163593902466L);
        k = Logger.getInstance(DiscoveredTestDataHolder.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = l ^ 0x2798FFE16BA0L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionFile";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClassName";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testMethodName";
                break;
            }
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testDiscovery/indices/DiscoveredTestDataHolder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedMethods";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedFiles";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFQName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionRef";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testDiscovery/indices/DiscoveredTestDataHolder";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestModulesByMethodName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestsByFile";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestsByClassName";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestsByMethodName";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionFile";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestId";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeVersion";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readVersion";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasTestTrace";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeTestTrace";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTestModulesByMethodName";
                break;
            }
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateTestData";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTestsByFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTestsByClassName";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTestsByMethodName";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "consumeDiscoveredTest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

