/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import b.a.lb;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.ConfigurationWithCommandLineShortener;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.JavaTestConfigurationWithDiscoverySupport;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunProfileWithCompileBeforeLaunchOption;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testDiscovery.TestDiscoveryIndex;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFramework;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestDiscoveryConfigurationProducer
extends JavaRunConfigurationProducerBase<JavaTestConfigurationWithDiscoverySupport> {
    private static final long a = lb.a(8743235186742021807L, -4847838285704752176L, MethodHandles.lookup().lookupClass()).a(214720909512220L);

    protected TestDiscoveryConfigurationProducer(ConfigurationType type) {
        super(type);
    }

    protected abstract void setPosition(JavaTestConfigurationBase var1, PsiLocation<PsiMethod> var2);

    protected abstract Pair<String, String> getPosition(JavaTestConfigurationBase var1);

    protected void setupDiscoveryConfiguration(JavaTestConfigurationBase configuration, PsiMethod sourceMethod, Module targetModule) {
        long l2 = a ^ 0x5834C556550EL;
        this.setPosition(configuration, (PsiLocation<PsiMethod>)new PsiLocation((PsiElement)sourceMethod));
        Pair<String, String> pair2 = this.getPosition(configuration);
        configuration.setName("Tests for " + StringUtil.getShortName((String)((String)pair2.first)) + "." + (String)pair2.second);
        configuration.setModule(targetModule);
    }

    protected boolean setupConfigurationFromContext(JavaTestConfigurationWithDiscoverySupport configuration, ConfigurationContext configurationContext, Ref<PsiElement> ref) {
        long l2 = a ^ 0x4EA4EDD7C883L;
        if (!Registry.is((String)"testDiscovery.enabled")) {
            return false;
        }
        Location location = configurationContext.getLocation();
        assert (location != null);
        Location location2 = JavaExecutionUtil.stepIntoSingleClass((Location)location);
        if (location2 == null) {
            return false;
        }
        PsiMethod psiMethod = TestDiscoveryConfigurationProducer.b(location2);
        Pair<String, String> pair2 = TestDiscoveryConfigurationProducer.a(psiMethod);
        if (psiMethod != null && pair2 != null) {
            Project project2 = configuration.getProject();
            TestDiscoveryIndex testDiscoveryIndex = TestDiscoveryIndex.getInstance(project2);
            if (testDiscoveryIndex.getTestsByMethodName((String)pair2.first, (String)pair2.second, configuration.getTestFrameworkId()).isEmpty()) {
                return false;
            }
            Module module2 = this.a(configuration, configurationContext, pair2, project2, testDiscoveryIndex);
            this.setupDiscoveryConfiguration(configuration, psiMethod, module2);
            return true;
        }
        return false;
    }

    private Module a(JavaTestConfigurationWithDiscoverySupport javaTestConfigurationWithDiscoverySupport, ConfigurationContext configurationContext, Pair<String, String> pair2, Project project2, TestDiscoveryIndex testDiscoveryIndex) {
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = configurationContext.getRunManager().getConfigurationTemplate(this.getConfigurationFactory());
        Module module2 = ((ModuleBasedConfiguration)runnerAndConfigurationSettings.getConfiguration()).getConfigurationModule().getModule();
        if (module2 != null) {
            return module2;
        }
        Collection<String> collection = testDiscoveryIndex.getTestModulesByMethodName((String)pair2.first, (String)pair2.second, javaTestConfigurationWithDiscoverySupport.getTestFrameworkId());
        if (collection.isEmpty()) {
            return null;
        }
        ArrayList<Module> arrayList = new ArrayList<Module>();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
        for (String string : collection) {
            Module module3 = moduleManager.findModuleByName(string);
            if (module3 == null) continue;
            arrayList.add(module3);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return TestDiscoveryConfigurationProducer.detectTargetModule(arrayList, project2);
    }

    public abstract boolean isApplicable(@NotNull Location<PsiMethod> var1);

    @NotNull
    public abstract RunProfileState createProfile(@NotNull Location<PsiMethod>[] var1, Module var2, RunConfiguration var3, ExecutionEnvironment var4);

    public RunProfile createProfile(Location<PsiMethod>[] testMethods, Module module2, ConfigurationContext context, String configurationName) {
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.cloneTemplateConfiguration(context);
        JavaTestConfigurationBase javaTestConfigurationBase = (JavaTestConfigurationBase)runnerAndConfigurationSettings.getConfiguration();
        javaTestConfigurationBase.setModule(module2);
        if (module2 == null) {
            javaTestConfigurationBase.setSearchScope(TestSearchScope.WHOLE_PROJECT);
        } else {
            javaTestConfigurationBase.setSearchScope(TestSearchScope.MODULE_WITH_DEPENDENCIES);
        }
        javaTestConfigurationBase.setShortenCommandLine(ShortenCommandLine.MANIFEST);
        return new MyRunProfile(testMethods, module2, javaTestConfigurationBase, configurationName);
    }

    public static Module detectTargetModule(Collection<? extends Module> survivedModules, Project project2) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
        HashSet<Module> hashSet = new HashSet<Module>(Arrays.asList(moduleManager.getModules()));
        survivedModules.forEach(module2 -> {
            List list2 = ModuleUtilCore.getAllDependentModules((Module)module2);
            list2.add(module2);
            hashSet.retainAll(list2);
        });
        if (!hashSet.isEmpty()) {
            Module module3 = (Module)hashSet.iterator().next();
            for (Module module4 : survivedModules) {
                if (!hashSet.contains(module4)) continue;
                module3 = module4;
            }
            return module3;
        }
        return null;
    }

    @Override
    protected Module findModule(JavaTestConfigurationWithDiscoverySupport configuration, Module contextModule) {
        return null;
    }

    private static PsiMethod b(Location location) {
        PsiClass psiClass;
        PsiElement psiElement = location.getPsiElement();
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMethod.class);
        if (psiMethod != null && (psiClass = psiMethod.getContainingClass()) != null) {
            TestFramework testFramework = TestFrameworks.detectFramework((PsiClass)psiClass);
            if (testFramework != null) {
                return null;
            }
            return psiMethod;
        }
        return null;
    }

    private static Pair<String, String> a(PsiMethod psiMethod) {
        if (psiMethod == null) {
            return null;
        }
        PsiClass psiClass = psiMethod.getContainingClass();
        if (psiClass == null) {
            return null;
        }
        String string = ClassUtil.getJVMClassName((PsiClass)psiClass);
        if (string != null) {
            return Pair.create((Object)string, (Object)psiMethod.getName());
        }
        return null;
    }

    public boolean isConfigurationFromContext(JavaTestConfigurationWithDiscoverySupport configuration, ConfigurationContext configurationContext) {
        Pair<String, String> pair2 = TestDiscoveryConfigurationProducer.a(TestDiscoveryConfigurationProducer.b(configurationContext.getLocation()));
        return pair2 != null && pair2.equals(this.getPosition(configuration));
    }

    protected static LinkedHashSet<String> collectMethodPatterns(@NotNull Location<PsiMethod>[] testMethods) {
        if (testMethods == null) {
            TestDiscoveryConfigurationProducer.b(0);
        }
        return Arrays.stream(testMethods).map(location -> {
            Iterator iterator = location.getAncestors(PsiClass.class, true);
            return JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)((PsiClass)((Location)iterator.next()).getPsiElement())) + "," + ((PsiMethod)location.getPsiElement()).getName();
        }).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static /* synthetic */ void b(int n2) {
        long l2 = a ^ 0x7AF3951E192L;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testMethods", "com/intellij/execution/testDiscovery/TestDiscoveryConfigurationProducer", "collectMethodPatterns"));
    }

    private class MyRunProfile
    implements WrappingRunConfiguration<RunConfiguration>,
    RunConfiguration,
    ConfigurationWithCommandLineShortener,
    RunProfileWithCompileBeforeLaunchOption {
        private final Location<PsiMethod>[] b;
        private final Module c;
        private final JavaTestConfigurationBase d;
        private final String a;
        private static final long e = lb.a(4102791843486574008L, 3369792505196120797L, MethodHandles.lookup().lookupClass()).a(266628547549636L);

        MyRunProfile(Location<PsiMethod>[] testMethods, Module module2, JavaTestConfigurationBase configuration, String configurationName) {
            this.b = testMethods;
            this.c = module2;
            this.d = configuration;
            this.a = configurationName;
        }

        @Nullable
        public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
            if (executor == null) {
                MyRunProfile.a(0);
            }
            if (environment == null) {
                MyRunProfile.a(1);
            }
            return TestDiscoveryConfigurationProducer.this.createProfile(this.b, this.c, (RunConfiguration)this.d, environment);
        }

        @NotNull
        public String getName() {
            String string = this.a;
            if (string == null) {
                MyRunProfile.a(2);
            }
            return string;
        }

        @Nullable
        public Icon getIcon() {
            return this.d.getIcon();
        }

        @Nullable
        public ShortenCommandLine getShortenCommandLine() {
            return this.d.getShortenCommandLine();
        }

        public void setShortenCommandLine(@Nullable ShortenCommandLine mode) {
            this.d.setShortenCommandLine(mode);
        }

        @Nullable
        public ConfigurationFactory getFactory() {
            return this.d.getFactory();
        }

        public void setName(@NotNull String name2) {
            if (name2 == null) {
                MyRunProfile.a(3);
            }
        }

        @NotNull
        public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
            SettingsEditor settingsEditor = this.d.getConfigurationEditor();
            if (settingsEditor == null) {
                MyRunProfile.a(4);
            }
            return settingsEditor;
        }

        public Project getProject() {
            return this.d.getProject();
        }

        public RunConfiguration clone() {
            return new MyRunProfile(this.b, this.c, this.d, this.a);
        }

        public RunConfiguration getPeer() {
            return this.d;
        }

        @NotNull
        public Module[] getModules() {
            Module[] moduleArray = this.d.getModules();
            if (moduleArray == null) {
                MyRunProfile.a(5);
            }
            return moduleArray;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = e ^ 0x26B942E3C409L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testDiscovery/TestDiscoveryConfigurationProducer$MyRunProfile";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testDiscovery/TestDiscoveryConfigurationProducer$MyRunProfile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigurationEditor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModules";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getState";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

