/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.scratch;

import b.a.lb;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.scratch.JavaScratchConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.ClassObject;
import com.intellij.openapi.compiler.CompilationException;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JpsJavaSdkType;

public class JavaScratchCompilationSupport
implements CompileTask {
    private static final long a = lb.a(6182982573019641792L, 6892113809606059440L, MethodHandles.lookup().lookupClass()).a(146567417967209L);

    public JavaScratchCompilationSupport(CompilerManager compileManager) {
        compileManager.addAfterTask((CompileTask)this);
    }

    @Nullable
    public static File getScratchOutputDirectory(Project project2) {
        long l2 = a ^ 0x2A5A59C36F8EL;
        File file = CompilerManager.getInstance((Project)project2).getJavacCompilerWorkingDir();
        return file != null ? new File(file, "scratches/out") : null;
    }

    @Nullable
    public static File getScratchTempDirectory(Project project2) {
        long l2 = a ^ 0x258ACDA83487L;
        File file = CompilerManager.getInstance((Project)project2).getJavacCompilerWorkingDir();
        return file != null ? new File(file, "scratches/src") : null;
    }

    public boolean execute(CompileContext context) {
        Sdk sdk;
        long l2 = a ^ 0x73170F7BD2FAL;
        Project project2 = context.getProject();
        RunConfiguration runConfiguration = CompileStepBeforeRun.getRunConfiguration(context);
        if (!(runConfiguration instanceof JavaScratchConfiguration)) {
            return true;
        }
        JavaScratchConfiguration javaScratchConfiguration = (JavaScratchConfiguration)runConfiguration;
        String string = javaScratchConfiguration.getScratchFileUrl();
        if (string == null) {
            context.addMessage(CompilerMessageCategory.ERROR, "Associated scratch file not found", null, -1, -1);
            return false;
        }
        Module module2 = ((JavaRunConfigurationModule)javaScratchConfiguration.getConfigurationModule()).getModule();
        Sdk sdk2 = sdk = module2 != null ? ModuleRootManager.getInstance((Module)module2).getSdk() : ProjectRootManager.getInstance((Project)project2).getProjectSdk();
        if (sdk == null) {
            String string2 = module2 != null ? "Cannot find associated SDK for run configuration module \"" + module2.getName() + "\".\nPlease check project settings." : "Cannot find associated project SDK for the run configuration.\nPlease check project settings.";
            context.addMessage(CompilerMessageCategory.ERROR, string2, string, -1, -1);
            return true;
        }
        if (!(sdk.getSdkType() instanceof JavaSdkType)) {
            String string3 = module2 != null ? "Expected Java SDK for run configuration module \"" + module2.getName() + "\".\nPlease check project settings." : "Expected Java SDK for project \"" + project2.getName() + "\".\nPlease check project settings.";
            context.addMessage(CompilerMessageCategory.ERROR, string3, string, -1, -1);
            return true;
        }
        File file = JavaScratchCompilationSupport.getScratchOutputDirectory(project2);
        if (file == null) {
            return true;
        }
        FileUtil.delete((File)file);
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            File file2;
            File file3 = file2 = new File(VirtualFileManager.extractPath((String)string));
            if (!StringUtil.endsWith((CharSequence)file3.getName(), (CharSequence)".java")) {
                object4 = JavaScratchCompilationSupport.getScratchTempDirectory(project2);
                if (object4 == null) {
                    return true;
                }
                FileUtil.delete((File)object4);
                object3 = (String)ReadAction.compute(() -> {
                    PsiFile psiFile;
                    VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(string);
                    if (virtualFile != null && (psiFile = PsiManager.getInstance((Project)project2).findFile(virtualFile)) instanceof PsiJavaFile) {
                        String string2 = null;
                        for (PsiClass psiClass : ((PsiJavaFile)psiFile).getClasses()) {
                            if (string2 == null) {
                                string2 = psiClass.getName();
                                if (!JavaScratchCompilationSupport.a(psiClass)) continue;
                                break;
                            }
                            if (!JavaScratchCompilationSupport.a(psiClass)) continue;
                            string2 = psiClass.getName();
                            break;
                        }
                        if (string2 != null) {
                            return string2;
                        }
                    }
                    return FileUtil.getNameWithoutExtension((File)file2);
                });
                file3 = new File((File)object4, (String)object3 + ".java");
                FileUtil.copy((File)file2, (File)file3);
            }
            object4 = Collections.singleton(file3);
            object3 = new LinkedHashSet();
            ArrayList arrayList = new ArrayList();
            Computable computable = module2 != null ? () -> ModuleRootManager.getInstance((Module)module2).orderEntries() : () -> ProjectRootManager.getInstance((Project)project2).orderEntries();
            ApplicationManager.getApplication().runReadAction(() -> JavaScratchCompilationSupport.a(computable, (Set)object3, arrayList));
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            arrayList2.add("-g");
            JavaSdkVersion javaSdkVersion = JavaSdk.getInstance().getVersion(sdk);
            if (javaSdkVersion != null) {
                object2 = javaSdkVersion.getMaxLanguageLevel();
                object = JpsJavaSdkType.complianceOption((JavaVersion)object2.toJavaVersion());
                arrayList2.add("-source");
                arrayList2.add(object);
                arrayList2.add("-target");
                arrayList2.add(object);
                if (object2.isPreview()) {
                    arrayList2.add("--enable-preview");
                }
            }
            arrayList2.add("-proc:none");
            object2 = CompilerManager.getInstance((Project)project2).compileJavaCode(arrayList2, arrayList, (Collection)object3, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), (Collection)object4, file);
            object = object2.iterator();
            while (object.hasNext()) {
                ClassObject classObject = (ClassObject)object.next();
                byte[] byArray = classObject.getContent();
                if (byArray == null) continue;
                FileUtil.writeToFile((File)new File(classObject.getPath()), (byte[])byArray);
            }
        }
        catch (CompilationException compilationException) {
            for (CompilationException.Message message : compilationException.getMessages()) {
                context.addMessage(message.getCategory(), message.getText(), string, message.getLine(), message.getColumn());
            }
        }
        catch (IOException iOException) {
            context.addMessage(CompilerMessageCategory.ERROR, iOException.getMessage(), string, -1, -1);
        }
        return true;
    }

    private static boolean a(PsiClass psiClass) {
        long l2 = a ^ 0x49A72EC52233L;
        PsiModifierList psiModifierList = psiClass.getModifierList();
        return psiModifierList != null && psiModifierList.hasModifierProperty("public");
    }

    private static /* synthetic */ void a(Computable computable, Set set, List list2) {
        for (String string : ((OrderEnumerator)computable.compute()).compileOnly().recursively().exportedOnly().withoutSdk().getPathsList().getPathList()) {
            set.add(new File(string));
        }
        for (String string : ((OrderEnumerator)computable.compute()).compileOnly().sdkOnly().getPathsList().getPathList()) {
            list2.add(new File(string));
        }
    }
}

