/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.remote;

import b.a.lb;
import com.intellij.application.options.ModuleDescriptionsComboBox;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.SideBorder;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.labels.DropDownLink;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class RemoteConfigurable
extends SettingsEditor<RemoteConfiguration> {
    private static final int i = 0;
    private static final int k = 65535;
    private final JPanel h;
    private final JTextArea d;
    private final JComboBox<Mode> j;
    private final JBCheckBox f;
    private final JComboBox<Transport> e;
    private final ConfigurationModuleSelector g;
    private final JTextField b;
    private final JTextField c;
    private final JTextField a;
    private static final long l = lb.a(6215771082881701487L, -5136424257043885652L, MethodHandles.lookup().lookupClass()).a(104550932484944L);

    public RemoteConfigurable(Project project2) {
        long l2 = l ^ 0x4397624C84A6L;
        this.d = new JTextArea();
        this.j = new ComboBox((Object[])Mode.values());
        this.f = new JBCheckBox("Auto restart");
        this.e = new ComboBox((Object[])Transport.values());
        this.b = new JTextField();
        this.c = new JTextField();
        this.a = new JTextField(Integer.toString(65535));
        this.e.setSelectedItem((Object)Transport.SOCKET);
        this.a.setMinimumSize(this.a.getPreferredSize());
        new ComponentValidator((Disposable)project2).withValidator(componentValidator -> {
            block5: {
                long l2 = l ^ 0x9EDAF29F2F1L;
                String string = this.a.getText();
                if (StringUtil.isNotEmpty((String)string)) {
                    try {
                        int n2 = Integer.parseInt(string);
                        if (n2 >= 0 && n2 <= 65535) {
                            componentValidator.updateInfo(null);
                            break block5;
                        }
                        componentValidator.updateInfo(new ValidationInfo("Incorrect port range. Set value between 0 and 65535", (JComponent)this.a));
                    }
                    catch (NumberFormatException numberFormatException) {
                        componentValidator.updateInfo(new ValidationInfo("Port value should be a number between 0 and 65535", (JComponent)this.a));
                    }
                } else {
                    componentValidator.updateInfo(null);
                }
            }
        }).installOn((JComponent)this.a);
        this.a.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){
            private static final long a = lb.a(7890708755506777913L, -3600450138651027900L, MethodHandles.lookup().lookupClass()).a(209547013081689L);

            protected void textChanged(@NotNull DocumentEvent e10) {
                if (e10 == null) {
                    1.a(0);
                }
                ComponentValidator.getInstance((JComponent)RemoteConfigurable.this.a).ifPresent(componentValidator -> componentValidator.revalidate());
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x70C75CC7D2D2L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/remote/RemoteConfigurable$1", "textChanged"));
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 21, 0, (Insets)JBUI.insets((int)4, (int)0, (int)0, (int)8), 0, 0);
        this.h = this.a(gridBagConstraints);
        JavaSdkVersion javaSdkVersion = JavaSdkVersionUtil.getJavaSdkVersion((Sdk)ProjectRootManager.getInstance((Project)project2).getProjectSdk());
        JDKVersionItem jDKVersionItem2 = javaSdkVersion != null ? Arrays.stream(JDKVersionItem.values()).filter(jDKVersionItem -> javaSdkVersion.isAtLeast(((JDKVersionItem)jDKVersionItem).a)).findFirst().orElse(JDKVersionItem.JDK9) : JDKVersionItem.JDK9;
        this.d.setLineWrap(true);
        this.d.setWrapStyleWord(true);
        this.d.setRows(2);
        this.d.setEditable(false);
        this.d.setBorder((Border)new SideBorder(JBColor.border(), 15));
        this.d.setMinimumSize(this.d.getPreferredSize());
        this.d.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e10) {
                RemoteConfigurable.this.d.selectAll();
            }
        });
        this.b(jDKVersionItem2);
        final DropDownLink dropDownLink = new DropDownLink((Object)jDKVersionItem2, Arrays.asList(JDKVersionItem.values()), jDKVersionItem -> this.b((JDKVersionItem)((Object)jDKVersionItem)), true);
        dropDownLink.setToolTipText("JVM arguments format");
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = JBUI.insetsTop((int)10);
        this.h.add((Component)UI.PanelFactory.panel((JComponent)this.d).withLabel("&Command line arguments for remote JVM:").moveLabelOnTop().withTopRightComponent((JComponent)dropDownLink).withComment("Copy and paste the arguments to the command line when JVM is started").createPanel(), gridBagConstraints);
        ModuleDescriptionsComboBox moduleDescriptionsComboBox = new ModuleDescriptionsComboBox();
        moduleDescriptionsComboBox.allowEmptySelection("<whole project>");
        this.g = new ConfigurationModuleSelector(project2, moduleDescriptionsComboBox);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = JBUI.insetsTop((int)21);
        this.h.add((Component)UI.PanelFactory.panel((JComponent)moduleDescriptionsComboBox).withLabel("Use &module classpath:").withComment("First search for sources of the debugged classes in the selected module classpath").createPanel(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = JBUI.emptyInsets();
        gridBagConstraints.weighty = 1.0;
        this.h.add((Component)new JPanel(), gridBagConstraints);
        DocumentAdapter documentAdapter = new DocumentAdapter(){
            private static final long a = lb.a(4601004623706061310L, 3674715402310793844L, MethodHandles.lookup().lookupClass()).a(276164017809385L);

            protected void textChanged(@NotNull DocumentEvent e10) {
                if (e10 == null) {
                    3.a(0);
                }
                RemoteConfigurable.this.b((JDKVersionItem)((Object)dropDownLink.getChosenItem()));
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x3EB6BC4A139AL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/remote/RemoteConfigurable$3", "textChanged"));
            }
        };
        this.c.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.b.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.a.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.j.addActionListener(actionEvent -> this.b((JDKVersionItem)((Object)((Object)dropDownLink.getChosenItem()))));
        this.e.addActionListener(actionEvent -> this.b((JDKVersionItem)((Object)((Object)dropDownLink.getChosenItem()))));
    }

    private void b(@NotNull JDKVersionItem jDKVersionItem) {
        if (jDKVersionItem == null) {
            RemoteConfigurable.a(0);
        }
        this.f.setVisible(this.j.getSelectedItem() == Mode.LISTEN);
        boolean bl2 = this.e.getSelectedItem() == Transport.SOCKET;
        RemoteConnection remoteConnection = new RemoteConnection(bl2, this.b.getText().trim(), bl2 ? this.a.getText().trim() : this.c.getText().trim(), this.j.getSelectedItem() == Mode.LISTEN);
        this.d.setText(jDKVersionItem.getLaunchCommandLine(remoteConnection));
    }

    protected void resetEditorFrom(@NotNull RemoteConfiguration rc) {
        if (rc == null) {
            RemoteConfigurable.a(1);
        }
        this.j.setSelectedItem((Object)(rc.SERVER_MODE ? Mode.LISTEN : Mode.ATTACH));
        this.f.setSelected(rc.AUTO_RESTART);
        if (SystemInfo.isWindows) {
            this.e.setSelectedItem((Object)(rc.USE_SOCKET_TRANSPORT ? Transport.SOCKET : Transport.SHMEM));
            if (!rc.USE_SOCKET_TRANSPORT) {
                this.c.setText(rc.SHMEM_ADDRESS);
            }
        }
        if (!SystemInfo.isWindows || rc.USE_SOCKET_TRANSPORT) {
            rc.USE_SOCKET_TRANSPORT = true;
            this.b.setText(rc.HOST);
            this.a.setText(rc.PORT);
        }
        this.g.reset(rc);
    }

    protected void applyEditorTo(@NotNull RemoteConfiguration rc) throws ConfigurationException {
        if (rc == null) {
            RemoteConfigurable.a(2);
        }
        rc.HOST = this.b.getText().trim();
        if (rc.HOST.isEmpty()) {
            rc.HOST = null;
        }
        rc.PORT = this.a.getText().trim();
        if (rc.PORT.isEmpty()) {
            rc.PORT = null;
        }
        rc.SHMEM_ADDRESS = this.c.getText().trim();
        if (rc.SHMEM_ADDRESS.isEmpty()) {
            rc.SHMEM_ADDRESS = null;
        }
        boolean bl2 = rc.USE_SOCKET_TRANSPORT = this.e.getSelectedItem() == Transport.SOCKET;
        if (rc.USE_SOCKET_TRANSPORT) {
            ComponentValidator.getInstance((JComponent)this.a).ifPresent(componentValidator -> componentValidator.revalidate());
        }
        rc.SERVER_MODE = this.j.getSelectedItem() == Mode.LISTEN;
        rc.AUTO_RESTART = this.f.isVisible() && this.f.isSelected();
        this.g.applyTo(rc);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.h;
        if (jPanel == null) {
            RemoteConfigurable.a(3);
        }
        return jPanel;
    }

    private static JLabel a(String string, JComponent jComponent) {
        JLabel jLabel = new JLabel();
        LabeledComponent.TextWithMnemonic.fromTextWithMnemonic((String)string).setToLabel(jLabel);
        jLabel.setLabelFor(jComponent);
        return jLabel;
    }

    private JPanel a(GridBagConstraints gridBagConstraints) {
        long l2 = l ^ 0x3B14CE9BA969L;
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = RemoteConfigurable.a("&Debugger mode:", this.j);
        JLabel jLabel2 = RemoteConfigurable.a("&Transport:", this.e);
        JLabel jLabel3 = RemoteConfigurable.a("&Host:", this.b);
        JLabel jLabel4 = RemoteConfigurable.a("&Port:", this.a);
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx += 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = JBUI.insetsTop((int)4);
        jPanel.add(this.j, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = JBUI.insets((int)4, (int)20, (int)0, (int)8);
        jPanel.add((Component)this.f, gridBagConstraints);
        gridBagConstraints.gridx += 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = JBUI.emptyInsets();
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        if (SystemInfo.isWindows) {
            JLabel jLabel5 = RemoteConfigurable.a("&Address:", this.c);
            jLabel5.setVisible(false);
            this.c.setVisible(false);
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = JBUI.insets((int)4, (int)0, (int)0, (int)8);
            jPanel.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints.gridx += 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = JBUI.insetsTop((int)4);
            jPanel.add(this.e, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 0;
            jPanel.add((Component)new JPanel(), gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = JBUI.insets((int)4, (int)0, (int)0, (int)8);
            gridBagConstraints.fill = 0;
            jPanel.add((Component)jLabel5, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = JBUI.insetsTop((int)4);
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.c, gridBagConstraints);
            this.e.addActionListener(actionEvent -> {
                boolean bl2 = this.e.getSelectedItem() == Transport.SHMEM;
                jLabel3.setVisible(!bl2);
                this.a.setVisible(!bl2);
                this.b.setVisible(!bl2);
                jLabel4.setVisible(!bl2);
                jLabel5.setVisible(bl2);
                this.c.setVisible(bl2);
            });
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = JBUI.insets((int)4, (int)0, (int)0, (int)8);
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jLabel3, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = JBUI.insetsTop((int)4);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.b, gridBagConstraints);
        gridBagConstraints.gridx += 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = JBUI.insets((int)4, (int)20, (int)0, (int)8);
        jPanel.add((Component)jLabel4, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = JBUI.insetsTop((int)4);
        jPanel.add((Component)this.a, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = JBUI.emptyInsets();
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        return jPanel;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = l ^ 0x5FCB327AD6E4L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vi";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rc";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/remote/RemoteConfigurable";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/remote/RemoteConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateArgsText";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class JDKVersionItem
    extends Enum<JDKVersionItem> {
        public static final /* enum */ JDKVersionItem JDK9;
        public static final /* enum */ JDKVersionItem JDK5to8;
        public static final /* enum */ JDKVersionItem JDK1_4;
        public static final /* enum */ JDKVersionItem JDK1_3;
        private final JavaSdkVersion a;
        private static final /* synthetic */ JDKVersionItem[] b;

        public static JDKVersionItem[] values() {
            return (JDKVersionItem[])b.clone();
        }

        public static JDKVersionItem valueOf(String name2) {
            return Enum.valueOf(JDKVersionItem.class, name2);
        }

        private JDKVersionItem(JavaSdkVersion version) {
            this.a = version;
        }

        abstract String getLaunchCommandLine(RemoteConnection var1);

        static {
            long l2 = lb.a(-2641388273918863454L, -7678598360586451445L, MethodHandles.lookup().lookupClass()).a(244941026876535L) ^ 0x56A460BEDB3L;
            JDK9 = new JDKVersionItem(JavaSdkVersion.JDK_1_9){
                private static final long c = lb.a(5700608001654206888L, -1407768520489363860L, MethodHandles.lookup().lookupClass()).a(234489653394207L);

                @Override
                String getLaunchCommandLine(RemoteConnection connection) {
                    long l2 = c ^ 0x22651A2F4D7EL;
                    String string = JDK5to8.getLaunchCommandLine(connection);
                    if (connection.isUseSockets() && !connection.isServerMode()) {
                        string = string.replace(connection.getAddress(), "*:" + connection.getAddress());
                    }
                    return string;
                }

                public String toString() {
                    long l2 = c ^ 0x7AC05088FB5AL;
                    return "JDK 9 or later";
                }
            };
            JDK5to8 = new JDKVersionItem(JavaSdkVersion.JDK_1_5){
                private static final long c = lb.a(-6847684146630880877L, -8333803557945560449L, MethodHandles.lookup().lookupClass()).a(225674755918869L);

                @Override
                String getLaunchCommandLine(RemoteConnection connection) {
                    long l2 = c ^ 0x58C48621C470L;
                    return connection.getLaunchCommandLine().replace("-Xdebug", "").replace("-Xrunjdwp:", "-agentlib:jdwp=").trim();
                }

                public String toString() {
                    long l2 = c ^ 0x731BB5E56B85L;
                    return "JDK 5 - 8";
                }
            };
            JDK1_4 = new JDKVersionItem(JavaSdkVersion.JDK_1_4){
                private static final long c = lb.a(2253609883226552309L, -4308119209162330557L, MethodHandles.lookup().lookupClass()).a(126390939655487L);

                @Override
                String getLaunchCommandLine(RemoteConnection connection) {
                    return connection.getLaunchCommandLine();
                }

                public String toString() {
                    long l2 = c ^ 0x321E07CC480FL;
                    return "JDK 1.4.x";
                }
            };
            JDK1_3 = new JDKVersionItem(JavaSdkVersion.JDK_1_3){
                private static final long c = lb.a(3384499242005836943L, -9060729069128709791L, MethodHandles.lookup().lookupClass()).a(72341105694960L);

                @Override
                String getLaunchCommandLine(RemoteConnection connection) {
                    long l2 = c ^ 0x36BEEFCC3E08L;
                    return "-Xnoagent -Djava.compiler=NONE " + connection.getLaunchCommandLine();
                }

                public String toString() {
                    long l2 = c ^ 0xB89F0068461L;
                    return "JDK 1.3.x or earlier";
                }
            };
            b = new JDKVersionItem[]{JDK9, JDK5to8, JDK1_4, JDK1_3};
        }
    }

    private static final class Transport
    extends Enum<Transport> {
        public static final /* enum */ Transport SOCKET;
        public static final /* enum */ Transport SHMEM;
        private final String b;
        private static final /* synthetic */ Transport[] a;

        public static Transport[] values() {
            return (Transport[])a.clone();
        }

        public static Transport valueOf(String name2) {
            return Enum.valueOf(Transport.class, name2);
        }

        private Transport(String text2) {
            this.b = text2;
        }

        public String toString() {
            return this.b;
        }

        static {
            long l2 = lb.a(7248390469724145048L, 7056267684548945823L, MethodHandles.lookup().lookupClass()).a(6678795151754L) ^ 0x46296F320C87L;
            SOCKET = new Transport("Socket");
            SHMEM = new Transport("Shared memory");
            a = new Transport[]{SOCKET, SHMEM};
        }
    }

    private static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode ATTACH;
        public static final /* enum */ Mode LISTEN;
        private final String b;
        private static final /* synthetic */ Mode[] a;

        public static Mode[] values() {
            return (Mode[])a.clone();
        }

        public static Mode valueOf(String name2) {
            return Enum.valueOf(Mode.class, name2);
        }

        private Mode(String text2) {
            this.b = text2;
        }

        public String toString() {
            return this.b;
        }

        static {
            long l2 = lb.a(7230196447454661827L, 1360442360746783674L, MethodHandles.lookup().lookupClass()).a(177402582534317L) ^ 0xD3D2C5E468BL;
            ATTACH = new Mode("Attach to remote JVM");
            LISTEN = new Mode("Listen to remote JVM");
            a = new Mode[]{ATTACH, LISTEN};
        }
    }
}

