/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import b.a.lb;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.SingleClassConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementListener;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefactoringListeners {
    public static RefactoringElementListener getListener(PsiPackage psiPackage, Accessor<PsiPackage> accessor) {
        StringBuilder stringBuilder = new StringBuilder();
        for (PsiPackage psiPackage2 = accessor.getPsiElement(); psiPackage2 != null; psiPackage2 = psiPackage2.getParentPackage()) {
            if (psiPackage2.equals(psiPackage)) {
                return new RefactorPackage((Accessor<? super PsiPackage>)accessor, stringBuilder.toString());
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, '.');
            }
            stringBuilder.insert(0, psiPackage2.getName());
        }
        return null;
    }

    public static RefactoringElementListener getListeners(PsiClass psiClass, Accessor<PsiClass> accessor) {
        PsiClass psiClass2 = accessor.getPsiElement();
        if (psiClass2 == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        PsiClass psiClass3 = psiClass2;
        while (psiClass3 != null) {
            if (psiClass3.equals(psiClass)) {
                return new RefactorClass((Accessor<? super PsiClass>)accessor, stringBuilder.toString());
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, '$');
            }
            stringBuilder.insert(0, psiClass3.getName());
            psiClass3 = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass3, PsiClass.class, (boolean)true);
        }
        return null;
    }

    public static RefactoringElementListener getClassOrPackageListener(PsiElement element, Accessor<PsiClass> accessor) {
        if (element instanceof PsiClass) {
            return RefactoringListeners.getListeners((PsiClass)element, accessor);
        }
        if (element instanceof PsiPackage) {
            PsiClass psiClass = accessor.getPsiElement();
            if (psiClass == null) {
                return null;
            }
            return RefactoringListeners.getListener((PsiPackage)element, new ClassPackageAccessor(accessor));
        }
        return null;
    }

    private static class ClassPackageAccessor
    implements Accessor<PsiPackage> {
        private final PsiPackage d;
        private final Module c;
        private final Accessor<PsiClass> b;
        private final String a;

        ClassPackageAccessor(Accessor<PsiClass> accessor) {
            String string;
            String string2;
            this.b = accessor;
            PsiClass psiClass = this.b.getPsiElement();
            psiClass = (PsiClass)psiClass.getOriginalElement();
            this.d = JavaDirectoryService.getInstance().getPackage(psiClass.getContainingFile().getContainingDirectory());
            this.c = JavaExecutionUtil.findModule((PsiClass)psiClass);
            String string3 = psiClass.getQualifiedName();
            String string4 = string2 = this.d != null ? this.d.getQualifiedName() : null;
            this.a = string3 != null && string2 != null && string3.startsWith(string2) ? (StringUtil.startsWithChar((CharSequence)(string = string3.substring(string2.length())), (char)'.') ? string.substring(1) : string) : null;
        }

        @Override
        public PsiPackage getPsiElement() {
            return this.d;
        }

        @Override
        public void setPsiElement(PsiPackage psiPackage) {
            if (this.a == null) {
                return;
            }
            String string = this.a(psiPackage.getQualifiedName());
            PsiClass psiClass = JUnitUtil.findPsiClass(string, this.c, psiPackage.getProject());
            if (psiClass != null) {
                this.b.setPsiElement(psiClass);
            } else {
                this.b.setName(string);
            }
        }

        @Override
        public void setName(String qualifiedName) {
            this.b.setName(this.a(qualifiedName));
        }

        private String a(String string) {
            if (string.length() > 0) {
                return string + '.' + this.a;
            }
            return this.a;
        }
    }

    public static class RefactorPackageByClass
    extends RenameElement<PsiClass> {
        private static final long c = lb.a(-8450710220958960068L, -7649266773674934944L, MethodHandles.lookup().lookupClass()).a(90861881357229L);

        public RefactorPackageByClass(Accessor<? super PsiClass> accessor) {
            super(accessor, "*");
        }

        @Override
        @Nullable
        public PsiClass findNewElement(PsiClass psiClass, String qualifiedName) {
            long l2 = c ^ 0x5EED10864CA2L;
            Module module2 = JavaExecutionUtil.findModule((PsiClass)psiClass);
            if (module2 == null) {
                return null;
            }
            return JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass(qualifiedName.replace('$', '.').replace("\\*", psiClass.getName()), GlobalSearchScope.moduleScope((Module)module2));
        }

        @Override
        public String getQualifiedName(PsiClass psiClass) {
            String string = psiClass.getQualifiedName();
            return string != null ? StringUtil.getPackageName((String)string) : null;
        }
    }

    private static class RefactorClass
    extends RenameElement<PsiClass> {
        RefactorClass(Accessor<? super PsiClass> accessor, String path) {
            super(accessor, path);
        }

        @Override
        @Nullable
        public PsiClass findNewElement(PsiClass psiClass, String qualifiedName) {
            Module module2 = JavaExecutionUtil.findModule((PsiClass)psiClass);
            if (module2 == null) {
                return null;
            }
            return JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass(qualifiedName.replace('$', '.'), GlobalSearchScope.moduleScope((Module)module2));
        }

        @Override
        public String getQualifiedName(PsiClass psiClass) {
            return psiClass.getQualifiedName();
        }
    }

    private static class RefactorPackage
    extends RenameElement<PsiPackage> {
        RefactorPackage(Accessor<? super PsiPackage> accessor, String path) {
            super(accessor, path);
        }

        @Override
        public PsiPackage findNewElement(PsiPackage psiPackage, String qualifiedName) {
            return JavaPsiFacade.getInstance((Project)psiPackage.getProject()).findPackage(qualifiedName);
        }

        @Override
        public String getQualifiedName(PsiPackage psiPackage) {
            return psiPackage.getQualifiedName();
        }
    }

    private static abstract class RenameElement<T extends PsiElement>
    extends RefactoringElementAdapter
    implements UndoRefactoringElementListener {
        private final Accessor<? super T> a;
        private final String b;
        private static final long d = lb.a(-4979477227811073418L, -7892017675670179819L, MethodHandles.lookup().lookupClass()).a(199769588957813L);

        RenameElement(Accessor<? super T> accessor, String path) {
            this.a = accessor;
            this.b = path;
        }

        public void elementRenamedOrMoved(@NotNull PsiElement newElement) {
            if (newElement == null) {
                RenameElement.a(0);
            }
            PsiElement psiElement = newElement;
            String string = this.getQualifiedName(psiElement);
            if (this.b.length() > 0) {
                string = string + "." + this.b;
                psiElement = this.findNewElement(psiElement, string);
            }
            if (psiElement != null) {
                this.a.setPsiElement(psiElement);
            } else {
                this.a.setName(string);
            }
        }

        @Nullable
        protected abstract T findNewElement(T var1, String var2);

        protected abstract String getQualifiedName(T var1);

        public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
            if (newElement == null) {
                RenameElement.a(1);
            }
            if (oldQualifiedName == null) {
                RenameElement.a(2);
            }
            this.a.setName(oldQualifiedName);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = d ^ 0x7B5A0E7F1F27L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldQualifiedName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/junit/RefactoringListeners$RenameElement";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "elementRenamedOrMoved";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "undoElementMovedOrRenamed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class SingleClassConfigurationAccessor
    implements Accessor<PsiClass> {
        private final SingleClassConfiguration a;

        public SingleClassConfigurationAccessor(SingleClassConfiguration configuration) {
            this.a = configuration;
        }

        @Override
        public PsiClass getPsiElement() {
            return this.a.getMainClass();
        }

        @Override
        public void setPsiElement(PsiClass psiClass) {
            this.a.setMainClass(psiClass);
        }

        @Override
        public void setName(String qualifiedName) {
            this.a.setMainClassName(qualifiedName);
        }
    }

    public static interface Accessor<T extends PsiElement> {
        public void setName(String var1);

        public T getPsiElement();

        public void setPsiElement(T var1);
    }
}

