/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.editor;

import b.a.lb;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Pair;
import com.intellij.testFramework.LightPlatformTestCase;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class EditorColorSchemeTestCase
extends LightPlatformTestCase {
    private static final long a = lb.a(-2963750923718845079L, -7773530425076807204L, MethodHandles.lookup().lookupClass()).a(108487284269390L);

    protected static EditorColorsScheme loadScheme(@NotNull String docText) throws ParserConfigurationException, IOException, SAXException {
        long l2 = a ^ 0xBDD7CDA5905L;
        if (docText == null) {
            EditorColorSchemeTestCase.a(0);
        }
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource inputSource = new InputSource(new StringReader(docText));
        Document document = documentBuilder.parse(inputSource);
        Element element = new DOMBuilder().build(document.getDocumentElement());
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getScheme("Default");
        EditorColorsSchemeImpl editorColorsSchemeImpl = new EditorColorsSchemeImpl(editorColorsScheme);
        editorColorsSchemeImpl.readExternal(element);
        return editorColorsSchemeImpl;
    }

    @NotNull
    protected Pair<EditorColorsScheme, TextAttributes> doTestWriteRead(@NotNull TextAttributesKey key, @NotNull TextAttributes attributes) {
        long l2 = a ^ 0x4CA7EBF9DC04L;
        if (key == null) {
            EditorColorSchemeTestCase.a(1);
        }
        if (attributes == null) {
            EditorColorSchemeTestCase.a(2);
        }
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getScheme("Default");
        EditorColorsScheme editorColorsScheme2 = (EditorColorsScheme)editorColorsScheme.clone();
        editorColorsScheme2.setName("test");
        editorColorsScheme2.setAttributes(key, attributes);
        Element element = new Element("scheme");
        ((AbstractColorsScheme)editorColorsScheme2).writeExternal(element);
        EditorColorsSchemeImpl editorColorsSchemeImpl = new EditorColorsSchemeImpl(editorColorsScheme);
        editorColorsSchemeImpl.readExternal(element);
        EditorColorSchemeTestCase.assertEquals((String)"test", (String)editorColorsSchemeImpl.getName());
        TextAttributes textAttributes = editorColorsSchemeImpl.getAttributes(key);
        Pair pair2 = Pair.create((Object)editorColorsSchemeImpl, (Object)textAttributes);
        if (pair2 == null) {
            EditorColorSchemeTestCase.a(3);
        }
        return pair2;
    }

    public static void assertXmlOutputEquals(String expected, Element root2) throws IOException {
        StringWriter stringWriter = new StringWriter();
        Format format = Format.getPrettyFormat();
        format.setLineSeparator("\n");
        new XMLOutputter(format).output(root2, (Writer)stringWriter);
        String string = stringWriter.toString();
        EditorColorSchemeTestCase.assertEquals((String)expected, (String)string);
    }

    protected Element serialize(@NotNull EditorColorsScheme scheme) {
        long l2 = a ^ 0x5FAA37A687E4L;
        if (scheme == null) {
            EditorColorSchemeTestCase.a(4);
        }
        Element element = new Element("scheme");
        ((AbstractColorsScheme)scheme).writeExternal(element);
        EditorColorSchemeTestCase.a(element);
        element.removeChildren("metaInfo");
        return element;
    }

    protected Element serializeWithFixedMeta(@NotNull EditorColorsScheme scheme) {
        long l2 = a ^ 0x4946A22BC3D4L;
        if (scheme == null) {
            EditorColorSchemeTestCase.a(5);
        }
        Element element2 = new Element("scheme");
        ((AbstractColorsScheme)scheme).writeExternal(element2);
        EditorColorSchemeTestCase.a(element2);
        Element element3 = element2.getChild("metaInfo");
        if (element3 != null) {
            element3.getChildren().forEach(element -> {
                long l2 = a ^ 0x59AAFCACE361L;
                Attribute attribute = element.getAttribute("name");
                if (!element.getName().equals("property") || attribute == null || !RainbowHighlighter.isRainbowKey((Object)attribute.getValue())) {
                    element.removeContent();
                }
            });
        }
        return element2;
    }

    private static void a(@NotNull Element element) {
        long l2 = a ^ 0x42D0AD889E66L;
        if (element == null) {
            EditorColorSchemeTestCase.a(6);
        }
        ArrayList arrayList = new ArrayList(element.getChildren("option"));
        for (Element element2 : arrayList) {
            String string = element2.getAttributeValue("name");
            if (string == null) continue;
            if ("FONT_SCALE".equals(string) || "EDITOR_FONT_SIZE".equals(string) || "EDITOR_FONT_NAME".equals(string)) {
                element.removeContent((Content)element2);
                continue;
            }
            if (!"CONSOLE_FONT_NAME".equals(string)) continue;
            element2.setAttribute("value", "Test");
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x6FC6FCF99487L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/editor/EditorColorSchemeTestCase";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/editor/EditorColorSchemeTestCase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doTestWriteRead";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadScheme";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doTestWriteRead";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serializeWithFixedMeta";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fixPlatformSpecificValues";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

