/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.palette;

import b.a.lb;
import com.intellij.designer.componentTree.TreeTransfer;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.palette.PaletteGroup;
import com.intellij.designer.palette.PaletteGroupComponent;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicListUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaletteItemsComponent
extends JBList {
    private static final SimpleTextAttributes b;
    private final PaletteGroup c;
    private final DesignerEditorPanel a;
    private int f = -1;
    private boolean e;
    private Integer d;
    private static final long g;

    public PaletteItemsComponent(PaletteGroup group2, @Nullable DesignerEditorPanel designer) {
        this.c = group2;
        this.a = designer;
        this.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return PaletteItemsComponent.this.c.getItems().size();
            }

            @Override
            public Object getElementAt(int index) {
                return PaletteItemsComponent.this.c.getItems().get(index);
            }
        });
        ColoredListCellRenderer coloredListCellRenderer = new ColoredListCellRenderer(){
            private static final long a = lb.a(-1687824116495988358L, 4182203494753706423L, MethodHandles.lookup().lookupClass()).a(172807068308952L);

            protected void customizeCellRenderer(@NotNull JList list2, Object value, int index, boolean selected, boolean hasFocus) {
                long l2 = a ^ 0xDDA55C2424FL;
                if (list2 == null) {
                    2.a(0);
                }
                this.clear();
                PaletteItem paletteItem = (PaletteItem)value;
                boolean bl2 = paletteItem.isEnabled();
                this.setEnabled(bl2);
                if (bl2) {
                    this.setIcon(paletteItem.getIcon());
                } else {
                    this.setIcon(IconLoader.getDisabledIcon((Icon)paletteItem.getIcon()));
                }
                String string = paletteItem.getTitle();
                String string2 = paletteItem.getTooltip();
                String string3 = PaletteItemsComponent.this.a.getVersionLabel(paletteItem.getVersion());
                String string4 = paletteItem.getDeprecatedIn();
                boolean bl3 = PaletteItemsComponent.this.a.isDeprecated(string4);
                this.append(string, bl3 ? b : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                if (!string3.isEmpty()) {
                    string3 = "<sup><i>" + string3 + "</i></sup>";
                }
                if (string2 != null) {
                    String string5 = "";
                    if (bl3) {
                        string5 = String.format("<b>This item is deprecated in version \"%1$s\".<br>", PaletteItemsComponent.this.a.getVersionLabel(string4));
                        String string6 = paletteItem.getDeprecatedHint();
                        if (!StringUtil.isEmpty((String)string6)) {
                            string5 = string5 + string6;
                        }
                        string5 = string5 + "</b><br><br>";
                    }
                    string2 = "<html><body><center><b>" + StringUtil.escapeXml((String)string) + "</b>" + string3 + "</center><p style='width: 300px'>" + string5 + string2 + "</p></body></html>";
                }
                this.setToolTipText(string2);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x50B12C9460A3L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/designer/palette/PaletteItemsComponent$2", "customizeCellRenderer"));
            }
        };
        coloredListCellRenderer.getIpad().left = 2 * UIUtil.getTreeLeftChildIndent();
        coloredListCellRenderer.getIpad().right = UIUtil.getTreeRightChildIndent();
        this.setCellRenderer((ListCellRenderer)coloredListCellRenderer);
        this.setVisibleRowCount(0);
        this.setLayoutOrientation(2);
        this.setSelectionMode(0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e10) {
                PaletteItemsComponent.this.e = SwingUtilities.isLeftMouseButton(e10) && PaletteItemsComponent.this.f >= 0 && PaletteItemsComponent.this.locationToIndex(e10.getPoint()) == PaletteItemsComponent.this.f && !UIUtil.isControlKeyDown((MouseEvent)e10) && !e10.isShiftDown();
            }

            @Override
            public void mouseReleased(MouseEvent e10) {
                if (SwingUtilities.isLeftMouseButton(e10) && PaletteItemsComponent.this.f >= 0 && PaletteItemsComponent.this.locationToIndex(e10.getPoint()) == PaletteItemsComponent.this.f && !UIUtil.isControlKeyDown((MouseEvent)e10) && !e10.isShiftDown() && PaletteItemsComponent.this.e) {
                    PaletteItemsComponent.this.clearSelection();
                }
            }
        });
        this.setDragEnabled(true);
        this.setTransferHandler(new TreeTransfer(PaletteItem.class));
        DnDManager.getInstance().registerSource(new DnDSource(){

            public boolean canStartDragging(DnDAction action, Point dragOrigin) {
                int n2 = PaletteItemsComponent.this.locationToIndex(dragOrigin);
                if (n2 != -1 && PaletteItemsComponent.this.a != null) {
                    PaletteItem paletteItem = PaletteItemsComponent.this.c.getItems().get(n2);
                    PaletteItemsComponent.this.a.activatePaletteItem(paletteItem);
                }
                return false;
            }

            public DnDDragStartBean startDragging(DnDAction action, Point dragOrigin) {
                return null;
            }

            @Nullable
            public Pair<Image, Point> createDraggedImage(DnDAction action, Point dragOrigin) {
                return null;
            }

            public void dragDropEnd() {
            }

            public void dropActionChanged(int gestureModifiers) {
            }
        }, (JComponent)((Object)this));
        this.b();
    }

    public void updateUI() {
        this.setUI(new BasicListUI(){
            MouseListener myListener;

            @Override
            protected void updateLayoutState() {
                super.updateLayoutState();
                Insets insets = this.list.getInsets();
                int n2 = this.list.getWidth() - (insets.left + insets.right);
                if (n2 >= this.cellWidth) {
                    int n3 = n2 / this.cellWidth;
                    this.cellWidth = n3 == 0 ? 1 : n2 / n3;
                }
            }

            @Override
            protected void installListeners() {
                this.myListener = new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e10) {
                        PaletteItemsComponent.this.f = list.getSelectedIndex();
                    }
                };
                PaletteItemsComponent.this.addMouseListener(this.myListener);
                super.installListeners();
            }

            @Override
            protected void uninstallListeners() {
                if (this.myListener != null) {
                    PaletteItemsComponent.this.removeMouseListener(this.myListener);
                }
                super.uninstallListeners();
            }
        });
        this.invalidate();
    }

    public int getWidth() {
        return this.d == null ? super.getWidth() : this.d.intValue();
    }

    public int getPreferredHeight(int width2) {
        this.d = width2;
        try {
            int n2 = this.getUI().getPreferredSize((JComponent)((Object)this)).height;
            return n2;
        }
        finally {
            this.d = null;
        }
    }

    public void takeFocusFrom(int indexToSelect) {
        if (indexToSelect == -1) {
            indexToSelect = this.getModel().getSize() - 1;
        } else if (this.getModel().getSize() == 0) {
            indexToSelect = -1;
        }
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this), true));
        this.setSelectedIndex(indexToSelect);
        if (indexToSelect >= 0) {
            this.ensureIndexIsVisible(indexToSelect);
        }
    }

    public void restoreSelection(PaletteItem paletteItem) {
        if (paletteItem == null) {
            this.clearSelection();
        } else {
            int n2 = this.c.getItems().indexOf(paletteItem);
            if (n2 == -1) {
                this.clearSelection();
            } else {
                this.takeFocusFrom(n2);
            }
        }
    }

    private void b() {
        long l2 = g ^ 0x724086C926C3L;
        ActionMap actionMap = this.getActionMap();
        actionMap.put("selectPreviousRow", new MoveFocusAction(actionMap.get("selectPreviousRow"), false));
        actionMap.put("selectNextRow", new MoveFocusAction(actionMap.get("selectNextRow"), true));
        actionMap.put("selectPreviousColumn", new MoveFocusAction(new ChangeColumnAction(actionMap.get("selectPreviousColumn"), false), false));
        actionMap.put("selectNextColumn", new MoveFocusAction(new ChangeColumnAction(actionMap.get("selectNextColumn"), true), true));
    }

    static {
        g = lb.a(-202323543564445651L, 5023214373364708781L, MethodHandles.lookup().lookupClass()).a(37217034540409L);
        b = new SimpleTextAttributes(4, null);
    }

    private class ChangeColumnAction
    extends AbstractAction {
        private final Action a;
        private final boolean b;

        ChangeColumnAction(Action defaultAction, boolean selectNext) {
            this.a = defaultAction;
            this.b = selectNext;
        }

        @Override
        public void actionPerformed(ActionEvent e10) {
            int n2 = PaletteItemsComponent.this.getSelectedIndex();
            this.a.actionPerformed(e10);
            int n3 = PaletteItemsComponent.this.getSelectedIndex();
            if (this.b && n2 < n3 || !this.b && n2 > n3) {
                return;
            }
            if (this.b) {
                if (n3 == n2 + 1) {
                    ++n3;
                }
                if (n3 < PaletteItemsComponent.this.getModel().getSize() - 1) {
                    PaletteItemsComponent.this.setSelectedIndex(n3 + 1);
                    PaletteItemsComponent.this.scrollRectToVisible(PaletteItemsComponent.this.getCellBounds(n3 + 1, n3 + 1));
                }
            } else if (n3 > 0) {
                PaletteItemsComponent.this.setSelectedIndex(n3 - 1);
                PaletteItemsComponent.this.scrollRectToVisible(PaletteItemsComponent.this.getCellBounds(n3 - 1, n3 - 1));
            }
        }
    }

    private class MoveFocusAction
    extends AbstractAction {
        private final Action a;
        private final boolean b;

        MoveFocusAction(Action defaultAction, boolean focusNext) {
            this.a = defaultAction;
            this.b = focusNext;
        }

        @Override
        public void actionPerformed(ActionEvent e10) {
            Component component;
            int n2 = PaletteItemsComponent.this.getSelectedIndex();
            this.a.actionPerformed(e10);
            int n3 = PaletteItemsComponent.this.getSelectedIndex();
            if (n2 != n3) {
                return;
            }
            if (this.b && n3 == 0) {
                return;
            }
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Container container = keyboardFocusManager.getCurrentFocusCycleRoot();
            FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
            if (focusTraversalPolicy == null) {
                focusTraversalPolicy = keyboardFocusManager.getDefaultFocusTraversalPolicy();
            }
            Component component2 = component = this.b ? focusTraversalPolicy.getComponentAfter(container, (Component)((Object)PaletteItemsComponent.this)) : focusTraversalPolicy.getComponentBefore(container, (Component)((Object)PaletteItemsComponent.this));
            if (component instanceof PaletteGroupComponent) {
                PaletteItemsComponent.this.clearSelection();
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(component, true));
                ((PaletteGroupComponent)component).scrollRectToVisible(component.getBounds());
            }
        }
    }
}

