/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.inspector.impl;

import com.intellij.designer.inspector.Property;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JTree;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public abstract class InspectorTreeUtil {
    public static int getNodeDepth(JTree tree2, TreeNode node) {
        TreePath treePath = TreeUtil.getPathFromRoot((TreeNode)node);
        return treePath.getPathCount() - (tree2.isRootVisible() ? 1 : 2);
    }

    public static int getAvailableWidth(JTree tree2, Property p2) {
        return InspectorTreeUtil.getAvailableWidth(tree2, InspectorTreeUtil.getNodeDepth(tree2, p2));
    }

    public static int getAvailableWidth(JTree tree2, int depth) {
        return tree2.getSize().width - (tree2.getInsets().right + tree2.getInsets().left + InspectorTreeUtil.getRowX(tree2, depth));
    }

    public static void invalidateTreeHeightCache(JTree tree2) {
        tree2.setRowHeight(1);
        tree2.setRowHeight(-1);
    }

    @Nullable
    public static <T extends Component> T getParentOfType(Component source, Class<T> clazz) {
        Container container = source.getParent();
        while (container != null) {
            if (!clazz.isInstance(container)) continue;
            return (T)container;
        }
        return null;
    }

    public static int getRowX(JTree tree2, int depth) {
        TreeUI treeUI = tree2.getUI();
        if (treeUI instanceof BasicTreeUI) {
            BasicTreeUI basicTreeUI = (BasicTreeUI)treeUI;
            return (basicTreeUI.getLeftChildIndent() + basicTreeUI.getRightChildIndent()) * depth;
        }
        int n2 = UIUtil.getTreeLeftChildIndent();
        int n3 = UIUtil.getTreeRightChildIndent();
        return (n2 + n3) * depth;
    }
}

