/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.tools;

import b.a.lb;
import com.intellij.designer.DesignerBundle;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.utils.Cursors;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ResizeTracker
extends InputTool {
    private final int g;
    private final String h;
    private OperationContext j;
    private List<EditOperation> i;
    private boolean f;
    private static final long k = lb.a(9221791977992524137L, 131768709860796656L, MethodHandles.lookup().lookupClass()).a(199334884096021L);

    public ResizeTracker(int direction, Object type, @Nullable String description) {
        this.g = direction;
        this.h = description;
        this.j = new OperationContext(type);
        this.j.setResizeDirection(direction);
        this.setDefaultCursor(Cursors.getResizeCursor(direction));
        this.setDisabledCursor(Cursors.getNoCursor());
    }

    @Override
    @Nullable
    protected String getDescription() {
        return this.h;
    }

    @Override
    public void deactivate() {
        this.e();
        this.j = null;
        this.i = null;
        super.deactivate();
    }

    @Override
    protected Cursor calculateCursor() {
        if (this.myState == 2) {
            return this.getDefaultCursor();
        }
        return super.calculateCursor();
    }

    @Override
    protected void handleButtonDown(int button) {
        if (button == 1) {
            if (this.myState == 1) {
                this.myState = 2;
            }
        } else {
            this.myState = 4;
            this.e();
            this.setExecuteEnabled(false);
        }
    }

    @Override
    protected void handleButtonUp(int button) {
        if (this.myState == 3) {
            this.myState = 0;
            this.e();
            this.d();
        }
    }

    @Override
    protected void handleDragStarted() {
        if (this.myState == 2) {
            this.myState = 3;
        }
    }

    @Override
    protected void handleDragInProgress() {
        if (this.myState == 3) {
            this.c();
            this.f();
            this.a();
        }
    }

    private void f() {
        for (EditOperation editOperation : this.g()) {
            editOperation.showFeedback();
        }
        this.f = true;
    }

    private void e() {
        if (this.f) {
            this.f = false;
            for (EditOperation editOperation : this.g()) {
                editOperation.eraseFeedback();
            }
        }
    }

    private void d() {
        long l2 = k ^ 0x170915DFCC99L;
        if (this.myExecuteEnabled) {
            ArrayList<EditOperation> arrayList = new ArrayList<EditOperation>();
            for (EditOperation editOperation : this.g()) {
                if (!editOperation.canExecute()) continue;
                arrayList.add(editOperation);
            }
            this.myToolProvider.execute(arrayList, DesignerBundle.message("command.tool_operation", new Object[0]));
        }
    }

    private void a() {
        for (EditOperation editOperation : this.g()) {
            if (!editOperation.canExecute()) continue;
            this.setExecuteEnabled(true);
            return;
        }
        this.setExecuteEnabled(false);
    }

    private void c() {
        this.j.setArea(this.myArea);
        this.j.setInputEvent(this.myInputEvent);
        this.j.setModifiers(this.myModifiers);
        Point point = new Point();
        Dimension dimension = new Dimension();
        int n2 = this.moveDeltaWidth();
        if ((this.g & 4) != 0) {
            point.x += n2;
            dimension.width -= n2;
        } else if ((this.g & 8) != 0) {
            dimension.width += n2;
        }
        int n3 = this.moveDeltaHeight();
        if ((this.g & 1) != 0) {
            point.y += n3;
            dimension.height -= n3;
        } else if ((this.g & 2) != 0) {
            dimension.height += n3;
        }
        this.j.setMoveDelta(point);
        this.j.setSizeDelta(dimension);
        this.j.setLocation(this.getLocation());
    }

    private List<EditOperation> g() {
        if (this.i == null) {
            this.j.setComponents(new ArrayList<RadComponent>(this.myArea.getSelection()));
            this.i = new ArrayList<EditOperation>();
            for (RadComponent radComponent : this.j.getComponents()) {
                RadComponent radComponent2 = radComponent.getParent();
                EditOperation editOperation = radComponent2 == null ? this.myArea.processRootOperation(this.j) : radComponent2.getLayout().processChildOperation(this.j);
                if (editOperation == null) continue;
                this.i.add(editOperation);
                editOperation.setComponent(radComponent);
            }
        }
        return this.i;
    }

    @Override
    public void keyPressed(KeyEvent event, EditableArea area) throws Exception {
        boolean bl2 = event.getModifiers() != this.myModifiers;
        super.keyPressed(event, area);
        if (event.getKeyCode() == 27) {
            this.myToolProvider.loadDefaultTool();
        } else if (bl2) {
            this.b();
        }
    }

    @Override
    public void keyReleased(KeyEvent event, EditableArea area) throws Exception {
        boolean bl2 = event.getModifiers() != this.myModifiers;
        super.keyReleased(event, area);
        if (bl2) {
            this.b();
        }
    }

    private void b() {
        if (this.j != null) {
            this.c();
            this.f();
            this.a();
        }
    }
}

