/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.tools;

import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.tools.ToolProvider;
import java.awt.Cursor;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public abstract class InputTool {
    protected static final int STATE_NONE = 0;
    protected static final int STATE_INIT = 1;
    protected static final int STATE_DRAG = 2;
    protected static final int STATE_DRAG_IN_PROGRESS = 3;
    protected static final int STATE_INVALID = 4;
    protected ToolProvider myToolProvider;
    protected EditableArea myArea;
    protected boolean myExecuteEnabled;
    private boolean d;
    protected int myState;
    protected int myCurrentScreenX;
    protected int myCurrentScreenY;
    protected InputEvent myInputEvent;
    protected int myModifiers;
    protected int myButton;
    protected int myStartScreenX;
    protected int myStartScreenY;
    private boolean b;
    private Cursor a;
    private Cursor c;
    private static final int e = 5;

    public void activate() {
        this.b = false;
        this.resetState();
        this.myState = 1;
        this.d = true;
    }

    public void deactivate() {
        this.d = false;
        this.setExecuteEnabled(false);
    }

    protected void resetState() {
        this.myCurrentScreenX = 0;
        this.myCurrentScreenY = 0;
        this.myInputEvent = null;
        this.myButton = 0;
        this.myStartScreenX = 0;
        this.myStartScreenY = 0;
    }

    public final void setToolProvider(ToolProvider provider) {
        this.myToolProvider = provider;
    }

    public final void setArea(@Nullable EditableArea area) {
        if (this.myArea != area) {
            this.setCursor(null);
            this.myArea = area;
            if (this.myArea != null) {
                Point point = MouseInfo.getPointerInfo().getLocation();
                SwingUtilities.convertPointFromScreen(point, this.myArea.getNativeComponent());
                this.myCurrentScreenX = point.x;
                this.myCurrentScreenY = point.y;
            }
            this.refreshCursor();
        }
    }

    protected final void setExecuteEnabled(boolean enabled) {
        this.myExecuteEnabled = enabled;
        this.refreshCursor();
    }

    protected final void setCursor(@Nullable Cursor cursor) {
        if (this.myArea != null) {
            this.myArea.setCursor(cursor);
        }
    }

    public void refreshCursor() {
        if (this.d) {
            this.setCursor(this.calculateCursor());
        }
    }

    @Nullable
    protected Cursor calculateCursor() {
        if (this.myState == 0) {
            return null;
        }
        return this.myExecuteEnabled ? this.getDefaultCursor() : this.getDisabledCursor();
    }

    protected Cursor getDefaultCursor() {
        return this.a;
    }

    public final void setDefaultCursor(@Nullable Cursor cursor) {
        if (this.a != cursor) {
            this.a = cursor;
            this.refreshCursor();
        }
    }

    protected final Cursor getDisabledCursor() {
        return this.c == null ? this.getDefaultCursor() : this.c;
    }

    public final void setDisabledCursor(@Nullable Cursor cursor) {
        if (this.c != cursor) {
            this.c = cursor;
            this.refreshCursor();
        }
    }

    @Nullable
    protected String getDescription() {
        return null;
    }

    public void keyTyped(KeyEvent event, EditableArea area) throws Exception {
        this.a(event);
        this.setArea(area);
    }

    public void keyPressed(KeyEvent event, EditableArea area) throws Exception {
        this.a(event);
        this.setArea(area);
    }

    public void keyReleased(KeyEvent event, EditableArea area) throws Exception {
        this.a(event);
        this.setArea(area);
    }

    private void a(KeyEvent keyEvent) {
        this.myInputEvent = keyEvent;
        this.myModifiers = keyEvent.getModifiers();
    }

    protected final boolean isShiftPressed() {
        return (this.myModifiers & 1) != 0;
    }

    protected final boolean isAltOptionPressed() {
        return (this.myModifiers & 8) != 0;
    }

    protected final boolean isCtrlCmdPressed() {
        return (this.myModifiers & 0x102) != 0;
    }

    private void a(MouseEvent mouseEvent) {
        this.myCurrentScreenX = mouseEvent.getX();
        this.myCurrentScreenY = mouseEvent.getY();
        this.myModifiers = mouseEvent.getModifiers();
        this.myButton = mouseEvent.getButton();
        this.myInputEvent = mouseEvent;
        this.myToolProvider.setEvent(mouseEvent);
    }

    private boolean a() {
        if (!this.b) {
            this.b = Math.abs(this.moveDeltaWidth()) > 5 || Math.abs(this.moveDeltaHeight()) > 5;
        }
        return this.b;
    }

    protected final int moveDeltaWidth() {
        return this.myCurrentScreenX - this.myStartScreenX;
    }

    protected final int moveDeltaHeight() {
        return this.myCurrentScreenY - this.myStartScreenY;
    }

    protected final Point getLocation() {
        return new Point(this.myCurrentScreenX, this.myCurrentScreenY);
    }

    protected void handleButtonDown(int button) {
    }

    protected void handleButtonUp(int button) {
    }

    protected void handleMove() {
    }

    protected void handleDrag() {
    }

    protected void handleDragStarted() {
    }

    protected void handleDragInProgress() {
    }

    protected void handlePopup() {
    }

    protected void handleDoubleClick(int button) {
    }

    protected void handleAreaExited() {
    }

    public void mouseDown(MouseEvent event, EditableArea area) throws Exception {
        this.setArea(area);
        this.a(event);
        this.myStartScreenX = event.getX();
        this.myStartScreenY = event.getY();
        this.handleButtonDown(event.getButton());
    }

    public void mouseUp(MouseEvent event, EditableArea area) throws Exception {
        this.setArea(area);
        this.a(event);
        this.handleButtonUp(event.getButton());
    }

    public void mouseMove(MouseEvent event, EditableArea area) throws Exception {
        this.setArea(area);
        this.a(event);
        if (this.myState == 3) {
            this.handleDragInProgress();
        } else {
            this.handleMove();
        }
    }

    public void mouseDrag(MouseEvent event, EditableArea area) throws Exception {
        this.setArea(area);
        boolean bl2 = this.a();
        this.a(event);
        this.handleDrag();
        if (this.a()) {
            if (!bl2) {
                this.handleDragStarted();
            }
            this.handleDragInProgress();
        }
    }

    public void mousePopup(MouseEvent event, EditableArea area) throws Exception {
        this.setArea(area);
        this.a(event);
        this.handlePopup();
    }

    public void mouseDoubleClick(MouseEvent event, EditableArea area) throws Exception {
        this.setArea(area);
        this.a(event);
        this.handleDoubleClick(event.getButton());
    }

    public void mouseEntered(MouseEvent event, EditableArea area) throws Exception {
        this.a(event);
        if (this.myArea != null) {
            this.handleAreaExited();
        }
        this.setArea(area);
        this.myToolProvider.setArea(area);
    }

    public void mouseExited(MouseEvent event, EditableArea area) throws Exception {
        if (this.myArea == area) {
            this.a(event);
            this.handleAreaExited();
            this.setArea(null);
            this.myToolProvider.setArea(null);
        }
    }
}

