/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.selection;

import com.intellij.designer.designSurface.DecorationLayer;
import com.intellij.designer.designSurface.selection.NonResizeSelectionDecorator;
import com.intellij.designer.designSurface.selection.ResizePoint;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.model.RadComponent;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;

public class ResizeSelectionDecorator
extends NonResizeSelectionDecorator {
    private final List<ResizePoint> c = new ArrayList<ResizePoint>();

    public ResizeSelectionDecorator(Color color, int lineWidth) {
        super(color, lineWidth);
    }

    public void clear() {
        this.c.clear();
    }

    public void addPoint(ResizePoint point) {
        this.c.add(point);
    }

    @Override
    public InputTool findTargetTool(DecorationLayer layer, RadComponent component, int x2, int y2) {
        for (ResizePoint resizePoint : this.c) {
            InputTool inputTool;
            if (!this.visible(component, resizePoint) || (inputTool = resizePoint.findTargetTool(layer, component, x2, y2)) == null) continue;
            return inputTool;
        }
        return super.findTargetTool(layer, component, x2, y2);
    }

    @Override
    public void decorate(DecorationLayer layer, Graphics2D g10, RadComponent component) {
        super.decorate(layer, g10, component);
        for (ResizePoint resizePoint : this.c) {
            if (!this.visible(component, resizePoint)) continue;
            resizePoint.decorate(layer, g10, component);
        }
    }

    protected boolean visible(RadComponent component, ResizePoint point) {
        return true;
    }
}

