/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.selection;

import com.intellij.designer.designSurface.ComponentDecorator;
import com.intellij.designer.designSurface.DecorationLayer;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.model.RadComponent;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class ResizePoint
extends ComponentDecorator {
    private static final int b = 5;
    private final Color a;
    private final Color c;

    public ResizePoint() {
        this(Color.GREEN, Color.BLACK);
    }

    public ResizePoint(Color color, Color border) {
        this.a = color;
        this.c = border;
    }

    @Override
    public InputTool findTargetTool(DecorationLayer layer, RadComponent component, int x2, int y2) {
        Point point = this.getLocation(layer, component);
        Rectangle rectangle = new Rectangle(point.x, point.y, this.getSize(), this.getSize());
        int n2 = this.getNeighborhoodSize();
        if (n2 > 0) {
            rectangle.grow(n2, n2);
        }
        if (rectangle.contains(x2, y2)) {
            return this.createTool(component);
        }
        return null;
    }

    @Override
    protected void paint(DecorationLayer layer, Graphics2D g10, RadComponent component) {
        Point point = this.getLocation(layer, component);
        g10.setColor(this.a);
        g10.fillRect(point.x, point.y, this.getSize(), this.getSize());
        g10.setColor(this.c);
        g10.drawRect(point.x, point.y, this.getSize(), this.getSize());
    }

    public abstract Object getType();

    protected abstract InputTool createTool(RadComponent var1);

    protected abstract Point getLocation(DecorationLayer var1, RadComponent var2);

    protected int getSize() {
        return 5;
    }

    protected int getNeighborhoodSize() {
        return 0;
    }
}

