/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface;

import b.a.lb;
import com.intellij.designer.AbstractToolWindowManager;
import com.intellij.designer.DesignerEditor;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.DesignerEditorState;
import com.intellij.designer.DesignerToolWindowContent;
import com.intellij.designer.DesignerToolWindowManager;
import com.intellij.designer.LightFillLayout;
import com.intellij.designer.ModuleProvider;
import com.intellij.designer.PaletteToolWindowContent;
import com.intellij.designer.actions.AbstractComboBoxAction;
import com.intellij.designer.actions.CommonEditActionsProvider;
import com.intellij.designer.actions.DesignerActionPanel;
import com.intellij.designer.componentTree.TreeComponentDecorator;
import com.intellij.designer.componentTree.TreeEditableArea;
import com.intellij.designer.designSurface.CaptionPanel;
import com.intellij.designer.designSurface.ComponentDecorator;
import com.intellij.designer.designSurface.ComponentEditableArea;
import com.intellij.designer.designSurface.ComponentSelectionListener;
import com.intellij.designer.designSurface.ComponentTargetFilter;
import com.intellij.designer.designSurface.DecorationLayer;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.designSurface.GlassLayer;
import com.intellij.designer.designSurface.InplaceEditingLayer;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.QuickFixManager;
import com.intellij.designer.designSurface.ZoomType;
import com.intellij.designer.designSurface.tools.ComponentCreationFactory;
import com.intellij.designer.designSurface.tools.ComponentPasteFactory;
import com.intellij.designer.designSurface.tools.CreationTool;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.designSurface.tools.MarqueeTracker;
import com.intellij.designer.designSurface.tools.PasteTool;
import com.intellij.designer.designSurface.tools.SelectionTool;
import com.intellij.designer.designSurface.tools.ToolProvider;
import com.intellij.designer.model.FindComponentVisitor;
import com.intellij.designer.model.Property;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadPropertyContext;
import com.intellij.designer.model.WrapInProvider;
import com.intellij.designer.palette.PaletteGroup;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.designer.palette.PaletteToolWindowManager;
import com.intellij.designer.propertyTable.InplaceContext;
import com.intellij.designer.propertyTable.PropertyTableTab;
import com.intellij.designer.propertyTable.TablePanelActionPolicy;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.FixedHashMap;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Scrollable;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DesignerEditorPanel
extends JPanel
implements DesignerEditorPanelFacade,
DataProvider,
ModuleProvider,
RadPropertyContext {
    private static final Logger A;
    protected static final Integer LAYER_COMPONENT;
    protected static final Integer LAYER_DECORATION;
    protected static final Integer LAYER_FEEDBACK;
    protected static final Integer LAYER_GLASS;
    protected static final Integer LAYER_INPLACE_EDITING;
    private static final Integer l;
    private static final String u = "designer";
    private static final String f = "error";
    private static final String r = "stack";
    private static final String D = "no_stack";
    @NotNull
    private final DesignerEditor w;
    private final Project n;
    private Module v;
    protected final VirtualFile myFile;
    private final CardLayout s;
    private final ThreeComponentsSplitter c;
    private final JPanel y;
    private JComponent C;
    protected DesignerActionPanel myActionPanel;
    protected CaptionPanel myHorizontalCaption;
    protected CaptionPanel myVerticalCaption;
    protected JScrollPane myScrollPane;
    protected JLayeredPane myLayeredPane;
    protected GlassLayer myGlassLayer;
    private DecorationLayer g;
    private FeedbackLayer q;
    private InplaceEditingLayer b;
    protected ToolProvider myToolProvider;
    protected EditableArea mySurfaceArea;
    protected RadComponent myRootComponent;
    protected QuickFixManager myQuickFixManager;
    private PaletteItem o;
    private List<?> d;
    private final Map<String, Property> a;
    private int[][] p;
    private int[][] z;
    private final Map<String, int[][]> B;
    private FixableMessageAction x;
    private JPanel t;
    protected JPanel myErrorMessages;
    private JPanel m;
    private CardLayout e;
    private JTextArea i;
    private JPanel k;
    private AsyncProcessIcon j;
    private JLabel h;
    protected String myLastExecuteCommand;
    private static final long E;

    public DesignerEditorPanel(@NotNull DesignerEditor editor, @NotNull Project project2, Module module2, @NotNull VirtualFile file) {
        if (editor == null) {
            DesignerEditorPanel.a(0);
        }
        if (project2 == null) {
            DesignerEditorPanel.a(1);
        }
        if (file == null) {
            DesignerEditorPanel.a(2);
        }
        this.s = new CardLayout();
        this.c = new ThreeComponentsSplitter();
        this.y = new JPanel(this.s);
        this.a = new HashMap<String, Property>();
        this.B = new FixedHashMap(16);
        this.w = editor;
        this.n = project2;
        this.v = module2;
        this.myFile = file;
        this.d();
        this.myToolProvider.loadDefaultTool();
    }

    private void d() {
        long l2 = E ^ 0x758845C058AEL;
        this.setLayout(new BorderLayout());
        this.c.setDividerWidth(0);
        this.c.setDividerMouseZoneSize(Registry.intValue((String)"ide.splitter.mouseZone"));
        this.add((Component)this.c, "Center");
        this.c();
        this.f();
        this.g();
        UIUtil.invokeLaterIfNeeded(() -> {
            DesignerEditorPanel designerEditorPanel = this;
            this.getDesignerWindowManager().bind(designerEditorPanel);
            this.getPaletteWindowManager().bind(designerEditorPanel);
        });
    }

    private void c() {
        long l2 = E ^ 0x2463DFF8A477L;
        JPanel jPanel = new JPanel((LayoutManager)new LightFillLayout());
        this.c.setInnerComponent((JComponent)jPanel);
        this.myLayeredPane = new MyLayeredPane();
        this.mySurfaceArea = this.createEditableArea();
        this.myToolProvider = this.createToolProvider();
        this.myGlassLayer = this.createGlassLayer(this.myToolProvider, this.mySurfaceArea);
        this.myLayeredPane.add((Component)this.myGlassLayer, LAYER_GLASS);
        this.g = this.createDecorationLayer();
        this.myLayeredPane.add((Component)this.g, LAYER_DECORATION);
        this.q = this.createFeedbackLayer();
        this.myLayeredPane.add((Component)this.q, LAYER_FEEDBACK);
        this.b = this.createInplaceEditingLayer();
        this.myLayeredPane.add((Component)this.b, LAYER_INPLACE_EDITING);
        this.myScrollPane = this.createScrollPane(this.myLayeredPane);
        this.myQuickFixManager = new QuickFixManager(this, this.myGlassLayer, this.myScrollPane.getViewport());
        this.myActionPanel = this.createActionPanel();
        this.x = new FixableMessageAction(this);
        jPanel.add(this.myActionPanel.getToolbarComponent());
        jPanel.add(this.y);
        this.C = this.createDesignerCardPanel();
        this.y.add((Component)this.C, u);
        this.mySurfaceArea.addSelectionListener(new ComponentSelectionListener(){

            @Override
            public void selectionChanged(EditableArea area) {
                DesignerEditorPanel.this.a();
            }
        });
    }

    protected JComponent createDesignerCardPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.myVerticalCaption = this.createCaptionPanel(false);
        jPanel.add((Component)((Object)this.myVerticalCaption), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.myHorizontalCaption = this.createCaptionPanel(true);
        jPanel.add((Component)((Object)this.myHorizontalCaption), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.myScrollPane, gridBagConstraints);
        this.myHorizontalCaption.attachToScrollPane(this.myScrollPane);
        this.myVerticalCaption.attachToScrollPane(this.myScrollPane);
        return jPanel;
    }

    public final ThreeComponentsSplitter getContentSplitter() {
        return this.c;
    }

    protected EditableArea createEditableArea() {
        return new DesignerEditableArea();
    }

    protected ToolProvider createToolProvider() {
        return new DesignerToolProvider();
    }

    protected GlassLayer createGlassLayer(ToolProvider provider, EditableArea area) {
        return new GlassLayer(provider, area);
    }

    protected DecorationLayer createDecorationLayer() {
        return new DecorationLayer(this, this.mySurfaceArea);
    }

    protected FeedbackLayer createFeedbackLayer() {
        return new FeedbackLayer(this);
    }

    protected InplaceEditingLayer createInplaceEditingLayer() {
        return new InplaceEditingLayer(this);
    }

    protected CaptionPanel createCaptionPanel(boolean horizontal) {
        return new CaptionPanel(this, horizontal, true);
    }

    protected JScrollPane createScrollPane(@NotNull JLayeredPane content) {
        if (content == null) {
            DesignerEditorPanel.a(3);
        }
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)content);
        jScrollPane.setBackground((Color)new JBColor(Color.WHITE, UIUtil.getListBackground()));
        return jScrollPane;
    }

    protected DesignerActionPanel createActionPanel() {
        return new DesignerActionPanel(this, this.myGlassLayer);
    }

    @Nullable
    public final PaletteItem getActivePaletteItem() {
        return this.o;
    }

    public final void activatePaletteItem(@Nullable PaletteItem paletteItem) {
        this.o = paletteItem;
        if (paletteItem != null) {
            this.myToolProvider.setActiveTool(new CreationTool(true, this.createCreationFactory(paletteItem)));
        } else if (this.myToolProvider.getActiveTool() instanceof CreationTool) {
            this.myToolProvider.loadDefaultTool();
        }
    }

    protected final void showDesignerCard() {
        long l2 = E ^ 0x62EA75E3BAE3L;
        this.myErrorMessages.removeAll();
        this.i.setText(null);
        this.myLayeredPane.revalidate();
        if (this.myHorizontalCaption != null) {
            this.myHorizontalCaption.update();
        }
        if (this.myVerticalCaption != null) {
            this.myVerticalCaption.update();
        }
        this.s.show(this.y, u);
    }

    private void f() {
        long l2 = E ^ 0x9635E696E0DL;
        this.t = new JPanel(new BorderLayout());
        this.myErrorMessages = new JPanel((LayoutManager)new VerticalFlowLayout(0, 10, 5, true, false));
        this.t.add((Component)this.myErrorMessages, "First");
        this.i = new JTextArea(50, 20);
        this.i.setEditable(false);
        this.e = new CardLayout();
        this.m = new JPanel(this.e);
        this.m.add((Component)new JLabel(), D);
        this.m.add((Component)ScrollPaneFactory.createScrollPane((Component)this.i), r);
        this.t.add((Component)this.m, "Center");
        this.y.add((Component)this.t, f);
    }

    public final void showError(@NotNull String message, @NotNull Throwable e10) {
        if (message == null) {
            DesignerEditorPanel.a(4);
        }
        if (e10 == null) {
            DesignerEditorPanel.a(5);
        }
        if (this.isProjectClosed()) {
            return;
        }
        while (e10 instanceof InvocationTargetException && e10.getCause() != null) {
            e10 = e10.getCause();
        }
        ErrorInfo errorInfo = new ErrorInfo();
        errorInfo.myMessage = errorInfo.myDisplayMessage = message;
        errorInfo.myThrowable = e10;
        this.configureError(errorInfo);
        if (errorInfo.myShowMessage) {
            this.showErrorPage(errorInfo);
        }
        if (errorInfo.myShowLog) {
            A.error(message, e10, this.getErrorAttachments(errorInfo));
        }
    }

    protected Attachment[] getErrorAttachments(ErrorInfo info) {
        return new Attachment[]{AttachmentFactory.createAttachment((VirtualFile)this.myFile)};
    }

    protected abstract void configureError(@NotNull ErrorInfo var1);

    protected void showErrorPage(ErrorInfo info) {
        long l2 = E ^ 0x6E1ACE53088AL;
        this.storeState();
        this.hideProgress();
        this.myRootComponent = null;
        this.myErrorMessages.removeAll();
        if (info.myShowStack) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            info.myThrowable.printStackTrace(new PrintStream(byteArrayOutputStream));
            this.i.setText(byteArrayOutputStream.toString());
            this.e.show(this.m, r);
        } else {
            this.i.setText(null);
            this.e.show(this.m, D);
        }
        this.addErrorMessage(new FixableMessageInfo(true, info.myDisplayMessage, "", "", null, null), Messages.getErrorIcon());
        for (FixableMessageInfo fixableMessageInfo : info.myMessages) {
            this.addErrorMessage(fixableMessageInfo, fixableMessageInfo.myErrorIcon ? Messages.getErrorIcon() : Messages.getWarningIcon());
        }
        this.t.revalidate();
        this.s.show(this.y, f);
        this.getDesignerToolWindow().refresh(true);
        this.repaint();
    }

    protected void addErrorMessage(final FixableMessageInfo message, Icon icon) {
        Object object;
        long l2 = E ^ 0x66C5D27914A3L;
        if (message.myLinkText.length() > 0 || message.myAfterLinkText.length() > 0) {
            object = new HyperlinkLabel();
            object.setOpaque(false);
            object.setHyperlinkText(message.myBeforeLinkText, message.myLinkText, message.myAfterLinkText);
            object.setIcon(icon);
            if (message.myQuickFix != null) {
                object.addHyperlinkListener(new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e10) {
                        if (e10.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            message.myQuickFix.run();
                        }
                    }
                });
            }
            this.myErrorMessages.add((Component)object);
        } else {
            object = new JBLabel();
            object.setOpaque(false);
            object.setText("<html><body>" + message.myBeforeLinkText.replace("\n", "<br>") + "</body></html>");
            object.setIcon(icon);
            this.myErrorMessages.add((Component)object);
        }
        if (message.myAdditionalFixes != null && message.myAdditionalFixes.size() > 0) {
            object = new JPanel(new FlowLayout(0, 5, 0));
            ((JComponent)object).setBorder((Border)JBUI.Borders.empty((int)3, (int)0, (int)10, (int)0));
            ((JComponent)object).setOpaque(false);
            ((Container)object).add(Box.createHorizontalStrut(icon.getIconWidth()));
            for (Pair<String, Runnable> pair2 : message.myAdditionalFixes) {
                HyperlinkLabel hyperlinkLabel = new HyperlinkLabel();
                hyperlinkLabel.setOpaque(false);
                hyperlinkLabel.setHyperlinkText((String)pair2.getFirst());
                final Runnable runnable = (Runnable)pair2.getSecond();
                hyperlinkLabel.addHyperlinkListener(new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e10) {
                        if (e10.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            runnable.run();
                        }
                    }
                });
                ((Container)object).add((Component)hyperlinkLabel);
            }
            this.myErrorMessages.add((Component)object);
        }
    }

    protected final void showWarnMessages(@Nullable List<FixableMessageInfo> messages) {
        if (messages == null) {
            this.x.hide();
        } else {
            this.x.show(messages);
        }
    }

    private void g() {
        long l2 = E ^ 0x24A90490041CL;
        this.j = new AsyncProcessIcon("Designer progress");
        this.h = new JLabel();
        JPanel jPanel = new JPanel();
        jPanel.add((Component)this.j);
        jPanel.add(this.h);
        jPanel.setBorder((Border)IdeBorderFactory.createRoundedBorder());
        this.k = new JPanel(new GridBagLayout());
        this.k.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.k.setOpaque(false);
    }

    protected final void showProgress(String message) {
        this.h.setText(message);
        if (this.k.getParent() == null) {
            this.myGlassLayer.setEnabled(false);
            this.j.resume();
            this.myLayeredPane.add((Component)this.k, l);
            this.myLayeredPane.repaint();
        }
    }

    protected final void hideProgress() {
        this.myGlassLayer.setEnabled(true);
        this.j.suspend();
        this.myLayeredPane.remove(this.k);
    }

    @Override
    @NotNull
    public final Module getModule() {
        long l2 = E ^ 0x2D67F4F8E517L;
        if (this.v.isDisposed()) {
            this.v = this.findModule(this.n, this.myFile);
            if (this.v == null) {
                throw new IllegalArgumentException("No module for file " + this.myFile + " in project " + this.n);
            }
        }
        Module module2 = this.v;
        if (module2 == null) {
            DesignerEditorPanel.a(6);
        }
        return module2;
    }

    @Nullable
    protected Module findModule(Project project2, VirtualFile file) {
        return ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project2);
    }

    @NotNull
    public final DesignerEditor getEditor() {
        DesignerEditor designerEditor = this.w;
        if (designerEditor == null) {
            DesignerEditorPanel.a(7);
        }
        return designerEditor;
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    @Override
    public final Project getProject() {
        return this.n;
    }

    public final boolean isProjectClosed() {
        return this.n.isDisposed() || !this.n.isOpen();
    }

    public EditableArea getSurfaceArea() {
        return this.mySurfaceArea;
    }

    public ToolProvider getToolProvider() {
        return this.myToolProvider;
    }

    public DesignerActionPanel getActionPanel() {
        return this.myActionPanel;
    }

    public InplaceEditingLayer getInplaceEditingLayer() {
        return this.b;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.C.isVisible() ? this.myGlassLayer : this.t;
    }

    @Nullable
    public List<?> getExpandedComponents() {
        return this.d;
    }

    public void setExpandedComponents(@Nullable List<?> expandedComponents) {
        this.d = expandedComponents;
    }

    public Property getSelectionProperty(@Nullable String key) {
        return this.a.get(key);
    }

    public void setSelectionProperty(@Nullable String key, Property selectionProperty) {
        this.a.put(key, selectionProperty);
    }

    protected void storeState() {
        if (this.myRootComponent != null && this.p == null && this.z == null) {
            this.p = new int[this.d == null ? 0 : this.d.size()][];
            for (int i10 = 0; i10 < this.p.length; ++i10) {
                IntArrayList intArrayList = new IntArrayList();
                DesignerEditorPanel.a((RadComponent)((Object)this.d.get(i10)), intArrayList);
                this.p[i10] = intArrayList.toArray();
            }
            this.z = this.e();
            this.d = null;
            InputTool inputTool = this.myToolProvider.getActiveTool();
            if (!(inputTool instanceof MarqueeTracker || inputTool instanceof CreationTool || inputTool instanceof PasteTool)) {
                this.myToolProvider.loadDefaultTool();
            }
        }
    }

    private void a() {
        if (!CommonEditActionsProvider.isDeleting) {
            this.B.put(this.getEditorText(), this.e());
        }
    }

    private int[][] e() {
        return DesignerEditorPanel.getSelectionState(this.mySurfaceArea.getSelection());
    }

    protected static int[][] getSelectionState(List<? extends RadComponent> selection) {
        int[][] nArrayArray = new int[selection.size()][];
        for (int i10 = 0; i10 < nArrayArray.length; ++i10) {
            IntArrayList intArrayList = new IntArrayList();
            DesignerEditorPanel.a(selection.get(i10), intArrayList);
            nArrayArray[i10] = intArrayList.toArray();
        }
        return nArrayArray;
    }

    private static void a(RadComponent radComponent, IntArrayList intArrayList) {
        RadComponent radComponent2 = radComponent.getParent();
        if (radComponent2 != null) {
            intArrayList.add(0, radComponent2.getChildren().indexOf((Object)radComponent));
            DesignerEditorPanel.a(radComponent2, intArrayList);
        }
    }

    protected void restoreState() {
        ArrayList<RadComponent> arrayList;
        DesignerToolWindowContent designerToolWindowContent = this.getDesignerToolWindow();
        if (this.p != null) {
            arrayList = new ArrayList<RadComponent>();
            for (int[] nArray : this.p) {
                DesignerEditorPanel.pathToComponent(arrayList, this.myRootComponent, nArray, 0);
            }
            this.d = arrayList;
            designerToolWindowContent.expandFromState();
            this.p = null;
        }
        arrayList = new ArrayList();
        int[][] nArray = this.B.get(this.getEditorText());
        if (nArray != null) {
            for (int[] nArray2 : nArray) {
                DesignerEditorPanel.pathToComponent(arrayList, this.myRootComponent, nArray2, 0);
            }
        }
        if (arrayList.isEmpty() && this.z != null) {
            for (int[] nArray2 : this.z) {
                DesignerEditorPanel.pathToComponent(arrayList, this.myRootComponent, nArray2, 0);
            }
        }
        if (arrayList.isEmpty()) {
            designerToolWindowContent.refresh(true);
        } else {
            this.mySurfaceArea.setSelection(arrayList);
        }
        this.z = null;
    }

    protected static void pathToComponent(List<? super RadComponent> components, RadComponent component, int[] path, int index) {
        if (index == path.length) {
            components.add(component);
        } else {
            List<RadComponent> list2 = component.getChildren();
            int n2 = path[index];
            if (0 <= n2 && n2 < list2.size()) {
                DesignerEditorPanel.pathToComponent(components, list2.get(n2), path, index + 1);
            }
        }
    }

    public abstract String getPlatformTarget();

    protected RadComponent findTarget(int x2, int y2, @Nullable ComponentTargetFilter filter) {
        if (this.myRootComponent != null) {
            FindComponentVisitor findComponentVisitor = new FindComponentVisitor(this.myLayeredPane, filter, x2, y2);
            this.myRootComponent.accept(findComponentVisitor, false);
            return findComponentVisitor.getResult();
        }
        return null;
    }

    protected abstract ComponentDecorator getRootSelectionDecorator();

    @Nullable
    protected EditOperation processRootOperation(OperationContext context) {
        return null;
    }

    protected abstract boolean execute(ThrowableRunnable<Exception> var1, boolean var2);

    protected abstract void executeWithReparse(ThrowableRunnable<Exception> var1);

    protected abstract void execute(List<EditOperation> var1);

    public abstract List<PaletteGroup> getPaletteGroups();

    @NotNull
    public String getVersionLabel(@Nullable String version) {
        String string = StringUtil.notNullize((String)version);
        if (string == null) {
            DesignerEditorPanel.a(8);
        }
        return string;
    }

    public boolean isDeprecated(@Nullable String deprecatedIn) {
        return !StringUtil.isEmpty((String)deprecatedIn);
    }

    protected InputTool createDefaultTool() {
        return new SelectionTool();
    }

    @NotNull
    protected abstract ComponentCreationFactory createCreationFactory(PaletteItem var1);

    @Nullable
    public abstract ComponentPasteFactory createPasteFactory(String var1);

    public abstract String getEditorText();

    public void activate() {
    }

    public void deactivate() {
    }

    @NotNull
    public DesignerEditorState createState() {
        DesignerEditorState designerEditorState = new DesignerEditorState(this.myFile, this.getZoom());
        if (designerEditorState == null) {
            DesignerEditorPanel.a(9);
        }
        return designerEditorState;
    }

    public boolean isEditorValid() {
        return this.myFile.isValid();
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            DesignerEditorPanel.a(10);
        }
        return this.myActionPanel.getData(dataId);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.j);
        this.getDesignerWindowManager().dispose(this);
        this.getPaletteWindowManager().dispose(this);
        Disposer.dispose((Disposable)this.c);
    }

    protected AbstractToolWindowManager getDesignerWindowManager() {
        return DesignerToolWindowManager.getInstance(this.n);
    }

    protected AbstractToolWindowManager getPaletteWindowManager() {
        return PaletteToolWindowManager.getInstance(this.n);
    }

    public DesignerToolWindowContent getDesignerToolWindow() {
        return DesignerToolWindowManager.getInstance(this);
    }

    protected PaletteToolWindowContent getPaletteToolWindow() {
        return PaletteToolWindowManager.getInstance(this);
    }

    @Nullable
    public WrapInProvider getWrapInProvider() {
        return null;
    }

    @Override
    @Nullable
    public RadComponent getRootComponent() {
        return this.myRootComponent;
    }

    public Object[] getTreeRoots() {
        Object[] objectArray;
        if (this.myRootComponent == null) {
            objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.myRootComponent;
        }
        return objectArray;
    }

    public abstract TreeComponentDecorator getTreeDecorator();

    public void handleTreeArea(TreeEditableArea treeArea) {
    }

    @NotNull
    public TablePanelActionPolicy getTablePanelActionPolicy() {
        TablePanelActionPolicy tablePanelActionPolicy = TablePanelActionPolicy.ALL;
        if (tablePanelActionPolicy == null) {
            DesignerEditorPanel.a(11);
        }
        return tablePanelActionPolicy;
    }

    @Nullable
    public PropertyTableTab[] getPropertyTableTabs() {
        return null;
    }

    public boolean isZoomSupported() {
        return false;
    }

    public void zoom(@NotNull ZoomType type) {
        if (type == null) {
            DesignerEditorPanel.a(12);
        }
    }

    public void setZoom(double zoom) {
    }

    public double getZoom() {
        return 1.0;
    }

    protected void viewZoomed() {
        this.myQuickFixManager.hideHint();
    }

    public void loadInspections(ProgressIndicator progress) {
    }

    public void updateInspections() {
        this.myQuickFixManager.update();
    }

    @NotNull
    protected Dimension getSceneSize(Component target) {
        int n2 = 0;
        int n3 = 0;
        if (this.myRootComponent != null) {
            Rectangle rectangle = this.myRootComponent.getBounds(target);
            n2 = Math.max(n2, (int)rectangle.getMaxX());
            n3 = Math.max(n3, (int)rectangle.getMaxY());
            for (RadComponent radComponent : this.myRootComponent.getChildren()) {
                Rectangle rectangle2 = radComponent.getBounds(target);
                n2 = Math.max(n2, (int)rectangle2.getMaxX());
                n3 = Math.max(n3, (int)rectangle2.getMaxY());
            }
        }
        Dimension dimension = new Dimension(n2 += 50, n3 += 40);
        if (dimension == null) {
            DesignerEditorPanel.a(13);
        }
        return dimension;
    }

    static {
        E = lb.a(-3192322235088424140L, -8576143187349207236L, MethodHandles.lookup().lookupClass()).a(233701024266224L);
        long l2 = E ^ 0x72D424B947E5L;
        A = Logger.getInstance((String)"#com.intellij.designer.designSurface.DesignerEditorPanel");
        LAYER_COMPONENT = JLayeredPane.DEFAULT_LAYER;
        LAYER_DECORATION = JLayeredPane.POPUP_LAYER;
        LAYER_FEEDBACK = JLayeredPane.DRAG_LAYER;
        LAYER_GLASS = LAYER_FEEDBACK + 100;
        LAYER_INPLACE_EDITING = LAYER_GLASS + 100;
        l = LAYER_INPLACE_EDITING + 100;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = E ^ 0x28DE95385124L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/designer/designSurface/DesignerEditorPanel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/designer/designSurface/DesignerEditorPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionLabel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createState";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTablePanelActionPolicy";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneSize";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createScrollPane";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "zoom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class FixableMessageInfo {
        public final boolean myErrorIcon;
        public final String myBeforeLinkText;
        public final String myLinkText;
        public final String myAfterLinkText;
        public final Runnable myQuickFix;
        public final List<Pair<String, Runnable>> myAdditionalFixes;

        public FixableMessageInfo(boolean errorIcon, String beforeLinkText, String linkText, String afterLinkText, Runnable quickFix, List<Pair<String, Runnable>> additionalFixes) {
            this.myErrorIcon = errorIcon;
            this.myBeforeLinkText = beforeLinkText;
            this.myLinkText = linkText;
            this.myAfterLinkText = afterLinkText;
            this.myQuickFix = quickFix;
            this.myAdditionalFixes = additionalFixes;
        }
    }

    public static final class ErrorInfo {
        public String myMessage;
        public String myDisplayMessage;
        public final List<FixableMessageInfo> myMessages = new ArrayList<FixableMessageInfo>();
        public Throwable myThrowable;
        public boolean myShowMessage = true;
        public boolean myShowStack = true;
        public boolean myShowLog;
    }

    private class FixableMessageAction
    extends AbstractComboBoxAction<FixableMessageInfo> {
        private final DefaultActionGroup f;
        private String e;
        private boolean d;
        final /* synthetic */ DesignerEditorPanel this$0;
        private static final long h = lb.a(6452048059924572409L, -6320020259149831280L, MethodHandles.lookup().lookupClass()).a(199632136944129L);

        FixableMessageAction(DesignerEditorPanel designerEditorPanel) {
            long l2 = h ^ 0x418DD1DF31E3L;
            this.this$0 = designerEditorPanel;
            this.f = new DefaultActionGroup();
            designerEditorPanel.myActionPanel.getActionGroup().add((AnAction)this.f);
            Presentation presentation = this.getTemplatePresentation();
            presentation.setDescription("Warnings");
            presentation.setIcon(AllIcons.Ide.Warning_notifications);
        }

        public void show(List<FixableMessageInfo> messages) {
            if (!this.d) {
                this.e = Integer.toString(messages.size());
                this.setItems(messages, null);
                this.f.add((AnAction)this);
                this.this$0.myActionPanel.update();
                this.d = true;
            }
        }

        public void hide() {
            if (this.d) {
                this.f.remove((AnAction)this);
                this.this$0.myActionPanel.update();
                this.d = false;
            }
        }

        @Override
        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button) {
            DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
            for (final FixableMessageInfo fixableMessageInfo : this.myItems) {
                Object object;
                if (fixableMessageInfo.myQuickFix != null && (fixableMessageInfo.myLinkText.length() > 0 || fixableMessageInfo.myAfterLinkText.length() > 0) || fixableMessageInfo.myAdditionalFixes != null && fixableMessageInfo.myAdditionalFixes.size() > 0) {
                    final AnAction[] anActionArray = new AnAction[1];
                    DefaultActionGroup defaultActionGroup2 = new DefaultActionGroup(){
                        private static final long a = lb.a(-4349503291147088779L, -6538029573583099740L, MethodHandles.lookup().lookupClass()).a(236805923036981L);

                        public boolean canBePerformed(@NotNull DataContext context) {
                            if (context == null) {
                                1.a(0);
                            }
                            return true;
                        }

                        public void actionPerformed(@NotNull AnActionEvent e10) {
                            if (e10 == null) {
                                1.a(1);
                            }
                            anActionArray[0].actionPerformed(e10);
                        }

                        private static /* synthetic */ void a(int n2) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            long l2 = a ^ 0x4034CE8CEECL;
                            Object[] objectArray3 = new Object[3];
                            switch (n2) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "context";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "e";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/intellij/designer/designSurface/DesignerEditorPanel$FixableMessageAction$1";
                            switch (n2) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "canBePerformed";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "actionPerformed";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                    defaultActionGroup2.setPopup(true);
                    object = defaultActionGroup2;
                    if (fixableMessageInfo.myQuickFix != null && (fixableMessageInfo.myLinkText.length() > 0 || fixableMessageInfo.myAfterLinkText.length() > 0)) {
                        AnAction anAction = new AnAction(){
                            private static final long a = lb.a(-658202509319798244L, -7270395115376308594L, MethodHandles.lookup().lookupClass()).a(65175369108924L);

                            public void actionPerformed(@NotNull AnActionEvent e10) {
                                if (e10 == null) {
                                    2.a(0);
                                }
                                fixableMessageInfo.myQuickFix.run();
                            }

                            private static /* synthetic */ void a(int n2) {
                                long l2 = a ^ 0x29F6A223DC9AL;
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/designer/designSurface/DesignerEditorPanel$FixableMessageAction$2", "actionPerformed"));
                            }
                        };
                        anAction.getTemplatePresentation().setText(this.a(fixableMessageInfo.myLinkText + fixableMessageInfo.myAfterLinkText));
                        defaultActionGroup2.add(anAction);
                        anActionArray[0] = anAction;
                    }
                    if (fixableMessageInfo.myAdditionalFixes != null && fixableMessageInfo.myAdditionalFixes.size() > 0) {
                        for (final Pair pair2 : fixableMessageInfo.myAdditionalFixes) {
                            AnAction anAction = new AnAction(){
                                private static final long a = lb.a(-4285960613344305322L, 3352901537776703761L, MethodHandles.lookup().lookupClass()).a(238510298730228L);

                                public void actionPerformed(@NotNull AnActionEvent e10) {
                                    if (e10 == null) {
                                        3.a(0);
                                    }
                                    ((Runnable)pair2.second).run();
                                }

                                private static /* synthetic */ void a(int n2) {
                                    long l2 = a ^ 0x52A65CDD8E4CL;
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/designer/designSurface/DesignerEditorPanel$FixableMessageAction$3", "actionPerformed"));
                                }
                            };
                            anAction.getTemplatePresentation().setText(this.a((String)pair2.first));
                            defaultActionGroup2.add(anAction);
                            if (anActionArray[0] != null) continue;
                            anActionArray[0] = anAction;
                        }
                    }
                } else {
                    object = new EmptyAction(true);
                }
                defaultActionGroup.add((AnAction)object);
                this.update(fixableMessageInfo, object.getTemplatePresentation(), true);
            }
            DefaultActionGroup defaultActionGroup2 = defaultActionGroup;
            if (defaultActionGroup2 == null) {
                FixableMessageAction.b(0);
            }
            return defaultActionGroup2;
        }

        @Override
        protected void update(FixableMessageInfo item, Presentation presentation, boolean popup) {
            if (popup) {
                presentation.setText(this.a(item.myBeforeLinkText));
            } else {
                presentation.setText(this.e);
            }
        }

        private String a(String string) {
            long l2 = h ^ 0x2A8BB7A03A56L;
            if (string != null) {
                string = string.trim();
                string = StringUtil.replace((String)string, (String)"&nbsp;", (String)" ");
                string = StringUtil.replace((String)string, (String)"\n", (String)" ");
                StringBuilder stringBuilder = new StringBuilder();
                int n2 = string.length();
                boolean bl2 = false;
                for (int i10 = 0; i10 < n2; ++i10) {
                    char c10 = string.charAt(i10);
                    if (c10 == ' ') {
                        if (bl2) continue;
                        bl2 = true;
                        stringBuilder.append(c10);
                        continue;
                    }
                    bl2 = false;
                    stringBuilder.append(c10);
                }
                string = stringBuilder.toString();
            }
            return string;
        }

        @Override
        protected boolean selectionChanged(FixableMessageInfo item) {
            return false;
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = h ^ 0x1464A96CD425L;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/designSurface/DesignerEditorPanel$FixableMessageAction", "createPopupActionGroup"));
        }
    }

    private final class MyLayeredPane
    extends JBLayeredPane
    implements Scrollable {
        private MyLayeredPane() {
        }

        public void doLayout() {
            for (int i10 = this.getComponentCount() - 1; i10 >= 0; --i10) {
                Component component = this.getComponent(i10);
                component.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Rectangle rectangle = DesignerEditorPanel.this.myScrollPane.getViewport().getBounds();
            Dimension dimension = DesignerEditorPanel.this.getSceneSize((Component)((Object)this));
            dimension.width = Math.max(dimension.width, rectangle.width);
            dimension.height = Math.max(dimension.height, rectangle.height);
            return dimension;
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            if (orientation == 0) {
                return visibleRect.width - 10;
            }
            return visibleRect.height - 10;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    protected class DesignerToolProvider
    extends ToolProvider {
        private static final long d = lb.a(4591442220241542675L, 6974827921596420797L, MethodHandles.lookup().lookupClass()).a(141894524517067L);

        protected DesignerToolProvider() {
        }

        @Override
        public void loadDefaultTool() {
            this.setActiveTool(DesignerEditorPanel.this.createDefaultTool());
        }

        @Override
        public void setActiveTool(InputTool tool) {
            if (this.getActiveTool() instanceof CreationTool && !(tool instanceof CreationTool)) {
                DesignerEditorPanel.this.getPaletteToolWindow().clearActiveItem();
            }
            if (!(tool instanceof SelectionTool)) {
                this.hideInspections();
            }
            super.setActiveTool(tool);
        }

        @Override
        public boolean execute(ThrowableRunnable<Exception> operation, String command, boolean updateProperties) {
            DesignerEditorPanel.this.myLastExecuteCommand = command;
            Ref ref = Ref.create((Object)Boolean.TRUE);
            CommandProcessor.getInstance().executeCommand(DesignerEditorPanel.this.getProject(), () -> ref.set((Object)DesignerEditorPanel.this.execute(operation, updateProperties)), command, null);
            return (Boolean)ref.get();
        }

        @Override
        public void executeWithReparse(ThrowableRunnable<Exception> operation, String command) {
            DesignerEditorPanel.this.myLastExecuteCommand = command;
            CommandProcessor.getInstance().executeCommand(DesignerEditorPanel.this.getProject(), () -> DesignerEditorPanel.this.executeWithReparse(operation), command, null);
        }

        @Override
        public void execute(List<EditOperation> operations, String command) {
            DesignerEditorPanel.this.myLastExecuteCommand = command;
            CommandProcessor.getInstance().executeCommand(DesignerEditorPanel.this.getProject(), () -> DesignerEditorPanel.this.execute(operations), command, null);
        }

        @Override
        public void startInplaceEditing(@Nullable InplaceContext inplaceContext) {
            DesignerEditorPanel.this.b.startEditing(inplaceContext);
        }

        @Override
        public void hideInspections() {
            DesignerEditorPanel.this.myQuickFixManager.hideHint();
        }

        @Override
        public void showError(@NonNls String message, Throwable e10) {
            DesignerEditorPanel.this.showError(message, e10);
        }

        @Override
        public boolean isZoomSupported() {
            return DesignerEditorPanel.this.isZoomSupported();
        }

        @Override
        public void zoom(@NotNull ZoomType type) {
            if (type == null) {
                DesignerToolProvider.a(0);
            }
            DesignerEditorPanel.this.zoom(type);
        }

        @Override
        public void setZoom(double zoom) {
            DesignerEditorPanel.this.setZoom(zoom);
        }

        @Override
        public double getZoom() {
            return DesignerEditorPanel.this.getZoom();
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = d ^ 0x5E2F6842C99BL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/designer/designSurface/DesignerEditorPanel$DesignerToolProvider", "zoom"));
        }
    }

    protected class DesignerEditableArea
    extends ComponentEditableArea {
        private static final long d = lb.a(2587708965442671599L, 4066374402374153815L, MethodHandles.lookup().lookupClass()).a(246992381228870L);

        public DesignerEditableArea() {
            super(DesignerEditorPanel.this.myLayeredPane);
        }

        @Override
        protected void fireSelectionChanged() {
            super.fireSelectionChanged();
            DesignerEditorPanel.this.myLayeredPane.revalidate();
            DesignerEditorPanel.this.myLayeredPane.repaint();
        }

        @Override
        public void scrollToSelection() {
            Rectangle rectangle;
            List<RadComponent> list2 = this.getSelection();
            if (list2.size() == 1 && (rectangle = list2.get(0).getBounds(DesignerEditorPanel.this.myLayeredPane)) != null) {
                DesignerEditorPanel.this.myLayeredPane.scrollRectToVisible(rectangle);
            }
        }

        @Override
        public RadComponent findTarget(int x2, int y2, @Nullable ComponentTargetFilter filter) {
            return DesignerEditorPanel.this.findTarget(x2, y2, filter);
        }

        @Override
        public InputTool findTargetTool(int x2, int y2) {
            return DesignerEditorPanel.this.g.findTargetTool(x2, y2);
        }

        @Override
        public void showSelection(boolean value) {
            DesignerEditorPanel.this.g.showSelection(value);
        }

        @Override
        public ComponentDecorator getRootSelectionDecorator() {
            return DesignerEditorPanel.this.getRootSelectionDecorator();
        }

        @Override
        @Nullable
        public EditOperation processRootOperation(OperationContext context) {
            return DesignerEditorPanel.this.processRootOperation(context);
        }

        @Override
        public FeedbackLayer getFeedbackLayer() {
            return DesignerEditorPanel.this.q;
        }

        @Override
        public RadComponent getRootComponent() {
            return DesignerEditorPanel.this.myRootComponent;
        }

        @Override
        public ActionGroup getPopupActions() {
            return DesignerEditorPanel.this.myActionPanel.getPopupActions(this);
        }

        @Override
        public String getPopupPlace() {
            long l2 = d ^ 0x45510025B123L;
            return "GuiDesigner.EditorPopup";
        }
    }
}

