/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import b.a.lb;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.LabelRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.lang.invoke.MethodHandles;

public abstract class UnboxableTypeRenderer
extends CompoundReferenceRenderer {
    public UnboxableTypeRenderer(String className, NodeRendererSettings rendererSettings) {
        super(rendererSettings, StringUtil.getShortName((String)className), new LabelRenderer(){

            @Override
            public String calcLabel(ValueDescriptor descriptor2, EvaluationContext evaluationContext, DescriptorLabelListener labelListener) throws EvaluateException {
                return DebuggerUtils.getValueAsString((EvaluationContext)evaluationContext, (Value)UnBoxingEvaluator.getInnerPrimitiveValue((ObjectReference)descriptor2.getValue()));
            }

            @Override
            public boolean isOnDemand(EvaluationContext evaluationContext, ValueDescriptor valueDescriptor) {
                return false;
            }
        }, null);
        LOG.assertTrue(UnBoxingEvaluator.isTypeUnboxable(className));
        this.setClassName(className);
        this.setEnabled(true);
    }

    @Override
    public boolean isApplicable(Type type) {
        return type instanceof ReferenceType && StringUtil.equals((CharSequence)type.name(), (CharSequence)this.getClassName());
    }

    public static class DoubleRenderer
    extends UnboxableTypeRenderer {
        private static final long e = lb.a(1489372059344309280L, 1038276400882593799L, MethodHandles.lookup().lookupClass()).a(268876280704697L);

        public DoubleRenderer(NodeRendererSettings rendererSettings) {
            long l2 = e ^ 0x16AE2BE1F0B1L;
            super("java.lang.Double", rendererSettings);
        }
    }

    public static class FloatRenderer
    extends UnboxableTypeRenderer {
        private static final long e = lb.a(-7115594318024595526L, -4549798445273805787L, MethodHandles.lookup().lookupClass()).a(156662857617199L);

        public FloatRenderer(NodeRendererSettings rendererSettings) {
            long l2 = e ^ 0x5C93BB0CB0A1L;
            super("java.lang.Float", rendererSettings);
        }
    }

    public static class LongRenderer
    extends UnboxableTypeRenderer {
        private static final long e = lb.a(1477303620620104816L, 4046672579703313072L, MethodHandles.lookup().lookupClass()).a(158200393113583L);

        public LongRenderer(NodeRendererSettings rendererSettings) {
            long l2 = e ^ 0x212A32B5145BL;
            super("java.lang.Long", rendererSettings);
        }
    }

    public static class IntegerRenderer
    extends UnboxableTypeRenderer {
        private static final long e = lb.a(6554396348738415332L, -5153618732854399864L, MethodHandles.lookup().lookupClass()).a(161493117773497L);

        public IntegerRenderer(NodeRendererSettings rendererSettings) {
            long l2 = e ^ 0x3941F4C4D7DL;
            super("java.lang.Integer", rendererSettings);
        }
    }

    public static class ShortRenderer
    extends UnboxableTypeRenderer {
        private static final long e = lb.a(-5635376794357520288L, 7952777891514785014L, MethodHandles.lookup().lookupClass()).a(267107637096002L);

        public ShortRenderer(NodeRendererSettings rendererSettings) {
            long l2 = e ^ 0x67350AEDB4F6L;
            super("java.lang.Short", rendererSettings);
        }
    }

    public static class CharacterRenderer
    extends UnboxableTypeRenderer {
        private static final long e = lb.a(-8185714689492770034L, 3456046201700027250L, MethodHandles.lookup().lookupClass()).a(7191203237104L);

        public CharacterRenderer(NodeRendererSettings rendererSettings) {
            long l2 = e ^ 0x58A7A30FD783L;
            super("java.lang.Character", rendererSettings);
        }
    }

    public static class ByteRenderer
    extends UnboxableTypeRenderer {
        private static final long e = lb.a(-6601652618079561091L, 6971317764423133974L, MethodHandles.lookup().lookupClass()).a(144557301385621L);

        public ByteRenderer(NodeRendererSettings rendererSettings) {
            long l2 = e ^ 0x6BC50AEEA8E3L;
            super("java.lang.Byte", rendererSettings);
        }
    }

    public static class BooleanRenderer
    extends UnboxableTypeRenderer {
        private static final long e = lb.a(-4372963979689479756L, -1479596292970305362L, MethodHandles.lookup().lookupClass()).a(155000806563506L);

        public BooleanRenderer(NodeRendererSettings rendererSettings) {
            long l2 = e ^ 0x59377C1F6728L;
            super("java.lang.Boolean", rendererSettings);
        }
    }
}

