/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeManager;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CachedEvaluator;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.TypeRenderer;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.Value;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ExpressionChildrenRenderer
extends TypeRenderer
implements ChildrenRenderer {
    @NonNls
    public static final String UNIQUE_ID = "ExpressionChildrenRenderer";
    private static final Key<Value> b;
    private static final Key<NodeRenderer> e;
    private CachedEvaluator c = this.createCachedEvaluator();
    private CachedEvaluator f = this.createCachedEvaluator();
    private NodeRenderer d;
    private static final long g;

    @Override
    public String getUniqueId() {
        long l2 = g ^ 0x177A6149459BL;
        return UNIQUE_ID;
    }

    @Override
    public ExpressionChildrenRenderer clone() {
        ExpressionChildrenRenderer expressionChildrenRenderer = (ExpressionChildrenRenderer)super.clone();
        expressionChildrenRenderer.c = this.createCachedEvaluator();
        expressionChildrenRenderer.setChildrenExpandable(this.getChildrenExpandable());
        expressionChildrenRenderer.f = this.createCachedEvaluator();
        expressionChildrenRenderer.setChildrenExpression(this.getChildrenExpression());
        return expressionChildrenRenderer;
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder builder, EvaluationContext evaluationContext) {
        long l2 = g ^ 0x7BF41FC5056CL;
        NodeManager nodeManager = builder.getNodeManager();
        try {
            ValueDescriptor valueDescriptor = builder.getParentDescriptor();
            Value value2 = this.a(evaluationContext.createEvaluationContext(value), valueDescriptor);
            NodeRenderer nodeRenderer = ExpressionChildrenRenderer.a(value2, valueDescriptor);
            nodeRenderer.buildChildren(value2, builder, evaluationContext);
        }
        catch (EvaluateException evaluateException) {
            ArrayList<DebuggerTreeNode> arrayList = new ArrayList<DebuggerTreeNode>();
            arrayList.add(nodeManager.createMessageNode(DebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0]) + " " + evaluateException.getMessage()));
            builder.setChildren(arrayList);
        }
    }

    @Nullable
    public static NodeRenderer getLastChildrenRenderer(ValueDescriptor descriptor2) {
        return (NodeRenderer)descriptor2.getUserData(e);
    }

    public static void setPreferableChildrenRenderer(ValueDescriptor descriptor2, NodeRenderer renderer) {
        descriptor2.putUserData(e, renderer);
    }

    public static Value getLastChildrenValue(NodeDescriptor descriptor2) {
        return (Value)descriptor2.getUserData(b);
    }

    private Value a(EvaluationContext evaluationContext, NodeDescriptor nodeDescriptor) throws EvaluateException {
        ExpressionEvaluator expressionEvaluator = this.f.getEvaluator(evaluationContext.getProject());
        Value value = evaluationContext.computeAndKeep(() -> expressionEvaluator.evaluate(evaluationContext));
        nodeDescriptor.putUserData(b, (Object)value);
        return value;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        TextWithImports textWithImports;
        long l2 = g ^ 0x7D2360D15952L;
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        TextWithImports textWithImports2 = DebuggerUtils.getInstance().readTextWithImports(element, "CHILDREN_EXPRESSION");
        if (textWithImports2 != null) {
            this.setChildrenExpression(textWithImports2);
        }
        if ((textWithImports = DebuggerUtils.getInstance().readTextWithImports(element, "CHILDREN_EXPANDABLE")) != null) {
            this.c.setReferenceExpression(textWithImports);
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        long l2 = g ^ 0x2B1D53A84690L;
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        DebuggerUtils.getInstance().writeTextWithImports(element, "CHILDREN_EXPANDABLE", this.getChildrenExpandable());
        DebuggerUtils.getInstance().writeTextWithImports(element, "CHILDREN_EXPRESSION", this.getChildrenExpression());
    }

    public PsiExpression getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
        long l2 = g ^ 0x2C2C4C017E85L;
        Value value = ExpressionChildrenRenderer.getLastChildrenValue(node.getParent().getDescriptor());
        if (value == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0]));
        }
        NodeRenderer nodeRenderer = ExpressionChildrenRenderer.a(value, (ValueDescriptor)node.getParent().getDescriptor());
        PsiExpression psiExpression = this.f.getPsiExpression(node.getProject());
        if (psiExpression == null) {
            return null;
        }
        return DebuggerTreeNodeExpression.substituteThis(nodeRenderer.getChildValueExpression(node, context), (PsiExpression)psiExpression.copy(), value);
    }

    private static NodeRenderer a(Value value, ValueDescriptor valueDescriptor) {
        NodeRenderer nodeRenderer = ExpressionChildrenRenderer.getLastChildrenRenderer(valueDescriptor);
        if (nodeRenderer == null || value == null || !nodeRenderer.isApplicable(value.type())) {
            nodeRenderer = DebugProcessImpl.getDefaultRenderer(value != null ? value.type() : null);
            ExpressionChildrenRenderer.setPreferableChildrenRenderer(valueDescriptor, nodeRenderer);
        }
        return nodeRenderer;
    }

    @Override
    public boolean isExpandable(Value value, EvaluationContext context, NodeDescriptor parentDescriptor) {
        Value value2;
        EvaluationContext evaluationContext = context.createEvaluationContext(value);
        if (!StringUtil.isEmpty((String)this.c.getReferenceExpression().getText())) {
            try {
                value2 = this.c.getEvaluator(evaluationContext.getProject()).evaluate(evaluationContext);
                if (value2 instanceof BooleanValue) {
                    return ((BooleanValue)value2).booleanValue();
                }
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        try {
            value2 = this.a(evaluationContext, parentDescriptor);
            NodeRenderer nodeRenderer = DebugProcessImpl.getDefaultRenderer(value.type());
            return nodeRenderer.isExpandable(value2, evaluationContext, parentDescriptor);
        }
        catch (EvaluateException evaluateException) {
            return true;
        }
    }

    public TextWithImports getChildrenExpression() {
        return this.f.getReferenceExpression();
    }

    public void setChildrenExpression(TextWithImports expression) {
        this.f.setReferenceExpression(expression);
    }

    public TextWithImports getChildrenExpandable() {
        return this.c.getReferenceExpression();
    }

    public void setChildrenExpandable(TextWithImports childrenExpandable) {
        this.c.setReferenceExpression(childrenExpandable);
    }

    @Override
    public void setClassName(String name2) {
        super.setClassName(name2);
        this.f.clear();
        this.c.clear();
    }

    public NodeRenderer getPredictedRenderer() {
        return this.d;
    }

    public void setPredictedRenderer(NodeRenderer predictedRenderer) {
        this.d = predictedRenderer;
    }

    static {
        g = lb.a(-5197816538242603825L, -3625951227531224035L, MethodHandles.lookup().lookupClass()).a(183462573354989L);
        long l2 = g ^ 0x78C7EA32D1FEL;
        b = new Key("EXPRESSION_VALUE");
        e = new Key("LAST_CHILDREN_RENDERER");
    }
}

