/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.ThreadDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.icons.AllIcons;
import com.sun.jdi.ObjectCollectedException;
import java.lang.invoke.MethodHandles;
import javax.swing.Icon;

public class ThreadDescriptorImpl
extends NodeDescriptorImpl
implements ThreadDescriptor {
    private final ThreadReferenceProxyImpl h;
    private String e = null;
    private boolean f = true;
    private boolean g = false;
    private boolean l;
    private boolean j;
    private boolean k;
    private SuspendContextImpl i;
    private static final long m = lb.a(-3229851928334873741L, -7800409510555799892L, MethodHandles.lookup().lookupClass()).a(212968733835904L);

    public ThreadDescriptorImpl(ThreadReferenceProxyImpl thread) {
        this.h = thread;
    }

    @Override
    public String getName() {
        return this.e;
    }

    @Override
    protected String calcRepresentation(EvaluationContextImpl context, DescriptorLabelListener labelListener) throws EvaluateException {
        long l2 = m ^ 0x2FF95116348L;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ThreadReferenceProxyImpl threadReferenceProxyImpl = this.getThreadReference();
        try {
            this.e = threadReferenceProxyImpl.name();
            ThreadGroupReferenceProxyImpl threadGroupReferenceProxyImpl = this.getThreadReference().threadGroupProxy();
            String string = threadGroupReferenceProxyImpl != null ? threadGroupReferenceProxyImpl.name() : null;
            String string2 = DebuggerUtilsEx.getThreadStatusText(this.getThreadReference().status());
            if (string != null && !"SYSTEM".equalsIgnoreCase(string)) {
                return DebuggerBundle.message((String)"label.thread.node.in.group", (Object[])new Object[]{this.e, threadReferenceProxyImpl.uniqueID(), string2, string});
            }
            return DebuggerBundle.message((String)"label.thread.node", (Object[])new Object[]{this.e, threadReferenceProxyImpl.uniqueID(), string2});
        }
        catch (ObjectCollectedException objectCollectedException) {
            return this.e != null ? DebuggerBundle.message((String)"label.thread.node.thread.collected", (Object[])new Object[]{this.e}) : "";
        }
    }

    @Override
    public ThreadReferenceProxyImpl getThreadReference() {
        return this.h;
    }

    public boolean isCurrent() {
        return this.l;
    }

    public boolean isFrozen() {
        return this.j;
    }

    @Override
    public boolean isExpandable() {
        return this.f;
    }

    @Override
    public void setContext(EvaluationContextImpl context) {
        ThreadReferenceProxyImpl threadReferenceProxyImpl = this.getThreadReference();
        SuspendManager suspendManager = context != null ? context.getDebugProcess().getSuspendManager() : null;
        SuspendContextImpl suspendContextImpl = context != null ? context.getSuspendContext() : null;
        try {
            this.g = suspendManager != null ? suspendManager.isSuspended(threadReferenceProxyImpl) : threadReferenceProxyImpl.isSuspended();
        }
        catch (ObjectCollectedException objectCollectedException) {
            this.g = false;
        }
        this.f = this.a(this.g);
        this.i = suspendManager != null ? SuspendManagerUtil.findContextByThread(suspendManager, threadReferenceProxyImpl) : suspendContextImpl;
        this.k = threadReferenceProxyImpl.isAtBreakpoint();
        this.l = suspendContextImpl != null ? suspendContextImpl.getThread() == threadReferenceProxyImpl : false;
        this.j = suspendManager != null ? suspendManager.isFrozen(threadReferenceProxyImpl) : this.g;
    }

    private boolean a(boolean bl2) {
        if (!bl2) {
            return false;
        }
        int n2 = this.getThreadReference().status();
        return n2 != -1 && n2 != 5 && n2 != 0;
    }

    public SuspendContextImpl getSuspendContext() {
        return this.i;
    }

    public boolean isAtBreakpoint() {
        return this.k;
    }

    public boolean isSuspended() {
        return this.g;
    }

    public Icon getIcon() {
        if (this.isCurrent()) {
            return AllIcons.Debugger.ThreadCurrent;
        }
        if (this.isAtBreakpoint()) {
            return AllIcons.Debugger.ThreadAtBreakpoint;
        }
        if (this.isFrozen()) {
            return AllIcons.Debugger.ThreadFrozen;
        }
        if (this.isSuspended()) {
            return AllIcons.Debugger.ThreadSuspended;
        }
        return AllIcons.Debugger.ThreadRunning;
    }
}

