/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import b.a.lb;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.settings.ThreadsViewSettings;
import com.intellij.debugger.ui.impl.watch.MethodsTracker;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.StackFrameDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.icons.AllIcons;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import java.lang.invoke.MethodHandles;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackFrameDescriptorImpl
extends NodeDescriptorImpl
implements StackFrameDescriptor {
    private final StackFrameProxyImpl j;
    private int l;
    private String f;
    private Location g;
    private MethodsTracker.MethodOccurrence h;
    private boolean n;
    private boolean k;
    private ObjectReference e;
    private SourcePosition m;
    private Icon i;
    private static final long o = lb.a(-4146870491865207544L, -2744681836674272151L, MethodHandles.lookup().lookupClass()).a(277954705771689L);

    public StackFrameDescriptorImpl(@NotNull StackFrameProxyImpl frame, @NotNull MethodsTracker tracker) {
        if (frame == null) {
            StackFrameDescriptorImpl.a(0);
        }
        if (tracker == null) {
            StackFrameDescriptorImpl.a(1);
        }
        this.f = null;
        this.i = AllIcons.Debugger.Frame;
        this.j = frame;
        try {
            this.l = frame.getFrameIndex();
            this.g = frame.location();
            try {
                this.e = frame.thisObject();
            }
            catch (EvaluateException evaluateException) {
                if (!(evaluateException.getCause() instanceof InternalException)) {
                    throw evaluateException;
                }
                LOG.info((Throwable)evaluateException);
            }
            this.h = tracker.getMethodOccurrence(this.l, DebuggerUtilsEx.getMethod(this.g));
            this.n = DebuggerUtils.isSynthetic((TypeComponent)this.h.getMethod());
            this.m = ContextUtil.getSourcePosition(this);
            PsiFile psiFile = this.m != null ? this.m.getFile() : null;
            this.k = DebuggerUtilsEx.isInLibraryContent(psiFile != null ? psiFile.getVirtualFile() : null, this.getDebugProcess().getProject());
        }
        catch (EvaluateException | InternalException throwable) {
            LOG.info(throwable);
            this.g = null;
            this.h = tracker.getMethodOccurrence(0, null);
            this.n = false;
            this.k = false;
        }
    }

    public int getUiIndex() {
        return this.l;
    }

    @NotNull
    public StackFrameProxyImpl getFrameProxy() {
        StackFrameProxyImpl stackFrameProxyImpl = this.j;
        if (stackFrameProxyImpl == null) {
            StackFrameDescriptorImpl.a(2);
        }
        return stackFrameProxyImpl;
    }

    @NotNull
    public DebugProcess getDebugProcess() {
        DebugProcess debugProcess = this.j.getVirtualMachine().getDebugProcess();
        if (debugProcess == null) {
            StackFrameDescriptorImpl.a(3);
        }
        return debugProcess;
    }

    @Nullable
    public Method getMethod() {
        return this.h.getMethod();
    }

    public int getOccurrenceIndex() {
        return this.h.getIndex();
    }

    public boolean isRecursiveCall() {
        return this.h.isRecursive();
    }

    @Nullable
    public ValueMarkup getValueMarkup() {
        XValueMarkers xValueMarkers;
        XDebugSession xDebugSession;
        DebugProcess debugProcess;
        if (this.e != null && (debugProcess = this.j.getVirtualMachine().getDebugProcess()) instanceof DebugProcessImpl && (xDebugSession = ((DebugProcessImpl)debugProcess).getSession().getXDebugSession()) instanceof XDebugSessionImpl && (xValueMarkers = ((XDebugSessionImpl)xDebugSession).getValueMarkers()) != null) {
            return (ValueMarkup)xValueMarkers.getAllMarkers().get(this.e);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.f;
    }

    @Override
    protected String calcRepresentation(EvaluationContextImpl context, DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
        long l2 = o ^ 0x54032E083692L;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.g == null) {
            return "";
        }
        ThreadsViewSettings threadsViewSettings = ThreadsViewSettings.getInstance();
        StringBuilder stringBuilder = new StringBuilder();
        Method method = this.h.getMethod();
        if (method != null) {
            this.f = method.name();
            stringBuilder.append(threadsViewSettings.SHOW_ARGUMENTS_TYPES ? DebuggerUtilsEx.methodNameWithArguments(method) : this.f);
        }
        if (threadsViewSettings.SHOW_LINE_NUMBER) {
            stringBuilder.append(':').append(DebuggerUtilsEx.getLineNumber(this.g, false));
        }
        if (threadsViewSettings.SHOW_CLASS_NAME) {
            String string;
            try {
                ReferenceType referenceType = this.g.declaringType();
                string = referenceType != null ? referenceType.name() : null;
            }
            catch (InternalError internalError) {
                string = internalError.toString();
            }
            if (string != null) {
                stringBuilder.append(", ");
                int n2 = string.lastIndexOf(46);
                if (n2 < 0) {
                    stringBuilder.append(string);
                } else {
                    stringBuilder.append(string.substring(n2 + 1));
                    if (threadsViewSettings.SHOW_PACKAGE_NAME) {
                        stringBuilder.append(" {");
                        stringBuilder.append(string, 0, n2);
                        stringBuilder.append("}");
                    }
                }
            }
        }
        if (threadsViewSettings.SHOW_SOURCE_NAME) {
            stringBuilder.append(", ").append(DebuggerUtilsEx.getSourceName(this.g, throwable -> {
                long l2 = o ^ 0x1BFAC5B66899L;
                return "Unknown Source";
            }));
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isExpandable() {
        return true;
    }

    @Override
    public final void setContext(EvaluationContextImpl context) {
        this.i = this.a();
    }

    public boolean isSynthetic() {
        return this.n;
    }

    public boolean isInLibraryContent() {
        return this.k;
    }

    @Nullable
    public Location getLocation() {
        return this.g;
    }

    public SourcePosition getSourcePosition() {
        return this.m;
    }

    private Icon a() {
        try {
            if (this.j.isObsolete()) {
                return AllIcons.Debugger.Db_obsolete;
            }
        }
        catch (EvaluateException evaluateException) {
            // empty catch block
        }
        return JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)6));
    }

    public Icon getIcon() {
        return this.i;
    }

    @Nullable
    public ObjectReference getThisObject() {
        return this.e;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = o ^ 0x15084624A890L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/impl/watch/StackFrameDescriptorImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/impl/watch/StackFrameDescriptorImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameProxy";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugProcess";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

