/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.AsyncStacksToggleAction;
import com.intellij.debugger.engine.AsyncStackTraceProvider;
import com.intellij.debugger.engine.AsyncStacksUtils;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluatorImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.settings.CapturePoint;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.breakpoints.WildcardMethodBreakpoint;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FixedHashMap;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import com.sun.jdi.event.LocatableEvent;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

public class StackCapturingLineBreakpoint
extends WildcardMethodBreakpoint {
    private static final Logger g;
    private final CapturePoint k;
    private final String e;
    private final MyEvaluator i;
    private final MyEvaluator h;
    public static final Key<List<StackCapturingLineBreakpoint>> CAPTURE_BREAKPOINTS;
    private static final Key<Map<Object, List<StackFrameItem>>> d;
    private static final int j = 1000;
    private final JavaMethodBreakpointProperties f = new JavaMethodBreakpointProperties();
    private static final long l;

    public StackCapturingLineBreakpoint(Project project2, CapturePoint capturePoint) {
        super(project2, (XBreakpoint<JavaMethodBreakpointProperties>)null);
        this.k = capturePoint;
        this.e = null;
        this.f.EMULATED = true;
        this.f.WATCH_EXIT = false;
        this.f.myClassPattern = this.k.myClassName;
        this.f.myMethodName = this.k.myMethodName;
        this.i = new MyEvaluator(this.k.myCaptureKeyExpression);
        this.h = new MyEvaluator(this.k.myInsertKeyExpression);
    }

    @Override
    @NotNull
    protected JavaMethodBreakpointProperties getProperties() {
        JavaMethodBreakpointProperties javaMethodBreakpointProperties = this.f;
        if (javaMethodBreakpointProperties == null) {
            StackCapturingLineBreakpoint.c(0);
        }
        return javaMethodBreakpointProperties;
    }

    @Override
    public String getSuspendPolicy() {
        long l2 = l ^ 0x5C8D7A6CA375L;
        return "SuspendThread";
    }

    @Override
    public boolean processLocatableEvent(SuspendContextCommandImpl action, LocatableEvent event) {
        ThreadReferenceProxyImpl threadReferenceProxyImpl;
        long l2 = l ^ 0x3A903368DBDFL;
        SuspendContextImpl suspendContextImpl = action.getSuspendContext();
        if (suspendContextImpl != null && (threadReferenceProxyImpl = suspendContextImpl.getThread()) != null) {
            DebugProcessImpl debugProcessImpl = suspendContextImpl.getDebugProcess();
            try {
                StackFrameProxyImpl stackFrameProxyImpl = (StackFrameProxyImpl)ContainerUtil.getFirstItem(threadReferenceProxyImpl.forceFrames());
                if (stackFrameProxyImpl != null) {
                    Value value;
                    Map map2 = (Map)debugProcessImpl.getUserData(d);
                    if (map2 == null) {
                        map2 = new FixedHashMap(1000);
                        AsyncStacksUtils.putProcessUserData(d, Collections.synchronizedMap(map2), debugProcessImpl);
                    }
                    if ((value = this.i.evaluate(new EvaluationContextImpl(suspendContextImpl, stackFrameProxyImpl))) instanceof ObjectReference) {
                        List<StackFrameItem> list2 = StackFrameItem.createFrames(suspendContextImpl, true);
                        if (list2.size() > AsyncStacksUtils.getMaxStackLength()) {
                            list2 = list2.subList(0, AsyncStacksUtils.getMaxStackLength());
                        }
                        map2.put(StackCapturingLineBreakpoint.a((ObjectReference)value), list2);
                    }
                }
            }
            catch (EvaluateException evaluateException) {
                g.debug((Throwable)evaluateException);
                debugProcessImpl.printToConsole(DebuggerBundle.message((String)"error.unable.to.evaluate.capture.expression", (Object[])new Object[]{evaluateException.getMessage()}) + "\n");
            }
        }
        return false;
    }

    @Override
    protected void fireBreakpointChanged() {
    }

    @Override
    public StreamEx matchingMethods(StreamEx<Method> methods, DebugProcessImpl debugProcess) {
        String string = this.getMethodName();
        return (StreamEx)((StreamEx)methods.filter(method -> Comparing.equal((String)string, (String)method.name()) && (this.e == null || Comparing.equal((String)this.e, (String)method.signature())))).limit(1L);
    }

    public static void deleteAll(DebugProcessImpl debugProcess) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        List list2 = (List)debugProcess.getUserData(CAPTURE_BREAKPOINTS);
        if (!ContainerUtil.isEmpty((Collection)list2)) {
            list2.forEach(debugProcess.getRequestsManager()::deleteRequest);
            list2.clear();
        }
    }

    public static void createAll(DebugProcessImpl debugProcess) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        DebuggerSettings.getInstance().getCapturePoints().stream().filter(capturePoint -> capturePoint.myEnabled).forEach(capturePoint -> StackCapturingLineBreakpoint.a(debugProcess, capturePoint));
    }

    public static void clearCaches(DebugProcessImpl debugProcess) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        List list2 = (List)debugProcess.getUserData(CAPTURE_BREAKPOINTS);
        if (!ContainerUtil.isEmpty((Collection)list2)) {
            list2.forEach(stackCapturingLineBreakpoint -> {
                stackCapturingLineBreakpoint.i.clearCache();
                stackCapturingLineBreakpoint.h.clearCache();
            });
        }
    }

    @Override
    public void createRequest(DebugProcessImpl debugProcess) {
        if (!StringUtil.isEmpty((String)this.getClassName())) {
            super.createRequest(debugProcess);
        }
    }

    @Override
    public void customizeRenderer(SimpleColoredComponent renderer) {
        long l2 = l ^ 0x4A83C14347A2L;
        renderer.append("Capture point at " + this.k.myClassName + "." + this.k.myMethodName);
    }

    @Override
    public boolean isEnabled() {
        return this.k.myEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.k.myEnabled = enabled;
        DebuggerSettings.getInstance().setCapturePoints(DebuggerSettings.getInstance().getCapturePoints());
    }

    private static void a(DebugProcessImpl debugProcessImpl, CapturePoint capturePoint) {
        StackCapturingLineBreakpoint stackCapturingLineBreakpoint = new StackCapturingLineBreakpoint(debugProcessImpl.getProject(), capturePoint);
        stackCapturingLineBreakpoint.createRequest(debugProcessImpl);
        CopyOnWriteArrayList<StackCapturingLineBreakpoint> copyOnWriteArrayList = (CopyOnWriteArrayList<StackCapturingLineBreakpoint>)debugProcessImpl.getUserData(CAPTURE_BREAKPOINTS);
        if (copyOnWriteArrayList == null) {
            copyOnWriteArrayList = new CopyOnWriteArrayList<StackCapturingLineBreakpoint>();
            AsyncStacksUtils.putProcessUserData(CAPTURE_BREAKPOINTS, copyOnWriteArrayList, debugProcessImpl);
        }
        copyOnWriteArrayList.add(stackCapturingLineBreakpoint);
    }

    @Nullable
    public static List<StackFrameItem> getRelatedStack(@NotNull StackFrameProxyImpl frame, @NotNull SuspendContextImpl suspendContext) {
        DebugProcessImpl debugProcessImpl;
        Map map2;
        long l2 = l ^ 0x7B00F6674A2AL;
        if (frame == null) {
            StackCapturingLineBreakpoint.c(1);
        }
        if (suspendContext == null) {
            StackCapturingLineBreakpoint.c(2);
        }
        if (ContainerUtil.isEmpty((Map)(map2 = (Map)(debugProcessImpl = suspendContext.getDebugProcess()).getUserData(d)))) {
            return null;
        }
        List list2 = (List)debugProcessImpl.getUserData(CAPTURE_BREAKPOINTS);
        if (ContainerUtil.isEmpty((Collection)list2)) {
            return null;
        }
        try {
            Location location = frame.location();
            String string = location.declaringType().name();
            String string2 = location.method().name();
            for (StackCapturingLineBreakpoint stackCapturingLineBreakpoint : list2) {
                String string3 = stackCapturingLineBreakpoint.k.myInsertClassName;
                if (!StringUtil.isEmpty((String)string3) && !StringUtil.equals((CharSequence)string3, (CharSequence)string) || !StringUtil.equals((CharSequence)stackCapturingLineBreakpoint.k.myInsertMethodName, (CharSequence)string2)) continue;
                try {
                    Value value = stackCapturingLineBreakpoint.h.evaluate(new EvaluationContextImpl(suspendContext, frame));
                    return value instanceof ObjectReference ? (List)map2.get(StackCapturingLineBreakpoint.a((ObjectReference)value)) : null;
                }
                catch (EvaluateException evaluateException) {
                    g.debug((Throwable)evaluateException);
                    if (evaluateException.getCause() instanceof IncompatibleThreadStateException) continue;
                    debugProcessImpl.printToConsole(DebuggerBundle.message((String)"error.unable.to.evaluate.insert.expression", (Object[])new Object[]{evaluateException.getMessage()}) + "\n");
                }
            }
        }
        catch (EvaluateException evaluateException) {
            g.debug((Throwable)evaluateException);
        }
        return null;
    }

    @Nullable
    public static List<StackFrameItem> getRelatedStack(@Nullable ObjectReference key, @Nullable DebugProcessImpl process2) {
        Map map2;
        if (process2 != null && key != null && (map2 = (Map)process2.getUserData(d)) != null) {
            return (List)map2.get(key);
        }
        return null;
    }

    private static Object a(ObjectReference objectReference) {
        return objectReference instanceof StringReference ? ((StringReference)objectReference).value() : objectReference;
    }

    static {
        l = lb.a(-127704576970497758L, 557542108015275438L, MethodHandles.lookup().lookupClass()).a(186336234927398L);
        long l2 = l ^ 0x779E520B1A67L;
        g = Logger.getInstance(StackCapturingLineBreakpoint.class);
        CAPTURE_BREAKPOINTS = Key.create((String)"CAPTURE_BREAKPOINTS");
        d = Key.create((String)"CAPTURED_STACKS");
    }

    private static /* synthetic */ void c(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = l ^ 0x43C5CF5AB625L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/StackCapturingLineBreakpoint";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/StackCapturingLineBreakpoint";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedStack";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CaptureAsyncStackTraceProvider
    implements AsyncStackTraceProvider {
        @Override
        @Nullable
        public List<StackFrameItem> getAsyncStackTrace(JavaStackFrame stackFrame, SuspendContextImpl suspendContext) {
            if (AsyncStacksToggleAction.isAsyncStacksEnabled((XDebugSessionImpl)suspendContext.getDebugProcess().getXdebugProcess().getSession())) {
                return StackCapturingLineBreakpoint.getRelatedStack(stackFrame.getStackFrameProxy(), suspendContext);
            }
            return null;
        }
    }

    private static class MyEvaluator {
        private final String b;
        private ExpressionEvaluator c;
        private final Map<Location, ExpressionEvaluator> a = ContainerUtil.createWeakMap();

        MyEvaluator(String expression) {
            boolean bl2;
            this.b = expression;
            final int n2 = DecompiledLocalVariable.getParamId(this.b);
            boolean bl3 = bl2 = n2 > -1;
            if (bl2) {
                this.c = new ExpressionEvaluatorImpl(new Evaluator(){
                    private static final long a = lb.a(5745837969274575651L, -7590399668313945247L, MethodHandles.lookup().lookupClass()).a(219923491522204L);

                    @Override
                    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
                        long l2 = a ^ 0x135C8654219BL;
                        List<Value> list2 = context.getFrameProxy().getArgumentValues();
                        if (n2 >= list2.size()) {
                            throw new EvaluateException("Param index " + n2 + " requested, but only " + list2.size() + " available");
                        }
                        return list2.get(n2);
                    }
                });
            }
        }

        @Nullable
        Value evaluate(EvaluationContext context) throws EvaluateException {
            Location location;
            ExpressionEvaluator expressionEvaluator = this.c;
            if (expressionEvaluator == null && (expressionEvaluator = this.a.get(location = context.getFrameProxy().location())) == null && !StringUtil.isEmpty((String)this.b)) {
                expressionEvaluator = (ExpressionEvaluator)ApplicationManager.getApplication().runReadAction(() -> {
                    SourcePosition sourcePosition = ContextUtil.getSourcePosition((StackFrameContext)context);
                    PsiElement psiElement = ContextUtil.getContextElement(sourcePosition);
                    return EvaluatorBuilderImpl.build(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, this.b), psiElement, sourcePosition, context.getProject());
                });
                this.a.put(location, expressionEvaluator);
            }
            if (expressionEvaluator != null) {
                return expressionEvaluator.evaluate(context);
            }
            return null;
        }

        void clearCache() {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            this.a.clear();
        }
    }
}

