/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.ClassesByNameProvider;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.debugger.ui.breakpoints.MethodBreakpointBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class MethodBreakpoint
extends BreakpointWithHighlighter<JavaMethodBreakpointProperties>
implements MethodBreakpointBase {
    private static final Logger k;
    @Nullable
    private JVMName j;
    private boolean l;
    @NonNls
    public static final Key<MethodBreakpoint> CATEGORY;
    private static final long m;

    protected MethodBreakpoint(@NotNull Project project2, XBreakpoint breakpoint) {
        if (project2 == null) {
            MethodBreakpoint.c(0);
        }
        super(project2, breakpoint);
    }

    public boolean isStatic() {
        return this.l;
    }

    @Override
    @NotNull
    public Key<MethodBreakpoint> getCategory() {
        Key<MethodBreakpoint> key = CATEGORY;
        if (key == null) {
            MethodBreakpoint.c(1);
        }
        return key;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.b() != null;
    }

    @Override
    public void reload() {
        Object object;
        super.reload();
        this.a(null);
        this.j = null;
        SourcePosition sourcePosition = this.getSourcePosition();
        if (sourcePosition != null && (object = MethodBreakpoint.a(this.myProject, sourcePosition)) != null) {
            this.a(object.methodName);
            this.j = object.methodSignature;
            this.l = object.isStatic;
        }
        if ((object = this.getPsiClass()) != null) {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myClassPattern = object.getQualifiedName();
        }
        if (this.l) {
            this.setInstanceFiltersEnabled(false);
        }
    }

    private static void a(final @NotNull MethodBreakpointBase methodBreakpointBase, @NotNull DebugProcessImpl debugProcessImpl, @NotNull ReferenceType referenceType) {
        if (methodBreakpointBase == null) {
            MethodBreakpoint.c(2);
        }
        if (debugProcessImpl == null) {
            MethodBreakpoint.c(3);
        }
        if (referenceType == null) {
            MethodBreakpoint.c(4);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        RequestManagerImpl requestManagerImpl = debugProcessImpl.getRequestsManager();
        ClassPrepareRequest classPrepareRequest = requestManagerImpl.createClassPrepareRequest((debugProcess, referenceType2) -> {
            if (referenceType == null) {
                MethodBreakpoint.c(40);
            }
            if (methodBreakpointBase == null) {
                MethodBreakpoint.c(41);
            }
            if (debugProcessImpl == null) {
                MethodBreakpoint.c(42);
            }
            if (MethodBreakpoint.b(referenceType2, referenceType)) {
                MethodBreakpoint.createRequestForPreparedClassEmulated(methodBreakpointBase, debugProcessImpl, referenceType2, false);
            }
        }, null);
        if (classPrepareRequest != null) {
            requestManagerImpl.registerRequest(methodBreakpointBase, classPrepareRequest);
            classPrepareRequest.enable();
        }
        AtomicReference atomicReference = new AtomicReference();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            long l2 = m ^ 0x49C8B2DE255BL;
            if (debugProcessImpl == null) {
                MethodBreakpoint.c(39);
            }
            ProgressWindow progressWindow = new ProgressWindow(true, false, debugProcessImpl.getProject(), "Cancel emulation");
            progressWindow.setDelayInMillis(2000);
            atomicReference.set(progressWindow);
        });
        final ProgressWindow progressWindow = (ProgressWindow)atomicReference.get();
        final AtomicBoolean atomicBoolean = new AtomicBoolean();
        XBreakpointListener xBreakpointListener = new XBreakpointListener<XBreakpoint<?>>(){
            private static final long a = lb.a(-4530899114291518640L, 5157376039455041923L, MethodHandles.lookup().lookupClass()).a(255832662043882L);

            void changed(@NotNull XBreakpoint b10) {
                if (b10 == null) {
                    1.a(0);
                }
                if (b10 == methodBreakpointBase.getXBreakpoint()) {
                    atomicBoolean.set(true);
                    progressWindow.cancel();
                }
            }

            public void breakpointRemoved(@NotNull XBreakpoint b10) {
                if (b10 == null) {
                    1.a(1);
                }
                this.changed(b10);
            }

            public void breakpointChanged(@NotNull XBreakpoint b10) {
                if (b10 == null) {
                    1.a(2);
                }
                this.changed(b10);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x5536B753E88EL;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "b";
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/MethodBreakpoint$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "changed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        debugProcessImpl.getProject().getMessageBus().connect((Disposable)progressWindow).subscribe(XBreakpointListener.TOPIC, (Object)xBreakpointListener);
        ProgressManager.getInstance().executeProcessUnderProgress(() -> {
            if (referenceType == null) {
                MethodBreakpoint.c(34);
            }
            if (methodBreakpointBase == null) {
                MethodBreakpoint.c(35);
            }
            if (debugProcessImpl == null) {
                MethodBreakpoint.c(36);
            }
            MethodBreakpoint.a(referenceType, (ReferenceType referenceType, ClassesByNameProvider classesByNameProvider) -> {
                if (methodBreakpointBase == null) {
                    MethodBreakpoint.c(37);
                }
                if (debugProcessImpl == null) {
                    MethodBreakpoint.c(38);
                }
                MethodBreakpoint.createRequestForPreparedClassEmulated(methodBreakpointBase, debugProcessImpl, referenceType, classesByNameProvider, false);
            }, (ProgressIndicator)progressWindow);
        }, (ProgressIndicator)progressWindow);
        if (progressWindow.isCanceled() && !atomicBoolean.get()) {
            methodBreakpointBase.disableEmulation();
        }
    }

    @Override
    public void disableEmulation() {
        MethodBreakpointBase.disableEmulation(this);
    }

    static void createRequestForPreparedClassEmulated(@NotNull MethodBreakpointBase breakpoint, @NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType classType, boolean base) {
        if (breakpoint == null) {
            MethodBreakpoint.c(5);
        }
        if (debugProcess == null) {
            MethodBreakpoint.c(6);
        }
        if (classType == null) {
            MethodBreakpoint.c(7);
        }
        MethodBreakpoint.createRequestForPreparedClassEmulated(breakpoint, debugProcess, classType, debugProcess.getVirtualMachineProxy().getClassesByNameProvider(), base);
    }

    static void createRequestForPreparedClassEmulated(final @NotNull MethodBreakpointBase breakpoint, final @NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType classType, @NotNull ClassesByNameProvider classesByName, boolean base) {
        if (breakpoint == null) {
            MethodBreakpoint.c(8);
        }
        if (debugProcess == null) {
            MethodBreakpoint.c(9);
        }
        if (classType == null) {
            MethodBreakpoint.c(10);
        }
        if (classesByName == null) {
            MethodBreakpoint.c(11);
        }
        if (!MethodBreakpointBase.canBeEmulated(debugProcess)) {
            breakpoint.disableEmulation();
            return;
        }
        if (!base && !MethodBreakpoint.shouldCreateRequest(breakpoint, breakpoint.getXBreakpoint(), debugProcess, true)) {
            return;
        }
        Method method2 = MethodBytecodeUtil.getLambdaMethod(classType, classesByName);
        if (method2 != null && !breakpoint.matchingMethods((StreamEx<Method>)StreamEx.of(((ClassType)classType).interfaces()).flatCollection(ReferenceType::allMethods), debugProcess).findFirst().isPresent()) {
            return;
        }
        StreamEx streamEx = method2 != null ? StreamEx.of((Object)method2) : breakpoint.matchingMethods((StreamEx<Method>)((StreamEx)StreamEx.of(classType.methods()).filter(method -> base || !method.isAbstract())), debugProcess);
        boolean bl2 = false;
        for (Method method3 : streamEx) {
            List<Location> list2;
            bl2 = true;
            if (method3.isNative()) {
                breakpoint.disableEmulation();
                return;
            }
            Method method4 = MethodBytecodeUtil.getBridgeTargetMethod(method3, classesByName);
            if (method4 != null && !ContainerUtil.isEmpty(DebuggerUtilsEx.allLineLocations(method4))) {
                method3 = method4;
            }
            if ((list2 = DebuggerUtilsEx.allLineLocations(method3)) == null && !method3.isBridge()) {
                breakpoint.disableEmulation();
                return;
            }
            if (ContainerUtil.isEmpty(list2)) continue;
            if (breakpoint.isWatchEntry()) {
                MethodBreakpoint.a((FilteredRequestor)breakpoint, (Location)ContainerUtil.getFirstItem(list2), debugProcess, true);
            }
            if (!breakpoint.isWatchExit()) continue;
            MethodBytecodeUtil.visit(method3, new MethodVisitor(458752){
                int myLastLine;
                private static final long a = lb.a(4277437384828944795L, -3866593803915001737L, MethodHandles.lookup().lookupClass()).a(48336022524496L);
                {
                    super(x0);
                    this.myLastLine = 0;
                }

                public void visitLineNumber(int line, Label start) {
                    this.myLastLine = line;
                }

                public void visitInsn(int opcode) {
                    switch (opcode) {
                        case 172: 
                        case 173: 
                        case 174: 
                        case 175: 
                        case 176: 
                        case 177: {
                            list2.stream().filter(location -> location.lineNumber() == this.myLastLine).findFirst().ifPresent(location -> {
                                if (breakpoint == null) {
                                    2.a(0);
                                }
                                if (debugProcess == null) {
                                    2.a(1);
                                }
                                MethodBreakpoint.a(breakpoint, location, debugProcess, false);
                            });
                        }
                    }
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    long l2 = a ^ 0x441501F3B5D6L;
                    Object[] objectArray2 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "breakpoint";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "debugProcess";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/debugger/ui/breakpoints/MethodBreakpoint$2";
                    objectArray[2] = "lambda$visitInsn$1";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, true);
        }
        if (base && bl2) {
            MethodBreakpoint.a(breakpoint, debugProcess, classType);
        }
    }

    private static void a(@NotNull FilteredRequestor filteredRequestor, @Nullable Location location, @NotNull DebugProcessImpl debugProcessImpl, boolean bl2) {
        BreakpointRequest breakpointRequest;
        long l2 = m ^ 0x1EC269F861BDL;
        if (filteredRequestor == null) {
            MethodBreakpoint.c(12);
        }
        if (debugProcessImpl == null) {
            MethodBreakpoint.c(13);
        }
        if ((breakpointRequest = MethodBreakpoint.createLocationBreakpointRequest(filteredRequestor, location, debugProcessImpl)) != null) {
            breakpointRequest.putProperty("METHOD_ENTRY_KEY", bl2);
        }
    }

    @Override
    protected void createRequestForPreparedClass(@NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType classType) {
        if (debugProcess == null) {
            MethodBreakpoint.c(14);
        }
        if (classType == null) {
            MethodBreakpoint.c(15);
        }
        if (this.isEmulated()) {
            MethodBreakpoint.createRequestForPreparedClassEmulated(this, debugProcess, classType, true);
        } else {
            this.b(debugProcess, classType);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void b(@NotNull DebugProcessImpl debugProcessImpl, @NotNull ReferenceType referenceType) {
        long l2 = m ^ 0x51033A5B3C5EL;
        if (debugProcessImpl == null) {
            MethodBreakpoint.c(16);
        }
        if (referenceType == null) {
            MethodBreakpoint.c(17);
        }
        try {
            boolean bl2 = false;
            for (Method mirror2 : referenceType.allMethods()) {
                String string = mirror2.signature();
                String string2 = mirror2.name();
                if (!this.b().equals(string2) || !this.j.getName(debugProcessImpl).equals(string)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                debugProcessImpl.getRequestsManager().setInvalid(this, DebuggerBundle.message((String)"error.invalid.breakpoint.method.not.found", (Object[])new Object[]{referenceType.name()}));
                return;
            }
            RequestManagerImpl requestManagerImpl = debugProcessImpl.getRequestsManager();
            if (this.isWatchEntry()) {
                void var7_10;
                MethodEntryRequest methodEntryRequest = MethodBreakpoint.findRequest(debugProcessImpl, MethodEntryRequest.class, this);
                if (methodEntryRequest == null) {
                    MethodEntryRequest methodEntryRequest2 = requestManagerImpl.createMethodEntryRequest(this);
                } else {
                    methodEntryRequest.disable();
                }
                var7_10.addClassFilter(referenceType);
                debugProcessImpl.getRequestsManager().enableRequest((EventRequest)var7_10);
            }
            if (this.isWatchExit()) {
                void var7_14;
                MethodExitRequest methodExitRequest = MethodBreakpoint.findRequest(debugProcessImpl, MethodExitRequest.class, this);
                if (methodExitRequest == null) {
                    MethodExitRequest methodExitRequest2 = requestManagerImpl.createMethodExitRequest(this);
                } else {
                    methodExitRequest.disable();
                }
                var7_14.addClassFilter(referenceType);
                debugProcessImpl.getRequestsManager().enableRequest((EventRequest)var7_14);
            }
        }
        catch (Exception exception) {
            k.debug((Throwable)exception);
        }
    }

    @Override
    public String getEventMessage(@NotNull LocatableEvent event) {
        if (event == null) {
            MethodBreakpoint.c(18);
        }
        return MethodBreakpoint.getEventMessage(event, this.getFileName());
    }

    static String getEventMessage(@NotNull LocatableEvent event, @NotNull String defaultFileName) {
        long l2 = m ^ 0x58CFD497D623L;
        if (event == null) {
            MethodBreakpoint.c(19);
        }
        if (defaultFileName == null) {
            MethodBreakpoint.c(20);
        }
        Location location = event.location();
        if (event instanceof MethodEntryEvent) {
            return MethodBreakpoint.a(true, ((MethodEntryEvent)event).method(), location, defaultFileName);
        }
        if (event instanceof MethodExitEvent) {
            return MethodBreakpoint.a(false, ((MethodExitEvent)event).method(), location, defaultFileName);
        }
        Object object = event.request().getProperty("METHOD_ENTRY_KEY");
        if (object instanceof Boolean) {
            return MethodBreakpoint.a((Boolean)object, location.method(), location, defaultFileName);
        }
        return "";
    }

    private static String a(boolean bl2, Method method, Location location, String string) {
        long l2 = m ^ 0x626BD14D9EC0L;
        String string2 = DebuggerUtilsEx.getLocationMethodQName(location);
        String string3 = DebuggerUtilsEx.getSourceName(location, throwable -> string);
        int n2 = location.lineNumber();
        return DebuggerBundle.message((String)(bl2 ? "status.method.entry.breakpoint.reached" : "status.method.exit.breakpoint.reached"), (Object[])new Object[]{method.declaringType().name() + "." + method.name() + "()", string2, string3, n2});
    }

    @Override
    public PsiElement getEvaluationElement() {
        return this.getPsiClass();
    }

    @Override
    protected Icon getDisabledIcon(boolean isMuted) {
        if (DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this) != null && isMuted) {
            return AllIcons.Debugger.Db_muted_dep_method_breakpoint;
        }
        return null;
    }

    @Override
    protected Icon getVerifiedIcon(boolean isMuted) {
        return this.isSuspend() ? AllIcons.Debugger.Db_verified_method_breakpoint : AllIcons.Debugger.Db_verified_no_suspend_method_breakpoint;
    }

    @Override
    @NotNull
    protected Icon getVerifiedWarningsIcon(boolean isMuted) {
        LayeredIcon layeredIcon = new LayeredIcon(new Icon[]{isMuted ? AllIcons.Debugger.Db_muted_method_breakpoint : AllIcons.Debugger.Db_method_breakpoint, AllIcons.General.WarningDecorator});
        if (layeredIcon == null) {
            MethodBreakpoint.c(21);
        }
        return layeredIcon;
    }

    @Override
    public String getDisplayName() {
        long l2 = m ^ 0x3C6B8097ED2FL;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isValid()) {
            boolean bl2;
            String string = this.getClassName();
            boolean bl3 = bl2 = string != null && string.length() > 0;
            if (bl2) {
                stringBuilder.append(string);
            }
            if (this.b() != null) {
                if (bl2) {
                    stringBuilder.append(".");
                }
                stringBuilder.append(this.b());
            }
        } else {
            stringBuilder.append(DebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]));
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean evaluateCondition(@NotNull EvaluationContextImpl context, @NotNull LocatableEvent event) throws EvaluateException {
        if (context == null) {
            MethodBreakpoint.c(22);
        }
        if (event == null) {
            MethodBreakpoint.c(23);
        }
        if (!this.matchesEvent(event, context.getDebugProcess())) {
            return false;
        }
        return super.evaluateCondition(context, event);
    }

    public boolean matchesEvent(@NotNull LocatableEvent event, DebugProcessImpl process2) throws EvaluateException {
        if (event == null) {
            MethodBreakpoint.c(24);
        }
        if (this.isEmulated()) {
            return true;
        }
        if (this.b() == null || this.j == null) {
            return false;
        }
        Method method = event.location().method();
        return method != null && method.name().equals(this.b()) && method.signature().equals(this.j.getName(process2));
    }

    @Nullable
    public static MethodBreakpoint create(@NotNull Project project2, XBreakpoint xBreakpoint) {
        if (project2 == null) {
            MethodBreakpoint.c(25);
        }
        MethodBreakpoint methodBreakpoint = new MethodBreakpoint(project2, xBreakpoint);
        return (MethodBreakpoint)methodBreakpoint.init();
    }

    @Nullable
    private static MethodDescriptor a(@NotNull Project project2, @NotNull SourcePosition sourcePosition) {
        Document document;
        if (project2 == null) {
            MethodBreakpoint.c(26);
        }
        if (sourcePosition == null) {
            MethodBreakpoint.c(27);
        }
        if ((document = PsiDocumentManager.getInstance((Project)project2).getDocument(sourcePosition.getFile())) == null) {
            return null;
        }
        MethodDescriptor methodDescriptor = (MethodDescriptor)ReadAction.compute(() -> {
            PsiMethod psiMethod;
            long l2 = m ^ 0x6AEAF7CF6FA8L;
            if (project2 == null) {
                MethodBreakpoint.c(32);
            }
            if (sourcePosition == null) {
                MethodBreakpoint.c(33);
            }
            if ((psiMethod = PositionUtil.getPsiElementAt(project2, PsiMethod.class, sourcePosition)) == null) {
                return null;
            }
            int n2 = psiMethod.getTextOffset();
            if (!DocumentUtil.isValidOffset((int)n2, (Document)document) || document.getLineNumber(n2) < sourcePosition.getLine()) {
                return null;
            }
            PsiIdentifier psiIdentifier = psiMethod.getNameIdentifier();
            int n3 = psiIdentifier != null ? psiIdentifier.getTextOffset() : n2;
            MethodDescriptor methodDescriptor = new MethodDescriptor();
            methodDescriptor.methodName = JVMNameUtil.getJVMMethodName(psiMethod);
            try {
                methodDescriptor.methodSignature = JVMNameUtil.getJVMSignature(psiMethod);
                methodDescriptor.isStatic = psiMethod.hasModifierProperty("static");
            }
            catch (IndexNotReadyException indexNotReadyException) {
                return null;
            }
            methodDescriptor.methodLine = document.getLineNumber(n3);
            return methodDescriptor;
        });
        if (methodDescriptor == null || methodDescriptor.methodName == null || methodDescriptor.methodSignature == null) {
            return null;
        }
        return methodDescriptor;
    }

    @Nullable
    static <T extends EventRequest> T findRequest(@NotNull DebugProcessImpl debugProcess, Class<T> requestClass, Requestor requestor) {
        if (debugProcess == null) {
            MethodBreakpoint.c(28);
        }
        return (T)((EventRequest)StreamEx.of(debugProcess.getRequestsManager().findRequests(requestor)).select(requestClass).findFirst().orElse(null));
    }

    @Override
    public void readExternal(@NotNull Element breakpointNode) throws InvalidDataException {
        long l2 = m ^ 0x233DE950F1EFL;
        if (breakpointNode == null) {
            MethodBreakpoint.c(29);
        }
        super.readExternal(breakpointNode);
        try {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_ENTRY = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)breakpointNode, (String)"WATCH_ENTRY"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_EXIT = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)breakpointNode, (String)"WATCH_EXIT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isEmulated() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).EMULATED;
    }

    @Override
    public boolean isWatchEntry() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_ENTRY;
    }

    @Override
    public boolean isWatchExit() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_EXIT;
    }

    @Override
    public StreamEx matchingMethods(StreamEx<Method> methods, DebugProcessImpl debugProcess) {
        try {
            String string = this.b();
            String string2 = this.j != null ? this.j.getName(debugProcess) : null;
            return (StreamEx)((StreamEx)methods.filter(method -> Comparing.equal((String)string, (String)method.name()) && Comparing.equal((String)string2, (String)method.signature()))).limit(1L);
        }
        catch (EvaluateException evaluateException) {
            k.warn((Throwable)evaluateException);
            return StreamEx.empty();
        }
    }

    @Nullable
    private String b() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myMethodName;
    }

    private void a(@Nullable String string) {
        ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myMethodName = string;
    }

    private static boolean b(@Nullable ReferenceType referenceType, @NotNull ReferenceType referenceType3) {
        if (referenceType3 == null) {
            MethodBreakpoint.c(30);
        }
        if (referenceType == null) {
            return false;
        }
        if (referenceType3.equals(referenceType)) {
            return true;
        }
        return MethodBreakpoint.a(referenceType).anyMatch(referenceType2 -> {
            if (referenceType3 == null) {
                MethodBreakpoint.c(31);
            }
            return MethodBreakpoint.b(referenceType2, referenceType3);
        });
    }

    private static Stream<? extends ReferenceType> a(ReferenceType referenceType) {
        if (referenceType instanceof InterfaceType) {
            return ((InterfaceType)referenceType).superinterfaces().stream();
        }
        if (referenceType instanceof ClassType) {
            return StreamEx.ofNullable((Object)((ClassType)referenceType).superclass()).prepend(((ClassType)referenceType).interfaces());
        }
        return StreamEx.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(ReferenceType referenceType2, BiConsumer<ReferenceType, ClassesByNameProvider> biConsumer, ProgressIndicator progressIndicator) {
        long l2 = m ^ 0x2A5078E6E1B8L;
        long l3 = 0L;
        if (k.isDebugEnabled()) {
            l3 = System.currentTimeMillis();
        }
        progressIndicator.setIndeterminate(false);
        progressIndicator.start();
        progressIndicator.setText(DebuggerBundle.message((String)"label.method.breakpoints.processing.classes", (Object[])new Object[0]));
        try {
            Object object;
            MultiMap multiMap = new MultiMap();
            List<ReferenceType> list2 = referenceType2.virtualMachine().allClasses();
            for (int i10 = 0; i10 < list2.size(); ++i10) {
                if (progressIndicator.isCanceled()) {
                    return;
                }
                object = list2.get(i10);
                if (object.isPrepared()) {
                    try {
                        MethodBreakpoint.a((ReferenceType)object).forEach(arg_0 -> MethodBreakpoint.a(multiMap, (ReferenceType)object, arg_0));
                    }
                    catch (ObjectCollectedException objectCollectedException) {
                        // empty catch block
                    }
                }
                progressIndicator.setText2(i10 + "/" + list2.size());
                progressIndicator.setFraction((double)i10 / (double)list2.size());
            }
            List list3 = ((StreamEx)StreamEx.ofTree((Object)referenceType2, referenceType -> StreamEx.of((Collection)multiMap.get(referenceType))).skip(1L)).toList();
            progressIndicator.setText(DebuggerBundle.message((String)"label.method.breakpoints.setting.breakpoints", (Object[])new Object[0]));
            object = ClassesByNameProvider.createCache(list2);
            for (int i11 = 0; i11 < list3.size(); ++i11) {
                if (progressIndicator.isCanceled()) {
                    return;
                }
                biConsumer.accept((ReferenceType)list3.get(i11), (ClassesByNameProvider)object);
                progressIndicator.setText2(i11 + "/" + list3.size());
                progressIndicator.setFraction((double)i11 / (double)list3.size());
            }
            if (k.isDebugEnabled()) {
                k.debug("Processed " + list3.size() + " classes in " + (System.currentTimeMillis() - l3) + "ms");
            }
        }
        finally {
            progressIndicator.stop();
        }
    }

    private static /* synthetic */ void a(MultiMap multiMap, ReferenceType referenceType, ReferenceType referenceType2) {
        multiMap.putValue((Object)referenceType2, (Object)referenceType);
    }

    static {
        m = lb.a(-5034537281628296056L, -7298470596751804028L, MethodHandles.lookup().lookupClass()).a(274659660199756L);
        long l2 = m ^ 0x149A668EB9BFL;
        k = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.MethodBreakpoint");
        CATEGORY = BreakpointCategory.lookup("method_breakpoints");
    }

    private static /* synthetic */ void c(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = m ^ 0x791ED139FB8EL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 21: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/MethodBreakpoint";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 35: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 28: 
            case 36: 
            case 38: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 4: 
            case 34: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseType";
                break;
            }
            case 7: 
            case 10: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesByName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 18: 
            case 19: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultFileName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePosition";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpointNode";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/MethodBreakpoint";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCategory";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getVerifiedWarningsIcon";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 21: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createRequestForSubClasses";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createRequestForPreparedClassEmulated";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createLocationBreakpointRequest";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createRequestForPreparedClass";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createRequestForPreparedClassOriginal";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getEventMessage";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "evaluateCondition";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "matchesEvent";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getMethodDescriptor";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findRequest";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "instanceOf";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$instanceOf$8";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getMethodDescriptor$6";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createRequestForSubClasses$3";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createRequestForSubClasses$1";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createRequestForSubClasses$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MethodDescriptor {
        String methodName;
        JVMName methodSignature;
        boolean isStatic;
        int methodLine;

        private MethodDescriptor() {
        }
    }
}

