/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import b.a.lb;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.SyntheticLineBreakpoint;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import com.sun.jdi.event.LocatableEvent;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class InstrumentationTracker {
    private static final Logger d;
    private final InstrumentationMethodBreakpoint c;
    private final InstrumentationMethodBreakpoint a;
    @NotNull
    private final DebugProcessImpl b;
    private static final java.lang.reflect.Method e;
    private static final long f;

    public static void track(DebugProcessImpl debugProcess) {
        if (e != null) {
            new InstrumentationTracker(debugProcess);
        }
    }

    private InstrumentationTracker(DebugProcessImpl debugProcess) {
        long l2 = f ^ 0xA6AEB91BEB4L;
        this.c = new InstrumentationMethodBreakpoint(debugProcess.getProject(), "sun.instrument.InstrumentationImpl", "redefineClasses"){
            private static final long o = lb.a(7375462221103590264L, 6636124113501061291L, MethodHandles.lookup().lookupClass()).a(4608449634237L);

            @Override
            public boolean processLocatableEvent(SuspendContextCommandImpl action, LocatableEvent event) {
                try {
                    Value value2 = event.thread().frame(0).getArgumentValues().get(0);
                    if (value2 instanceof ArrayReference) {
                        ((ArrayReference)value2).getValues().forEach(value -> {
                            long l2 = o ^ 0x6B7DE794CBC6L;
                            Value value2 = ((ObjectReference)value).getValue(((ReferenceType)value.type()).fieldByName("mClass"));
                            InstrumentationTracker.this.a(((ClassObjectReference)value2).reflectedType());
                        });
                    }
                }
                catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                    LOG.warn((Throwable)incompatibleThreadStateException);
                }
                return false;
            }
        };
        this.a = new InstrumentationMethodBreakpoint(debugProcess.getProject(), "sun.instrument.InstrumentationImpl", "retransformClasses"){

            @Override
            public boolean processLocatableEvent(SuspendContextCommandImpl action, LocatableEvent event) {
                try {
                    Value value2 = event.thread().frame(0).getArgumentValues().get(0);
                    if (value2 instanceof ArrayReference) {
                        ((ArrayReference)value2).getValues().forEach(value -> InstrumentationTracker.this.a(((ClassObjectReference)value).reflectedType()));
                    }
                }
                catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                    LOG.warn((Throwable)incompatibleThreadStateException);
                }
                return false;
            }
        };
        this.b = debugProcess;
        this.c.createRequest(debugProcess);
        this.a.createRequest(debugProcess);
    }

    private void a(ReferenceType referenceType) {
        if (!e.getDeclaringClass().isAssignableFrom(referenceType.getClass())) {
            return;
        }
        List list2 = ((StreamEx)StreamEx.of(referenceType.virtualMachine().eventRequestManager().breakpointRequests()).filter(breakpointRequest -> referenceType.equals(breakpointRequest.location().declaringType()))).map(RequestManagerImpl::findRequestor).toList();
        list2.forEach(this.b.getRequestsManager()::deleteRequest);
        try {
            e.invoke((Object)referenceType, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            d.error((Throwable)reflectiveOperationException);
        }
        StreamEx.of((Collection)list2).select(Breakpoint.class).forEach(breakpoint -> breakpoint.createRequest(this.b));
    }

    static {
        f = lb.a(3882127781735576376L, -4412943679885604447L, MethodHandles.lookup().lookupClass()).a(196710059982781L);
        long l2 = f ^ 0x39D28C2685F3L;
        d = Logger.getInstance(InstrumentationTracker.class);
        java.lang.reflect.Method method = null;
        try {
            method = ReflectionUtil.getDeclaredMethod(Class.forName("com.sun.tools.jdi.ReferenceTypeImpl"), (String)"noticeRedefineClass", (Class[])new Class[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            d.warn((Throwable)classNotFoundException);
        }
        e = method;
    }

    public static class InstrumentationMethodBreakpoint
    extends SyntheticLineBreakpoint {
        private final String m;
        private final String n;
        private static final long p = lb.a(-7227184135350639179L, 8890926451093975154L, MethodHandles.lookup().lookupClass()).a(28192912951209L);

        public InstrumentationMethodBreakpoint(@NotNull Project project2, String className, String methodName) {
            if (project2 == null) {
                InstrumentationMethodBreakpoint.e(0);
            }
            super(project2);
            this.m = className;
            this.n = methodName;
        }

        @Override
        public void createRequest(@NotNull DebugProcessImpl debugProcess) {
            if (debugProcess == null) {
                InstrumentationMethodBreakpoint.e(1);
            }
            this.createOrWaitPrepare(debugProcess, this.m);
        }

        @Override
        protected void createRequestForPreparedClass(DebugProcessImpl debugProcess, ReferenceType classType) {
            for (Method method : classType.methodsByName(this.n)) {
                this.createRequestInMethod(debugProcess, method);
            }
        }

        protected void createRequestInMethod(DebugProcessImpl debugProcess, Method method) {
            try {
                Location location = (Location)ContainerUtil.getLastItem(method.allLineLocations());
                BreakpointWithHighlighter.createLocationBreakpointRequest(this, location, debugProcess);
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
        }

        @Override
        public String getDisplayName() {
            long l2 = p ^ 0x2EE4FC927834L;
            return "Instrumentation tracker: " + this.n;
        }

        private static /* synthetic */ void e(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = p ^ 0x64EF1F9C543FL;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugProcess";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/ui/breakpoints/InstrumentationTracker$InstrumentationMethodBreakpoint";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createRequest";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

