/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.sun.jdi.Field;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.debugger.breakpoints.properties.JavaFieldBreakpointProperties;

public class FieldBreakpoint
extends BreakpointWithHighlighter<JavaFieldBreakpointProperties> {
    private static final Logger j;
    private boolean k;
    @NonNls
    public static final Key<FieldBreakpoint> CATEGORY;
    private static final long l;

    protected FieldBreakpoint(Project project2, XBreakpoint breakpoint) {
        super(project2, breakpoint);
    }

    private FieldBreakpoint(Project project2, @NotNull String fieldName, XBreakpoint breakpoint) {
        if (fieldName == null) {
            FieldBreakpoint.c(0);
        }
        super(project2, breakpoint);
        this.setFieldName(fieldName);
    }

    public boolean isStatic() {
        return this.k;
    }

    public String getFieldName() {
        return ((JavaFieldBreakpointProperties)((Object)this.getProperties())).myFieldName;
    }

    @Override
    protected Icon getDisabledIcon(boolean isMuted) {
        if (DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this) != null && isMuted) {
            return AllIcons.Debugger.Db_muted_dep_field_breakpoint;
        }
        return null;
    }

    @Override
    protected Icon getVerifiedIcon(boolean isMuted) {
        return this.isSuspend() ? AllIcons.Debugger.Db_verified_field_breakpoint : AllIcons.Debugger.Db_verified_no_suspend_field_breakpoint;
    }

    @Override
    protected Icon getVerifiedWarningsIcon(boolean isMuted) {
        return new LayeredIcon(new Icon[]{isMuted ? AllIcons.Debugger.Db_muted_field_breakpoint : AllIcons.Debugger.Db_field_breakpoint, AllIcons.General.WarningDecorator});
    }

    @Override
    public Key<FieldBreakpoint> getCategory() {
        return CATEGORY;
    }

    public PsiField getPsiField() {
        SourcePosition sourcePosition = this.getSourcePosition();
        try {
            PsiField psiField = (PsiField)ReadAction.compute(() -> {
                PsiClass psiClass = FieldBreakpoint.getPsiClassAt(sourcePosition);
                return psiClass != null ? psiClass.findFieldByName(this.getFieldName(), true) : null;
            });
            if (psiField != null) {
                return psiField;
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        return PositionUtil.getPsiElementAt(this.myProject, PsiField.class, sourcePosition);
    }

    @Override
    public void reload() {
        long l2 = l ^ 0x5035DC15A24L;
        super.reload();
        PsiField psiField = PositionUtil.getPsiElementAt(this.myProject, PsiField.class, this.getSourcePosition());
        if (psiField != null) {
            this.setFieldName(psiField.getName());
            PsiClass psiClass = psiField.getContainingClass();
            if (psiClass != null) {
                ((JavaFieldBreakpointProperties)((Object)this.getProperties())).myClassName = psiClass.getQualifiedName();
            }
            this.k = psiField.hasModifierProperty("static");
        }
        if (this.k) {
            this.setInstanceFiltersEnabled(false);
        }
    }

    @Override
    protected ObjectReference getThisObject(SuspendContextImpl context, LocatableEvent event) throws EvaluateException {
        ObjectReference objectReference;
        if (event instanceof ModificationWatchpointEvent) {
            ObjectReference objectReference2 = ((ModificationWatchpointEvent)event).object();
            if (objectReference2 != null) {
                return objectReference2;
            }
        } else if (event instanceof AccessWatchpointEvent && (objectReference = ((AccessWatchpointEvent)event).object()) != null) {
            return objectReference;
        }
        return super.getThisObject(context, event);
    }

    @Override
    public void createRequestForPreparedClass(DebugProcessImpl debugProcess, ReferenceType refType) {
        long l2 = l ^ 0x646564CBE3B2L;
        VirtualMachineProxyImpl virtualMachineProxyImpl = debugProcess.getVirtualMachineProxy();
        try {
            RequestManagerImpl requestManagerImpl = debugProcess.getRequestsManager();
            Field field = refType.fieldByName(this.getFieldName());
            if (field == null) {
                requestManagerImpl.setInvalid(this, DebuggerBundle.message((String)"error.invalid.breakpoint.missing.field.in.class", (Object[])new Object[]{this.getFieldName(), refType.name()}));
                return;
            }
            if (this.b() && virtualMachineProxyImpl.canWatchFieldModification()) {
                requestManagerImpl.enableRequest(requestManagerImpl.createModificationWatchpointRequest(this, field));
                j.debug("Modification request added");
            }
            if (this.a() && virtualMachineProxyImpl.canWatchFieldAccess()) {
                requestManagerImpl.enableRequest(requestManagerImpl.createAccessWatchpointRequest(this, field));
                if (j.isDebugEnabled()) {
                    j.debug("Access request added field = " + field.name() + "; refType = " + refType.name());
                }
            }
        }
        catch (Exception exception) {
            j.debug((Throwable)exception);
        }
    }

    @Override
    public String getEventMessage(LocatableEvent event) {
        long l2 = l ^ 0x34D31A7DA65L;
        Location location = event.location();
        String string = DebuggerUtilsEx.getLocationMethodQName(location);
        String string2 = DebuggerUtilsEx.getSourceName(location, throwable -> this.getFileName());
        int n2 = location.lineNumber();
        if (event instanceof ModificationWatchpointEvent) {
            ModificationWatchpointEvent modificationWatchpointEvent = (ModificationWatchpointEvent)event;
            ObjectReference objectReference = modificationWatchpointEvent.object();
            Field field = modificationWatchpointEvent.field();
            if (objectReference != null) {
                return DebuggerBundle.message((String)"status.field.watchpoint.reached.modification", (Object[])new Object[]{field.declaringType().name(), field.name(), modificationWatchpointEvent.valueCurrent(), modificationWatchpointEvent.valueToBe(), string, string2, n2, objectReference.uniqueID()});
            }
            return DebuggerBundle.message((String)"status.static.field.watchpoint.reached.modification", (Object[])new Object[]{field.declaringType().name(), field.name(), modificationWatchpointEvent.valueCurrent(), modificationWatchpointEvent.valueToBe(), string, string2, n2});
        }
        if (event instanceof AccessWatchpointEvent) {
            AccessWatchpointEvent accessWatchpointEvent = (AccessWatchpointEvent)event;
            ObjectReference objectReference = accessWatchpointEvent.object();
            Field field = accessWatchpointEvent.field();
            if (objectReference != null) {
                return DebuggerBundle.message((String)"status.field.watchpoint.reached.access", (Object[])new Object[]{field.declaringType().name(), field.name(), string, string2, n2, objectReference.uniqueID()});
            }
            return DebuggerBundle.message((String)"status.static.field.watchpoint.reached.access", (Object[])new Object[]{field.declaringType().name(), field.name(), string, string2, n2});
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        long l2 = l ^ 0x4C2780EDC3DEL;
        if (!this.isValid()) {
            return DebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]);
        }
        String string = this.getClassName();
        return string != null && !string.isEmpty() ? string + "." + this.getFieldName() : this.getFieldName();
    }

    public static FieldBreakpoint create(@NotNull Project project2, String fieldName, XBreakpoint xBreakpoint) {
        if (project2 == null) {
            FieldBreakpoint.c(1);
        }
        FieldBreakpoint fieldBreakpoint = new FieldBreakpoint(project2, fieldName, xBreakpoint);
        return (FieldBreakpoint)fieldBreakpoint.init();
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.getPsiField() != null;
    }

    @Override
    public boolean isAt(@NotNull Document document, int offset) {
        PsiField psiField;
        if (document == null) {
            FieldBreakpoint.c(2);
        }
        return (psiField = FieldBreakpoint.findField(this.myProject, document, offset)) == this.getPsiField();
    }

    public static PsiField findField(Project project2, Document document, int offset) {
        long l2 = l ^ 0x3F84E780F11CL;
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
        if (psiFile == null) {
            return null;
        }
        offset = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)offset, (String)" \t");
        PsiElement psiElement2 = psiFile.findElementAt(offset);
        if (psiElement2 == null) {
            return null;
        }
        PsiField psiField = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)psiElement2, PsiField.class, (boolean)false);
        int n2 = document.getLineNumber(offset);
        if (psiField == null) {
            PsiField[] psiFieldArray = new PsiField[]{null};
            XDebuggerUtil.getInstance().iterateLine(project2, document, n2, psiElement -> {
                PsiField psiField = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiField.class, (boolean)false);
                if (psiField != null) {
                    psiFieldArray[0] = psiField;
                    return false;
                }
                return true;
            });
            psiField = psiFieldArray[0];
        }
        return psiField;
    }

    @Override
    public void readExternal(@NotNull Element breakpointNode) throws InvalidDataException {
        long l2 = l ^ 0x5371E92ADF1EL;
        if (breakpointNode == null) {
            FieldBreakpoint.c(3);
        }
        super.readExternal(breakpointNode);
        this.setFieldName(breakpointNode.getAttributeValue("field_name"));
        if (this.getFieldName() == null) {
            throw new InvalidDataException("No field name for field breakpoint");
        }
        try {
            ((JavaFieldBreakpointProperties)((Object)this.getProperties())).WATCH_MODIFICATION = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)breakpointNode, (String)"WATCH_MODIFICATION"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((JavaFieldBreakpointProperties)((Object)this.getProperties())).WATCH_ACCESS = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)breakpointNode, (String)"WATCH_ACCESS"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public PsiElement getEvaluationElement() {
        return this.getPsiClass();
    }

    private boolean b() {
        return ((JavaFieldBreakpointProperties)((Object)this.getProperties())).WATCH_MODIFICATION;
    }

    private boolean a() {
        return ((JavaFieldBreakpointProperties)((Object)this.getProperties())).WATCH_ACCESS;
    }

    void setFieldName(String fieldName) {
        ((JavaFieldBreakpointProperties)((Object)this.getProperties())).myFieldName = fieldName;
    }

    static {
        l = lb.a(-8880511273616460774L, -1764975358568481168L, MethodHandles.lookup().lookupClass()).a(45011754702808L);
        long l2 = l ^ 0x54BE9B04FD4AL;
        j = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.FieldBreakpoint");
        CATEGORY = BreakpointCategory.lookup("field_breakpoints");
    }

    private static /* synthetic */ void c(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = l ^ 0x1E12995BAE3AL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpointNode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/ui/breakpoints/FieldBreakpoint";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAt";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

