/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import b.a.lb;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.settings.CaptureConfigurable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class CaptureSettingsProvider {
    private static final Logger a;
    private static final KeyProvider c;
    private static final String b = "*";
    private static final long d;

    @NotNull
    public static Properties getPointsProperties() {
        long l2 = d ^ 0x79CB55E567C3L;
        Properties properties = new Properties();
        if (Registry.is((String)"debugger.capture.points.agent.annotations")) {
            int n2 = 0;
            for (AgentPoint agentPoint : CaptureSettingsProvider.a()) {
                properties.setProperty((agentPoint.isCapture() ? "capture" : "insert") + n2++, agentPoint.myClassName + " " + agentPoint.myMethodName + " " + agentPoint.myMethodDesc + " " + agentPoint.myKey.asString());
            }
        }
        Properties properties2 = properties;
        if (properties2 == null) {
            CaptureSettingsProvider.b(0);
        }
        return properties2;
    }

    private static List<AgentPoint> a() {
        return (List)ReadAction.compute(() -> {
            ArrayList arrayList = new ArrayList();
            CaptureConfigurable.processCaptureAnnotations((bl2, psiModifierListOwner) -> {
                PsiAnnotationMemberValue psiAnnotationMemberValue;
                Object object;
                Object object2;
                KeyProvider keyProvider;
                PsiMethod psiMethod;
                long l2 = d ^ 0x7AD709CFFFDDL;
                if (psiModifierListOwner instanceof PsiMethod) {
                    psiMethod = (PsiMethod)psiModifierListOwner;
                    keyProvider = c;
                } else if (psiModifierListOwner instanceof PsiParameter) {
                    object2 = (PsiParameter)psiModifierListOwner;
                    psiMethod = (PsiMethod)object2.getDeclarationScope();
                    keyProvider = CaptureSettingsProvider.a(psiMethod.getParameterList().getParameterIndex((PsiParameter)object2));
                } else {
                    return;
                }
                object2 = JVMNameUtil.getClassVMName(psiMethod.getContainingClass());
                if (object2 == null) {
                    a.warn("Unable to find VM class name for annotated method: " + psiMethod.getName());
                    return;
                }
                String string = ((String)object2).replaceAll("\\.", "/");
                String string2 = JVMNameUtil.getJVMMethodName(psiMethod);
                String string3 = b;
                try {
                    string3 = JVMNameUtil.getJVMSignature(psiMethod).getName(null);
                }
                catch (EvaluateException evaluateException) {
                    a.error((Throwable)evaluateException);
                }
                PsiModifierList psiModifierList = psiModifierListOwner.getModifierList();
                if (psiModifierList != null && (object = psiModifierList.findAnnotation(CaptureConfigurable.getAnnotationName(bl2))) != null && (psiAnnotationMemberValue = object.findAttributeValue("keyExpression")) != null && !"\"\"".equals(psiAnnotationMemberValue.getText())) {
                    keyProvider = new FieldKeyProvider(string, StringUtil.unquoteString((String)psiAnnotationMemberValue.getText()));
                }
                object = bl2 != false ? new AgentCapturePoint(string, string2, string3, keyProvider) : new AgentInsertPoint(string, string2, string3, keyProvider);
                arrayList.add(object);
            });
            return arrayList;
        });
    }

    private static KeyProvider a(int n2) {
        return new StringKeyProvider(Integer.toString(n2));
    }

    static {
        d = lb.a(6095743142599919909L, 7729073855610979004L, MethodHandles.lookup().lookupClass()).a(119487631444613L);
        long l2 = d ^ 0x19ED14A08CFDL;
        a = Logger.getInstance(CaptureSettingsProvider.class);
        c = new StringKeyProvider("this");
    }

    private static /* synthetic */ void b(int n2) {
        long l2 = d ^ 0x14C3DE4C94A2L;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/settings/CaptureSettingsProvider", "getPointsProperties"));
    }

    private static class FieldKeyProvider
    implements KeyProvider {
        private final String b;
        private final String a;

        FieldKeyProvider(String className, String fieldName) {
            this.b = className;
            this.a = fieldName;
        }

        @Override
        public String asString() {
            return this.b + " " + this.a;
        }
    }

    private static class StringKeyProvider
    implements KeyProvider {
        private final String a;

        StringKeyProvider(String value) {
            this.a = value;
        }

        @Override
        public String asString() {
            return this.a;
        }
    }

    private static interface KeyProvider {
        public String asString();
    }

    private static class AgentInsertPoint
    extends AgentPoint {
        AgentInsertPoint(String className, String methodName, String methodDesc, KeyProvider key) {
            super(className, methodName, methodDesc, key);
        }

        @Override
        public boolean isCapture() {
            return false;
        }
    }

    private static class AgentCapturePoint
    extends AgentPoint {
        AgentCapturePoint(String className, String methodName, String methodDesc, KeyProvider key) {
            super(className, methodName, methodDesc, key);
        }

        @Override
        public boolean isCapture() {
            return true;
        }
    }

    private static abstract class AgentPoint {
        public final String myClassName;
        public final String myMethodName;
        public final String myMethodDesc;
        public final KeyProvider myKey;
        private static final String a = " ";
        private static final long b = lb.a(-8210771403013513913L, -6049667033249044972L, MethodHandles.lookup().lookupClass()).a(120423782338235L);

        AgentPoint(String className, String methodName, String methodDesc, KeyProvider key) {
            long l2 = b ^ 0x499FE54F3899L;
            assert (!className.contains(".")) : "Classname should not contain . here";
            this.myClassName = className;
            this.myMethodName = methodName;
            this.myMethodDesc = methodDesc;
            this.myKey = key;
        }

        public abstract boolean isCapture();

        public String toString() {
            return this.myClassName + "." + this.myMethodName + a + this.myKey.asString();
        }
    }
}

