/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import b.a.lb;
import com.intellij.codeInsight.AnnotationsPanel;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.settings.CapturePoint;
import com.intellij.debugger.settings.DebuggerProjectSettings;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.JavaDebuggerSupport;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.DumbAwareActionButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.xmlb.XmlSerializer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.BiConsumer;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaptureConfigurable
implements SearchableConfigurable {
    private static final Logger e;
    private final Project c;
    private JCheckBox d;
    private JButton g;
    private JPanel a;
    private MyTableModel h;
    private JCheckBox f;
    private JPanel b;
    private static final long i;

    public CaptureConfigurable(Project project2) {
        this.c = project2;
        this.a();
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            CaptureConfigurable.a(0);
        }
        return string;
    }

    @NotNull
    public String getHelpTopic() {
        long l2 = i ^ 0x73B371AC4627L;
        if ("reference.idesettings.debugger.capture" == null) {
            CaptureConfigurable.a(1);
        }
        return "reference.idesettings.debugger.capture";
    }

    @Nullable
    public JComponent createComponent() {
        long l2 = i ^ 0x47BAD1095AB3L;
        this.h = new MyTableModel();
        final JBTable jBTable = new JBTable((TableModel)this.h);
        jBTable.setColumnSelectionAllowed(false);
        final JTextField jTextField = new JTextField();
        jTextField.putClientProperty("JComponent.compactHeight", Boolean.TRUE);
        jBTable.setDefaultEditor(String.class, (TableCellEditor)new DefaultCellEditor(jTextField));
        jBTable.setDefaultRenderer(String.class, (TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                Dimension dimension2 = jTextField.getPreferredSize();
                dimension.height = Math.max(dimension.height, dimension2.height);
                return dimension;
            }
        });
        TableColumnModel tableColumnModel = jBTable.getColumnModel();
        TableUtil.setupCheckboxColumn((TableColumn)tableColumnModel.getColumn(0));
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JTable)jBTable);
        toolbarDecorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                CaptureConfigurable.this.h.addRow();
            }
        });
        toolbarDecorator.setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.removeSelectedItems((JTable)jBTable);
            }
        });
        toolbarDecorator.setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.moveSelectedItemsUp((JTable)jBTable);
            }
        });
        toolbarDecorator.setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.moveSelectedItemsDown((JTable)jBTable);
            }
        });
        toolbarDecorator.addExtraAction((AnActionButton)new DumbAwareActionButton("Duplicate", "Duplicate", PlatformIcons.COPY_ICON){
            private static final long a = lb.a(9102436512458560703L, -4434145792480668544L, MethodHandles.lookup().lookupClass()).a(247849462725406L);

            public boolean isEnabled() {
                return jBTable.getSelectedRowCount() == 1;
            }

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    6.a(0);
                }
                CaptureConfigurable.this.a(jBTable).forEach(capturePoint -> {
                    try {
                        int n2 = CaptureConfigurable.this.h.add(capturePoint.clone());
                        jBTable.getSelectionModel().setSelectionInterval(n2, n2);
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        e.error((Throwable)cloneNotSupportedException);
                    }
                });
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x265B057856F1L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/settings/CaptureConfigurable$6", "actionPerformed"));
            }
        });
        toolbarDecorator.addExtraAction((AnActionButton)new DumbAwareActionButton("Enable Selected", "Enable Selected", PlatformIcons.SELECT_ALL_ICON){
            private static final long a = lb.a(8153569019592360058L, -1416012704732767201L, MethodHandles.lookup().lookupClass()).a(253824607614023L);

            public boolean isEnabled() {
                return jBTable.getSelectedRowCount() > 0;
            }

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    7.a(0);
                }
                CaptureConfigurable.this.a(jBTable).forEach(capturePoint -> {
                    capturePoint.myEnabled = true;
                });
                jBTable.repaint();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x38C2E202F0BEL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/settings/CaptureConfigurable$7", "actionPerformed"));
            }
        });
        toolbarDecorator.addExtraAction((AnActionButton)new DumbAwareActionButton("Disable Selected", "Disable Selected", PlatformIcons.UNSELECT_ALL_ICON){
            private static final long a = lb.a(1451083231328096493L, 1752862768025437600L, MethodHandles.lookup().lookupClass()).a(128799428013378L);

            public boolean isEnabled() {
                return jBTable.getSelectedRowCount() > 0;
            }

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    8.a(0);
                }
                CaptureConfigurable.this.a(jBTable).forEach(capturePoint -> {
                    capturePoint.myEnabled = false;
                });
                jBTable.repaint();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x46F3434F4EFL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/settings/CaptureConfigurable$8", "actionPerformed"));
            }
        });
        new DumbAwareAction("Toggle"){
            private static final long a = lb.a(-7831003504773477418L, 9202239665044556291L, MethodHandles.lookup().lookupClass()).a(191440315471486L);

            public void update(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    9.a(0);
                }
                e10.getPresentation().setEnabled(jBTable.getSelectedRowCount() == 1 && !jBTable.isEditing());
            }

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    9.a(1);
                }
                CaptureConfigurable.this.a(jBTable).forEach(capturePoint -> {
                    capturePoint.myEnabled = !capturePoint.myEnabled;
                });
                jBTable.repaint();
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x21A2C6E39414L;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/debugger/settings/CaptureConfigurable$9";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(32, 0)), (JComponent)jBTable);
        toolbarDecorator.addExtraAction((AnActionButton)new DumbAwareActionButton("Import", "Import", AllIcons.Actions.Install){
            private static final long a = lb.a(-792882988023636333L, 7437063919983007595L, MethodHandles.lookup().lookupClass()).a(130701348620196L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                long l2 = a ^ 0x236249582A3BL;
                if (e10 == null) {
                    10.a(0);
                }
                FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, false, true, false, true, true){
                    private static final long a = lb.a(-9159172347355884858L, 3860320904831417297L, MethodHandles.lookup().lookupClass()).a(103900597256105L);

                    public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                        long l2 = a ^ 0x105E26B2219AL;
                        return super.isFileVisible(file, showHiddenFiles) && (file.isDirectory() || "xml".equals(file.getExtension()) || file.getFileType() == FileTypes.ARCHIVE);
                    }

                    public boolean isFileSelectable(VirtualFile file) {
                        return file.getFileType() == StdFileTypes.XML;
                    }
                };
                fileChooserDescriptor.setDescription("Please select a file to import.");
                fileChooserDescriptor.setTitle("Import Capture Points");
                Object[] objectArray = FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor, (Project)e10.getProject(), null);
                if (ArrayUtil.isEmpty((Object[])objectArray)) {
                    return;
                }
                jBTable.getSelectionModel().clearSelection();
                for (Object object : objectArray) {
                    try {
                        for (String string : JDOMUtil.load((InputStream)object.getInputStream()).getChildren()) {
                            int n2 = CaptureConfigurable.this.h.addIfNeeded((CapturePoint)XmlSerializer.deserialize((Element)string, CapturePoint.class));
                            jBTable.getSelectionModel().addSelectionInterval(n2, n2);
                        }
                    }
                    catch (Exception exception) {
                        String string;
                        string = exception.getLocalizedMessage();
                        Messages.showErrorDialog((Project)e10.getProject(), (String)(string != null && string.length() > 0 ? string : exception.toString()), (String)"Export Failed");
                    }
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x37E965E028E6L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/settings/CaptureConfigurable$10", "actionPerformed"));
            }
        });
        toolbarDecorator.addExtraAction((AnActionButton)new DumbAwareActionButton("Export", "Export", AllIcons.ToolbarDecorator.Export){
            private static final long a = lb.a(-586516756509831498L, 6127479791675576478L, MethodHandles.lookup().lookupClass()).a(54826524631056L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                VirtualFileWrapper virtualFileWrapper;
                long l2 = a ^ 0x70FB7E360223L;
                if (e10 == null) {
                    11.a(0);
                }
                if ((virtualFileWrapper = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor("Export Selected Capture Points to File...", "", new String[]{"xml"}), e10.getProject()).save(null, null)) == null) {
                    return;
                }
                Element element = new Element("capture-points");
                CaptureConfigurable.this.a(jBTable).forEach(capturePoint -> {
                    try {
                        CapturePoint capturePoint2 = capturePoint.clone();
                        capturePoint2.myEnabled = false;
                        element.addContent(XmlSerializer.serialize((Object)capturePoint2));
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        e.error((Throwable)cloneNotSupportedException);
                    }
                });
                try {
                    JDOMUtil.write((Element)element, (File)virtualFileWrapper.getFile());
                }
                catch (Exception exception) {
                    String string = exception.getLocalizedMessage();
                    Messages.showErrorDialog((Project)e10.getProject(), (String)(string != null && string.length() > 0 ? string : exception.toString()), (String)"Export Failed");
                }
            }

            public boolean isEnabled() {
                return jBTable.getSelectedRowCount() > 0;
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x271AE304ECFFL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/settings/CaptureConfigurable$11", "actionPerformed"));
            }
        });
        this.g.addActionListener(actionEvent -> new AsyncAnnotationsDialog(this, this.c).show());
        this.a.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Breakpoints based", (boolean)false));
        this.a.add((Component)toolbarDecorator.createPanel(), "Center");
        return this.b;
    }

    private StreamEx<CapturePoint> a(JBTable jBTable) {
        return IntStreamEx.of((int[])jBTable.getSelectedRows()).map(arg_0 -> jBTable.convertRowIndexToModel(arg_0)).mapToObj(this.h::get);
    }

    public boolean isModified() {
        return DebuggerSettings.getInstance().CAPTURE_VARIABLES != this.f.isSelected() || DebuggerSettings.getInstance().INSTRUMENTING_AGENT != this.d.isSelected() || !DebuggerSettings.getInstance().getCapturePoints().equals(this.h.myCapturePoints);
    }

    public void apply() throws ConfigurationException {
        DebuggerSettings.getInstance().setCapturePoints(this.h.myCapturePoints);
        DebuggerSettings.getInstance().CAPTURE_VARIABLES = this.f.isSelected();
        DebuggerSettings.getInstance().INSTRUMENTING_AGENT = this.d.isSelected();
    }

    public void reset() {
        this.f.setSelected(DebuggerSettings.getInstance().CAPTURE_VARIABLES);
        this.d.setSelected(DebuggerSettings.getInstance().INSTRUMENTING_AGENT);
        this.h.myCapturePoints = DebuggerSettings.getInstance().cloneCapturePoints();
        this.h.a();
        this.h.fireTableDataChanged();
    }

    @Nls
    public String getDisplayName() {
        long l2 = i ^ 0x5778A4C7EE37L;
        return DebuggerBundle.message((String)"async.stacktraces.configurable.display.name", (Object[])new Object[0]);
    }

    static void processCaptureAnnotations(BiConsumer<Boolean, PsiModifierListOwner> consumer) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project2 = JavaDebuggerSupport.getContextProjectForEditorFieldsInDebuggerConfigurables();
        DebuggerProjectSettings debuggerProjectSettings = DebuggerProjectSettings.getInstance(project2);
        CaptureConfigurable.a(project2, debuggerProjectSettings, true, consumer);
        CaptureConfigurable.a(project2, debuggerProjectSettings, false, consumer);
    }

    private static void a(Project project2, DebuggerProjectSettings debuggerProjectSettings, boolean bl2, BiConsumer<Boolean, PsiModifierListOwner> biConsumer) {
        try {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project2);
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project2);
            for (String string : CaptureConfigurable.a(debuggerProjectSettings, bl2)) {
                PsiClass psiClass = javaPsiFacade.findClass(string, globalSearchScope);
                if (psiClass == null) continue;
                AnnotatedElementsSearch.searchElements((PsiClass)psiClass, (SearchScope)globalSearchScope, (Class[])new Class[]{PsiMethod.class, PsiParameter.class}).forEach(psiModifierListOwner -> biConsumer.accept(bl2, (PsiModifierListOwner)psiModifierListOwner));
            }
        }
        catch (ProcessCanceledException | IndexNotReadyException throwable) {
        }
        catch (Exception exception) {
            e.error((Throwable)exception);
        }
    }

    static String getAnnotationName(boolean capture) {
        return (capture ? Async.Schedule.class : Async.Execute.class).getName().replace("$", ".");
    }

    private static List<String> a(DebuggerProjectSettings debuggerProjectSettings, boolean bl2) {
        return StreamEx.of((Object[])(bl2 ? debuggerProjectSettings.myAsyncScheduleAnnotations : debuggerProjectSettings.myAsyncExecuteAnnotations)).prepend((Object)CaptureConfigurable.getAnnotationName(bl2)).toList();
    }

    static {
        i = lb.a(8053554601533842948L, 1282922875033131982L, MethodHandles.lookup().lookupClass()).a(22638256755226L);
        e = Logger.getInstance(CaptureConfigurable.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = i ^ 0x13D6F48079CCL;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/debugger/settings/CaptureConfigurable";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private /* synthetic */ void a() {
        JPanel jPanel;
        JButton jButton;
        JPanel jPanel2;
        long l2 = i ^ 0x432D13D1B332L;
        this.b = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBCheckBox jBCheckBox = new JBCheckBox();
        this.d = jBCheckBox;
        this.a((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.capture.configurable.debugger.agent"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.g = jButton = new JButton();
        this.a(jButton, ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.capture.configurable.annotations.configure"));
        jPanel2.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.a = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JBCheckBox jBCheckBox2 = new JBCheckBox();
        this.f = jBCheckBox2;
        this.a((AbstractButton)jBCheckBox2, ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.capture.configurable.capture.variables"));
        jPanel.add((Component)jBCheckBox2, "South");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.b;
    }

    private /* synthetic */ void a(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        char c10 = '\u0000';
        int n2 = -1;
        for (int i10 = 0; i10 < string.length(); ++i10) {
            if (string.charAt(i10) == '&') {
                if (++i10 == string.length()) break;
                if (!bl2 && string.charAt(i10) != '&') {
                    bl2 = true;
                    c10 = string.charAt(i10);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i10));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl2) {
            abstractButton.setMnemonic(c10);
            abstractButton.setDisplayedMnemonicIndex(n2);
        }
    }

    private class AsyncAnnotationsDialog
    extends DialogWrapper {
        private final AnnotationsPanel c;
        private final AnnotationsPanel a;
        private final DebuggerProjectSettings b;
        final /* synthetic */ CaptureConfigurable this$0;
        private static final long d = lb.a(-3263738885932701976L, 9119522188923672591L, MethodHandles.lookup().lookupClass()).a(44259073975938L);

        private AsyncAnnotationsDialog(@NotNull CaptureConfigurable captureConfigurable, Project project2) {
            long l2 = d ^ 0x31699C47EF12L;
            if (project2 == null) {
                AsyncAnnotationsDialog.a(0);
            }
            this.this$0 = captureConfigurable;
            super(project2, true);
            this.b = DebuggerProjectSettings.getInstance(captureConfigurable.c);
            this.c = new AnnotationsPanel(project2, "Async Schedule", "", CaptureConfigurable.a(this.b, true), new String[]{CaptureConfigurable.getAnnotationName(true)}, Collections.emptySet(), false, false);
            this.a = new AnnotationsPanel(project2, "Async Execute", "", CaptureConfigurable.a(this.b, false), new String[]{CaptureConfigurable.getAnnotationName(false)}, Collections.emptySet(), false, false);
            this.init();
            this.setTitle("Async Annotations Configuration");
        }

        protected JComponent createCenterPanel() {
            Splitter splitter = new Splitter(true);
            splitter.setFirstComponent(this.c.getComponent());
            splitter.setSecondComponent(this.a.getComponent());
            splitter.setHonorComponentsMinimumSize(true);
            splitter.setPreferredSize((Dimension)JBUI.size((int)300, (int)400));
            return splitter;
        }

        protected void doOKAction() {
            this.b.myAsyncScheduleAnnotations = (String[])((StreamEx)StreamEx.of((Object[])this.c.getAnnotations()).filter(string -> !string.equals(CaptureConfigurable.getAnnotationName(true)))).toArray((Object[])ArrayUtil.EMPTY_STRING_ARRAY);
            this.b.myAsyncExecuteAnnotations = (String[])((StreamEx)StreamEx.of((Object[])this.a.getAnnotations()).filter(string -> !string.equals(CaptureConfigurable.getAnnotationName(false)))).toArray((Object[])ArrayUtil.EMPTY_STRING_ARRAY);
            super.doOKAction();
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = d ^ 0xFDD646A0C1BL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/settings/CaptureConfigurable$AsyncAnnotationsDialog", "<init>"));
        }
    }

    private static class MyTableModel
    extends AbstractTableModel
    implements ItemRemovable {
        public static final int ENABLED_COLUMN = 0;
        public static final int CLASS_COLUMN = 1;
        public static final int METHOD_COLUMN = 2;
        public static final int PARAM_COLUMN = 3;
        public static final int INSERT_CLASS_COLUMN = 4;
        public static final int INSERT_METHOD_COLUMN = 5;
        public static final int INSERT_KEY_EXPR = 6;
        static final String[] COLUMN_NAMES;
        List<CapturePoint> myCapturePoints = DebuggerSettings.getInstance().cloneCapturePoints();
        private static final long a;

        private MyTableModel() {
            this.a();
        }

        private void a() {
            long l2 = a ^ 0x1EBAE0C09CB9L;
            if (Registry.is((String)"debugger.capture.points.annotations")) {
                ArrayList arrayList = new ArrayList();
                CaptureConfigurable.processCaptureAnnotations((bl2, psiModifierListOwner) -> {
                    long l2 = a ^ 0x74B9294965DDL;
                    if (psiModifierListOwner instanceof PsiMethod) {
                        MyTableModel.a(psiModifierListOwner, (PsiMethod)psiModifierListOwner, "this", bl2, arrayList);
                    } else if (psiModifierListOwner instanceof PsiParameter) {
                        PsiParameter psiParameter = (PsiParameter)psiModifierListOwner;
                        PsiMethod psiMethod = (PsiMethod)psiParameter.getDeclarationScope();
                        MyTableModel.a((PsiModifierListOwner)psiParameter, psiMethod, "param_" + psiMethod.getParameterList().getParameterIndex(psiParameter), bl2, arrayList);
                    }
                });
                arrayList.forEach(this::addIfNeeded);
            }
        }

        private static void a(PsiModifierListOwner psiModifierListOwner, PsiMethod psiMethod, String string, boolean bl2, List<CapturePoint> list2) {
            PsiAnnotation psiAnnotation;
            long l2 = a ^ 0x4C6E51E86077L;
            CapturePoint capturePoint = new CapturePoint();
            capturePoint.myEnabled = false;
            if (bl2) {
                capturePoint.myClassName = JVMNameUtil.getNonAnonymousClassName(psiMethod.getContainingClass());
                capturePoint.myMethodName = JVMNameUtil.getJVMMethodName(psiMethod);
            } else {
                capturePoint.myInsertClassName = JVMNameUtil.getNonAnonymousClassName(psiMethod.getContainingClass());
                capturePoint.myInsertMethodName = JVMNameUtil.getJVMMethodName(psiMethod);
            }
            PsiModifierList psiModifierList = psiModifierListOwner.getModifierList();
            if (psiModifierList != null && (psiAnnotation = psiModifierList.findAnnotation(CaptureConfigurable.getAnnotationName(bl2))) != null) {
                String string2;
                String string3;
                PsiAnnotationMemberValue psiAnnotationMemberValue = psiAnnotation.findAttributeValue("keyExpression");
                String string4 = string3 = psiAnnotationMemberValue != null ? StringUtil.unquoteString((String)psiAnnotationMemberValue.getText()) : null;
                if (StringUtil.isEmpty((String)string3)) {
                    string3 = string;
                }
                if (bl2) {
                    capturePoint.myCaptureKeyExpression = string3;
                } else {
                    capturePoint.myInsertKeyExpression = string3;
                }
                PsiAnnotationMemberValue psiAnnotationMemberValue2 = psiAnnotation.findAttributeValue("group");
                String string5 = string2 = psiAnnotationMemberValue2 != null ? StringUtil.unquoteString((String)psiAnnotationMemberValue2.getText()) : null;
                if (!StringUtil.isEmpty((String)string2)) {
                    for (CapturePoint capturePoint2 : list2) {
                        if (!StringUtil.startsWith((CharSequence)string2, (CharSequence)capturePoint2.myClassName) || !StringUtil.endsWith((CharSequence)string2, (CharSequence)capturePoint2.myMethodName)) continue;
                        capturePoint2.myInsertClassName = capturePoint.myInsertClassName;
                        capturePoint2.myInsertMethodName = capturePoint.myInsertMethodName;
                        capturePoint2.myInsertKeyExpression = capturePoint.myInsertKeyExpression;
                        return;
                    }
                }
            }
            list2.add(capturePoint);
        }

        @Override
        public String getColumnName(int column) {
            return COLUMN_NAMES[column];
        }

        @Override
        public int getRowCount() {
            return this.myCapturePoints.size();
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            CapturePoint capturePoint = this.myCapturePoints.get(row);
            switch (col) {
                case 0: {
                    return capturePoint.myEnabled;
                }
                case 1: {
                    return capturePoint.myClassName;
                }
                case 2: {
                    return capturePoint.myMethodName;
                }
                case 3: {
                    return capturePoint.myCaptureKeyExpression;
                }
                case 4: {
                    return capturePoint.myInsertClassName;
                }
                case 5: {
                    return capturePoint.myInsertMethodName;
                }
                case 6: {
                    return capturePoint.myInsertKeyExpression;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            CapturePoint capturePoint = this.myCapturePoints.get(row);
            switch (col) {
                case 0: {
                    capturePoint.myEnabled = (Boolean)value;
                    break;
                }
                case 1: {
                    capturePoint.myClassName = (String)value;
                    break;
                }
                case 2: {
                    capturePoint.myMethodName = (String)value;
                    break;
                }
                case 3: {
                    capturePoint.myCaptureKeyExpression = (String)value;
                    break;
                }
                case 4: {
                    capturePoint.myInsertClassName = (String)value;
                    break;
                }
                case 5: {
                    capturePoint.myInsertMethodName = (String)value;
                    break;
                }
                case 6: {
                    capturePoint.myInsertKeyExpression = (String)value;
                }
            }
            this.fireTableCellUpdated(row, col);
        }

        public Class getColumnClass(int columnIndex) {
            return columnIndex == 0 ? Boolean.class : String.class;
        }

        CapturePoint get(int idx) {
            return this.myCapturePoints.get(idx);
        }

        int add(CapturePoint p2) {
            this.myCapturePoints.add(p2);
            int n2 = this.getRowCount() - 1;
            this.fireTableRowsInserted(n2, n2);
            return n2;
        }

        int addIfNeeded(CapturePoint p2) {
            CapturePoint capturePoint = p2;
            try {
                capturePoint = p2.clone();
                capturePoint.myEnabled = !capturePoint.myEnabled;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                e.error((Throwable)cloneNotSupportedException);
            }
            int n2 = this.myCapturePoints.indexOf(p2);
            if (n2 < 0) {
                n2 = this.myCapturePoints.indexOf(capturePoint);
            }
            if (n2 < 0) {
                n2 = this.add(p2);
            }
            return n2;
        }

        public void addRow() {
            this.add(new CapturePoint());
        }

        public void removeRow(int row) {
            this.myCapturePoints.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        static {
            a = lb.a(7275298160896838909L, 596680810559605621L, MethodHandles.lookup().lookupClass()).a(150540105739804L);
            long l2 = a ^ 0x32BC90CBAC57L;
            COLUMN_NAMES = new String[]{"", "Capture class name", "Capture method name", "Capture key expression", "Insert class name", "Insert method name", "Insert key expression"};
        }
    }
}

